/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.common;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.position.BlockPosition;
import powercrystals.core.position.INeighboorUpdateTile;
import powercrystals.powerconverters.common.BridgeSideData;
import powercrystals.powerconverters.power.TileEntityBridgeComponent;
import powercrystals.powerconverters.power.TileEntityEnergyConsumer;
import powercrystals.powerconverters.power.TileEntityEnergyProducer;

public class TileEntityEnergyBridge
extends any
implements INeighboorUpdateTile {
    private int _energyStored;
    private int _energyStoredMax = 16000000;
    private int _energyScaledClient;
    private int _energyStoredLast;
    private boolean _isInputLimited;
    private Map _producerTiles = new HashMap();
    private Map _clientSideData = new HashMap();
    private Map _producerOutputRates = new HashMap();
    private boolean _initialized;

    public TileEntityEnergyBridge() {
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            this._clientSideData.put(d, new BridgeSideData());
            this._producerOutputRates.put(d, 0);
        }
    }

    public int getEnergyStored() {
        return this._energyStored;
    }

    public int getEnergyStoredMax() {
        return this._energyStoredMax;
    }

    public int storeEnergy(int energy) {
        int toStore = Math.min(energy, this._energyStoredMax - this._energyStored);
        this._energyStored += toStore;
        return energy - toStore;
    }

    public void g() {
        super.g();
        if (!this._initialized) {
            this.onNeighboorChanged();
            this._initialized = true;
        }
        if (!this.k.I) {
            int energyRemaining = Math.min(this._energyStored, this._energyStoredMax);
            int energyNotProduced = 0;
            for (Map.Entry prod : this._producerTiles.entrySet()) {
                if (energyRemaining > 0) {
                    energyNotProduced = ((TileEntityEnergyProducer)((Object)prod.getValue())).produceEnergy(energyRemaining);
                    if (energyNotProduced > energyRemaining) {
                        energyNotProduced = energyRemaining;
                    }
                    this._producerOutputRates.put(prod.getKey(), (energyRemaining - energyNotProduced) / ((TileEntityEnergyProducer)((Object)prod.getValue())).getPowerSystem().getInternalEnergyPerOutput());
                    energyRemaining = energyNotProduced;
                    continue;
                }
                ((TileEntityEnergyProducer)((Object)prod.getValue())).produceEnergy(0);
                this._producerOutputRates.put(prod.getKey(), 0);
            }
            this._energyStored = Math.max(0, energyRemaining);
            this._isInputLimited = (this._energyStored != this._energyStoredLast || this._energyStored != this._energyStoredMax) && this._energyStored <= this._energyStoredLast;
            this._energyStoredLast = this._energyStored;
        }
    }

    public void onNeighboorChanged() {
        HashMap<ForgeDirection, TileEntityEnergyProducer> producerTiles = new HashMap<ForgeDirection, TileEntityEnergyProducer>();
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            BlockPosition p = new BlockPosition((any)this);
            p.orientation = d;
            p.moveForwards(1);
            any te = this.k.q(p.x, p.y, p.z);
            if (te == null || !(te instanceof TileEntityEnergyProducer)) continue;
            producerTiles.put(d, (TileEntityEnergyProducer)te);
        }
        this._producerTiles = producerTiles;
    }

    public BridgeSideData getDataForSide(ForgeDirection dir) {
        if (!this.k.I) {
            BridgeSideData d = new BridgeSideData();
            BlockPosition p = new BlockPosition((any)this);
            p.orientation = dir;
            p.moveForwards(1);
            any te = this.k.q(p.x, p.y, p.z);
            if (te != null && te instanceof TileEntityBridgeComponent) {
                if (te instanceof TileEntityEnergyConsumer) {
                    d.isConsumer = true;
                    d.outputRate = ((TileEntityEnergyConsumer)te).getInputRate();
                }
                if (te instanceof TileEntityEnergyProducer) {
                    d.isProducer = true;
                    d.outputRate = (Integer)this._producerOutputRates.get(dir);
                }
                TileEntityBridgeComponent c = (TileEntityBridgeComponent)te;
                d.powerSystem = c.getPowerSystem();
                d.isConnected = c.isConnected();
                d.side = dir;
                d.voltageNameIndex = c.getVoltageIndex();
            }
            return d;
        }
        return (BridgeSideData)this._clientSideData.get(dir);
    }

    public boolean isInputLimited() {
        return this._isInputLimited;
    }

    @SideOnly(value=Side.CLIENT)
    public void setIsInputLimited(boolean isInputLimited) {
        this._isInputLimited = isInputLimited;
    }

    public int getEnergyScaled() {
        if (this.k.I) {
            return this._energyScaledClient;
        }
        return 120 * this._energyStored / this._energyStoredMax;
    }

    public void setEnergyScaled(int scaled) {
        this._energyScaledClient = scaled;
    }

    public void b(bq par1nbtTagCompound) {
        super.b(par1nbtTagCompound);
        par1nbtTagCompound.a("energyStored", this._energyStored);
    }

    public void a(bq par1nbtTagCompound) {
        super.a(par1nbtTagCompound);
        this._energyStored = par1nbtTagCompound.e("energyStored");
    }
}

