/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.ic2;

import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import powercrystals.powerconverters.PowerConverterCore;
import powercrystals.powerconverters.power.TileEntityEnergyConsumer;

public class TileEntityIndustrialCraftConsumer
extends TileEntityEnergyConsumer
implements IEnergySink {
    private boolean _isAddedToEnergyNet;
    private boolean _didFirstAddToNet;
    private int _euLastTick;
    private long _lastTickInjected;

    public TileEntityIndustrialCraftConsumer() {
        this(0);
    }

    public TileEntityIndustrialCraftConsumer(int voltageIndex) {
        super(PowerConverterCore.powerSystemIndustrialCraft, voltageIndex, IEnergyEmitter.class);
    }

    @Override
    public void g() {
        super.g();
        if (!this._didFirstAddToNet && !this.k.I) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this._didFirstAddToNet = true;
            this._isAddedToEnergyNet = true;
        }
        if (this.k.G() - this._lastTickInjected > 20L) {
            this._euLastTick = 0;
        }
    }

    public void s() {
        super.s();
        if (!this._isAddedToEnergyNet) {
            this._didFirstAddToNet = false;
        }
    }

    public void w_() {
        if (this._isAddedToEnergyNet) {
            if (!this.k.I) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            }
            this._isAddedToEnergyNet = false;
        }
        super.w_();
    }

    public boolean acceptsEnergyFrom(any emitter, Direction direction) {
        return true;
    }

    public boolean isAddedToEnergyNet() {
        return this._isAddedToEnergyNet;
    }

    public int demandsEnergy() {
        return this.getTotalEnergyDemand() / PowerConverterCore.powerSystemIndustrialCraft.getInternalEnergyPerInput();
    }

    public int injectEnergy(Direction directionFrom, int amount) {
        int pcuNotStored = this.storeEnergy(amount * PowerConverterCore.powerSystemIndustrialCraft.getInternalEnergyPerInput());
        int euNotStored = pcuNotStored / PowerConverterCore.powerSystemIndustrialCraft.getInternalEnergyPerInput();
        int euThisInjection = amount - euNotStored;
        if (this._lastTickInjected == this.k.G()) {
            this._euLastTick += euThisInjection;
        } else {
            this._euLastTick = euThisInjection;
            this._lastTickInjected = this.k.G();
        }
        return euNotStored;
    }

    public int getMaxSafeInput() {
        if (this.getVoltageIndex() == 3) {
            return Integer.MAX_VALUE;
        }
        return this.getPowerSystem().getVoltageValues()[this.getVoltageIndex()];
    }

    @Override
    public int getInputRate() {
        return this._euLastTick;
    }
}

