/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import gcewing.lighting.BlockFloodlight;
import gcewing.lighting.BlockFloodlightBeam;
import gcewing.lighting.GregsLighting;
import gcewing.lighting.OrderedProperties;
import gcewing.lighting.TEFloodlightBeam;
import net.minecraftforge.common.ForgeDirection;

public class Floodlight {
    public static int maxRange = 64;
    public static boolean debugBeamBlocks = false;

    public static void init(OrderedProperties orderedProperties) {
        maxRange = orderedProperties.getInt("maxFloodlightRange", maxRange);
        debugBeamBlocks = orderedProperties.getBoolean("debugBeamBlocks", false);
    }

    public static void updateBeams(yc yc2, int n, int n2, int n3) {
        if (debugBeamBlocks) {
            System.out.printf("Floodlight.updateBeams at (%d,%d,%d)\n", n, n2, n3);
        }
        for (int i = 0; i < 6; ++i) {
            Floodlight.updateBeamInDirection(yc2, n, n2, n3, ForgeDirection.getOrientation((int)i));
        }
    }

    static void updateBeamInDirection(yc yc2, int n, int n2, int n3, ForgeDirection forgeDirection) {
        if (debugBeamBlocks) {
            System.out.printf("Floodlight.updateBeamInDirection %s from (%d,%d,%d) in %s\n", forgeDirection, n, n2, n3, yc2);
        }
        int n4 = Floodlight.findSourceIntensity(yc2, n, n2, n3, forgeDirection);
        Floodlight.propagateBeam(yc2, n, n2, n3, forgeDirection, n4, 0);
    }

    static int findSourceIntensity(yc yc2, int n, int n2, int n3, ForgeDirection forgeDirection) {
        if (debugBeamBlocks) {
            System.out.printf("Floodlight.findSourceIntensity %s from (%d,%d,%d)\n", forgeDirection, n, n2, n3);
        }
        int n4 = yc2.O();
        for (int i = 1; i <= maxRange; ++i) {
            int n5;
            int n6 = n - i * forgeDirection.offsetX;
            int n7 = n2 - i * forgeDirection.offsetY;
            int n8 = n3 - i * forgeDirection.offsetZ;
            if (debugBeamBlocks) {
                System.out.printf("Floodlight.findSourceIntensity: Checking (%d,%d,%d)\n", n6, n7, n8);
            }
            if (n7 < 0 || n7 >= n4) {
                if (debugBeamBlocks) {
                    System.out.printf("Floodlight.findSourceIntensity: Reached edge of map, returning 0\n", new Object[0]);
                }
                return 0;
            }
            amq amq2 = Floodlight.getBlock(yc2, n6, n7, n8);
            if (amq2 == null) {
                if (debugBeamBlocks) {
                    System.out.printf("Floodlight.findSourceIntensity: Found air, returning 0\n", new Object[0]);
                }
                return 0;
            }
            if (debugBeamBlocks) {
                System.out.printf("Floodlight.findSourceIntensity: Found %s\n", amq2.a());
            }
            if (amq2 instanceof BlockFloodlight) {
                if (debugBeamBlocks) {
                    System.out.printf("Floodlight.findSourceIntensity: Found floodlight\n", new Object[0]);
                }
                if (((BlockFloodlight)amq2).isActiveInDirection(yc2, n6, n7, n8, forgeDirection)) {
                    n5 = maxRange + 1 - i;
                    if (debugBeamBlocks) {
                        System.out.printf("Floodlight.findSourceIntensity: Is active, returning %d\n", n5);
                    }
                    return n5;
                }
            }
            if (amq2 instanceof BlockFloodlightBeam && (n5 = Floodlight.beamIntensity(yc2, n6, n7, n8, forgeDirection)) > 0) {
                int n9 = n5 - i;
                if (debugBeamBlocks) {
                    System.out.printf("Floodlight.findSourceIntensity: Found beam block, returning %d\n", n9);
                }
                return n9;
            }
            if (!amq2.c()) continue;
            if (debugBeamBlocks) {
                System.out.printf("Floodlight.findSourceIntensity: Found opaque block, returning 0\n", new Object[0]);
            }
            return 0;
        }
        return 0;
    }

    public static void propagateBeam(yc yc2, int n, int n2, int n3, ForgeDirection forgeDirection, int n4, int n5) {
        if (debugBeamBlocks) {
            System.out.printf("Floodlight.propagateBeam %s from (%d,%d,%d) + %d with intensity %d\n", forgeDirection, n, n2, n3, n5, n4);
        }
        int n6 = yc2.O();
        for (int i = n5; i < maxRange; ++i) {
            int n7 = n + i * forgeDirection.offsetX;
            int n8 = n2 + i * forgeDirection.offsetY;
            int n9 = n3 + i * forgeDirection.offsetZ;
            if (debugBeamBlocks) {
                System.out.printf("Floodlight.propagateBeam: Checking (%d,%d,%d)\n", n7, n8, n9);
            }
            if (n8 < 0 || n8 >= n6) {
                if (debugBeamBlocks) {
                    System.out.printf("Floodlight.propagateBeam: Reached edge of map\n", new Object[0]);
                }
                return;
            }
            amq amq2 = Floodlight.getBlock(yc2, n7, n8, n9);
            if (amq2 != null && amq2.c()) {
                if (debugBeamBlocks) {
                    System.out.printf("Floodlight.propagateBeam: Found opaque block\n", new Object[0]);
                }
                return;
            }
            if (amq2 != null && !(amq2 instanceof BlockFloodlightBeam) || Floodlight.setBeamIntensity(yc2, n7, n8, n9, forgeDirection, n4 - i) || i == n5) continue;
            if (debugBeamBlocks) {
                System.out.printf("Floodlight.propagateBeam: Intensity already correct\n", new Object[0]);
            }
            return;
        }
    }

    static amq getBlock(yc yc2, int n, int n2, int n3) {
        return amq.p[yc2.a(n, n2, n3)];
    }

    static int beamIntensity(yc yc2, int n, int n2, int n3, ForgeDirection forgeDirection) {
        TEFloodlightBeam tEFloodlightBeam = Floodlight.getBeamTileEntity(yc2, n, n2, n3);
        return tEFloodlightBeam.getIntensity(forgeDirection);
    }

    static boolean setBeamIntensity(yc yc2, int n, int n2, int n3, ForgeDirection forgeDirection, int n4) {
        Object object;
        if (n4 < 0) {
            n4 = 0;
        }
        if (debugBeamBlocks) {
            System.out.printf("Floodlight.setBeamIntensity %s at (%d,%d,%d) to %d\n", forgeDirection, n, n2, n3, n4);
        }
        if ((object = Floodlight.getBlock(yc2, n, n2, n3)) == null) {
            if (n4 == 0) {
                return false;
            }
            if (debugBeamBlocks) {
                System.out.printf("Floodlight.setBeamIntensity: Placing beam block\n", new Object[0]);
            }
            object = GregsLighting.floodlightBeam;
            yc2.b(n, n2, n3, object.cm);
        }
        TEFloodlightBeam tEFloodlightBeam = Floodlight.getBeamTileEntity(yc2, n, n2, n3);
        boolean bl = tEFloodlightBeam.setIntensity(forgeDirection, n4);
        if (tEFloodlightBeam.allIntensitiesZero()) {
            if (debugBeamBlocks) {
                System.out.printf("Floodlight.setBeamIntensity: Removing beam block\n", new Object[0]);
            }
            yc2.b(n, n2, n3, 0);
        }
        return bl;
    }

    static TEFloodlightBeam getBeamTileEntity(yc yc2, int n, int n2, int n3) {
        return (TEFloodlightBeam)yc2.q(n, n2, n3);
    }
}

