/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes;

import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLFingerprintViolationEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.event.FMLStateEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import logisticspipes.blocks.LogisticsSignBlock;
import logisticspipes.blocks.LogisticsSolidBlock;
import logisticspipes.blocks.powertile.LogisticsPowerJuntionTileEntity_BuildCraft;
import logisticspipes.blocks.powertile.LogisticsPowerJuntionTileEntity_IC2_BuildCraft;
import logisticspipes.commands.LogisticsPipesCommand;
import logisticspipes.config.Configs;
import logisticspipes.items.CraftingSignCreator;
import logisticspipes.items.ItemDisk;
import logisticspipes.items.ItemHUDArmor;
import logisticspipes.items.ItemModule;
import logisticspipes.items.ItemParts;
import logisticspipes.items.ItemUpgrade;
import logisticspipes.items.LogisticsItem;
import logisticspipes.items.LogisticsItemCard;
import logisticspipes.items.LogisticsLiquidContainer;
import logisticspipes.items.LogisticsSolidBlockItem;
import logisticspipes.items.RemoteOrderer;
import logisticspipes.log.RequestLogFormator;
import logisticspipes.logic.BaseLogicSatellite;
import logisticspipes.logistics.LogisticsLiquidManager;
import logisticspipes.logistics.LogisticsManagerV2;
import logisticspipes.main.CreativeTabLP;
import logisticspipes.main.LogisticsEventListener;
import logisticspipes.main.LogisticsWorldManager;
import logisticspipes.network.GuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.ProxyManager;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.SpecialInventoryHandlerManager;
import logisticspipes.proxy.buildcraft.BuildCraftProxy;
import logisticspipes.proxy.cc.LogisticsPowerJuntionTileEntity_CC_BuildCraft;
import logisticspipes.proxy.cc.LogisticsPowerJuntionTileEntity_CC_IC2_BuildCraft;
import logisticspipes.proxy.cc.LogisticsTileGenericPipe_CC;
import logisticspipes.proxy.recipeproviders.AssemblyAdvancedWorkbench;
import logisticspipes.proxy.recipeproviders.AutoWorkbench;
import logisticspipes.proxy.recipeproviders.RollingMachine;
import logisticspipes.proxy.recipeproviders.SolderingStation;
import logisticspipes.proxy.specialconnection.SpecialPipeConnection;
import logisticspipes.proxy.specialconnection.SpecialTileConnection;
import logisticspipes.proxy.specialconnection.TeleportPipes;
import logisticspipes.proxy.specialconnection.TesseractConnection;
import logisticspipes.recipes.RecipeManager;
import logisticspipes.recipes.SolderingStationRecipes;
import logisticspipes.renderer.LogisticsHUDRenderer;
import logisticspipes.routing.RouterManager;
import logisticspipes.routing.ServerRouter;
import logisticspipes.textures.Textures;
import logisticspipes.ticks.ClientPacketBufferHandlerThread;
import logisticspipes.ticks.HudUpdateTick;
import logisticspipes.ticks.QueuedTasks;
import logisticspipes.ticks.RenderTickHandler;
import logisticspipes.ticks.RoutingTableUpdateThread;
import logisticspipes.ticks.ServerPacketBufferHandlerThread;
import logisticspipes.ticks.WorldTickHandler;
import logisticspipes.utils.InventoryUtilFactory;
import logisticspipes.utils.LiquidIdentifier;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="LogisticsPipes|Main", name="Logistics Pipes", version="0.7.0.98", certificateFingerprint="e896b0959225b49ad1c1c512ab870ccedabec74b", dependencies="required-after:Forge@[6.5.0.0,);required-after:BuildCraft|Core;required-after:BuildCraft|Transport;required-after:BuildCraft|Builders;required-after:BuildCraft|Silicon;after:IC2;after:Forestry;after:Thaumcraft;after:CCTurtle;after:ComputerCraft;after:factorization;after:GregTech_Addon;after:AppliedEnergistics;after:ThermalExpansion|Transport;after:BetterStorage")
@NetworkMod(channels={"BCLP"}, packetHandler=PacketHandler.class, clientSideRequired=true, serverSideRequired=true)
public class LogisticsPipes {
    @Mod.Instance(value="LogisticsPipes|Main")
    public static LogisticsPipes instance;
    public static boolean DisplayRequests;
    public static boolean DEBUG;
    public static String MCVersion;
    private boolean certificateError = false;
    public static up LogisticsBasicPipe;
    public static up LogisticsRequestPipe;
    public static up LogisticsProviderPipe;
    public static up LogisticsCraftingPipe;
    public static up LogisticsSatellitePipe;
    public static up LogisticsSupplierPipe;
    public static up LogisticsBuilderSupplierPipe;
    public static up LogisticsLiquidSupplierPipe;
    public static up LogisticsChassiPipe1;
    public static up LogisticsChassiPipe2;
    public static up LogisticsChassiPipe3;
    public static up LogisticsChassiPipe4;
    public static up LogisticsChassiPipe5;
    public static up LogisticsCraftingPipeMK2;
    public static up LogisticsRequestPipeMK2;
    public static up LogisticsProviderPipeMK2;
    public static up LogisticsRemoteOrdererPipe;
    public static up LogisticsApiaristAnalyserPipe;
    public static up LogisticsApiaristSinkPipe;
    public static up LogisticsInvSysCon;
    public static up LogisticsEntrance;
    public static up LogisticsDestination;
    public static up LogisticsCraftingPipeMK3;
    public static up LogisticsFirewall;
    public static up LogisticsLiquidConnector;
    public static up LogisticsLiquidBasic;
    public static up LogisticsLiquidInsertion;
    public static up LogisticsLiquidProvider;
    public static up LogisticsLiquidRequest;
    public static up LogisticsNetworkMonitior;
    public static up LogisticsRemoteOrderer;
    public static up LogisticsCraftingSignCreator;
    public static ItemDisk LogisticsItemDisk;
    public static up LogisticsItemCard;
    public static ItemHUDArmor LogisticsHUDArmor;
    public static up LogisticsParts;
    public static up LogisticsUpgradeManager;
    public static up LogisticsLiquidContainer;
    public static ItemModule ModuleItem;
    public static ItemUpgrade UpgradeItem;
    private Textures textures = new Textures();
    public static Class powerTileEntity;
    public static final String logisticsTileGenericPipeMapping = "logisticspipes.pipes.basic.LogisticsTileGenericPipe";
    public static CreativeTabLP LPCreativeTab;
    public static amq logisticsSign;
    public static amq logisticsSolidBlock;
    public static Logger log;
    public static Logger requestLog;

    @Mod.Init
    public void init(FMLInitializationEvent event) {
        SimpleServiceLocator.setBuildCraftProxy(new BuildCraftProxy());
        RouterManager manager = new RouterManager();
        SimpleServiceLocator.setRouterManager(manager);
        SimpleServiceLocator.setDirectConnectionManager(manager);
        SimpleServiceLocator.setSecurityStationManager(manager);
        SimpleServiceLocator.setLogisticsManager(new LogisticsManagerV2());
        SimpleServiceLocator.setInventoryUtilFactory(new InventoryUtilFactory());
        SimpleServiceLocator.setSpecialConnectionHandler(new SpecialPipeConnection());
        SimpleServiceLocator.setSpecialConnectionHandler(new SpecialTileConnection());
        SimpleServiceLocator.setLogisticsLiquidManager(new LogisticsLiquidManager());
        this.textures.load((FMLStateEvent)event);
        if (event.getSide().isClient()) {
            SimpleServiceLocator.buildCraftProxy.registerLocalization();
        }
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        if (event.getSide().equals((Object)Side.CLIENT)) {
            TickRegistry.registerTickHandler((ITickHandler)new RenderTickHandler(), (Side)Side.CLIENT);
        }
        if (!Configs.LOGISTICS_TILE_GENERIC_PIPE_REPLACEMENT_DISABLED) {
            TickRegistry.registerTickHandler((ITickHandler)new WorldTickHandler(), (Side)Side.SERVER);
            TickRegistry.registerTickHandler((ITickHandler)new WorldTickHandler(), (Side)Side.CLIENT);
        }
        TickRegistry.registerTickHandler((ITickHandler)new QueuedTasks(), (Side)Side.SERVER);
        if (event.getSide() == Side.CLIENT) {
            SimpleServiceLocator.setClientPacketBufferHandlerThread(new ClientPacketBufferHandlerThread());
        }
        SimpleServiceLocator.setServerPacketBufferHandlerThread(new ServerPacketBufferHandlerThread());
        for (int i = 0; i < Configs.MULTI_THREAD_NUMBER; ++i) {
            new RoutingTableUpdateThread(i);
        }
        MinecraftForge.EVENT_BUS.register((Object)new LogisticsWorldManager());
        MinecraftForge.EVENT_BUS.register((Object)new LogisticsEventListener());
    }

    @Mod.PreInit
    public void LoadConfig(FMLPreInitializationEvent evt) {
        Configs.load(evt);
        log = evt.getModLog();
        requestLog = Logger.getLogger("LogisticsPipes|Request");
        requestLog.setUseParentHandlers(false);
        try {
            File logPath = new File((File)FMLInjectionData.data()[6], "LogisticsPipes-Request.log");
            FileHandler fileHandler = new FileHandler(logPath.getPath(), true);
            fileHandler.setFormatter(new RequestLogFormator());
            fileHandler.setLevel(Level.ALL);
            requestLog.addHandler(fileHandler);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (DEBUG) {
            log.setLevel(Level.ALL);
        }
        if (this.certificateError) {
            log.severe("Certificate not correct");
            log.severe("This in not a LogisticsPipes version from RS485.");
        }
    }

    @Mod.PostInit
    public void PostLoad(FMLPostInitializationEvent event) {
        ProxyManager.load();
        SpecialInventoryHandlerManager.load();
        SimpleServiceLocator.specialpipeconnection.registerHandler(new TeleportPipes());
        SimpleServiceLocator.specialtileconnection.registerHandler(new TesseractConnection());
        LogisticsNetworkMonitior = new LogisticsItem(Configs.LOGISTICSNETWORKMONITOR_ID);
        LogisticsNetworkMonitior.c(0);
        LogisticsNetworkMonitior.b("networkMonitorItem");
        LogisticsItemCard = new LogisticsItemCard(Configs.ITEM_CARD_ID);
        LogisticsItemCard.c(4);
        LogisticsItemCard.b("logisticsItemCard");
        LogisticsRemoteOrderer = new RemoteOrderer(Configs.LOGISTICSREMOTEORDERER_ID);
        LogisticsRemoteOrderer.b("remoteOrdererItem");
        LogisticsCraftingSignCreator = new CraftingSignCreator(Configs.LOGISTICSCRAFTINGSIGNCREATOR_ID);
        LogisticsCraftingSignCreator.c(2);
        LogisticsCraftingSignCreator.b("CraftingSignCreator");
        int renderIndex = MainProxy.isClient() ? RenderingRegistry.addNewArmourRendererPrefix((String)"LogisticsHUD") : 0;
        LogisticsHUDArmor = new ItemHUDArmor(Configs.ITEM_HUD_ID, renderIndex);
        LogisticsHUDArmor.c(5);
        LogisticsHUDArmor.b("logisticsHUDGlasses");
        LogisticsParts = new ItemParts(Configs.ITEM_PARTS_ID);
        LogisticsParts.c(8);
        LogisticsParts.b("logisticsParts");
        SimpleServiceLocator.buildCraftProxy.registerTrigger();
        ModuleItem = new ItemModule(Configs.ITEM_MODULE_ID);
        ModuleItem.b("itemModule");
        ModuleItem.loadModules();
        LogisticsItemDisk = new ItemDisk(Configs.ITEM_DISK_ID);
        LogisticsItemDisk.b("itemDisk");
        LogisticsItemDisk.c(3);
        UpgradeItem = new ItemUpgrade(Configs.ITEM_UPGRADE_ID);
        UpgradeItem.b("itemUpgrade");
        UpgradeItem.loadUpgrades();
        LogisticsUpgradeManager = new LogisticsItem(Configs.ITEM_UPGRADE_MANAGER_ID);
        LogisticsUpgradeManager.c(10);
        LogisticsUpgradeManager.b("upgradeManagerItem");
        if (DEBUG) {
            LogisticsLiquidContainer = new LogisticsLiquidContainer(Configs.ITEM_LIQUID_CONTAINER_ID);
            LogisticsLiquidContainer.c(11);
            LogisticsLiquidContainer.b("logisticsLiquidContainer");
        }
        SimpleServiceLocator.buildCraftProxy.registerPipes(event.getSide());
        ModLoader.addName((Object)LogisticsNetworkMonitior, (String)"Network monitor");
        ModLoader.addName((Object)LogisticsItemCard, (String)"Logistics Item Card");
        ModLoader.addName((Object)LogisticsRemoteOrderer, (String)"Remote Orderer");
        ModLoader.addName((Object)LogisticsCraftingSignCreator, (String)"Crafting Sign Creator");
        ModLoader.addName((Object)((Object)ModuleItem), (String)"BlankModule");
        ModLoader.addName((Object)((Object)LogisticsItemDisk), (String)"Logistics Disk");
        LanguageRegistry.instance().addNameForObject((Object)LogisticsHUDArmor, "en_US", "Logistics HUD Glasses");
        LanguageRegistry.instance().addNameForObject((Object)new ur(LogisticsParts, 1, 0), "en_US", "Logistics HUD Bow");
        LanguageRegistry.instance().addNameForObject((Object)new ur(LogisticsParts, 1, 1), "en_US", "Logistics HUD Glass");
        LanguageRegistry.instance().addNameForObject((Object)new ur(LogisticsParts, 1, 2), "en_US", "Logistics HUD Nose Bridge");
        LanguageRegistry.instance().addNameForObject((Object)new ur(LogisticsParts, 1, 3), "en_US", "Nano Hopper");
        LanguageRegistry.instance().addNameForObject((Object)new ur(LogisticsUpgradeManager, 1, 0), "en_US", "Upgrade Manager");
        if (DEBUG) {
            LanguageRegistry.instance().addNameForObject((Object)new ur(LogisticsLiquidContainer, 1, 0), "en_US", "Logistics Liquid Container");
        }
        LanguageRegistry.instance().addStringLocalization("itemGroup.Logistics_Pipes", "en_US", "Logistics Pipes");
        SimpleServiceLocator.IC2Proxy.addCraftingRecipes();
        SimpleServiceLocator.forestryProxy.addCraftingRecipes();
        SimpleServiceLocator.thaumCraftProxy.addCraftingRecipes();
        SimpleServiceLocator.addCraftingRecipeProvider(new AutoWorkbench());
        SimpleServiceLocator.addCraftingRecipeProvider(new AssemblyAdvancedWorkbench());
        SimpleServiceLocator.addCraftingRecipeProvider(new SolderingStation());
        if (RollingMachine.load()) {
            SimpleServiceLocator.addCraftingRecipeProvider(new RollingMachine());
        }
        SolderingStationRecipes.loadRecipe();
        logisticsSign = new LogisticsSignBlock(Configs.LOGISTICS_SIGN_ID);
        ModLoader.registerBlock((amq)logisticsSign);
        logisticsSolidBlock = new LogisticsSolidBlock(Configs.LOGISTICS_SOLID_BLOCK_ID);
        ModLoader.registerBlock((amq)logisticsSolidBlock, LogisticsSolidBlockItem.class);
        powerTileEntity = SimpleServiceLocator.IC2Proxy.hasIC2() ? (SimpleServiceLocator.ccProxy.isCC() ? LogisticsPowerJuntionTileEntity_CC_IC2_BuildCraft.class : LogisticsPowerJuntionTileEntity_IC2_BuildCraft.class) : (SimpleServiceLocator.ccProxy.isCC() ? LogisticsPowerJuntionTileEntity_CC_BuildCraft.class : LogisticsPowerJuntionTileEntity_BuildCraft.class);
        if (SimpleServiceLocator.ccProxy.isCC()) {
            BuildCraftProxy.logisticsTileGenericPipe = LogisticsTileGenericPipe_CC.class;
        } else if (!Configs.LOGISTICS_TILE_GENERIC_PIPE_REPLACEMENT_DISABLED) {
            BuildCraftProxy.logisticsTileGenericPipe = LogisticsTileGenericPipe.class;
        }
        MainProxy.proxy.registerTileEntitis();
        RecipeManager.loadRecipes();
        MainProxy.proxy.registerParticles();
        LiquidIdentifier.initFromForge(false);
        LiquidIdentifier.get(9, 0, "water");
        LiquidIdentifier.get(11, 0, "lava");
    }

    @Mod.ServerStopping
    public void cleanup(FMLServerStoppingEvent event) {
        SimpleServiceLocator.routerManager.serverStopClean();
        QueuedTasks.clearAllTasks();
        HudUpdateTick.clearUpdateFlags();
        BaseLogicSatellite.cleanup();
        ServerRouter.cleanup();
        if (event.getSide().equals((Object)Side.CLIENT)) {
            LogisticsHUDRenderer.instance().clear();
        }
    }

    @Mod.ServerStarting
    public void registerCommands(FMLServerStartingEvent event) {
        event.registerServerCommand((y)new LogisticsPipesCommand());
    }

    @Mod.FingerprintWarning
    public void certificateWarning(FMLFingerprintViolationEvent warning) {
        if (!DEBUG) {
            System.out.println("[LogisticsPipes|Certificate] Certificate not correct");
            System.out.println("[LogisticsPipes|Certificate] Expected: " + warning.expectedFingerprint);
            System.out.println("[LogisticsPipes|Certificate] File: " + warning.source.getAbsolutePath());
            System.out.println("[LogisticsPipes|Certificate] This in not a LogisticsPipes version from RS485.");
            this.certificateError = true;
        }
    }

    static {
        DEBUG = "false".equals("%DEBUG%") || "false".equals("true");
        MCVersion = "1.4.7";
        LPCreativeTab = new CreativeTabLP();
    }
}

