/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.blocks.powertile;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import java.util.ArrayList;
import java.util.List;
import logisticspipes.api.ILogisticsPowerProvider;
import logisticspipes.config.Configs;
import logisticspipes.gui.hud.HUDPowerJunction;
import logisticspipes.interfaces.IBlockWatchingHandler;
import logisticspipes.interfaces.IGuiOpenControler;
import logisticspipes.interfaces.IHeadUpDisplayBlockRendererProvider;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.network.packets.PacketCoordinates;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.proxy.MainProxy;
import logisticspipes.renderer.LogisticsHUDRenderer;
import logisticspipes.utils.gui.DummyContainer;

public class LogisticsPowerJuntionTileEntity_BuildCraft
extends any
implements IPowerReceptor,
ILogisticsPowerProvider,
IGuiOpenControler,
IHeadUpDisplayBlockRendererProvider,
IBlockWatchingHandler {
    public boolean needMorePowerTriggerCheck = true;
    public final int BuildCraftMultiplier = 5;
    public final int MAX_STORAGE = 2000000;
    private IPowerProvider powerFramework;
    private List guiListener = new ArrayList();
    private int internalStorage = 0;
    private int lastUpdateStorage = 0;
    private boolean init = false;
    private List watcherList = new ArrayList();
    private IHeadUpDisplayRenderer HUD;

    public LogisticsPowerJuntionTileEntity_BuildCraft() {
        this.powerFramework = PowerFramework.currentFramework.createPowerProvider();
        this.powerFramework.configure(0, 1, 250, 1, 750);
        this.HUD = new HUDPowerJunction(this);
    }

    @Override
    public boolean useEnergy(int amount, List providersToIgnore) {
        if (providersToIgnore != null && providersToIgnore.contains(this)) {
            return false;
        }
        if (this.canUseEnergy(amount, null)) {
            this.internalStorage -= amount * Configs.POWER_USAGE_MULTIPLIER;
            if (this.internalStorage < 1000000) {
                this.needMorePowerTriggerCheck = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canUseEnergy(int amount, List providersToIgnore) {
        if (providersToIgnore != null && providersToIgnore.contains(this)) {
            return false;
        }
        return this.internalStorage >= amount * Configs.POWER_USAGE_MULTIPLIER;
    }

    @Override
    public boolean useEnergy(int amount) {
        return this.useEnergy(amount, null);
    }

    public int freeSpace() {
        return 2000000 - this.internalStorage;
    }

    public void updateClients() {
        MainProxy.sendToPlayerList(new PacketPipeInteger(71, this.l, this.m, this.n, this.internalStorage).getPacket(), this.guiListener);
        MainProxy.sendToPlayerList(new PacketPipeInteger(71, this.l, this.m, this.n, this.internalStorage).getPacket(), this.watcherList);
        this.lastUpdateStorage = this.internalStorage;
    }

    @Override
    public boolean canUseEnergy(int amount) {
        return this.canUseEnergy(amount, null);
    }

    public void addEnergy(float amount) {
        this.internalStorage = (int)((float)this.internalStorage + amount);
        if (this.internalStorage > 2000000) {
            this.internalStorage = 2000000;
        }
        if (this.internalStorage == 2000000) {
            this.needMorePowerTriggerCheck = false;
        }
    }

    public void a(bq par1nbtTagCompound) {
        super.a(par1nbtTagCompound);
        this.internalStorage = par1nbtTagCompound.e("powerLevel");
    }

    public void b(bq par1nbtTagCompound) {
        super.b(par1nbtTagCompound);
        par1nbtTagCompound.a("powerLevel", this.internalStorage);
    }

    public void g() {
        super.g();
        if (MainProxy.isServer(this.k)) {
            float energy = Math.min(this.powerFramework.getEnergyStored(), (float)(this.freeSpace() / 5));
            if (this.freeSpace() > 0 && energy == 0.0f && this.powerFramework.getEnergyStored() > 0.0f) {
                energy = 1.0f;
            }
            if (this.powerFramework.useEnergy(energy, energy, false) == energy) {
                this.powerFramework.useEnergy(energy, energy, true);
                this.addEnergy(energy * 5.0f);
            }
            if (this.internalStorage != this.lastUpdateStorage) {
                this.updateClients();
            }
        }
        if (!this.init) {
            if (MainProxy.isClient(this.k)) {
                LogisticsHUDRenderer.instance().add(this);
            }
            this.init = true;
        }
    }

    public void w_() {
        super.w_();
        if (MainProxy.isClient(this.k)) {
            LogisticsHUDRenderer.instance().remove(this);
        }
    }

    public void s() {
        super.s();
        if (MainProxy.isClient(this.k)) {
            this.init = false;
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (MainProxy.isClient(this.k)) {
            LogisticsHUDRenderer.instance().remove(this);
        }
    }

    public void setPowerProvider(IPowerProvider provider) {
        this.powerFramework = provider;
    }

    public IPowerProvider getPowerProvider() {
        return this.powerFramework;
    }

    public void doWork() {
    }

    public int powerRequest() {
        return Math.min(this.powerFramework.getMaxEnergyReceived(), this.freeSpace() / 5);
    }

    @Override
    public int getPowerLevel() {
        return this.internalStorage;
    }

    public int getChargeState() {
        return this.internalStorage * 100 / 2000000;
    }

    public rq createContainer(qx player) {
        DummyContainer dummy = new DummyContainer(player, null, this);
        dummy.addNormalSlotsForPlayerInventory(8, 80);
        return dummy;
    }

    @Override
    public void guiOpenedByPlayer(qx player) {
        this.guiListener.add(player);
        this.updateClients();
    }

    @Override
    public void guiClosedByPlayer(qx player) {
        this.guiListener.remove(player);
    }

    public void handlePowerPacket(PacketPipeInteger packet) {
        if (MainProxy.isClient(this.k)) {
            this.internalStorage = packet.integer;
        }
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public int getX() {
        return this.l;
    }

    @Override
    public int getY() {
        return this.m;
    }

    @Override
    public int getZ() {
        return this.n;
    }

    @Override
    public yc getWorld() {
        return this.k;
    }

    @Override
    public void startWaitching() {
        MainProxy.sendPacketToServer(new PacketCoordinates(72, this.l, this.m, this.n).getPacket());
    }

    @Override
    public void stopWaitching() {
        MainProxy.sendPacketToServer(new PacketCoordinates(73, this.l, this.m, this.n).getPacket());
    }

    @Override
    public void playerStartWatching(qx player) {
        this.watcherList.add(player);
        this.updateClients();
    }

    @Override
    public void playerStopWatching(qx player) {
        this.watcherList.remove(player);
    }

    @Override
    public boolean isExistend() {
        return this.k.q(this.l, this.m, this.n) == this;
    }
}

