/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui.hud;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.ArrayList;
import logisticspipes.gui.hud.BasicHUDGui;
import logisticspipes.hud.HUDConfig;
import logisticspipes.interfaces.IHUDButton;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.logisticspipes.ChassiModule;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.SimpleInventory;
import logisticspipes.utils.gui.BasicGuiHelper;
import logisticspipes.utils.gui.hud.BasicHUDButton;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class HUDChassiePipe
extends BasicHUDGui {
    private final PipeLogisticsChassi pipe;
    private final ChassiModule module;
    private final SimpleInventory moduleInventory;
    private int selected = -1;
    private int modulePage = 0;
    private int xCursor;
    private int yCursor;

    public HUDChassiePipe(PipeLogisticsChassi pipeLogisticsChassi, ChassiModule _module, SimpleInventory _moduleInventory) {
        this.pipe = pipeLogisticsChassi;
        this.module = _module;
        this.moduleInventory = _moduleInventory;
        for (int i = 0; i < this.pipe.getChassiSize(); ++i) {
            this.addButton(new ItemButton(this.moduleInventory, i, -45, -35 + i % 3 * 27, 20, 25));
        }
        this.addButton(new BasicHUDButton("<", -45, -45, 8, 8){

            @Override
            public boolean shouldRenderButton() {
                return !HUDChassiePipe.this.isSlotSelected();
            }

            @Override
            public void clicked() {
                HUDChassiePipe.this.modulePage--;
            }

            @Override
            public boolean buttonEnabled() {
                return HUDChassiePipe.this.modulePage > 0;
            }
        });
        this.addButton(new BasicHUDButton(">", -33, -45, 8, 8){

            @Override
            public boolean shouldRenderButton() {
                return !HUDChassiePipe.this.isSlotSelected();
            }

            @Override
            public void clicked() {
                HUDChassiePipe.this.modulePage++;
            }

            @Override
            public boolean buttonEnabled() {
                return HUDChassiePipe.this.modulePage < (HUDChassiePipe.this.pipe.getChassiSize() - 1) / 3;
            }
        });
        this.addButton(new BasicHUDButton("x", 37, -45, 8, 8){

            @Override
            public boolean shouldRenderButton() {
                return HUDChassiePipe.this.isSlotSelected();
            }

            @Override
            public void clicked() {
                HUDChassiePipe.this.resetSelection();
            }

            @Override
            public boolean buttonEnabled() {
                return true;
            }
        });
    }

    @Override
    public void renderHeadUpDisplay(double distance, boolean day, Minecraft mc, HUDConfig config) {
        if (day) {
            GL11.glColor4b((byte)64, (byte)64, (byte)64, (byte)64);
        } else {
            GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)64);
        }
        BasicGuiHelper.drawGuiBackGround(mc, -50, -50, 50, 50, 0.0f, false);
        if (day) {
            GL11.glColor4b((byte)64, (byte)64, (byte)64, (byte)127);
        } else {
            GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)127);
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)((double)-5.0E-5f * distance)));
        super.renderHeadUpDisplay(distance, day, mc, config);
        if (this.selected != -1) {
            ILogisticsModule selectedmodule = this.module.getSubModule(this.selected);
            if (selectedmodule == null) {
                return;
            }
            GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)64);
            BasicGuiHelper.drawGuiBackGround(mc, -23, -35, 45, 45, 0.0f, false);
            GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)127);
            if (selectedmodule instanceof IHUDModuleHandler && ((IHUDModuleHandler)((Object)selectedmodule)).getRenderer() != null) {
                GL11.glTranslatef((float)11.0f, (float)5.0f, (float)((float)((double)-5.0E-5f * distance)));
                ((IHUDModuleHandler)((Object)selectedmodule)).getRenderer().renderContent();
                if (((IHUDModuleHandler)((Object)selectedmodule)).getRenderer().getButtons() != null) {
                    for (IHUDButton button : ((IHUDModuleHandler)((Object)selectedmodule)).getRenderer().getButtons()) {
                        button.renderAlways();
                        if (button.shouldRenderButton()) {
                            button.renderButton(button.isFocused(), button.isblockFocused());
                        }
                        if (!button.buttonEnabled() || !button.shouldRenderButton()) continue;
                        if (button.getX() - 1 < this.xCursor - 11 && this.xCursor - 11 < button.getX() + button.sizeX() + 1 && button.getY() - 1 < this.yCursor - 5 && this.yCursor - 5 < button.getY() + button.sizeY() + 1) {
                            if (!button.isFocused() && !button.isblockFocused()) {
                                button.setFocused();
                                continue;
                            }
                            if (button.focusedTime() <= 400 || button.isblockFocused()) continue;
                            button.clicked();
                            button.blockFocused();
                            continue;
                        }
                        if (!button.isFocused() && !button.isblockFocused()) continue;
                        button.clearFocused();
                    }
                }
                GL11.glTranslatef((float)-11.0f, (float)-5.0f, (float)((float)((double)5.0E-5f * distance)));
            } else {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)((double)-5.0E-5f * distance)));
                mc.p.b("Nothing", -5, -15, 0);
                mc.p.b("to", 9, -5, 0);
                mc.p.b("display", -5, 5, 0);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)((double)5.0E-5f * distance)));
            }
        } else {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)((double)-0.005f * distance)));
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0E-4f);
            GL11.glScalef((float)0.8f, (float)0.8f, (float)-1.0f);
            BasicGuiHelper.renderItemIdentifierStackListIntoGui(this.pipe.displayList, null, 0, -15, -35, 3, 12, 18, 18, mc, true, true, true, true);
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)((double)5.0E-5f * distance)));
    }

    @Override
    public boolean display(HUDConfig config) {
        if (!config.isHUDChassie()) {
            return false;
        }
        for (int i = 0; i < this.moduleInventory.k_(); ++i) {
            ur stack = this.moduleInventory.a(i);
            if (stack == null || stack.c == 0) continue;
            return true;
        }
        return true;
    }

    @Override
    public boolean cursorOnWindow(int x, int y2) {
        return -50 < x && x < 50 && -50 < y2 && y2 < 50;
    }

    @Override
    public void handleCursor(int x, int y2) {
        super.handleCursor(x, y2);
        this.xCursor = x;
        this.yCursor = y2;
    }

    private void moduleClicked(int number) {
        ILogisticsModule selectedmodule;
        this.selected = number;
        if (this.selected != -1 && (selectedmodule = this.module.getSubModule(this.selected)) instanceof IHUDModuleHandler) {
            ((IHUDModuleHandler)((Object)selectedmodule)).startWatching();
        }
    }

    private void resetSelection() {
        ILogisticsModule selectedmodule;
        if (this.selected != -1 && (selectedmodule = this.module.getSubModule(this.selected)) instanceof IHUDModuleHandler) {
            ((IHUDModuleHandler)((Object)selectedmodule)).stopWatching();
        }
        this.selected = -1;
    }

    private boolean isSlotSelected() {
        return this.selected != -1;
    }

    private boolean isSlotSelected(int number) {
        return this.selected == number;
    }

    private boolean shouldDisplayButton(int number) {
        return this.modulePage * 3 <= number && number < (this.modulePage + 1) * 3;
    }

    public void stopWatching() {
        this.resetSelection();
    }

    private class ItemButton
    extends BasicHUDButton {
        private SimpleInventory inv;
        private int position;

        public ItemButton(SimpleInventory inv, int position, int x, int y2, int width, int heigth) {
            super("item." + position, x, y2, width, heigth);
            this.inv = inv;
            this.position = position;
        }

        @Override
        public void clicked() {
            HUDChassiePipe.this.moduleClicked(this.position);
        }

        @Override
        public void renderButton(boolean hover, boolean clicked) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-5.0E-5f);
            Minecraft mc = FMLClientHandler.instance().getClient();
            if (hover && !HUDChassiePipe.this.isSlotSelected(this.position)) {
                GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)127);
                if (!clicked) {
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.01f);
                }
            } else if (!this.buttonEnabled() && !HUDChassiePipe.this.isSlotSelected(this.position)) {
                GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)32);
            } else {
                GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)64);
            }
            GL11.glScaled((double)0.5, (double)0.5, (double)1.0);
            if (HUDChassiePipe.this.isSlotSelected(this.position)) {
                BasicGuiHelper.drawGuiBackGround(mc, this.posX * 2, this.posY * 2, (this.posX + this.sizeX) * 2 + 19, (this.posY + this.sizeY) * 2, 0.0f, false, true, true, true, false);
            } else {
                BasicGuiHelper.drawGuiBackGround(mc, this.posX * 2, this.posY * 2, (this.posX + this.sizeX) * 2, (this.posY + this.sizeY) * 2, 0.0f, false);
            }
            GL11.glScaled((double)2.0, (double)2.0, (double)1.0);
            if (clicked) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.01f);
            }
            ur module = this.inv.a(this.position);
            ArrayList<ItemIdentifierStack> list = new ArrayList<ItemIdentifierStack>();
            list.add(ItemIdentifierStack.GetFromStack(module));
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-5.0E-5f);
            if (!this.buttonEnabled() && !HUDChassiePipe.this.isSlotSelected(this.position)) {
                GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)32);
            } else {
                GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)127);
            }
            BasicGuiHelper.renderItemIdentifierStackListIntoGui(list, null, 0, this.posX + (this.sizeX - 16) / 2, this.posY + (this.sizeY - 16) / 2, 1, 1, 18, 18, mc, false, false, this.buttonEnabled() || HUDChassiePipe.this.isSlotSelected(this.position), true);
            if (hover) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.01f);
            }
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)1.0E-4f);
        }

        @Override
        public void renderAlways() {
            if (this.inv.a(this.position) == null && HUDChassiePipe.this.shouldDisplayButton(this.position)) {
                GL11.glPushMatrix();
                GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)64);
                GL11.glScaled((double)0.5, (double)0.5, (double)1.0);
                Minecraft mc = FMLClientHandler.instance().getClient();
                BasicGuiHelper.drawGuiBackGround(mc, this.posX * 2, this.posY * 2, (this.posX + this.sizeX) * 2, (this.posY + this.sizeY) * 2, 0.0f, false);
                GL11.glPopMatrix();
            }
        }

        @Override
        public boolean shouldRenderButton() {
            boolean result = this.inv.a(this.position) != null && HUDChassiePipe.this.shouldDisplayButton(this.position);
            return result;
        }

        @Override
        public boolean buttonEnabled() {
            return !HUDChassiePipe.this.isSlotSelected();
        }
    }
}

