/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui.hud;

import logisticspipes.gui.hud.BasicHUDGui;
import logisticspipes.hud.HUDConfig;
import logisticspipes.logic.BaseLogicSatellite;
import logisticspipes.pipes.PipeItemsSatelliteLogistics;
import logisticspipes.utils.gui.BasicGuiHelper;
import logisticspipes.utils.gui.hud.BasicHUDButton;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class HUDSatellite
extends BasicHUDGui {
    private final PipeItemsSatelliteLogistics pipe;
    private int page;

    public HUDSatellite(final PipeItemsSatelliteLogistics pipe) {
        this.pipe = pipe;
        this.addButton(new BasicHUDButton("<", -2, -40, 8, 8){

            @Override
            public void clicked() {
                if (HUDSatellite.this.page > 0) {
                    HUDSatellite.this.page--;
                }
            }

            @Override
            public boolean shouldRenderButton() {
                return pipe.itemList.size() > 0;
            }

            @Override
            public boolean buttonEnabled() {
                return HUDSatellite.this.page > 0;
            }
        });
        this.addButton(new BasicHUDButton(">", 37, -40, 8, 8){

            @Override
            public void clicked() {
                if (HUDSatellite.this.page + 1 < HUDSatellite.this.getMaxPage()) {
                    HUDSatellite.this.page++;
                }
            }

            @Override
            public boolean shouldRenderButton() {
                return pipe.itemList.size() > 0;
            }

            @Override
            public boolean buttonEnabled() {
                return HUDSatellite.this.page + 1 < HUDSatellite.this.getMaxPage();
            }
        });
    }

    @Override
    public void renderHeadUpDisplay(double distance, boolean day, Minecraft mc, HUDConfig config) {
        if (this.pipe.itemList.size() > 0) {
            if (day) {
                GL11.glColor4b((byte)64, (byte)64, (byte)64, (byte)64);
            } else {
                GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)64);
            }
            BasicGuiHelper.drawGuiBackGround(mc, -50, -50, 50, 50, 0.0f, false);
            if (day) {
                GL11.glColor4b((byte)64, (byte)64, (byte)64, (byte)127);
            } else {
                GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)127);
            }
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.01f);
            super.renderHeadUpDisplay(distance, day, mc, config);
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0E-4f);
            String message = "ID: " + Integer.toString(((BaseLogicSatellite)this.pipe.logic).satelliteId);
            mc.p.b(message, -28, -28, 0);
            GL11.glScalef((float)0.8f, (float)0.8f, (float)-1.0f);
            BasicGuiHelper.renderItemIdentifierStackListIntoGui(this.pipe.itemList, null, this.page, -35, -20, 4, 12, 18, 18, mc, true, true, true, true);
            GL11.glScalef((float)0.8f, (float)0.8f, (float)-1.0f);
            message = "(" + Integer.toString(this.page + 1) + "/" + Integer.toString(this.getMaxPage()) + ")";
            mc.p.b(message, 9, -41, 0);
        } else {
            if (day) {
                GL11.glColor4b((byte)64, (byte)64, (byte)64, (byte)64);
            } else {
                GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)64);
            }
            BasicGuiHelper.drawGuiBackGround(mc, -30, -30, 30, 30, 0.0f, false);
            if (day) {
                GL11.glColor4b((byte)64, (byte)64, (byte)64, (byte)127);
            } else {
                GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)127);
            }
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.01f);
            super.renderHeadUpDisplay(distance, day, mc, config);
            GL11.glScalef((float)3.0f, (float)3.0f, (float)1.0E-4f);
            String message = Integer.toString(((BaseLogicSatellite)this.pipe.logic).satelliteId);
            mc.p.b(message, -(mc.p.a(message) / 2), -4, 0);
        }
    }

    public int getMaxPage() {
        int ret = this.pipe.itemList.size() / 12;
        if (this.pipe.itemList.size() % 12 != 0 || ret == 0) {
            ++ret;
        }
        return ret;
    }

    @Override
    public boolean display(HUDConfig config) {
        return config.isHUDSatellite();
    }

    @Override
    public boolean cursorOnWindow(int x, int y2) {
        if (this.pipe.itemList.size() > 0) {
            return -50 < x && x < 50 && -50 < y2 && y2 < 50;
        }
        return -30 < x && x < 30 && -30 < y2 && y2 < 30;
    }

    @Override
    public void handleCursor(int x, int y2) {
        super.handleCursor(x, y2);
    }
}

