/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.items;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import logisticspipes.items.LogisticsItem;
import logisticspipes.pipes.upgrades.AdvancedSatelliteUpgrade;
import logisticspipes.pipes.upgrades.IPipeUpgrade;
import logisticspipes.pipes.upgrades.SpeedUpgrade;
import logisticspipes.pipes.upgrades.connection.ConnectionUpgradeDOWN;
import logisticspipes.pipes.upgrades.connection.ConnectionUpgradeEAST;
import logisticspipes.pipes.upgrades.connection.ConnectionUpgradeNORTH;
import logisticspipes.pipes.upgrades.connection.ConnectionUpgradeSOUTH;
import logisticspipes.pipes.upgrades.connection.ConnectionUpgradeUP;
import logisticspipes.pipes.upgrades.connection.ConnectionUpgradeWEST;
import logisticspipes.pipes.upgrades.sneaky.SneakyUpgradeDOWN;
import logisticspipes.pipes.upgrades.sneaky.SneakyUpgradeEAST;
import logisticspipes.pipes.upgrades.sneaky.SneakyUpgradeNORTH;
import logisticspipes.pipes.upgrades.sneaky.SneakyUpgradeSOUTH;
import logisticspipes.pipes.upgrades.sneaky.SneakyUpgradeUP;
import logisticspipes.pipes.upgrades.sneaky.SneakyUpgradeWEST;

public class ItemUpgrade
extends LogisticsItem {
    public static final int SNEAKY_UP = 0;
    public static final int SNEAKY_DOWN = 1;
    public static final int SNEAKY_NORTH = 2;
    public static final int SNEAKY_SOUTH = 3;
    public static final int SNEAKY_EAST = 4;
    public static final int SNEAKY_WEST = 5;
    public static final int CONNECTION_UP = 10;
    public static final int CONNECTION_DOWN = 11;
    public static final int CONNECTION_NORTH = 12;
    public static final int CONNECTION_SOUTH = 13;
    public static final int CONNECTION_EAST = 14;
    public static final int CONNECTION_WEST = 15;
    public static final int SPEED = 20;
    public static final int ADVANCED_SAT_CRAFTINGPIPE = 21;
    List upgrades = new ArrayList();

    public ItemUpgrade(int i) {
        super(i);
        this.cn = true;
    }

    public void loadUpgrades() {
        this.registerUpgrade(0, "Sneaky Upgrade (UP)", SneakyUpgradeUP.class);
        this.registerUpgrade(1, "Sneaky Upgrade (DOWN)", SneakyUpgradeDOWN.class);
        this.registerUpgrade(2, "Sneaky Upgrade (NORTH)", SneakyUpgradeNORTH.class);
        this.registerUpgrade(3, "Sneaky Upgrade (SOUTH)", SneakyUpgradeSOUTH.class);
        this.registerUpgrade(4, "Sneaky Upgrade (EAST)", SneakyUpgradeEAST.class);
        this.registerUpgrade(5, "Sneaky Upgrade (WEST)", SneakyUpgradeWEST.class);
        this.registerUpgrade(10, "Disconnection Upgrade (UP)", ConnectionUpgradeUP.class, 151);
        this.registerUpgrade(11, "Disconnection Upgrade (DOWN)", ConnectionUpgradeDOWN.class, 152);
        this.registerUpgrade(12, "Disconnection Upgrade (NORTH)", ConnectionUpgradeNORTH.class, 153);
        this.registerUpgrade(13, "Disconnection Upgrade (SOUTH)", ConnectionUpgradeSOUTH.class, 154);
        this.registerUpgrade(14, "Disconnection Upgrade (EAST)", ConnectionUpgradeEAST.class, 155);
        this.registerUpgrade(15, "Disconnection Upgrade (WEST)", ConnectionUpgradeWEST.class, 156);
        this.registerUpgrade(20, "Item Speed Upgrade", SpeedUpgrade.class, 150);
        this.registerUpgrade(21, "Advanced Satellite Upgrade", AdvancedSatelliteUpgrade.class, 157);
    }

    public void registerUpgrade(int id, String name, Class moduleClass) {
        boolean flag = true;
        for (Upgrade upgrade : this.upgrades) {
            if (upgrade.getId() != id) continue;
            flag = false;
        }
        if ("".equals(name) || !flag) {
            if (!flag) {
                throw new UnsupportedOperationException("Someting went wrong while registering a new Logistics Pipe Upgrade. (Id " + id + " already in use)");
            }
            throw new UnsupportedOperationException("Someting went wrong while registering a new Logistics Pipe Upgrade. (No name given)");
        }
        this.upgrades.add(new Upgrade(id, name, moduleClass));
    }

    public void registerUpgrade(int id, String name, Class moduleClass, int textureId) {
        boolean flag = true;
        for (Upgrade upgrade : this.upgrades) {
            if (upgrade.getId() != id) continue;
            flag = false;
        }
        if ("".equals(name) || !flag) {
            if (!flag) {
                throw new UnsupportedOperationException("Someting went wrong while registering a new Logistics Pipe Upgrade. (Id " + id + " already in use)");
            }
            throw new UnsupportedOperationException("Someting went wrong while registering a new Logistics Pipe Upgrade. (No name given)");
        }
        this.upgrades.add(new Upgrade(id, name, moduleClass, textureId));
    }

    public int[] getRegisteredUpgradeIDs() {
        int[] array = new int[this.upgrades.size()];
        int i = 0;
        for (Upgrade upgrade : this.upgrades) {
            array[i++] = upgrade.getId();
        }
        return array;
    }

    public tj w() {
        return tj.d;
    }

    public void a(int par1, tj par2CreativeTabs, List par3List) {
        for (Upgrade upgrade : this.upgrades) {
            par3List.add(new ur((up)this, 1, upgrade.getId()));
        }
    }

    public IPipeUpgrade getUpgradeForItem(ur itemStack, IPipeUpgrade currentUpgrade) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.c != this.cj) {
            return null;
        }
        for (Upgrade upgrade : this.upgrades) {
            if (itemStack.j() != upgrade.getId()) continue;
            if (upgrade.getIPipeUpgradeClass() == null) {
                return null;
            }
            if (currentUpgrade != null && upgrade.getIPipeUpgradeClass().equals(currentUpgrade.getClass())) {
                return currentUpgrade;
            }
            IPipeUpgrade newupgrade = upgrade.getIPipeUpgrade();
            if (newupgrade == null) {
                return null;
            }
            return newupgrade;
        }
        return null;
    }

    public String l(ur itemstack) {
        for (Upgrade upgrade : this.upgrades) {
            if (itemstack.j() != upgrade.getId()) continue;
            return upgrade.getName();
        }
        return null;
    }

    public int b(int i) {
        for (Upgrade upgrade : this.upgrades) {
            if (upgrade.getId() != i || upgrade.getTextureIndex() == -1) continue;
            return upgrade.getTextureIndex();
        }
        return 144 + i;
    }

    private class Upgrade {
        private String name;
        private int id;
        private Class upgradeClass;
        private int textureIndex = -1;

        private Upgrade(int id, String name, Class moduleClass) {
            this.id = id;
            this.name = name;
            this.upgradeClass = moduleClass;
        }

        private Upgrade(int id, String name, Class moduleClass, int textureIndex) {
            this.id = id;
            this.name = name;
            this.upgradeClass = moduleClass;
            this.textureIndex = textureIndex;
        }

        private IPipeUpgrade getIPipeUpgrade() {
            if (this.upgradeClass == null) {
                return null;
            }
            try {
                return (IPipeUpgrade)this.upgradeClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            return null;
        }

        private Class getIPipeUpgradeClass() {
            return this.upgradeClass;
        }

        private int getId() {
            return this.id;
        }

        private String getName() {
            return this.name;
        }

        private int getTextureIndex() {
            return this.textureIndex;
        }
    }
}

