/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logic;

import buildcraft.builders.TileBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.interfaces.routing.IRequireReliableTransport;
import logisticspipes.logic.BaseRoutingLogic;
import logisticspipes.pipes.PipeItemsBuilderSupplierLogistics;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.RequestManager;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.WorldUtil;

public class LogicBuilderSupplier
extends BaseRoutingLogic
implements IRequireReliableTransport {
    private final HashMap _requestedItems = new HashMap();
    private boolean _requestPartials = false;
    public IRoutedPowerProvider _power;
    public boolean pause = false;

    public LogicBuilderSupplier() {
        this.throttleTime = 100;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void throttledUpdateEntity() {
        if (this.pause) {
            return;
        }
        super.throttledUpdateEntity();
        WorldUtil worldUtil = new WorldUtil(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        block0: for (AdjacentTile tile : worldUtil.getAdjacentTileEntities(true)) {
            if (!(tile.tile instanceof TileBuilder)) continue;
            TileBuilder builder = (TileBuilder)tile.tile;
            IInventoryUtil invUtil = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil((la)tile.tile);
            Collection neededItems = builder.getNeededItems();
            HashMap<Object, Integer> needed = new HashMap<Object, Integer>();
            if (neededItems == null) {
                return;
            }
            for (ur stack : neededItems) {
                Map.Entry item = ItemIdentifier.get(stack);
                Integer neededCount = (Integer)needed.get(item);
                if (neededCount == null) {
                    needed.put(item, stack.a);
                    continue;
                }
                needed.put(item, neededCount + stack.a);
            }
            HashMap have = invUtil.getItemsAndCount();
            for (Map.Entry item : needed.entrySet()) {
                Integer requestedCount;
                Integer haveCount = (Integer)have.get(item.getKey());
                if (haveCount != null) {
                    item.setValue((Integer)item.getValue() - haveCount);
                }
                if ((requestedCount = (Integer)this._requestedItems.get(item.getKey())) == null) continue;
                item.setValue((Integer)item.getValue() - requestedCount);
            }
            ((PipeItemsBuilderSupplierLogistics)this.container.pipe).setRequestFailed(false);
            for (Map.Entry need : needed.entrySet()) {
                Integer amountRequested = (Integer)need.getValue();
                if (amountRequested == null || amountRequested < 1) continue;
                int neededCount = amountRequested;
                if (!this._power.useEnergy(15)) continue block0;
                boolean success = false;
                if (this._requestPartials) {
                    neededCount = RequestManager.requestPartial(((ItemIdentifier)need.getKey()).makeStack(neededCount), (IRequestItems)this.container.pipe);
                    if (neededCount > 0) {
                        success = true;
                    }
                } else {
                    success = RequestManager.request(((ItemIdentifier)need.getKey()).makeStack(neededCount), (IRequestItems)this.container.pipe, null);
                }
                if (success) {
                    Integer currentRequest = (Integer)this._requestedItems.get(need.getKey());
                    if (currentRequest == null) {
                        this._requestedItems.put(need.getKey(), neededCount);
                        continue;
                    }
                    this._requestedItems.put(need.getKey(), currentRequest + neededCount);
                    continue;
                }
                ((PipeItemsBuilderSupplierLogistics)this.container.pipe).setRequestFailed(true);
            }
        }
    }

    private void decreaseRequested(ItemIdentifierStack item) {
        int remaining = item.stackSize;
        Integer count = (Integer)this._requestedItems.get(item.getItem());
        if (count != null) {
            this._requestedItems.put(item.getItem(), Math.max(0, count - remaining));
            remaining -= count.intValue();
        }
        if (remaining <= 0) {
            return;
        }
        for (Map.Entry entry : this._requestedItems.entrySet()) {
            if (((ItemIdentifier)entry.getKey()).itemID == item.getItem().itemID && ((ItemIdentifier)entry.getKey()).itemDamage == item.getItem().itemDamage) {
                int expected = (Integer)entry.getValue();
                entry.setValue(Math.max(0, expected - remaining));
                remaining -= expected;
            }
            if (remaining > 0) continue;
            return;
        }
        LogisticsPipes.requestLog.info("builder supplier got unexpected item " + item.toString());
    }

    @Override
    public void itemLost(ItemIdentifierStack item) {
        this.decreaseRequested(item);
    }

    @Override
    public void itemArrived(ItemIdentifierStack item) {
        this.decreaseRequested(item);
        this.delayThrottle();
    }

    @Override
    public void onWrenchClicked(qx entityplayer) {
    }
}

