/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.gui.hud.modules.HUDAdvancedExtractor;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.ILogisticsGuiModule;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.IModuleInventoryReceive;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.ISneakyDirectionReceiver;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.logisticspipes.SidedInventoryAdapter;
import logisticspipes.network.packets.PacketModuleInteger;
import logisticspipes.network.packets.PacketModuleInvContent;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.InventoryHelper;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.Pair3;
import logisticspipes.utils.SimpleInventory;
import logisticspipes.utils.SinkReply;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class ModuleAdvancedExtractor
implements ILogisticsGuiModule,
ISneakyDirectionReceiver,
IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver,
IModuleInventoryReceive,
ISimpleInventoryEventHandler {
    protected int currentTick = 0;
    private final SimpleInventory _filterInventory = new SimpleInventory(9, "Item list", 1);
    private boolean _itemsIncluded = true;
    protected IInventoryProvider _invProvider;
    protected ISendRoutedItem _itemSender;
    protected IRoutedPowerProvider _power;
    private ForgeDirection _sneakyDirection = ForgeDirection.UNKNOWN;
    private int slot = 0;
    public int xCoord = 0;
    public int yCoord = 0;
    public int zCoord = 0;
    private IWorldProvider _world;
    private IHUDModuleRenderer HUD = new HUDAdvancedExtractor(this);
    private final List localModeWatchers = new ArrayList();

    public ModuleAdvancedExtractor() {
        this._filterInventory.addListener(this);
    }

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerprovider) {
        this._invProvider = invProvider;
        this._itemSender = itemSender;
        this._power = powerprovider;
        this._world = world;
    }

    public SimpleInventory getFilterInventory() {
        return this._filterInventory;
    }

    @Override
    public ForgeDirection getSneakyDirection() {
        return this._sneakyDirection;
    }

    @Override
    public void setSneakyDirection(ForgeDirection sneakyDirection) {
        this._sneakyDirection = sneakyDirection;
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        this._filterInventory.readFromNBT(nbttagcompound);
        this.setItemsIncluded(nbttagcompound.n("itemsIncluded"));
        if (nbttagcompound.b("sneakydirection")) {
            this._sneakyDirection = ForgeDirection.values()[nbttagcompound.e("sneakydirection")];
        } else if (nbttagcompound.b("sneakyorientation")) {
            int t = nbttagcompound.e("sneakyorientation");
            switch (t) {
                default: {
                    this._sneakyDirection = ForgeDirection.UNKNOWN;
                    break;
                }
                case 1: {
                    this._sneakyDirection = ForgeDirection.UP;
                    break;
                }
                case 2: {
                    this._sneakyDirection = ForgeDirection.SOUTH;
                    break;
                }
                case 3: {
                    this._sneakyDirection = ForgeDirection.DOWN;
                }
            }
        }
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        this._filterInventory.writeToNBT(nbttagcompound);
        nbttagcompound.a("itemsIncluded", this.areItemsIncluded());
        nbttagcompound.a("sneakydirection", this._sneakyDirection.ordinal());
    }

    @Override
    public int getGuiHandlerID() {
        return 27;
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority) {
        return null;
    }

    @Override
    public ILogisticsModule getSubModule(int slot) {
        return null;
    }

    protected int ticksToAction() {
        return 100;
    }

    protected int itemsToExtract() {
        return 1;
    }

    protected int neededEnergy() {
        return 6;
    }

    protected CoreRoutedPipe.ItemSendMode itemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public void tick() {
        if (++this.currentTick < this.ticksToAction()) {
            return;
        }
        this.currentTick = 0;
        la inventory = this._invProvider.getRawInventory();
        if (inventory == null) {
            return;
        }
        if (inventory instanceof ISidedInventory) {
            ForgeDirection extractOrientation = this._sneakyDirection;
            if (extractOrientation == ForgeDirection.UNKNOWN) {
                extractOrientation = this._invProvider.inventoryOrientation().getOpposite();
            }
            inventory = new SidedInventoryAdapter((ISidedInventory)inventory, extractOrientation);
        }
        this.checkExtract(inventory);
    }

    private void checkExtract(la inventory) {
        la inv = InventoryHelper.getInventory(inventory);
        for (int k = 0; k < inv.k_(); ++k) {
            ur slot;
            if (inv.a(k) == null || inventory.a((int)k).a <= 0 || (slot = inv.a(k)) == null || slot.a <= 0 || !this.CanExtract(slot)) continue;
            LinkedList<Object> jamList = new LinkedList<Object>();
            Pair3 reply = this._itemSender.hasDestination(ItemIdentifier.get(slot), true, jamList);
            if (reply == null) continue;
            int itemsleft = this.itemsToExtract();
            while (reply != null) {
                int count = Math.min(itemsleft, slot.a);
                if (((SinkReply)reply.getValue2()).maxNumberOfItems > 0) {
                    count = Math.min(count, ((SinkReply)reply.getValue2()).maxNumberOfItems);
                }
                while (!this._power.useEnergy(this.neededEnergy() * count) && count > 0) {
                    MainProxy.sendSpawnParticlePacket(7, this.xCoord, this.yCoord, this.zCoord, this._world.getWorld(), 2);
                    --count;
                }
                if (count <= 0) break;
                ur stackToSend = inv.a(k, count);
                this._itemSender.sendStack(stackToSend, reply, this.itemSendMode());
                if ((itemsleft -= count) <= 0 || !SimpleServiceLocator.buildCraftProxy.checkMaxItems() || (slot = inv.a(k)) == null) break;
                jamList.add(reply.getValue1());
                reply = this._itemSender.hasDestination(ItemIdentifier.get(slot), true, jamList);
            }
            return;
        }
    }

    public boolean CanExtract(ur item) {
        for (int i = 0; i < this._filterInventory.k_(); ++i) {
            ur stack = this._filterInventory.a(i);
            if (stack == null || stack.c != item.c) continue;
            if (up.e[item.c].n()) {
                return this.areItemsIncluded();
            }
            if (stack.j() != item.j()) continue;
            return this.areItemsIncluded();
        }
        return !this.areItemsIncluded();
    }

    public boolean areItemsIncluded() {
        return this._itemsIncluded;
    }

    public void setItemsIncluded(boolean flag) {
        this._itemsIncluded = flag;
        MainProxy.sendToPlayerList(new PacketModuleInteger(31, this.xCoord, this.yCoord, this.zCoord, this.slot, this.areItemsIncluded() ? 1 : 0).getPacket(), this.localModeWatchers);
    }

    @Override
    public List getClientInformation() {
        ArrayList<String> list = new ArrayList<String>(5);
        list.add(this.areItemsIncluded() ? "Included" : "Excluded");
        list.add("Extraction: " + (this._sneakyDirection == ForgeDirection.UNKNOWN ? "DEFAULT" : this._sneakyDirection.name()));
        list.add("Filter: ");
        list.add("<inventory>");
        list.add("<that>");
        return list;
    }

    @Override
    public void registerPosition(int xCoord, int yCoord, int zCoord, int slot) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.slot = slot;
    }

    @Override
    public void InventoryChanged(SimpleInventory inventory) {
        MainProxy.sendToPlayerList(new PacketModuleInvContent(62, this.xCoord, this.yCoord, this.zCoord, this.slot, ItemIdentifierStack.getListFromInventory(inventory)).getPacket(), this.localModeWatchers);
    }

    @Override
    public void handleInvContent(Collection list) {
        this._filterInventory.handleItemIdentifierList(list);
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(60, this.xCoord, this.yCoord, this.zCoord, this.slot).getPacket());
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(60, this.xCoord, this.yCoord, this.zCoord, this.slot).getPacket());
    }

    @Override
    public void startWatching(qx player) {
        this.localModeWatchers.add(player);
        MainProxy.sendPacketToPlayer(new PacketModuleInvContent(62, this.xCoord, this.yCoord, this.zCoord, this.slot, ItemIdentifierStack.getListFromInventory(this._filterInventory)).getPacket(), (Player)player);
        MainProxy.sendPacketToPlayer(new PacketModuleInteger(25, this.xCoord, this.yCoord, this.zCoord, this.slot, this._sneakyDirection.ordinal()).getPacket(), (Player)player);
        MainProxy.sendPacketToPlayer(new PacketModuleInteger(31, this.xCoord, this.yCoord, this.zCoord, this.slot, this.areItemsIncluded() ? 1 : 0).getPacket(), (Player)player);
    }

    @Override
    public void stopWatching(qx player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public IHUDModuleRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public int getZPos() {
        return this.zCoord;
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public List getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return false;
    }
}

