/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import java.util.List;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.interfaces.ILogisticsGuiModule;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.network.INBTPacketProvider;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.SinkReply;

public class ModuleApiaristSink
implements ILogisticsGuiModule,
INBTPacketProvider {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public SinkSetting[] filter = new SinkSetting[6];
    public IWorldProvider worldProvider;
    private IRoutedPowerProvider _power;
    private static final SinkReply _sinkReply = new SinkReply(SinkReply.FixedPriority.APIARIST_BeeSink, 0, true, false, 2, 0);

    public ModuleApiaristSink() {
        this.filter[0] = new SinkSetting(this);
        this.filter[1] = new SinkSetting(this);
        this.filter[2] = new SinkSetting(this);
        this.filter[3] = new SinkSetting(this);
        this.filter[4] = new SinkSetting(this);
        this.filter[5] = new SinkSetting(this);
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        bq filters = nbttagcompound.l("filters");
        for (int i = 0; i < this.filter.length; ++i) {
            bq filterNBT = filters.l("" + i);
            this.filter[i].readFromNBT(filterNBT);
        }
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        bq filters = new bq();
        for (int i = 0; i < this.filter.length; ++i) {
            bq filterNBT = new bq();
            this.filter[i].writeToNBT(filterNBT);
            filters.a("" + i, filterNBT);
        }
        nbttagcompound.a("filters", filters);
    }

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerprovider) {
        this.worldProvider = world;
        this._power = powerprovider;
    }

    @Override
    public int getGuiHandlerID() {
        return 28;
    }

    public boolean isFiltered(ItemIdentifier item) {
        for (int i = 0; i < 6; ++i) {
            Boolean accept = null;
            for (SinkSetting setting : this.filter) {
                if (setting.filterGroup - 1 != i) continue;
                accept = accept == null ? Boolean.valueOf(setting.isFiltered(item)) : Boolean.valueOf(accept != false && setting.isFiltered(item));
            }
            if (accept == null || !accept.booleanValue()) continue;
            return true;
        }
        for (SinkSetting setting : this.filter) {
            if (setting.filterGroup != 0 || !setting.isFiltered(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier itemID, int bestPriority, int bestCustomPriority) {
        if (bestPriority > ModuleApiaristSink._sinkReply.fixedPriority.ordinal() || bestPriority == ModuleApiaristSink._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= ModuleApiaristSink._sinkReply.customPriority) {
            return null;
        }
        ur item = itemID.makeNormalStack(1);
        if (SimpleServiceLocator.forestryProxy.isBee(item) && SimpleServiceLocator.forestryProxy.isAnalysedBee(item) && this.isFiltered(itemID) && this._power.canUseEnergy(2)) {
            return _sinkReply;
        }
        return null;
    }

    @Override
    public ILogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void tick() {
    }

    @Override
    public void readFromPacketNBT(bq tag) {
        this.readFromNBT(tag);
    }

    @Override
    public void writeToPacketNBT(bq tag) {
        this.writeToNBT(tag);
    }

    @Override
    public void registerPosition(int xCoord, int yCoord, int zCoord, int slot) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    @Override
    public List getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    public static class SinkSetting {
        private final ModuleApiaristSink module;
        public FilterType filterType = FilterType.Null;
        public String firstBee = "";
        public String secondBee = "";
        public int filterGroup = 0;

        public SinkSetting(ModuleApiaristSink module) {
            this.module = module;
        }

        public void firstBeeUp() {
            this.firstBee = SimpleServiceLocator.forestryProxy.getNextAlleleId(this.firstBee, this.module.worldProvider.getWorld());
        }

        public void firstBeeDown() {
            this.firstBee = SimpleServiceLocator.forestryProxy.getPrevAlleleId(this.firstBee, this.module.worldProvider.getWorld());
        }

        public void firstBeeReset() {
            this.firstBee = "";
        }

        public void secondBeeUp() {
            this.secondBee = SimpleServiceLocator.forestryProxy.getNextAlleleId(this.secondBee, this.module.worldProvider.getWorld());
        }

        public void secondBeeDown() {
            this.secondBee = SimpleServiceLocator.forestryProxy.getPrevAlleleId(this.secondBee, this.module.worldProvider.getWorld());
        }

        public void secondBeeReset() {
            this.secondBee = "";
        }

        public void filterGroupUp() {
            this.filterGroup = this.filterGroup <= 5 ? ++this.filterGroup : 0;
        }

        public void filterGroupDown() {
            this.filterGroup = this.filterGroup >= 1 ? --this.filterGroup : 6;
        }

        public void filterGroupReset() {
            this.filterGroup = 0;
        }

        public void FilterTypeUp() {
            this.filterType = this.filterType.ordinal() + 1 >= FilterType.values().length ? FilterType.values()[0] : FilterType.values()[this.filterType.ordinal() + 1];
        }

        public void FilterTypeDown() {
            this.filterType = this.filterType.ordinal() - 1 < 0 ? FilterType.values()[FilterType.values().length - 1] : FilterType.values()[this.filterType.ordinal() - 1];
        }

        public void FilterTypeReset() {
            this.filterType = FilterType.Null;
        }

        public void readFromNBT(bq nbttagcompound) {
            this.filterType = nbttagcompound.b("filterType") ? FilterType.values()[nbttagcompound.e("filterType")] : FilterType.Null;
            this.firstBee = nbttagcompound.i("firstBeeString");
            this.secondBee = nbttagcompound.i("secondBeeString");
            this.filterGroup = nbttagcompound.e("filterGroup");
        }

        public void writeToNBT(bq nbttagcompound) {
            nbttagcompound.a("filterType", this.filterType.ordinal());
            nbttagcompound.a("firstBeeString", this.firstBee);
            nbttagcompound.a("secondBeeString", this.secondBee);
            nbttagcompound.a("filterGroup", this.filterGroup);
        }

        private boolean allAllele(ur bee) {
            return this.firstAllele(bee) && this.secondAllele(bee);
        }

        private boolean firstAllele(ur bee) {
            return SimpleServiceLocator.forestryProxy.getFirstAlleleId(bee).equals(this.firstBee) || this.firstBee.equals("");
        }

        private boolean secondAllele(ur bee) {
            return SimpleServiceLocator.forestryProxy.getSecondAlleleId(bee).equals(this.secondBee) || this.secondBee.equals("");
        }

        public boolean isFiltered(ItemIdentifier itemID) {
            ur item = itemID.makeNormalStack(1);
            switch (this.filterType) {
                case BeeAllele: {
                    return this.allAllele(item);
                }
                case Drone: {
                    return this.allAllele(item) && SimpleServiceLocator.forestryProxy.isDrone(item);
                }
                case Princess: {
                    return this.allAllele(item) && SimpleServiceLocator.forestryProxy.isPrincess(item);
                }
                case Queen: {
                    return this.allAllele(item) && SimpleServiceLocator.forestryProxy.isQueen(item);
                }
                case Purebred: {
                    return this.firstAllele(item) && SimpleServiceLocator.forestryProxy.isPurebred(item);
                }
                case Nocturnal: {
                    return this.allAllele(item) && SimpleServiceLocator.forestryProxy.isNocturnal(item);
                }
                case PureNocturnal: {
                    return this.allAllele(item) && SimpleServiceLocator.forestryProxy.isPureNocturnal(item);
                }
                case Flyer: {
                    return this.allAllele(item) && SimpleServiceLocator.forestryProxy.isFlyer(item);
                }
                case PureFlyer: {
                    return this.allAllele(item) && SimpleServiceLocator.forestryProxy.isPureFlyer(item);
                }
                case Cave: {
                    return this.allAllele(item) && SimpleServiceLocator.forestryProxy.isCave(item);
                }
                case PureCave: {
                    return this.allAllele(item) && SimpleServiceLocator.forestryProxy.isPureCave(item);
                }
            }
            return false;
        }
    }

    public static enum FilterType {
        Null("", 0, 0),
        BeeAllele("gui.pipe.filter.BEE", 3, 2),
        Drone("gui.pipe.filter.DRONE", 4, 2),
        Princess("gui.pipe.filter.PRINCESS", 5, 2),
        Queen("gui.pipe.filter.QUEEN", 6, 2),
        Purebred("gui.pipe.filter.PURE_BREED", 7, 1),
        Nocturnal("gui.pipe.filter.NOCTURNAL", 8, 2),
        PureNocturnal("gui.pipe.filter.PURE_NOCTURNAL", 9, 2),
        Flyer("gui.pipe.filter.FLYER", 10, 2),
        PureFlyer("gui.pipe.filter.PURE_FLYER", 11, 2),
        Cave("gui.pipe.filter.CAVE", 12, 2),
        PureCave("gui.pipe.filter.PURE_CAVE", 13, 2);

        public String path;
        public int icon;
        public int secondSlots;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private FilterType(int text) {
            void secondSlot;
            void id;
            this.path = (String)text;
            this.icon = id;
            this.secondSlots = secondSlot;
        }
    }
}

