/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import buildcraft.api.inventory.ISpecialInventory;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.LogisticsPipes;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.gui.hud.modules.HUDExtractor;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.ILogisticsGuiModule;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.ISneakyDirectionReceiver;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.logisticspipes.SidedInventoryAdapter;
import logisticspipes.network.packets.PacketModuleInteger;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.Pair3;
import logisticspipes.utils.SinkReply;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class ModuleExtractor
implements ILogisticsGuiModule,
ISneakyDirectionReceiver,
IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver {
    private int currentTick = 0;
    private IInventoryProvider _invProvider;
    private ISendRoutedItem _itemSender;
    private IRoutedPowerProvider _power;
    private ForgeDirection _sneakyDirection = ForgeDirection.UNKNOWN;
    private IWorldProvider _world;
    private int slot = 0;
    private int xCoord = 0;
    private int yCoord = 0;
    private int zCoord = 0;
    private IHUDModuleRenderer HUD = new HUDExtractor(this);
    private final List localModeWatchers = new ArrayList();

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerprovider) {
        this._invProvider = invProvider;
        this._itemSender = itemSender;
        this._power = powerprovider;
        this._world = world;
    }

    protected int ticksToAction() {
        return 100;
    }

    protected int itemsToExtract() {
        return 1;
    }

    protected int neededEnergy() {
        return 5;
    }

    protected CoreRoutedPipe.ItemSendMode itemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public ForgeDirection getSneakyDirection() {
        return this._sneakyDirection;
    }

    @Override
    public void setSneakyDirection(ForgeDirection sneakyDirection) {
        this._sneakyDirection = sneakyDirection;
        MainProxy.sendToPlayerList(new PacketModuleInteger(25, this.xCoord, this.yCoord, this.zCoord, this.slot, this._sneakyDirection.ordinal()).getPacket(), this.localModeWatchers);
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority) {
        return null;
    }

    @Override
    public int getGuiHandlerID() {
        return 20;
    }

    @Override
    public ILogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        if (nbttagcompound.b("sneakydirection")) {
            this._sneakyDirection = ForgeDirection.values()[nbttagcompound.e("sneakydirection")];
        } else if (nbttagcompound.b("sneakyorientation")) {
            int t = nbttagcompound.e("sneakyorientation");
            switch (t) {
                default: {
                    this._sneakyDirection = ForgeDirection.UNKNOWN;
                    break;
                }
                case 1: {
                    this._sneakyDirection = ForgeDirection.UP;
                    break;
                }
                case 2: {
                    this._sneakyDirection = ForgeDirection.SOUTH;
                    break;
                }
                case 3: {
                    this._sneakyDirection = ForgeDirection.DOWN;
                }
            }
        }
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        nbttagcompound.a("sneakydirection", this._sneakyDirection.ordinal());
    }

    @Override
    public void tick() {
        if (++this.currentTick < this.ticksToAction()) {
            return;
        }
        this.currentTick = 0;
        la targetInventory = this._invProvider.getRawInventory();
        if (targetInventory == null) {
            return;
        }
        ForgeDirection extractOrientation = this._sneakyDirection;
        if (extractOrientation == ForgeDirection.UNKNOWN) {
            extractOrientation = this._invProvider.inventoryOrientation().getOpposite();
        }
        if (targetInventory instanceof ISpecialInventory) {
            ur[] stack = ((ISpecialInventory)targetInventory).extractItem(false, extractOrientation, 1);
            if (stack == null || stack.length < 1 || stack[0] == null || stack[0].a == 0) {
                return;
            }
            Pair3 reply = this._itemSender.hasDestination(ItemIdentifier.get(stack[0]), true, new ArrayList());
            if (reply == null) {
                return;
            }
            ur[] stacks = ((ISpecialInventory)targetInventory).extractItem(true, extractOrientation, 1);
            if (stacks == null || stacks.length < 1 || stacks[0] == null || stacks[0].a == 0) {
                LogisticsPipes.log.info("extractor extractItem(true) got nothing from " + targetInventory.toString());
                return;
            }
            if (!ur.b((ur)stack[0], (ur)stacks[0])) {
                LogisticsPipes.log.info("extractor extract got a unexpected item from " + targetInventory.toString());
            }
            this._itemSender.sendStack(stacks[0], reply, this.itemSendMode());
            return;
        }
        if (targetInventory instanceof ISidedInventory) {
            targetInventory = new SidedInventoryAdapter((ISidedInventory)targetInventory, extractOrientation);
        }
        block0: for (int i = 0; i < targetInventory.k_(); ++i) {
            ur slot = targetInventory.a(i);
            if (slot == null) continue;
            LinkedList<Object> jamList = new LinkedList<Object>();
            Pair3 reply = this._itemSender.hasDestination(ItemIdentifier.get(slot), true, jamList);
            if (reply == null) continue;
            int itemsleft = this.itemsToExtract();
            while (reply != null) {
                int count = Math.min(itemsleft, slot.a);
                if (((SinkReply)reply.getValue2()).maxNumberOfItems > 0) {
                    count = Math.min(count, ((SinkReply)reply.getValue2()).maxNumberOfItems);
                }
                while (!this._power.useEnergy(this.neededEnergy() * count) && count > 0) {
                    MainProxy.sendSpawnParticlePacket(7, this.xCoord, this.yCoord, this.zCoord, this._world.getWorld(), 2);
                    --count;
                }
                if (count <= 0) break block0;
                ur stackToSend = targetInventory.a(i, count);
                this._itemSender.sendStack(stackToSend, reply, this.itemSendMode());
                if ((itemsleft -= count) <= 0 || !SimpleServiceLocator.buildCraftProxy.checkMaxItems() || (slot = targetInventory.a(i)) == null) break block0;
                jamList.add(reply.getValue1());
                reply = this._itemSender.hasDestination(ItemIdentifier.get(slot), true, jamList);
            }
            break;
        }
    }

    @Override
    public List getClientInformation() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("Extraction: " + (this._sneakyDirection == ForgeDirection.UNKNOWN ? "DEFAULT" : this._sneakyDirection.name()));
        return list;
    }

    @Override
    public void registerPosition(int xCoord, int yCoord, int zCoord, int slot) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.slot = slot;
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(60, this.xCoord, this.yCoord, this.zCoord, this.slot).getPacket());
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(60, this.xCoord, this.yCoord, this.zCoord, this.slot).getPacket());
    }

    @Override
    public void startWatching(qx player) {
        this.localModeWatchers.add(player);
        MainProxy.sendToPlayerList(new PacketModuleInteger(25, this.xCoord, this.yCoord, this.zCoord, this.slot, this._sneakyDirection.ordinal()).getPacket(), this.localModeWatchers);
    }

    @Override
    public void stopWatching(qx player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public IHUDModuleRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public int getZPos() {
        return this.zCoord;
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public List getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return false;
    }
}

