/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.gui.hud.modules.HUDModBasedItemSink;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.ILogisticsGuiModule;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.network.packets.PacketModuleNBT;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.SinkReply;

public class ModuleModBasedItemSink
implements ILogisticsGuiModule,
IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver {
    public final List modList = new LinkedList();
    private BitSet modIdSet;
    private int slot = 0;
    private int xCoord = 0;
    private int yCoord = 0;
    private int zCoord = 0;
    private IHUDModuleRenderer HUD = new HUDModBasedItemSink(this);
    private IRoutedPowerProvider _power;
    private IWorldProvider _world;
    private final List localModeWatchers = new ArrayList();
    private static final SinkReply _sinkReply = new SinkReply(SinkReply.FixedPriority.ModBasedItemSink, 0, true, false, 5, 0);

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerprovider) {
        this._power = powerprovider;
        this._world = world;
    }

    @Override
    public void registerPosition(int xCoord, int yCoord, int zCoord, int slot) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.slot = slot;
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority) {
        if (bestPriority > ModuleModBasedItemSink._sinkReply.fixedPriority.ordinal() || bestPriority == ModuleModBasedItemSink._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= ModuleModBasedItemSink._sinkReply.customPriority) {
            return null;
        }
        if (this.modIdSet == null) {
            this.buildModIdSet();
        }
        if (this.modIdSet.get(item.getModId()) && this._power.canUseEnergy(5)) {
            return _sinkReply;
        }
        return null;
    }

    @Override
    public int getGuiHandlerID() {
        return 29;
    }

    @Override
    public ILogisticsModule getSubModule(int slot) {
        return null;
    }

    private void buildModIdSet() {
        this.modIdSet = new BitSet();
        for (String modname : this.modList) {
            int modid = ItemIdentifier.getModIdForName(modname);
            this.modIdSet.set(modid);
        }
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        this.modList.clear();
        int limit = nbttagcompound.e("listSize");
        for (int i = 0; i < limit; ++i) {
            this.modList.add(nbttagcompound.i("Mod" + i));
        }
        this.modIdSet = null;
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        nbttagcompound.a("listSize", this.modList.size());
        for (int i = 0; i < this.modList.size(); ++i) {
            nbttagcompound.a("Mod" + i, (String)this.modList.get(i));
        }
        this.modIdSet = null;
    }

    @Override
    public void tick() {
    }

    @Override
    public List getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Mods: ");
        list.addAll(this.modList);
        return list;
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(60, this.xCoord, this.yCoord, this.zCoord, this.slot).getPacket());
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(60, this.xCoord, this.yCoord, this.zCoord, this.slot).getPacket());
    }

    @Override
    public void startWatching(qx player) {
        this.localModeWatchers.add(player);
        bq nbt = new bq();
        this.writeToNBT(nbt);
        MainProxy.sendPacketToPlayer(new PacketModuleNBT(86, this.xCoord, this.yCoord, this.zCoord, this.slot, nbt).getPacket(), (Player)player);
    }

    @Override
    public void stopWatching(qx player) {
        this.localModeWatchers.remove(player);
    }

    public void ModListChanged() {
        if (MainProxy.isServer(this._world.getWorld())) {
            bq nbt = new bq();
            this.writeToNBT(nbt);
            MainProxy.sendToPlayerList(new PacketModuleNBT(86, this.xCoord, this.yCoord, this.zCoord, this.slot, nbt).getPacket(), this.localModeWatchers);
        } else {
            bq nbt = new bq();
            this.writeToNBT(nbt);
            MainProxy.sendPacketToServer(new PacketModuleNBT(86, this.xCoord, this.yCoord, this.zCoord, this.slot, nbt).getPacket());
        }
    }

    @Override
    public IHUDModuleRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    @Override
    public List getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }
}

