/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.gui.hud.modules.HUDPassiveSupplier;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ILogisticsGuiModule;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.IModuleInventoryReceive;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.network.packets.PacketModuleInvContent;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.SimpleInventory;
import logisticspipes.utils.SinkReply;

public class ModulePassiveSupplier
implements ILogisticsGuiModule,
IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver,
IModuleInventoryReceive,
ISimpleInventoryEventHandler {
    private final SimpleInventory _filterInventory = new SimpleInventory(9, "Requested items", 64);
    private IInventoryProvider _invProvider;
    private IRoutedPowerProvider _power;
    private int slot = 0;
    private int xCoord = 0;
    private int yCoord = 0;
    private int zCoord = 0;
    private IHUDModuleRenderer HUD = new HUDPassiveSupplier(this);
    private final List localModeWatchers = new ArrayList();
    private static final SinkReply _sinkReply = new SinkReply(SinkReply.FixedPriority.PassiveSupplier, 0, true, false, 2, 0);

    public ModulePassiveSupplier() {
        this._filterInventory.addListener(this);
    }

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerprovider) {
        this._invProvider = invProvider;
        this._power = powerprovider;
    }

    public la getFilterInventory() {
        return this._filterInventory;
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority) {
        IInventoryUtil targetUtil;
        int haveCount;
        if (bestPriority > ModulePassiveSupplier._sinkReply.fixedPriority.ordinal() || bestPriority == ModulePassiveSupplier._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= ModulePassiveSupplier._sinkReply.customPriority) {
            return null;
        }
        la targetInventory = this._invProvider.getSneakyInventory();
        if (targetInventory == null) {
            return null;
        }
        if (!this._filterInventory.containsItem(item)) {
            return null;
        }
        int targetCount = this._filterInventory.itemCount(item);
        if (targetCount <= (haveCount = (targetUtil = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(targetInventory)).itemCount(item))) {
            return null;
        }
        if (this._power.canUseEnergy(2)) {
            return new SinkReply(_sinkReply, targetCount - haveCount);
        }
        return null;
    }

    @Override
    public int getGuiHandlerID() {
        return 23;
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        this._filterInventory.readFromNBT(nbttagcompound, "");
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        this._filterInventory.writeToNBT(nbttagcompound, "");
    }

    @Override
    public ILogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void tick() {
    }

    @Override
    public List getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Supplied: ");
        list.add("<inventory>");
        list.add("<that>");
        return list;
    }

    @Override
    public void registerPosition(int xCoord, int yCoord, int zCoord, int slot) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.slot = slot;
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(60, this.xCoord, this.yCoord, this.zCoord, this.slot).getPacket());
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(60, this.xCoord, this.yCoord, this.zCoord, this.slot).getPacket());
    }

    @Override
    public void startWatching(qx player) {
        this.localModeWatchers.add(player);
        MainProxy.sendPacketToPlayer(new PacketModuleInvContent(62, this.xCoord, this.yCoord, this.zCoord, this.slot, ItemIdentifierStack.getListFromInventory(this._filterInventory)).getPacket(), (Player)player);
    }

    @Override
    public void stopWatching(qx player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public IHUDModuleRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public void handleInvContent(Collection list) {
        this._filterInventory.handleItemIdentifierList(list);
    }

    @Override
    public void InventoryChanged(SimpleInventory inventory) {
        MainProxy.sendToPlayerList(new PacketModuleInvContent(62, this.xCoord, this.yCoord, this.zCoord, this.slot, ItemIdentifierStack.getListFromInventory(this._filterInventory)).getPacket(), this.localModeWatchers);
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public List getSpecificInterests() {
        Map mapIC = this._filterInventory.getItemsAndCount();
        ArrayList li = new ArrayList(mapIC.size());
        li.addAll(mapIC.keySet());
        return li;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }
}

