/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import java.util.List;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.SinkReply;

public class ModulePolymorphicItemSink
implements ILogisticsModule {
    private IInventoryProvider _invProvider;
    private IRoutedPowerProvider _power;
    private static final SinkReply _sinkReply = new SinkReply(SinkReply.FixedPriority.ItemSink, 0, true, false, 3, 0);

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerprovider) {
        this._invProvider = invProvider;
        this._power = powerprovider;
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority) {
        if (bestPriority > ModulePolymorphicItemSink._sinkReply.fixedPriority.ordinal() || bestPriority == ModulePolymorphicItemSink._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= ModulePolymorphicItemSink._sinkReply.customPriority) {
            return null;
        }
        la targetInventory = this._invProvider.getSneakyInventory();
        if (targetInventory == null) {
            return null;
        }
        IInventoryUtil invUtil = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(targetInventory);
        if (!invUtil.containsUndamagedItem(item.getUndamaged())) {
            return null;
        }
        if (this._power.canUseEnergy(3)) {
            return _sinkReply;
        }
        return null;
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
    }

    @Override
    public ILogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void tick() {
    }

    @Override
    public void registerPosition(int xCoord, int yCoord, int zCoord, int slot) {
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public List getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return true;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return true;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }
}

