/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.ILogisticsGuiModule;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.network.packets.PacketModuleNBT;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.SinkReply;

public class ModuleThaumicAspectSink
implements ILogisticsGuiModule,
IClientInformationProvider,
IModuleWatchReciver {
    private int slot = 0;
    private int xCoord = 0;
    private int yCoord = 0;
    private int zCoord = 0;
    private IRoutedPowerProvider _power;
    private IWorldProvider _world;
    public final List aspectList = new LinkedList();
    private final List localModeWatchers = new ArrayList();
    private static final SinkReply _sinkReply = new SinkReply(SinkReply.FixedPriority.ItemSink, -2, true, false, 5, 0);

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerProvider) {
        this._power = powerProvider;
        this._world = world;
    }

    @Override
    public void registerPosition(int xCoord, int yCoord, int zCoord, int slot) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.slot = slot;
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority) {
        if (bestPriority > ModuleThaumicAspectSink._sinkReply.fixedPriority.ordinal() || bestPriority == ModuleThaumicAspectSink._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= ModuleThaumicAspectSink._sinkReply.customPriority) {
            return null;
        }
        if (this.isOfInterest(item)) {
            return _sinkReply;
        }
        return null;
    }

    private boolean isOfInterest(ItemIdentifier itemID) {
        if (itemID == null || this.aspectList.size() == 0) {
            return false;
        }
        ur item = itemID.makeNormalStack(1);
        List itemAspectList = SimpleServiceLocator.thaumCraftProxy.getListOfTagIDsForStack(item);
        if (itemAspectList.size() == 0 || itemAspectList == null) {
            return false;
        }
        for (int i = 0; i < itemAspectList.size(); ++i) {
            if (!this.aspectList.contains(itemAspectList.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public ILogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void tick() {
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        this.aspectList.clear();
        int size = nbttagcompound.e("aspectListSize");
        if (size <= 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            this.aspectList.add(nbttagcompound.e("aspect" + i));
        }
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        nbttagcompound.a("aspectListSize", this.aspectList.size());
        if (this.aspectList.size() <= 0) {
            return;
        }
        for (int i = 0; i < this.aspectList.size(); ++i) {
            nbttagcompound.a("aspect" + i, ((Integer)this.aspectList.get(i)).intValue());
        }
    }

    @Override
    public void startWatching(qx player) {
        this.localModeWatchers.add(player);
        bq nbt = new bq();
        this.writeToNBT(nbt);
        MainProxy.sendPacketToPlayer(new PacketModuleNBT(90, this.xCoord, this.yCoord, this.zCoord, this.slot, nbt).getPacket(), (Player)player);
    }

    @Override
    public void stopWatching(qx player) {
        this.localModeWatchers.remove(player);
    }

    public void aspectListChanged() {
        if (MainProxy.isServer(this._world.getWorld())) {
            bq nbt = new bq();
            this.writeToNBT(nbt);
            MainProxy.sendToPlayerList(new PacketModuleNBT(90, this.xCoord, this.yCoord, this.zCoord, this.slot, nbt).getPacket(), this.localModeWatchers);
        } else {
            bq nbt = new bq();
            this.writeToNBT(nbt);
            MainProxy.sendPacketToServer(new PacketModuleNBT(90, this.xCoord, this.yCoord, this.zCoord, this.slot, nbt).getPacket());
        }
    }

    @Override
    public List getClientInformation() {
        ArrayList<String> info = new ArrayList<String>();
        info.add("Aspects: ");
        if (this.aspectList.size() == 0) {
            info.add("none");
        }
        for (int i = 0; i < this.aspectList.size(); ++i) {
            info.add(" - " + SimpleServiceLocator.thaumCraftProxy.getNameForTagID((Integer)this.aspectList.get(i)));
        }
        return info;
    }

    @Override
    public int getGuiHandlerID() {
        return 41;
    }

    public void handleItem(ur stack) {
        List itemAspectList = SimpleServiceLocator.thaumCraftProxy.getListOfTagIDsForStack(stack);
        if (itemAspectList == null) {
            return;
        }
        boolean listChanged = false;
        for (int i = 0; i < itemAspectList.size(); ++i) {
            if (this.aspectList.contains(itemAspectList.get(i)) || this.aspectList.size() >= 9) continue;
            this.aspectList.add(itemAspectList.get(i));
            listChanged = true;
        }
        if (listChanged) {
            this.aspectListChanged();
        }
    }

    public void clearAspectList() {
        bq nbt = new bq();
        this.readFromNBT(nbt);
        this.aspectListChanged();
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    @Override
    public List getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }
}

