/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network;

import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import logisticspipes.LogisticsPipes;
import logisticspipes.blocks.LogisticsSecurityTileEntity;
import logisticspipes.blocks.LogisticsSolderingTileEntity;
import logisticspipes.blocks.powertile.LogisticsPowerJuntionTileEntity_BuildCraft;
import logisticspipes.config.Configs;
import logisticspipes.gui.GuiInvSysConnector;
import logisticspipes.gui.GuiProviderPipe;
import logisticspipes.gui.GuiSecurityStation;
import logisticspipes.gui.GuiSupplierPipe;
import logisticspipes.gui.modules.GuiAdvancedExtractor;
import logisticspipes.gui.modules.GuiExtractor;
import logisticspipes.gui.modules.GuiProvider;
import logisticspipes.gui.orderer.GuiOrderer;
import logisticspipes.gui.popup.GuiDiskPopup;
import logisticspipes.interfaces.IChestContentReceiver;
import logisticspipes.interfaces.IModuleInventoryReceive;
import logisticspipes.interfaces.IOrderManagerContentReceiver;
import logisticspipes.interfaces.IRotationProvider;
import logisticspipes.interfaces.ISendQueueContentRecieiver;
import logisticspipes.interfaces.ISneakyDirectionReceiver;
import logisticspipes.interfaces.PlayerListReciver;
import logisticspipes.items.PacketInteger;
import logisticspipes.logic.BaseLogicCrafting;
import logisticspipes.logic.BaseLogicSatellite;
import logisticspipes.logic.LogicLiquidSupplier;
import logisticspipes.logic.LogicProvider;
import logisticspipes.logic.LogicSupplier;
import logisticspipes.modules.ModuleAdvancedExtractor;
import logisticspipes.modules.ModuleApiaristSink;
import logisticspipes.modules.ModuleElectricManager;
import logisticspipes.modules.ModuleItemSink;
import logisticspipes.modules.ModuleModBasedItemSink;
import logisticspipes.modules.ModuleThaumicAspectSink;
import logisticspipes.nei.LoadingHelper;
import logisticspipes.network.GuiHandler;
import logisticspipes.network.TilePacketWrapper;
import logisticspipes.network.packets.GuiArgumentPacket;
import logisticspipes.network.packets.PacketBufferTransfer;
import logisticspipes.network.packets.PacketCoordinatesUUID;
import logisticspipes.network.packets.PacketCraftingLoop;
import logisticspipes.network.packets.PacketInventoryChange;
import logisticspipes.network.packets.PacketItem;
import logisticspipes.network.packets.PacketItems;
import logisticspipes.network.packets.PacketLiquidUpdate;
import logisticspipes.network.packets.PacketModuleInteger;
import logisticspipes.network.packets.PacketModuleInvContent;
import logisticspipes.network.packets.PacketModuleNBT;
import logisticspipes.network.packets.PacketNBT;
import logisticspipes.network.packets.PacketNameUpdatePacket;
import logisticspipes.network.packets.PacketPipeBitSet;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.network.packets.PacketPipeInvContent;
import logisticspipes.network.packets.PacketPipeUpdate;
import logisticspipes.network.packets.PacketRenderFX;
import logisticspipes.network.packets.PacketRequestGuiContent;
import logisticspipes.network.packets.PacketRoutingStats;
import logisticspipes.network.packets.PacketSimulate;
import logisticspipes.network.packets.PacketStringList;
import logisticspipes.pipes.PipeItemsApiaristSink;
import logisticspipes.pipes.PipeItemsFirewall;
import logisticspipes.pipes.PipeItemsInvSysConnector;
import logisticspipes.pipes.PipeItemsLiquidSupplier;
import logisticspipes.pipes.PipeItemsRequestLogisticsMk2;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.security.SecuritySettings;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemMessage;
import logisticspipes.utils.gui.ISubGuiControler;
import net.minecraftforge.common.ForgeDirection;

public class ClientPacketHandler {
    public static void onPacketData(ce manager, di packet, Player player) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.c));
        ClientPacketHandler.onPacketData(data, player);
    }

    public static void onPacketData(DataInputStream data, Player player) {
        try {
            int packetID = data.read();
            switch (packetID) {
                case 3: {
                    PacketPipeInteger packetA1 = new PacketPipeInteger();
                    packetA1.readData(data);
                    ClientPacketHandler.onCraftingPipeSetSatellite(packetA1);
                    break;
                }
                case 5: {
                    PacketInventoryChange packetA = new PacketInventoryChange();
                    packetA.readData(data);
                    ClientPacketHandler.onCraftingPipeSetImport(packetA);
                    break;
                }
                case 8: {
                    PacketPipeInteger packetB = new PacketPipeInteger();
                    packetB.readData(data);
                    ClientPacketHandler.onSatellitePipeSetSatellite(packetB);
                    break;
                }
                case 13: {
                    PacketRequestGuiContent packetC = new PacketRequestGuiContent();
                    packetC.readData(data);
                    ClientPacketHandler.onOrdererRefreshAnswer(packetC);
                    break;
                }
                case 14: {
                    PacketItems packetD = new PacketItems();
                    packetD.readData(data);
                    ClientPacketHandler.onItemsResponse(packetD);
                    break;
                }
                case 15: {
                    PacketCraftingLoop packetE = new PacketCraftingLoop();
                    packetE.readData(data);
                    ClientPacketHandler.onCraftingLoop(packetE);
                    break;
                }
                case 17: {
                    PacketModuleInteger packetH = new PacketModuleInteger();
                    packetH.readData(data);
                    ClientPacketHandler.onItemSinkStatusRecive(packetH);
                    break;
                }
                case 20: {
                    PacketPipeInteger packetF = new PacketPipeInteger();
                    packetF.readData(data);
                    ClientPacketHandler.onProviderPipeModeRecive(packetF);
                    break;
                }
                case 21: {
                    PacketPipeInteger packetG = new PacketPipeInteger();
                    packetG.readData(data);
                    ClientPacketHandler.onProviderPipeIncludeRecive(packetG);
                    break;
                }
                case 23: {
                    PacketPipeInteger packetI = new PacketPipeInteger();
                    packetI.readData(data);
                    ClientPacketHandler.onSupplierPipeRecive(packetI);
                    break;
                }
                case 25: {
                    PacketModuleInteger packetJ = new PacketModuleInteger();
                    packetJ.readData(data);
                    ClientPacketHandler.onModulePipeRecive(packetJ);
                    break;
                }
                case 28: {
                    PacketPipeInteger packetK = new PacketPipeInteger();
                    packetK.readData(data);
                    ClientPacketHandler.onProviderModuleModeRecive(packetK);
                    break;
                }
                case 29: {
                    PacketPipeInteger packetL = new PacketPipeInteger();
                    packetL.readData(data);
                    ClientPacketHandler.onProviderModuleIncludeRecive(packetL);
                    break;
                }
                case 31: {
                    PacketModuleInteger packetM = new PacketModuleInteger();
                    packetM.readData(data);
                    ClientPacketHandler.onAdvancedExtractorModuleIncludeRecive(packetM);
                    break;
                }
                case 38: {
                    PacketItem packetO = new PacketItem();
                    packetO.readData(data);
                    ClientPacketHandler.handleRequestMK2DiskItem(packetO);
                    break;
                }
                case 36: {
                    PacketPipeUpdate packetOa = new PacketPipeUpdate();
                    packetOa.readData(data);
                    ClientPacketHandler.handlePacketPipeUpdate(packetOa);
                    break;
                }
                case 42: {
                    PacketItems packetP = new PacketItems();
                    packetP.readData(data);
                    ClientPacketHandler.handleMacroResponse(packetP);
                    break;
                }
                case 44: {
                    PacketModuleNBT packetQ = new PacketModuleNBT();
                    packetQ.readData(data);
                    ClientPacketHandler.handleBeePacketNBT(packetQ);
                    break;
                }
                case 45: {
                    PacketPipeInteger packetR = new PacketPipeInteger();
                    packetR.readData(data);
                    ClientPacketHandler.onLiquidSupplierPartials(player, packetR);
                    break;
                }
                case 46: {
                    PacketRequestGuiContent packetS = new PacketRequestGuiContent();
                    packetS.readData(data);
                    ClientPacketHandler.onInvSysConGuiData(player, packetS);
                    break;
                }
                case 47: {
                    PacketPipeInteger packetT = new PacketPipeInteger();
                    packetT.readData(data);
                    ClientPacketHandler.onSolderingUpdateHeat(player, packetT);
                    break;
                }
                case 48: {
                    PacketPipeInteger packetU = new PacketPipeInteger();
                    packetU.readData(data);
                    ClientPacketHandler.onSolderingUpdateProgress(player, packetU);
                    break;
                }
                case 49: {
                    PacketInventoryChange packetV = new PacketInventoryChange();
                    packetV.readData(data);
                    ClientPacketHandler.onSolderingUpdateInventory(player, packetV);
                    break;
                }
                case 52: {
                    PacketPipeInvContent packetW = new PacketPipeInvContent();
                    packetW.readData(data);
                    ClientPacketHandler.onSateliteChestInv(player, packetW);
                    break;
                }
                case 53: {
                    PacketPipeInvContent packetX = new PacketPipeInvContent();
                    packetX.readData(data);
                    ClientPacketHandler.onOrderManagerContent(player, packetX);
                    break;
                }
                case 56: {
                    PacketBufferTransfer packetZ = new PacketBufferTransfer();
                    packetZ.readData(data);
                    ClientPacketHandler.onBufferTransfer(packetZ);
                    break;
                }
                case 57: {
                    PacketPipeInteger packetAa = new PacketPipeInteger();
                    packetAa.readData(data);
                    ClientPacketHandler.onInvSysConResistance(player, packetAa);
                    break;
                }
                case 59: {
                    PacketPipeInvContent packetAb = new PacketPipeInvContent();
                    packetAb.readData(data);
                    ClientPacketHandler.onChassieInvRecive(player, packetAb);
                    break;
                }
                case 62: {
                    PacketModuleInvContent packetAc = new PacketModuleInvContent();
                    packetAc.readData(data);
                    ClientPacketHandler.onModuleInvRecive(packetAc);
                    break;
                }
                case 64: {
                    PacketModuleInteger packetAj = new PacketModuleInteger();
                    packetAj.readData(data);
                    ClientPacketHandler.onElectricModuleStateChange(packetAj);
                    break;
                }
                case 65: {
                    PacketPipeInvContent packetAk = new PacketPipeInvContent();
                    packetAk.readData(data);
                    ClientPacketHandler.onSendQueueInventory(packetAk);
                    break;
                }
                case 67: {
                    PacketPipeInteger packetAl = new PacketPipeInteger();
                    packetAl.readData(data);
                    ClientPacketHandler.onRotationSet(packetAl);
                    break;
                }
                case 68: {
                    PacketPipeInteger packetAm = new PacketPipeInteger();
                    packetAm.readData(data);
                    ClientPacketHandler.onPrioritySet(packetAm);
                    break;
                }
                case 71: {
                    PacketPipeInteger packetAn = new PacketPipeInteger();
                    packetAn.readData(data);
                    ClientPacketHandler.onPowerLevel(packetAn);
                    break;
                }
                case 74: {
                    PacketRoutingStats packetAo = new PacketRoutingStats();
                    packetAo.readData(data);
                    ClientPacketHandler.onStatUpdate(packetAo);
                    break;
                }
                case 75: {
                    ClientPacketHandler.enableNBTDEBUG();
                    break;
                }
                case 77: {
                    PacketInteger packetAq = new PacketInteger();
                    packetAq.readData(data);
                    ClientPacketHandler.onRequestDimension(packetAq);
                    break;
                }
                case 78: {
                    PacketRenderFX packetAr = new PacketRenderFX();
                    packetAr.readData(data);
                    ClientPacketHandler.onParticleRenderUpdate(packetAr);
                    break;
                }
                case 80: {
                    PacketSimulate packetAs = new PacketSimulate();
                    packetAs.readData(data);
                    ClientPacketHandler.onComponentList(packetAs);
                    break;
                }
                case 81: {
                    ClientPacketHandler.sendNamesToServer();
                    break;
                }
                case 82: {
                    PacketNameUpdatePacket packetAt = new PacketNameUpdatePacket();
                    packetAt.readData(data);
                    ClientPacketHandler.onItemNameRequest(packetAt);
                    break;
                }
                case 83: {
                    PacketLiquidUpdate packetAu = new PacketLiquidUpdate();
                    packetAu.readData(data);
                    break;
                }
                case 86: {
                    PacketModuleNBT packetAv = new PacketModuleNBT();
                    packetAv.readData(data);
                    ClientPacketHandler.onModBasedItemSinkList(packetAv);
                    break;
                }
                case 87: {
                    PacketPipeBitSet packetAw = new PacketPipeBitSet();
                    packetAw.readData(data);
                    ClientPacketHandler.onFirewallFlags(packetAw);
                    break;
                }
                case 92: {
                    PacketStringList packetAx = new PacketStringList();
                    packetAx.readData(data);
                    ClientPacketHandler.onPlayerList(packetAx);
                    break;
                }
                case 93: {
                    PacketCoordinatesUUID packetAy = new PacketCoordinatesUUID();
                    packetAy.readData(data);
                    ClientPacketHandler.onSecurityID(packetAy);
                    break;
                }
                case 94: {
                    PacketNBT packetAz = new PacketNBT();
                    packetAz.readData(data);
                    ClientPacketHandler.onOpenSecurityPlayer(packetAz);
                    break;
                }
                case 90: {
                    PacketModuleNBT packetBa = new PacketModuleNBT();
                    packetBa.readData(data);
                    ClientPacketHandler.onThaumicAspectList(packetBa);
                    break;
                }
                case 96: {
                    PacketPipeInteger packetBb = new PacketPipeInteger();
                    packetBb.readData(data);
                    ClientPacketHandler.onSetSecurityCC(packetBb);
                    break;
                }
                case 97: {
                    GuiArgumentPacket packetBc = new GuiArgumentPacket();
                    packetBc.readData(data);
                    GuiHandler.argumentQueue.put(packetBc.guiID, packetBc.args);
                    break;
                }
                case 100: {
                    PacketModuleInteger packetBd = new PacketModuleInteger();
                    packetBd.readData(data);
                    ClientPacketHandler.onCraftingPipeSetSatelliteAdvanced(packetBd);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void onCraftingPipeSetSatellite(PacketPipeInteger packet) {
        TileGenericPipe pipe = ClientPacketHandler.getPipe((yc)FMLClientHandler.instance().getClient().e, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof BaseLogicCrafting)) {
            return;
        }
        ((BaseLogicCrafting)pipe.pipe.logic).setSatelliteId(packet.integer, -1, -1);
    }

    private static void onCraftingPipeSetImport(PacketInventoryChange packet) {
        TileGenericPipe pipe = ClientPacketHandler.getPipe((yc)FMLClientHandler.instance().getClient().e, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof BaseLogicCrafting)) {
            return;
        }
        BaseLogicCrafting craftingPipe = (BaseLogicCrafting)pipe.pipe.logic;
        for (int i = 0; i < packet.itemStacks.size(); ++i) {
            craftingPipe.setDummyInventorySlot(i, (ur)packet.itemStacks.get(i));
        }
    }

    private static void onSatellitePipeSetSatellite(PacketPipeInteger packet) {
        TileGenericPipe pipe = ClientPacketHandler.getPipe((yc)FMLClientHandler.instance().getClient().e, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof BaseLogicSatellite)) {
            return;
        }
        ((BaseLogicSatellite)pipe.pipe.logic).setSatelliteId(packet.integer);
    }

    private static void onOrdererRefreshAnswer(PacketRequestGuiContent packet) {
        if (FMLClientHandler.instance().getClient().r instanceof GuiOrderer) {
            ((GuiOrderer)FMLClientHandler.instance().getClient().r).handlePacket(packet);
        }
    }

    private static void onItemsResponse(PacketItems packet) {
        if (FMLClientHandler.instance().getClient().r instanceof GuiOrderer) {
            ((GuiOrderer)FMLClientHandler.instance().getClient().r).handleRequestAnswer(packet.items, !packet.error, (ISubGuiControler)((GuiOrderer)FMLClientHandler.instance().getClient().r), (qx)FMLClientHandler.instance().getClient().g);
        } else if (packet.error) {
            for (ItemMessage items : packet.items) {
                FMLClientHandler.instance().getClient().g.b("Missing: " + items);
            }
        } else {
            for (ItemMessage items : packet.items) {
                FMLClientHandler.instance().getClient().g.b("Requested: " + items);
            }
            FMLClientHandler.instance().getClient().g.b("Request successful!");
        }
    }

    private static void onCraftingLoop(PacketCraftingLoop packet) {
        ItemIdentifier item = ((ItemMessage)packet.items.get(0)).getItemIdentifier();
        FMLClientHandler.instance().getClient().g.b("Logistics: Possible crafting loop while trying to craft " + item.getFriendlyName() + " !! ABORTING !!");
    }

    private static void onItemSinkStatusRecive(PacketModuleInteger packet) {
        if (packet.slot == 20) {
            return;
        }
        TileGenericPipe pipe = ClientPacketHandler.getPipe((yc)FMLClientHandler.instance().getClient().e, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (packet.slot == -1) {
            if (!(pipe.pipe instanceof CoreRoutedPipe)) {
                return;
            }
            if (!(((CoreRoutedPipe)pipe.pipe).getLogisticsModule() instanceof ModuleItemSink)) {
                return;
            }
            ModuleItemSink module = (ModuleItemSink)((CoreRoutedPipe)pipe.pipe).getLogisticsModule();
            module.setDefaultRoute(packet.integer == 1);
            return;
        }
        if (!(pipe.pipe instanceof PipeLogisticsChassi)) {
            return;
        }
        if (((PipeLogisticsChassi)pipe.pipe).getModules() == null) {
            return;
        }
        if (((PipeLogisticsChassi)pipe.pipe).getModules().getSubModule(packet.slot) instanceof ModuleItemSink) {
            ModuleItemSink module = (ModuleItemSink)((PipeLogisticsChassi)pipe.pipe).getModules().getSubModule(packet.slot);
            module.setDefaultRoute(packet.integer == 1);
        }
    }

    private static void onProviderPipeModeRecive(PacketPipeInteger packet) {
        TileGenericPipe pipe = ClientPacketHandler.getPipe((yc)FMLClientHandler.instance().getClient().e, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof LogicProvider)) {
            return;
        }
        ((LogicProvider)pipe.pipe.logic).setExtractionMode(packet.integer);
    }

    private static void onProviderPipeIncludeRecive(PacketPipeInteger packet) {
        TileGenericPipe pipe = ClientPacketHandler.getPipe((yc)FMLClientHandler.instance().getClient().e, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof LogicProvider)) {
            return;
        }
        ((LogicProvider)pipe.pipe.logic).setFilterExcluded(packet.integer == 1);
        if (FMLClientHandler.instance().getClient().r instanceof GuiProviderPipe) {
            ((GuiProviderPipe)FMLClientHandler.instance().getClient().r).refreshInclude();
        }
    }

    private static void onSupplierPipeRecive(PacketPipeInteger packet) {
        TileGenericPipe pipe = ClientPacketHandler.getPipe((yc)FMLClientHandler.instance().getClient().e, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof LogicSupplier)) {
            return;
        }
        ((LogicSupplier)pipe.pipe.logic).setRequestingPartials(packet.integer == 1);
        if (FMLClientHandler.instance().getClient().r instanceof GuiSupplierPipe) {
            ((GuiSupplierPipe)FMLClientHandler.instance().getClient().r).refreshMode();
        }
    }

    private static void onModulePipeRecive(PacketModuleInteger packet) {
        if (packet.slot == 20) {
            if (FMLClientHandler.instance().getClient().r instanceof GuiExtractor) {
                ((GuiExtractor)FMLClientHandler.instance().getClient().r).setMode(ForgeDirection.getOrientation((int)packet.integer));
            }
            return;
        }
        TileGenericPipe pipe = ClientPacketHandler.getPipe((yc)FMLClientHandler.instance().getClient().e, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (packet.slot == -1) {
            if (pipe.pipe instanceof CoreRoutedPipe && ((CoreRoutedPipe)pipe.pipe).getLogisticsModule() instanceof ISneakyDirectionReceiver) {
                ((ISneakyDirectionReceiver)((Object)((CoreRoutedPipe)pipe.pipe).getLogisticsModule())).setSneakyDirection(ForgeDirection.getOrientation((int)packet.integer));
            }
            return;
        }
        if (pipe.pipe instanceof PipeLogisticsChassi && ((PipeLogisticsChassi)pipe.pipe).getModules() != null && ((PipeLogisticsChassi)pipe.pipe).getModules().getSubModule(packet.slot) instanceof ISneakyDirectionReceiver) {
            ISneakyDirectionReceiver recieiver = (ISneakyDirectionReceiver)((Object)((PipeLogisticsChassi)pipe.pipe).getModules().getSubModule(packet.slot));
            recieiver.setSneakyDirection(ForgeDirection.getOrientation((int)packet.integer));
        }
    }

    private static void onProviderModuleModeRecive(PacketPipeInteger packet) {
        if (FMLClientHandler.instance().getClient().r instanceof GuiProvider) {
            ((GuiProvider)FMLClientHandler.instance().getClient().r).handleModuleModeRecive(packet);
        }
    }

    private static void onProviderModuleIncludeRecive(PacketPipeInteger packet) {
        if (FMLClientHandler.instance().getClient().r instanceof GuiProvider) {
            ((GuiProvider)FMLClientHandler.instance().getClient().r).handleModuleIncludeRecive(packet);
        }
    }

    private static void onAdvancedExtractorModuleIncludeRecive(PacketModuleInteger packet) {
        if (packet.slot == 20) {
            if (FMLClientHandler.instance().getClient().r instanceof GuiAdvancedExtractor) {
                ((GuiAdvancedExtractor)FMLClientHandler.instance().getClient().r).setInclude(packet.integer == 1);
            }
            return;
        }
        TileGenericPipe pipe = ClientPacketHandler.getPipe((yc)FMLClientHandler.instance().getClient().e, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (packet.slot == -1) {
            if (pipe.pipe instanceof CoreRoutedPipe && ((CoreRoutedPipe)pipe.pipe).getLogisticsModule() instanceof ModuleAdvancedExtractor) {
                ((ModuleAdvancedExtractor)((CoreRoutedPipe)pipe.pipe).getLogisticsModule()).setItemsIncluded(packet.integer == 1);
            }
            return;
        }
        if (pipe.pipe instanceof PipeLogisticsChassi && ((PipeLogisticsChassi)pipe.pipe).getModules() != null && ((PipeLogisticsChassi)pipe.pipe).getModules().getSubModule(packet.slot) instanceof ModuleAdvancedExtractor) {
            ModuleAdvancedExtractor recieiver = (ModuleAdvancedExtractor)((PipeLogisticsChassi)pipe.pipe).getModules().getSubModule(packet.slot);
            recieiver.setItemsIncluded(packet.integer == 1);
        }
    }

    private static void handlePacketPipeUpdate(PacketPipeUpdate packet) {
        TileGenericPipe tile = ClientPacketHandler.getPipe((yc)FMLClientHandler.instance().getClient().e, packet.posX, packet.posY, packet.posZ);
        if (tile == null) {
            return;
        }
        if (tile.pipe == null) {
            return;
        }
        new TilePacketWrapper(new Class[]{TileGenericPipe.class, tile.pipe.transport.getClass(), tile.pipe.logic.getClass()}).fromPayload(new Object[]{tile.pipe.container, tile.pipe.transport, tile.pipe.logic}, packet.getPayload());
    }

    private static void handleRequestMK2DiskItem(PacketItem packet) {
        TileGenericPipe tile = ClientPacketHandler.getPipe((yc)FMLClientHandler.instance().getClient().e, packet.posX, packet.posY, packet.posZ);
        if (tile == null) {
            return;
        }
        if (tile.pipe instanceof PipeItemsRequestLogisticsMk2) {
            ((PipeItemsRequestLogisticsMk2)tile.pipe).setDisk(packet.itemstack);
        }
    }

    private static void handleMacroResponse(PacketItems packet) {
        if (FMLClientHandler.instance().getClient().r instanceof GuiOrderer && ((GuiOrderer)FMLClientHandler.instance().getClient().r).getSubGui() instanceof GuiDiskPopup) {
            ((GuiOrderer)FMLClientHandler.instance().getClient().r).handleRequestAnswer(packet.items, packet.error, (ISubGuiControler)((GuiOrderer)FMLClientHandler.instance().getClient().r).getSubGui(), (qx)FMLClientHandler.instance().getClient().g);
        }
    }

    private static void handleBeePacketNBT(PacketModuleNBT packet) {
        ModuleApiaristSink sink;
        if (packet.slot == 20) {
            return;
        }
        TileGenericPipe tile = ClientPacketHandler.getPipe((yc)FMLClientHandler.instance().getClient().e, packet.posX, packet.posY, packet.posZ);
        if (tile == null) {
            return;
        }
        if (packet.slot == -1 && tile.pipe instanceof PipeItemsApiaristSink) {
            sink = (ModuleApiaristSink)((PipeItemsApiaristSink)tile.pipe).getLogisticsModule();
        } else if (tile.pipe instanceof CoreRoutedPipe && ((CoreRoutedPipe)tile.pipe).getLogisticsModule().getSubModule(packet.slot) instanceof ModuleApiaristSink) {
            sink = (ModuleApiaristSink)((CoreRoutedPipe)tile.pipe).getLogisticsModule().getSubModule(packet.slot);
        } else {
            return;
        }
        packet.handle(sink);
    }

    private static void onLiquidSupplierPartials(Player player, PacketPipeInteger packet) {
        TileGenericPipe tile = ClientPacketHandler.getPipe((yc)FMLClientHandler.instance().getClient().e, packet.posX, packet.posY, packet.posZ);
        if (tile == null) {
            return;
        }
        if (tile.pipe instanceof PipeItemsLiquidSupplier && tile.pipe.logic instanceof LogicLiquidSupplier) {
            ((LogicLiquidSupplier)tile.pipe.logic).setRequestingPartials(packet.integer % 10 == 1);
        }
    }

    private static void onInvSysConGuiData(Player player, PacketRequestGuiContent packet) {
        if (FMLClientHandler.instance().getClient().r instanceof GuiInvSysConnector) {
            ((GuiInvSysConnector)FMLClientHandler.instance().getClient().r).handleContentAnswer(packet._allItems);
        }
    }

    private static void onSolderingUpdateHeat(Player player, PacketPipeInteger packet) {
        any tile = FMLClientHandler.instance().getClient().e.q(packet.posX, packet.posY, packet.posZ);
        if (tile instanceof LogisticsSolderingTileEntity) {
            LogisticsSolderingTileEntity station = (LogisticsSolderingTileEntity)tile;
            int old = station.heat;
            station.heat = packet.integer;
            if (station.heat == 0 && old != 0 || station.heat != 0 && old == 0) {
                FMLClientHandler.instance().getClient().e.i(packet.posX, packet.posY, packet.posZ);
            }
        }
    }

    private static void onSolderingUpdateProgress(Player player, PacketPipeInteger packet) {
        any tile = FMLClientHandler.instance().getClient().e.q(packet.posX, packet.posY, packet.posZ);
        if (tile instanceof LogisticsSolderingTileEntity) {
            LogisticsSolderingTileEntity station = (LogisticsSolderingTileEntity)tile;
            station.progress = packet.integer;
        }
    }

    private static void onSolderingUpdateInventory(Player player, PacketInventoryChange packet) {
        any tile = FMLClientHandler.instance().getClient().e.q(packet.posX, packet.posY, packet.posZ);
        if (tile instanceof LogisticsSolderingTileEntity) {
            LogisticsSolderingTileEntity station = (LogisticsSolderingTileEntity)tile;
            for (int i = 0; i < station.k_() && i < packet.itemStacks.size(); ++i) {
                ur stack = (ur)packet.itemStacks.get(i);
                station.a(i, stack);
            }
        }
    }

    private static void onSateliteChestInv(Player player, PacketPipeInvContent packet) {
        TileGenericPipe tile = ClientPacketHandler.getPipe((yc)FMLClientHandler.instance().getClient().e, packet.posX, packet.posY, packet.posZ);
        if (tile == null) {
            return;
        }
        if (tile.pipe instanceof IChestContentReceiver) {
            ((IChestContentReceiver)tile.pipe).setReceivedChestContent(packet._allItems);
        }
    }

    private static void onOrderManagerContent(Player player, PacketPipeInvContent packet) {
        TileGenericPipe tile = ClientPacketHandler.getPipe((yc)FMLClientHandler.instance().getClient().e, packet.posX, packet.posY, packet.posZ);
        if (tile == null) {
            return;
        }
        if (tile.pipe instanceof IOrderManagerContentReceiver) {
            ((IOrderManagerContentReceiver)tile.pipe).setOrderManagerContent(packet._allItems);
        }
    }

    private static void onBufferTransfer(PacketBufferTransfer packet) {
        SimpleServiceLocator.clientBufferHandler.handlePacket(packet);
    }

    private static void onInvSysConResistance(Player player, PacketPipeInteger packet) {
        TileGenericPipe pipe = ClientPacketHandler.getPipe((yc)FMLClientHandler.instance().getClient().e, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe instanceof PipeItemsInvSysConnector) {
            PipeItemsInvSysConnector invCon = (PipeItemsInvSysConnector)pipe.pipe;
            invCon.resistance = packet.integer;
        }
    }

    private static void onChassieInvRecive(Player player, PacketPipeInvContent packet) {
        TileGenericPipe pipe = ClientPacketHandler.getPipe((yc)FMLClientHandler.instance().getClient().e, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe instanceof PipeLogisticsChassi) {
            PipeLogisticsChassi chassie = (PipeLogisticsChassi)pipe.pipe;
            chassie.handleModuleItemIdentifierList(packet._allItems);
        }
    }

    private static void onModuleInvRecive(PacketModuleInvContent packet) {
        TileGenericPipe pipe = ClientPacketHandler.getPipe((yc)FMLClientHandler.instance().getClient().e, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe instanceof PipeLogisticsChassi && ((PipeLogisticsChassi)pipe.pipe).getModules() != null && ((PipeLogisticsChassi)pipe.pipe).getModules().getSubModule(packet.slot) instanceof IModuleInventoryReceive) {
            IModuleInventoryReceive module = (IModuleInventoryReceive)((Object)((PipeLogisticsChassi)pipe.pipe).getModules().getSubModule(packet.slot));
            module.handleInvContent(packet._allItems);
        }
    }

    private static void onElectricModuleStateChange(PacketModuleInteger packet) {
        TileGenericPipe pipe = ClientPacketHandler.getPipe((yc)FMLClientHandler.instance().getClient().e, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe instanceof PipeLogisticsChassi && ((PipeLogisticsChassi)pipe.pipe).getModules() != null && ((PipeLogisticsChassi)pipe.pipe).getModules().getSubModule(packet.slot) instanceof ModuleElectricManager) {
            ModuleElectricManager module = (ModuleElectricManager)((PipeLogisticsChassi)pipe.pipe).getModules().getSubModule(packet.slot);
            module.setDischargeMode(packet.integer == 1);
        }
    }

    private static void onSendQueueInventory(PacketPipeInvContent packet) {
        TileGenericPipe pipe = ClientPacketHandler.getPipe((yc)FMLClientHandler.instance().getClient().e, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe instanceof ISendQueueContentRecieiver) {
            ISendQueueContentRecieiver receiver = (ISendQueueContentRecieiver)pipe.pipe;
            receiver.handleSendQueueItemIdentifierList(packet._allItems);
        }
    }

    private static void onRotationSet(PacketPipeInteger packet) {
        any tile = FMLClientHandler.instance().getClient().e.q(packet.posX, packet.posY, packet.posZ);
        if (tile instanceof IRotationProvider) {
            ((IRotationProvider)tile).setRotation(packet.integer);
            FMLClientHandler.instance().getClient().e.i(packet.posX, packet.posY, packet.posZ);
        }
    }

    private static void onPrioritySet(PacketPipeInteger packet) {
        TileGenericPipe pipe = ClientPacketHandler.getPipe((yc)FMLClientHandler.instance().getClient().e, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof BaseLogicCrafting)) {
            return;
        }
        ((BaseLogicCrafting)pipe.pipe.logic).setPriority(packet.integer);
    }

    private static void onPowerLevel(PacketPipeInteger packet) {
        any tile = FMLClientHandler.instance().getClient().e.q(packet.posX, packet.posY, packet.posZ);
        if (tile instanceof LogisticsPowerJuntionTileEntity_BuildCraft) {
            ((LogisticsPowerJuntionTileEntity_BuildCraft)tile).handlePowerPacket(packet);
        }
    }

    private static void onStatUpdate(PacketRoutingStats packet) {
        TileGenericPipe pipe = ClientPacketHandler.getPipe((yc)FMLClientHandler.instance().getClient().e, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe instanceof CoreRoutedPipe)) {
            return;
        }
        CoreRoutedPipe cPipe = (CoreRoutedPipe)pipe.pipe;
        cPipe.stat_session_sent = packet.stat_session_sent;
        cPipe.stat_session_recieved = packet.stat_session_recieved;
        cPipe.stat_session_relayed = packet.stat_session_relayed;
        cPipe.stat_lifetime_sent = packet.stat_lifetime_sent;
        cPipe.stat_lifetime_recieved = packet.stat_lifetime_recieved;
        cPipe.stat_lifetime_relayed = packet.stat_lifetime_relayed;
        cPipe.server_routing_table_size = packet.server_routing_table_size;
    }

    private static void onParticleRenderUpdate(PacketRenderFX packet) {
        int x = packet.posX;
        int y2 = packet.posY;
        int z = packet.posZ;
        int particle = packet.particle;
        int amount = packet.amount;
        MainProxy.spawnParticle(particle, x, y2, z, amount);
    }

    private static void enableNBTDEBUG() {
        block3: {
            try {
                Class.forName("codechicken.nei.forge.GuiContainerManager");
                Configs.TOOLTIP_INFO = true;
                LoadingHelper.LoadNeiNBTDebugHelper();
            }
            catch (ClassNotFoundException e) {
            }
            catch (Exception e1) {
                if (!LogisticsPipes.DEBUG) break block3;
                e1.printStackTrace();
            }
        }
    }

    private static void onRequestDimension(PacketInteger packet) {
        if (FMLClientHandler.instance().getClient().r instanceof GuiOrderer) {
            ((GuiOrderer)FMLClientHandler.instance().getClient().r).dimension = packet.value;
            ((GuiOrderer)FMLClientHandler.instance().getClient().r).refreshItems();
        } else {
            GuiOrderer.dimensioncache = packet.value;
            GuiOrderer.cachetime = System.currentTimeMillis();
        }
    }

    private static void onComponentList(PacketSimulate packet) {
        if (FMLClientHandler.instance().getClient().r instanceof GuiOrderer) {
            ((GuiOrderer)FMLClientHandler.instance().getClient().r).handleSimulateAnswer(packet.used, packet.missing, (GuiOrderer)FMLClientHandler.instance().getClient().r, (qx)FMLClientHandler.instance().getClient().g);
        } else {
            for (ItemMessage items : packet.used) {
                FMLClientHandler.instance().getClient().g.b("Used: " + items);
            }
            for (ItemMessage items : packet.missing) {
                FMLClientHandler.instance().getClient().g.b("Missing: " + items);
            }
        }
    }

    private static void sendNamesToServer() {
        up[] itemList = up.e;
        LinkedList<ItemIdentifier> identList = new LinkedList<ItemIdentifier>();
        for (up item : itemList) {
            if (item == null) continue;
            for (tj tab : item.getCreativeTabs()) {
                ArrayList list = new ArrayList();
                item.a(item.cj, tab, list);
                if (list.size() > 0) {
                    for (ur stack : list) {
                        identList.add(ItemIdentifier.get(stack));
                    }
                    continue;
                }
                identList.add(ItemIdentifier.get(item.cj, 0, null));
            }
        }
        SimpleServiceLocator.clientBufferHandler.setPause(true);
        for (ItemIdentifier item : identList) {
            MainProxy.sendCompressedPacketToServer((di)new PacketNameUpdatePacket(item).getPacket());
        }
        SimpleServiceLocator.clientBufferHandler.setPause(false);
        FMLClientHandler.instance().getClient().g.b("Names in send Queue");
    }

    private static void onItemNameRequest(PacketNameUpdatePacket packetAt) {
        MainProxy.sendCompressedPacketToServer((di)new PacketNameUpdatePacket(packetAt.item).getPacket());
    }

    private static void onModBasedItemSinkList(PacketModuleNBT packet) {
        TileGenericPipe pipe = ClientPacketHandler.getPipe(MainProxy.getClientMainWorld(), packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe instanceof PipeLogisticsChassi && ((PipeLogisticsChassi)pipe.pipe).getModules() != null && ((PipeLogisticsChassi)pipe.pipe).getModules().getSubModule(packet.slot) instanceof ModuleModBasedItemSink) {
            ((ModuleModBasedItemSink)((PipeLogisticsChassi)pipe.pipe).getModules().getSubModule(packet.slot)).readFromNBT(packet.tag);
            ((ModuleModBasedItemSink)((PipeLogisticsChassi)pipe.pipe).getModules().getSubModule(packet.slot)).ModListChanged();
        }
    }

    private static void onThaumicAspectList(PacketModuleNBT packet) {
        TileGenericPipe pipe = ClientPacketHandler.getPipe(MainProxy.getClientMainWorld(), packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe instanceof PipeLogisticsChassi && ((PipeLogisticsChassi)pipe.pipe).getModules() != null && ((PipeLogisticsChassi)pipe.pipe).getModules().getSubModule(packet.slot) instanceof ModuleThaumicAspectSink) {
            ((ModuleThaumicAspectSink)((PipeLogisticsChassi)pipe.pipe).getModules().getSubModule(packet.slot)).readFromNBT(packet.tag);
            ((ModuleThaumicAspectSink)((PipeLogisticsChassi)pipe.pipe).getModules().getSubModule(packet.slot)).aspectListChanged();
        }
    }

    private static void onFirewallFlags(PacketPipeBitSet packet) {
        TileGenericPipe pipe = ClientPacketHandler.getPipe(MainProxy.getClientMainWorld(), packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe instanceof PipeItemsFirewall) {
            PipeItemsFirewall firewall = (PipeItemsFirewall)pipe.pipe;
            firewall.setFlags(packet.flags);
        }
    }

    private static void onPlayerList(PacketStringList packet) {
        if (FMLClientHandler.instance().getClient().r instanceof PlayerListReciver) {
            ((PlayerListReciver)FMLClientHandler.instance().getClient().r).recivePlayerList(packet.list);
        }
    }

    private static void onSecurityID(PacketCoordinatesUUID packet) {
        any tile = MainProxy.getClientMainWorld().q(packet.posX, packet.posY, packet.posZ);
        if (tile instanceof LogisticsSecurityTileEntity) {
            ((LogisticsSecurityTileEntity)tile).setClientUUID(packet.uuid);
        }
    }

    private static void onOpenSecurityPlayer(PacketNBT packet) {
        if (FMLClientHandler.instance().getClient().r instanceof GuiSecurityStation) {
            SecuritySettings setting = new SecuritySettings(null);
            setting.readFromNBT(packet.tag);
            ((GuiSecurityStation)FMLClientHandler.instance().getClient().r).handlePlayerSecurityOpen(setting);
        }
    }

    private static void onSetSecurityCC(PacketPipeInteger packet) {
        any tile = MainProxy.getClientMainWorld().q(packet.posX, packet.posY, packet.posZ);
        if (tile instanceof LogisticsSecurityTileEntity) {
            ((LogisticsSecurityTileEntity)tile).setClientCC(packet.integer == 1);
            if (FMLClientHandler.instance().getClient().r instanceof GuiSecurityStation) {
                ((GuiSecurityStation)FMLClientHandler.instance().getClient().r).refreshCheckBoxes();
            }
        }
    }

    private static void onCraftingPipeSetSatelliteAdvanced(PacketModuleInteger packet) {
        TileGenericPipe pipe = ClientPacketHandler.getPipe((yc)FMLClientHandler.instance().getClient().e, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof BaseLogicCrafting)) {
            return;
        }
        ((BaseLogicCrafting)pipe.pipe.logic).setSatelliteId(packet.integer, packet.slot, -1);
    }

    private static TileGenericPipe getPipe(yc world, int x, int y2, int z) {
        if (world == null) {
            return null;
        }
        if (!world.f(x, y2, z)) {
            return null;
        }
        any tile = world.q(x, y2, z);
        if (!(tile instanceof TileGenericPipe)) {
            return null;
        }
        return (TileGenericPipe)tile;
    }
}

