/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network;

import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.util.LinkedList;
import java.util.Set;
import logisticspipes.LogisticsPipes;
import logisticspipes.blocks.LogisticsSecurityTileEntity;
import logisticspipes.blocks.powertile.LogisticsPowerJuntionTileEntity_BuildCraft;
import logisticspipes.gui.PacketStringCoordinates;
import logisticspipes.hud.HUDConfig;
import logisticspipes.interfaces.IBlockWatchingHandler;
import logisticspipes.interfaces.ILogisticsGuiModule;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.IRotationProvider;
import logisticspipes.interfaces.ISneakyDirectionReceiver;
import logisticspipes.interfaces.IWatchingHandler;
import logisticspipes.interfaces.routing.IRequestLiquid;
import logisticspipes.logic.BaseLogicCrafting;
import logisticspipes.logic.BaseLogicSatellite;
import logisticspipes.logic.LogicLiquidSupplier;
import logisticspipes.logic.LogicProvider;
import logisticspipes.logic.LogicSupplier;
import logisticspipes.modules.ModuleAdvancedExtractor;
import logisticspipes.modules.ModuleApiaristSink;
import logisticspipes.modules.ModuleElectricManager;
import logisticspipes.modules.ModuleExtractor;
import logisticspipes.modules.ModuleItemSink;
import logisticspipes.modules.ModuleModBasedItemSink;
import logisticspipes.modules.ModuleProvider;
import logisticspipes.modules.ModuleThaumicAspectSink;
import logisticspipes.network.packets.PacketBufferTransfer;
import logisticspipes.network.packets.PacketCoordinates;
import logisticspipes.network.packets.PacketHUDSettings;
import logisticspipes.network.packets.PacketInventoryChange;
import logisticspipes.network.packets.PacketItem;
import logisticspipes.network.packets.PacketModuleInteger;
import logisticspipes.network.packets.PacketModuleNBT;
import logisticspipes.network.packets.PacketNBT;
import logisticspipes.network.packets.PacketNameUpdatePacket;
import logisticspipes.network.packets.PacketPipeBeePacket;
import logisticspipes.network.packets.PacketPipeBitSet;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.network.packets.PacketPipeString;
import logisticspipes.network.packets.PacketPipeUpdate;
import logisticspipes.network.packets.PacketRequestGuiContent;
import logisticspipes.network.packets.PacketRequestSubmit;
import logisticspipes.network.packets.PacketStringList;
import logisticspipes.pipes.PipeItemsApiaristSink;
import logisticspipes.pipes.PipeItemsCraftingLogistics;
import logisticspipes.pipes.PipeItemsFirewall;
import logisticspipes.pipes.PipeItemsInvSysConnector;
import logisticspipes.pipes.PipeItemsLiquidSupplier;
import logisticspipes.pipes.PipeItemsProviderLogistics;
import logisticspipes.pipes.PipeItemsRequestLogisticsMk2;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.RequestHandler;
import logisticspipes.utils.gui.DummyModuleContainer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeDirection;

public class ServerPacketHandler {
    public static void onPacketData(ce manager, di packet, Player player) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.c));
        ServerPacketHandler.onPacketData(data, player);
    }

    public static void onPacketData(DataInputStream data, Player playerFML) {
        iq player = (iq)playerFML;
        try {
            int packetID = data.read();
            switch (packetID) {
                case 1: {
                    PacketCoordinates packet = new PacketCoordinates();
                    packet.readData(data);
                    ServerPacketHandler.onCraftingPipeNextSatellite(player, packet);
                    break;
                }
                case 2: {
                    PacketCoordinates packetA = new PacketCoordinates();
                    packetA.readData(data);
                    ServerPacketHandler.onCraftingPipePrevSatellite(player, packetA);
                    break;
                }
                case 4: {
                    PacketCoordinates packetB = new PacketCoordinates();
                    packetB.readData(data);
                    ServerPacketHandler.onCraftingPipeImport(player, packetB);
                    break;
                }
                case 6: {
                    PacketCoordinates packetC = new PacketCoordinates();
                    packetC.readData(data);
                    ServerPacketHandler.onSatellitePipeNext(player, packetC);
                    break;
                }
                case 7: {
                    PacketCoordinates packetD = new PacketCoordinates();
                    packetD.readData(data);
                    ServerPacketHandler.onSatellitePipePrev(player, packetD);
                    break;
                }
                case 9: {
                    PacketPipeInteger packetE = new PacketPipeInteger();
                    packetE.readData(data);
                    ServerPacketHandler.onModuleGuiOpen(player, packetE);
                    break;
                }
                case 10: {
                    PacketPipeInteger packetF = new PacketPipeInteger();
                    packetF.readData(data);
                    ServerPacketHandler.onGuiBackOpen(player, packetF);
                    break;
                }
                case 11: {
                    PacketRequestSubmit packetG = new PacketRequestSubmit();
                    packetG.readData(data);
                    ServerPacketHandler.onRequestSubmit(player, packetG);
                    break;
                }
                case 12: {
                    PacketPipeInteger packetH = new PacketPipeInteger();
                    packetH.readData(data);
                    ServerPacketHandler.onRefreshRequest(player, packetH);
                    break;
                }
                case 16: {
                    PacketPipeInteger packetI = new PacketPipeInteger();
                    packetI.readData(data);
                    ServerPacketHandler.onItemSinkDefault(player, packetI);
                    break;
                }
                case 18: {
                    PacketCoordinates packetJ = new PacketCoordinates();
                    packetJ.readData(data);
                    ServerPacketHandler.onProviderModeChange(player, packetJ);
                    break;
                }
                case 19: {
                    PacketCoordinates packetK = new PacketCoordinates();
                    packetK.readData(data);
                    ServerPacketHandler.onProviderIncludeChange(player, packetK);
                    break;
                }
                case 22: {
                    PacketCoordinates packetL = new PacketCoordinates();
                    packetL.readData(data);
                    ServerPacketHandler.onSupplierModeChange(player, packetL);
                    break;
                }
                case 24: {
                    PacketPipeInteger packetM = new PacketPipeInteger();
                    packetM.readData(data);
                    ServerPacketHandler.onExtractorModeChange(player, packetM);
                    break;
                }
                case 26: {
                    PacketPipeInteger packetN = new PacketPipeInteger();
                    packetN.readData(data);
                    ServerPacketHandler.onProviderModuleModeChange(player, packetN);
                    break;
                }
                case 27: {
                    PacketPipeInteger packetO = new PacketPipeInteger();
                    packetO.readData(data);
                    ServerPacketHandler.onProviderModuleIncludeChange(player, packetO);
                    break;
                }
                case 30: {
                    PacketPipeInteger packetP = new PacketPipeInteger();
                    packetP.readData(data);
                    ServerPacketHandler.onAdvancedExtractorModuleIncludeChange(player, packetP);
                    break;
                }
                case 32: {
                    PacketPipeInteger packetQ = new PacketPipeInteger();
                    packetQ.readData(data);
                    ServerPacketHandler.onAdvancedExtractorModuleGuiSneaky(player, packetQ);
                    break;
                }
                case 33: {
                    PacketCoordinates packetR = new PacketCoordinates();
                    packetR.readData(data);
                    ServerPacketHandler.onPipeUpdateRequest(player, packetR);
                    break;
                }
                case 34: {
                    PacketCoordinates packetS = new PacketCoordinates();
                    packetS.readData(data);
                    ServerPacketHandler.onCraftingPipeUpdateRequest(player, packetS);
                    break;
                }
                case 35: {
                    PacketCoordinates packetT = new PacketCoordinates();
                    packetT.readData(data);
                    ServerPacketHandler.onCraftingPipeOpenConnectedGui(player, packetT);
                    break;
                }
                case 37: {
                    PacketCoordinates packetU = new PacketCoordinates();
                    packetU.readData(data);
                    ServerPacketHandler.onDiskContentRequest(player, packetU);
                    break;
                }
                case 39: {
                    PacketPipeString packetV = new PacketPipeString();
                    packetV.readData(data);
                    ServerPacketHandler.onDiskSetName(player, packetV);
                    break;
                }
                case 38: {
                    PacketItem packetW = new PacketItem();
                    packetW.readData(data);
                    ServerPacketHandler.onDiskChangeClientSide(player, packetW);
                    break;
                }
                case 40: {
                    PacketCoordinates packetX = new PacketCoordinates();
                    packetX.readData(data);
                    ServerPacketHandler.onDiskDrop(player, packetX);
                    break;
                }
                case 41: {
                    PacketPipeInteger packetY = new PacketPipeInteger();
                    packetY.readData(data);
                    ServerPacketHandler.onDiskMacroRequest(player, packetY);
                    break;
                }
                case 43: {
                    PacketPipeBeePacket packetZ = new PacketPipeBeePacket();
                    packetZ.readData(data);
                    ServerPacketHandler.onBeeModuleSetBee(player, packetZ);
                    break;
                }
                case 45: {
                    PacketPipeInteger packetAa = new PacketPipeInteger();
                    packetAa.readData(data);
                    ServerPacketHandler.onLiquidSupplierPartials(player, packetAa);
                    break;
                }
                case 46: {
                    PacketCoordinates packetAb = new PacketCoordinates();
                    packetAb.readData(data);
                    ServerPacketHandler.onInvSysContentRequest(player, packetAb);
                    break;
                }
                case 50: {
                    PacketPipeInteger packetAc = new PacketPipeInteger();
                    packetAc.readData(data);
                    ServerPacketHandler.onHUDWatchingChange(player, packetAc, true);
                    break;
                }
                case 51: {
                    PacketPipeInteger packetAd = new PacketPipeInteger();
                    packetAd.readData(data);
                    ServerPacketHandler.onHUDWatchingChange(player, packetAd, false);
                    break;
                }
                case 57: {
                    PacketPipeInteger packetAf = new PacketPipeInteger();
                    packetAf.readData(data);
                    ServerPacketHandler.onInvSysConResistance(player, packetAf);
                    break;
                }
                case 58: {
                    PacketPipeInteger packetAg = new PacketPipeInteger();
                    packetAg.readData(data);
                    ServerPacketHandler.onCraftingPipeStackMove(player, packetAg);
                    break;
                }
                case 60: {
                    PacketPipeInteger packetAh = new PacketPipeInteger();
                    packetAh.readData(data);
                    ServerPacketHandler.onHUDModuleWatchingChange(player, packetAh, true);
                    break;
                }
                case 61: {
                    PacketPipeInteger packetAi = new PacketPipeInteger();
                    packetAi.readData(data);
                    ServerPacketHandler.onHUDModuleWatchingChange(player, packetAi, false);
                    break;
                }
                case 63: {
                    PacketModuleInteger packetAj = new PacketModuleInteger();
                    packetAj.readData(data);
                    ServerPacketHandler.onElectricModuleStateChange(player, packetAj);
                    break;
                }
                case 66: {
                    PacketCoordinates packetAk = new PacketCoordinates();
                    packetAk.readData(data);
                    ServerPacketHandler.onRotationRequest(player, packetAk);
                    break;
                }
                case 69: {
                    PacketCoordinates packetAl = new PacketCoordinates();
                    packetAl.readData(data);
                    ServerPacketHandler.onPriorityUp(player, packetAl);
                    break;
                }
                case 70: {
                    PacketCoordinates packetAm = new PacketCoordinates();
                    packetAm.readData(data);
                    ServerPacketHandler.onPriorityDown(player, packetAm);
                    break;
                }
                case 72: {
                    PacketCoordinates packetAn = new PacketCoordinates();
                    packetAn.readData(data);
                    ServerPacketHandler.onHUDBlockWatch(player, packetAn, true);
                    break;
                }
                case 73: {
                    PacketCoordinates packetAo = new PacketCoordinates();
                    packetAo.readData(data);
                    ServerPacketHandler.onHUDBlockWatch(player, packetAo, false);
                    break;
                }
                case 76: {
                    PacketHUDSettings packetAp = new PacketHUDSettings();
                    packetAp.readData(data);
                    ServerPacketHandler.onHUDSettings(player, packetAp);
                    break;
                }
                case 79: {
                    PacketRequestSubmit packetAq = new PacketRequestSubmit();
                    packetAq.readData(data);
                    ServerPacketHandler.onRequestComponents(player, packetAq);
                    break;
                }
                case 56: {
                    PacketBufferTransfer packetAr = new PacketBufferTransfer();
                    packetAr.readData(data);
                    ServerPacketHandler.onBufferTransfer(packetAr, playerFML);
                    break;
                }
                case 82: {
                    PacketNameUpdatePacket packetAs = new PacketNameUpdatePacket();
                    packetAs.readData(data);
                    ServerPacketHandler.onNameUpdate(packetAs);
                    break;
                }
                case 84: {
                    PacketPipeInteger packetAt = new PacketPipeInteger();
                    packetAt.readData(data);
                    ServerPacketHandler.onLiquidRefreshRequest(player, packetAt);
                    break;
                }
                case 85: {
                    PacketRequestSubmit packetAu = new PacketRequestSubmit();
                    packetAu.readData(data);
                    ServerPacketHandler.onLiquidRequestSubmit(player, packetAu);
                    break;
                }
                case 86: {
                    PacketModuleNBT packetAv = new PacketModuleNBT();
                    packetAv.readData(data);
                    ServerPacketHandler.onModBasedItemSinkList(player, packetAv);
                    break;
                }
                case 87: {
                    PacketPipeBitSet packetAw = new PacketPipeBitSet();
                    packetAw.readData(data);
                    ServerPacketHandler.onFirewallFlags(player, packetAw);
                    break;
                }
                case 89: {
                    PacketPipeInteger packetAx = new PacketPipeInteger();
                    packetAx.readData(data);
                    ServerPacketHandler.onSecurityCardButton(player, packetAx);
                    break;
                }
                case 90: {
                    PacketModuleNBT packetAy = new PacketModuleNBT();
                    packetAy.readData(data);
                    ServerPacketHandler.onThaumicAspectSinkList(player, packetAy);
                    break;
                }
                case 91: {
                    if (!LogisticsPipes.DEBUG) break;
                    PacketCoordinates packetAz = new PacketCoordinates();
                    packetAz.readData(data);
                    ServerPacketHandler.onCheatJunctionPower(player, packetAz);
                    break;
                }
                case 92: {
                    ServerPacketHandler.onPlayerListRequest(player);
                    break;
                }
                case 94: {
                    PacketStringCoordinates packetBa = new PacketStringCoordinates();
                    packetBa.readData(data);
                    ServerPacketHandler.onOpenSecurityPlayer(player, packetBa);
                    break;
                }
                case 95: {
                    PacketNBT packetBb = new PacketNBT();
                    packetBb.readData(data);
                    ServerPacketHandler.onSaveSecurityPlayer(player, packetBb);
                    break;
                }
                case 96: {
                    PacketPipeInteger packetBc = new PacketPipeInteger();
                    packetBc.readData(data);
                    ServerPacketHandler.onSetSecurityCC(player, packetBc);
                    break;
                }
                case 98: {
                    PacketPipeInteger packetBd = new PacketPipeInteger();
                    packetBd.readData(data);
                    ServerPacketHandler.onCraftingPipeNextSatelliteAdvanced(player, packetBd);
                    break;
                }
                case 99: {
                    PacketPipeInteger packetBe = new PacketPipeInteger();
                    packetBe.readData(data);
                    ServerPacketHandler.onCraftingPipePrevSatelliteAdvanced(player, packetBe);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void onCraftingPipeNextSatellite(iq player, PacketCoordinates packet) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof BaseLogicCrafting)) {
            return;
        }
        ((BaseLogicCrafting)pipe.pipe.logic).setNextSatellite((qx)player);
    }

    private static void onCraftingPipePrevSatellite(iq player, PacketCoordinates packet) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof BaseLogicCrafting)) {
            return;
        }
        ((BaseLogicCrafting)pipe.pipe.logic).setPrevSatellite((qx)player);
    }

    private static void onCraftingPipeImport(iq player, PacketCoordinates packet) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof BaseLogicCrafting)) {
            return;
        }
        ((BaseLogicCrafting)pipe.pipe.logic).importFromCraftingTable((qx)player);
    }

    private static void onSatellitePipeNext(iq player, PacketCoordinates packet) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof BaseLogicSatellite)) {
            return;
        }
        ((BaseLogicSatellite)pipe.pipe.logic).setNextId((qx)player);
    }

    private static void onSatellitePipePrev(iq player, PacketCoordinates packet) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof BaseLogicSatellite)) {
            return;
        }
        ((BaseLogicSatellite)pipe.pipe.logic).setPrevId((qx)player);
    }

    private static void onModuleGuiOpen(iq player, PacketPipeInteger packet) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe instanceof PipeLogisticsChassi)) {
            return;
        }
        PipeLogisticsChassi cassiPipe = (PipeLogisticsChassi)pipe.pipe;
        if (!(cassiPipe.getLogisticsModule().getSubModule(packet.integer) instanceof ILogisticsGuiModule)) {
            return;
        }
        player.openGui((Object)LogisticsPipes.instance, ((ILogisticsGuiModule)cassiPipe.getLogisticsModule().getSubModule(packet.integer)).getGuiHandlerID() + 100 * (packet.integer + 1), player.p, packet.posX, packet.posY, packet.posZ);
        if (cassiPipe.getLogisticsModule().getSubModule(packet.integer) instanceof ModuleItemSink) {
            MainProxy.sendPacketToPlayer(new PacketModuleInteger(17, packet.posX, packet.posY, packet.posZ, packet.integer, ((ModuleItemSink)cassiPipe.getLogisticsModule().getSubModule(packet.integer)).isDefaultRoute() ? 1 : 0).getPacket(), (Player)player);
        }
        if (cassiPipe.getLogisticsModule().getSubModule(packet.integer) instanceof ModuleExtractor) {
            MainProxy.sendPacketToPlayer(new PacketModuleInteger(25, packet.posX, packet.posY, packet.posZ, packet.integer, ((ModuleExtractor)cassiPipe.getLogisticsModule().getSubModule(packet.integer)).getSneakyDirection().ordinal()).getPacket(), (Player)player);
        }
        if (cassiPipe.getLogisticsModule().getSubModule(packet.integer) instanceof ModuleProvider) {
            MainProxy.sendPacketToPlayer(new PacketPipeInteger(29, packet.posX, packet.posY, packet.posZ, ((ModuleProvider)cassiPipe.getLogisticsModule().getSubModule(packet.integer)).isExcludeFilter() ? 1 : 0).getPacket(), (Player)player);
            MainProxy.sendPacketToPlayer(new PacketPipeInteger(28, packet.posX, packet.posY, packet.posZ, ((ModuleProvider)cassiPipe.getLogisticsModule().getSubModule(packet.integer)).getExtractionMode().ordinal()).getPacket(), (Player)player);
        }
        if (cassiPipe.getLogisticsModule().getSubModule(packet.integer) instanceof ModuleAdvancedExtractor) {
            MainProxy.sendPacketToPlayer(new PacketModuleInteger(31, packet.posX, packet.posY, packet.posZ, packet.integer, ((ModuleAdvancedExtractor)cassiPipe.getLogisticsModule().getSubModule(packet.integer)).areItemsIncluded() ? 1 : 0).getPacket(), (Player)player);
        }
    }

    private static void onGuiBackOpen(iq player, PacketPipeInteger packet) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe instanceof PipeLogisticsChassi)) {
            return;
        }
        player.openGui((Object)LogisticsPipes.instance, packet.integer, player.p, packet.posX, packet.posY, packet.posZ);
    }

    private static void onRequestSubmit(iq player, PacketRequestSubmit packet) {
        TileGenericPipe pipe = MainProxy.proxy.getPipeInDimensionAt(packet.dimension, packet.posX, packet.posY, packet.posZ, (qx)player);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe instanceof CoreRoutedPipe)) {
            return;
        }
        RequestHandler.request(player, packet, (CoreRoutedPipe)pipe.pipe);
    }

    private static void onRequestComponents(iq player, PacketRequestSubmit packet) {
        TileGenericPipe pipe = MainProxy.proxy.getPipeInDimensionAt(packet.dimension, packet.posX, packet.posY, packet.posZ, (qx)player);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe instanceof CoreRoutedPipe)) {
            return;
        }
        RequestHandler.simulate(player, packet, (CoreRoutedPipe)pipe.pipe);
    }

    private static void onRefreshRequest(iq player, PacketPipeInteger packet) {
        RequestHandler.DisplayOptions option;
        int dimension = (packet.integer - packet.integer % 10) / 10;
        TileGenericPipe pipe = MainProxy.proxy.getPipeInDimensionAt(dimension, packet.posX, packet.posY, packet.posZ, (qx)player);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe instanceof CoreRoutedPipe)) {
            return;
        }
        switch (packet.integer % 10) {
            case 0: {
                option = RequestHandler.DisplayOptions.Both;
                break;
            }
            case 1: {
                option = RequestHandler.DisplayOptions.SupplyOnly;
                break;
            }
            case 2: {
                option = RequestHandler.DisplayOptions.CraftOnly;
                break;
            }
            default: {
                option = RequestHandler.DisplayOptions.Both;
            }
        }
        RequestHandler.refresh(player, (CoreRoutedPipe)pipe.pipe, option);
    }

    private static void onItemSinkDefault(iq player, PacketPipeInteger packet) {
        int value = packet.integer % 10;
        int slot = packet.integer / 10;
        if (slot == 20) {
            DummyModuleContainer dummy;
            if (player.bL instanceof DummyModuleContainer && (dummy = (DummyModuleContainer)player.bL).getModule() instanceof ModuleItemSink) {
                ((ModuleItemSink)dummy.getModule()).setDefaultRoute(value == 1);
            }
            return;
        }
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe instanceof CoreRoutedPipe)) {
            return;
        }
        CoreRoutedPipe piperouted = (CoreRoutedPipe)pipe.pipe;
        if (piperouted.getLogisticsModule() == null) {
            return;
        }
        if (slot <= 0) {
            if (piperouted.getLogisticsModule() instanceof ModuleItemSink) {
                ModuleItemSink module = (ModuleItemSink)piperouted.getLogisticsModule();
                module.setDefaultRoute(value == 1);
                return;
            }
        } else if (piperouted.getLogisticsModule().getSubModule(slot - 1) instanceof ModuleItemSink) {
            ModuleItemSink module = (ModuleItemSink)piperouted.getLogisticsModule().getSubModule(slot - 1);
            module.setDefaultRoute(value == 1);
            return;
        }
    }

    private static void onProviderModeChange(iq player, PacketCoordinates packet) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe instanceof PipeItemsProviderLogistics)) {
            return;
        }
        PipeItemsProviderLogistics providerpipe = (PipeItemsProviderLogistics)pipe.pipe;
        LogicProvider logic = (LogicProvider)providerpipe.logic;
        logic.nextExtractionMode();
        MainProxy.sendPacketToPlayer(new PacketPipeInteger(20, packet.posX, packet.posY, packet.posZ, logic.getExtractionMode().ordinal()).getPacket(), (Player)player);
    }

    private static void onProviderIncludeChange(iq player, PacketCoordinates packet) {
        LogicProvider logic;
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe instanceof PipeItemsProviderLogistics)) {
            return;
        }
        PipeItemsProviderLogistics providerpipe = (PipeItemsProviderLogistics)pipe.pipe;
        logic.setFilterExcluded(!(logic = (LogicProvider)providerpipe.logic).isExcludeFilter());
        MainProxy.sendPacketToPlayer(new PacketPipeInteger(21, packet.posX, packet.posY, packet.posZ, logic.isExcludeFilter() ? 1 : 0).getPacket(), (Player)player);
    }

    private static void onSupplierModeChange(iq player, PacketCoordinates packet) {
        LogicSupplier logic;
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof LogicSupplier)) {
            return;
        }
        logic.setRequestingPartials(!(logic = (LogicSupplier)pipe.pipe.logic).isRequestingPartials());
        MainProxy.sendPacketToPlayer(new PacketPipeInteger(23, packet.posX, packet.posY, packet.posZ, logic.isRequestingPartials() ? 1 : 0).getPacket(), (Player)player);
    }

    private static void onExtractorModeChange(iq player, PacketPipeInteger packet) {
        int value = packet.integer % 10;
        int slot = packet.integer / 10;
        if (slot == 20) {
            DummyModuleContainer dummy;
            if (player.bL instanceof DummyModuleContainer && (dummy = (DummyModuleContainer)player.bL).getModule() instanceof ISneakyDirectionReceiver) {
                ISneakyDirectionReceiver module = (ISneakyDirectionReceiver)((Object)dummy.getModule());
                module.setSneakyDirection(ForgeDirection.getOrientation((int)value));
                MainProxy.sendPacketToPlayer(new PacketModuleInteger(25, packet.posX, packet.posY, packet.posZ, -1, module.getSneakyDirection().ordinal()).getPacket(), (Player)player);
            }
            return;
        }
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe instanceof CoreRoutedPipe)) {
            return;
        }
        CoreRoutedPipe piperouted = (CoreRoutedPipe)pipe.pipe;
        if (piperouted.getLogisticsModule() == null) {
            return;
        }
        if (slot <= 0) {
            if (piperouted.getLogisticsModule() instanceof ISneakyDirectionReceiver) {
                ISneakyDirectionReceiver module = (ISneakyDirectionReceiver)((Object)piperouted.getLogisticsModule());
                module.setSneakyDirection(ForgeDirection.getOrientation((int)value));
                MainProxy.sendPacketToPlayer(new PacketModuleInteger(25, packet.posX, packet.posY, packet.posZ, -1, module.getSneakyDirection().ordinal()).getPacket(), (Player)player);
                return;
            }
        } else if (piperouted.getLogisticsModule().getSubModule(slot - 1) instanceof ISneakyDirectionReceiver) {
            ISneakyDirectionReceiver module = (ISneakyDirectionReceiver)((Object)piperouted.getLogisticsModule().getSubModule(slot - 1));
            module.setSneakyDirection(ForgeDirection.getOrientation((int)value));
            MainProxy.sendPacketToPlayer(new PacketModuleInteger(25, packet.posX, packet.posY, packet.posZ, slot - 1, module.getSneakyDirection().ordinal()).getPacket(), (Player)player);
            return;
        }
    }

    private static void onProviderModuleModeChange(iq player, PacketPipeInteger packet) {
        int slot = packet.integer;
        if (slot == 20) {
            DummyModuleContainer dummy;
            if (player.bL instanceof DummyModuleContainer && (dummy = (DummyModuleContainer)player.bL).getModule() instanceof ModuleProvider) {
                ModuleProvider module = (ModuleProvider)dummy.getModule();
                module.nextExtractionMode();
                MainProxy.sendPacketToPlayer(new PacketPipeInteger(28, packet.posX, packet.posY, packet.posZ, module.getExtractionMode().ordinal()).getPacket(), (Player)player);
            }
            return;
        }
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe instanceof CoreRoutedPipe)) {
            return;
        }
        CoreRoutedPipe piperouted = (CoreRoutedPipe)pipe.pipe;
        if (piperouted.getLogisticsModule() == null) {
            return;
        }
        if (slot <= 0) {
            if (piperouted.getLogisticsModule() instanceof ModuleProvider) {
                ModuleProvider module = (ModuleProvider)piperouted.getLogisticsModule();
                module.nextExtractionMode();
                MainProxy.sendPacketToPlayer(new PacketPipeInteger(28, packet.posX, packet.posY, packet.posZ, module.getExtractionMode().ordinal()).getPacket(), (Player)player);
                return;
            }
        } else if (piperouted.getLogisticsModule().getSubModule(slot - 1) instanceof ModuleProvider) {
            ModuleProvider module = (ModuleProvider)piperouted.getLogisticsModule().getSubModule(slot - 1);
            module.nextExtractionMode();
            MainProxy.sendPacketToPlayer(new PacketPipeInteger(28, packet.posX, packet.posY, packet.posZ, module.getExtractionMode().ordinal()).getPacket(), (Player)player);
            return;
        }
    }

    private static void onProviderModuleIncludeChange(iq player, PacketPipeInteger packet) {
        int slot = packet.integer;
        if (slot == 20) {
            DummyModuleContainer dummy;
            if (player.bL instanceof DummyModuleContainer && (dummy = (DummyModuleContainer)player.bL).getModule() instanceof ModuleProvider) {
                ModuleProvider module;
                module.setFilterExcluded(!(module = (ModuleProvider)dummy.getModule()).isExcludeFilter());
                MainProxy.sendPacketToPlayer(new PacketPipeInteger(29, packet.posX, packet.posY, packet.posZ, module.isExcludeFilter() ? 1 : 0).getPacket(), (Player)player);
            }
            return;
        }
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe instanceof CoreRoutedPipe)) {
            return;
        }
        CoreRoutedPipe piperouted = (CoreRoutedPipe)pipe.pipe;
        if (piperouted.getLogisticsModule() == null) {
            return;
        }
        if (slot <= 0) {
            if (piperouted.getLogisticsModule() instanceof ModuleProvider) {
                ModuleProvider module;
                module.setFilterExcluded(!(module = (ModuleProvider)piperouted.getLogisticsModule()).isExcludeFilter());
                MainProxy.sendPacketToPlayer(new PacketPipeInteger(29, packet.posX, packet.posY, packet.posZ, module.isExcludeFilter() ? 1 : 0).getPacket(), (Player)player);
                return;
            }
        } else if (piperouted.getLogisticsModule().getSubModule(slot - 1) instanceof ModuleProvider) {
            ModuleProvider module;
            module.setFilterExcluded(!(module = (ModuleProvider)piperouted.getLogisticsModule().getSubModule(slot - 1)).isExcludeFilter());
            MainProxy.sendPacketToPlayer(new PacketPipeInteger(29, packet.posX, packet.posY, packet.posZ, module.isExcludeFilter() ? 1 : 0).getPacket(), (Player)player);
            return;
        }
    }

    private static void onAdvancedExtractorModuleIncludeChange(iq player, PacketPipeInteger packet) {
        int slot = packet.integer / 10;
        if (slot == 20) {
            DummyModuleContainer dummy;
            if (player.bL instanceof DummyModuleContainer && (dummy = (DummyModuleContainer)player.bL).getModule() instanceof ModuleAdvancedExtractor) {
                ((ModuleAdvancedExtractor)dummy.getModule()).setItemsIncluded(!((ModuleAdvancedExtractor)dummy.getModule()).areItemsIncluded());
                MainProxy.sendPacketToPlayer(new PacketModuleInteger(31, packet.posX, packet.posY, packet.posZ, 20, ((ModuleAdvancedExtractor)dummy.getModule()).areItemsIncluded() ? 1 : 0).getPacket(), (Player)player);
            }
            return;
        }
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe instanceof CoreRoutedPipe)) {
            return;
        }
        CoreRoutedPipe piperouted = (CoreRoutedPipe)pipe.pipe;
        if (piperouted.getLogisticsModule() == null) {
            return;
        }
        if (slot <= 0) {
            if (piperouted.getLogisticsModule() instanceof ModuleAdvancedExtractor) {
                ModuleAdvancedExtractor module;
                module.setItemsIncluded(!(module = (ModuleAdvancedExtractor)piperouted.getLogisticsModule()).areItemsIncluded());
                MainProxy.sendPacketToPlayer(new PacketModuleInteger(31, packet.posX, packet.posY, packet.posZ, -1, module.areItemsIncluded() ? 1 : 0).getPacket(), (Player)player);
                return;
            }
        } else if (piperouted.getLogisticsModule().getSubModule(slot - 1) instanceof ModuleAdvancedExtractor) {
            ModuleAdvancedExtractor module;
            module.setItemsIncluded(!(module = (ModuleAdvancedExtractor)piperouted.getLogisticsModule().getSubModule(slot - 1)).areItemsIncluded());
            MainProxy.sendPacketToPlayer(new PacketModuleInteger(31, packet.posX, packet.posY, packet.posZ, slot - 1, module.areItemsIncluded() ? 1 : 0).getPacket(), (Player)player);
            return;
        }
    }

    private static void onAdvancedExtractorModuleGuiSneaky(iq player, PacketPipeInteger packet) {
        int slot = packet.integer;
        if (slot == 20) {
            DummyModuleContainer dummy;
            if (player.bL instanceof DummyModuleContainer && (dummy = (DummyModuleContainer)player.bL).getModule() instanceof ModuleAdvancedExtractor) {
                player.i();
                player.openGui((Object)LogisticsPipes.instance, 20 + 100 * packet.integer, player.p, packet.posX, packet.posY, packet.posZ);
                MainProxy.sendPacketToPlayer(new PacketModuleInteger(25, packet.posX, packet.posY, packet.posZ, -1, ((ModuleAdvancedExtractor)dummy.getModule()).getSneakyDirection().ordinal()).getPacket(), (Player)player);
            }
            return;
        }
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe instanceof CoreRoutedPipe)) {
            return;
        }
        CoreRoutedPipe piperouted = (CoreRoutedPipe)pipe.pipe;
        if (piperouted.getLogisticsModule() == null) {
            return;
        }
        if (slot <= 0) {
            if (piperouted.getLogisticsModule() instanceof ModuleAdvancedExtractor) {
                ModuleAdvancedExtractor module = (ModuleAdvancedExtractor)piperouted.getLogisticsModule();
                player.openGui((Object)LogisticsPipes.instance, 20 + 100 * packet.integer, player.p, packet.posX, packet.posY, packet.posZ);
                MainProxy.sendPacketToPlayer(new PacketModuleInteger(25, packet.posX, packet.posY, packet.posZ, -1, module.getSneakyDirection().ordinal()).getPacket(), (Player)player);
                return;
            }
        } else if (piperouted.getLogisticsModule().getSubModule(slot - 1) instanceof ModuleAdvancedExtractor) {
            ModuleAdvancedExtractor module = (ModuleAdvancedExtractor)piperouted.getLogisticsModule().getSubModule(slot - 1);
            player.openGui((Object)LogisticsPipes.instance, 20 + 100 * packet.integer, player.p, packet.posX, packet.posY, packet.posZ);
            MainProxy.sendPacketToPlayer(new PacketModuleInteger(25, packet.posX, packet.posY, packet.posZ, slot - 1, module.getSneakyDirection().ordinal()).getPacket(), (Player)player);
            return;
        }
    }

    private static void onPipeUpdateRequest(iq playerEntity, PacketCoordinates packet) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(playerEntity.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        MainProxy.sendPacketToPlayer(new PacketPipeUpdate(36, packet.posX, packet.posY, packet.posZ, ((CoreRoutedPipe)pipe.pipe).getLogisticsNetworkPacket()).getPacket(), (Player)playerEntity);
        ((CoreRoutedPipe)pipe.pipe).refreshRender(true);
    }

    private static void onCraftingPipeUpdateRequest(iq player, PacketCoordinates packet) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe instanceof CoreRoutedPipe)) {
            return;
        }
        MainProxy.sendPacketToPlayer(new PacketPipeUpdate(36, packet.posX, packet.posY, packet.posZ, ((CoreRoutedPipe)pipe.pipe).getLogisticsNetworkPacket()).getPacket(), (Player)player);
        if (pipe.pipe instanceof PipeItemsCraftingLogistics && pipe.pipe.logic instanceof BaseLogicCrafting) {
            PacketInventoryChange newpacket = new PacketInventoryChange(5, pipe.l, pipe.m, pipe.n, ((BaseLogicCrafting)pipe.pipe.logic).getDummyInventory());
            MainProxy.sendPacketToPlayer(newpacket.getPacket(), (Player)player);
        }
    }

    private static void onCraftingPipeOpenConnectedGui(iq player, PacketCoordinates packet) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe instanceof PipeItemsCraftingLogistics && pipe.pipe.logic instanceof BaseLogicCrafting) {
            ((BaseLogicCrafting)pipe.pipe.logic).openAttachedGui((qx)player);
        }
    }

    private static void onDiskContentRequest(iq player, PacketCoordinates packet) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe instanceof PipeItemsRequestLogisticsMk2) {
            if (((PipeItemsRequestLogisticsMk2)pipe.pipe).getDisk() != null && !((PipeItemsRequestLogisticsMk2)pipe.pipe).getDisk().o()) {
                ((PipeItemsRequestLogisticsMk2)pipe.pipe).getDisk().d(new bq("tag"));
            }
            MainProxy.sendPacketToPlayer(new PacketItem(38, pipe.l, pipe.m, pipe.n, ((PipeItemsRequestLogisticsMk2)pipe.pipe).getDisk()).getPacket(), (Player)player);
        }
    }

    private static void onDiskSetName(iq player, PacketPipeString packet) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe instanceof PipeItemsRequestLogisticsMk2) {
            if (((PipeItemsRequestLogisticsMk2)pipe.pipe).getDisk() == null) {
                return;
            }
            if (!((PipeItemsRequestLogisticsMk2)pipe.pipe).getDisk().o()) {
                ((PipeItemsRequestLogisticsMk2)pipe.pipe).getDisk().d(new bq("tag"));
            }
            bq nbt = ((PipeItemsRequestLogisticsMk2)pipe.pipe).getDisk().p();
            nbt.a("name", packet.string);
        }
    }

    private static void onDiskChangeClientSide(iq player, PacketItem packet) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe instanceof PipeItemsRequestLogisticsMk2) {
            ((PipeItemsRequestLogisticsMk2)pipe.pipe).setDisk(packet.itemstack);
        }
        ServerPacketHandler.onDiskContentRequest(player, packet);
    }

    private static void onDiskDrop(iq player, PacketCoordinates packet) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe instanceof PipeItemsRequestLogisticsMk2) {
            ((PipeItemsRequestLogisticsMk2)pipe.pipe).dropDisk();
        }
        ServerPacketHandler.onDiskContentRequest(player, packet);
    }

    private static void onDiskMacroRequest(iq player, PacketPipeInteger packet) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe instanceof PipeItemsRequestLogisticsMk2) {
            by list;
            if (((PipeItemsRequestLogisticsMk2)pipe.pipe).getDisk() == null) {
                return;
            }
            if (!((PipeItemsRequestLogisticsMk2)pipe.pipe).getDisk().o()) {
                return;
            }
            bq nbt = ((PipeItemsRequestLogisticsMk2)pipe.pipe).getDisk().p();
            if (!nbt.b("macroList")) {
                list = new by();
                nbt.a("macroList", (cd)list);
            }
            list = nbt.m("macroList");
            for (int i = 0; i < list.c(); ++i) {
                if (i != packet.integer) continue;
                bq itemlist = (bq)list.b(i);
                RequestHandler.requestMacrolist(itemlist, (PipeItemsRequestLogisticsMk2)pipe.pipe, (qx)player);
                break;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void onBeeModuleSetBee(iq player, PacketPipeBeePacket packet) {
        ModuleApiaristSink sink;
        if (packet.integer1 == 20) {
            if (!(player.bL instanceof DummyModuleContainer)) return;
            DummyModuleContainer dummy = (DummyModuleContainer)player.bL;
            if (!(dummy.getModule() instanceof ModuleApiaristSink)) return;
            sink = (ModuleApiaristSink)dummy.getModule();
        } else {
            TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
            if (pipe == null) {
                return;
            }
            if (pipe.pipe instanceof PipeItemsApiaristSink) {
                sink = (ModuleApiaristSink)((PipeItemsApiaristSink)pipe.pipe).getLogisticsModule();
            } else {
                if (!(pipe.pipe instanceof CoreRoutedPipe) || !(((CoreRoutedPipe)pipe.pipe).getLogisticsModule().getSubModule(packet.integer1 - 1) instanceof ModuleApiaristSink)) return;
                sink = (ModuleApiaristSink)((CoreRoutedPipe)pipe.pipe).getLogisticsModule().getSubModule(packet.integer1 - 1);
            }
        }
        if (packet.integer2 >= sink.filter.length) {
            return;
        }
        switch (packet.integer3) {
            case 0: {
                sink.filter[packet.integer2].firstBee = packet.string1;
                return;
            }
            case 1: {
                sink.filter[packet.integer2].secondBee = packet.string1;
                return;
            }
            case 2: {
                sink.filter[packet.integer2].filterGroup = packet.integer4;
                return;
            }
            case 3: {
                if (packet.integer4 >= ModuleApiaristSink.FilterType.values().length) {
                    return;
                }
                sink.filter[packet.integer2].filterType = ModuleApiaristSink.FilterType.values()[packet.integer4];
            }
        }
    }

    private static void onLiquidSupplierPartials(iq player, PacketPipeInteger packet) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe instanceof PipeItemsLiquidSupplier) {
            PipeItemsLiquidSupplier liquid = (PipeItemsLiquidSupplier)pipe.pipe;
            ((LogicLiquidSupplier)liquid.logic).setRequestingPartials(packet.integer % 10 == 1);
        }
    }

    private static void onInvSysContentRequest(iq player, PacketCoordinates packet) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe instanceof PipeItemsInvSysConnector) {
            PipeItemsInvSysConnector connector = (PipeItemsInvSysConnector)pipe.pipe;
            Set allItems = connector.getExpectedItems();
            PacketRequestGuiContent packetContent = new PacketRequestGuiContent(allItems, 46);
            MainProxy.sendPacketToPlayer(packetContent.getPacket(), (Player)player);
        }
    }

    private static void onHUDWatchingChange(iq player, PacketPipeInteger packet, boolean add) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe instanceof IWatchingHandler) {
            IWatchingHandler handler = (IWatchingHandler)pipe.pipe;
            if (add) {
                handler.playerStartWatching((qx)player, packet.integer);
            } else {
                handler.playerStopWatching((qx)player, packet.integer);
            }
        }
    }

    private static void onInvSysConResistance(iq player, PacketPipeInteger packet) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe instanceof PipeItemsInvSysConnector) {
            PipeItemsInvSysConnector invCon = (PipeItemsInvSysConnector)pipe.pipe;
            invCon.resistance = packet.integer;
            invCon.getRouter().update(true);
        }
    }

    private static void onCraftingPipeStackMove(iq player, PacketPipeInteger packet) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe instanceof PipeItemsCraftingLogistics && ((PipeItemsCraftingLogistics)pipe.pipe).logic instanceof BaseLogicCrafting) {
            BaseLogicCrafting logic = (BaseLogicCrafting)((PipeItemsCraftingLogistics)pipe.pipe).logic;
            logic.handleStackMove(packet.integer);
        }
    }

    private static void onHUDModuleWatchingChange(iq player, PacketPipeInteger packet, boolean flag) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe instanceof PipeLogisticsChassi && ((PipeLogisticsChassi)pipe.pipe).getModules() != null && ((PipeLogisticsChassi)pipe.pipe).getModules().getSubModule(packet.integer) instanceof IModuleWatchReciver) {
            IModuleWatchReciver handler = (IModuleWatchReciver)((Object)((PipeLogisticsChassi)pipe.pipe).getModules().getSubModule(packet.integer));
            if (flag) {
                handler.startWatching((qx)player);
            } else {
                handler.stopWatching((qx)player);
            }
        }
    }

    private static void onElectricModuleStateChange(iq player, PacketModuleInteger packet) {
        if (packet.slot == 20) {
            DummyModuleContainer dummy;
            if (player.bL instanceof DummyModuleContainer && (dummy = (DummyModuleContainer)player.bL).getModule() instanceof ModuleElectricManager) {
                ModuleElectricManager module = (ModuleElectricManager)dummy.getModule();
                module.setDischargeMode(packet.integer == 1);
            }
            return;
        }
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe instanceof PipeLogisticsChassi && ((PipeLogisticsChassi)pipe.pipe).getModules() != null && ((PipeLogisticsChassi)pipe.pipe).getModules().getSubModule(packet.slot) instanceof ModuleElectricManager) {
            ModuleElectricManager module = (ModuleElectricManager)((PipeLogisticsChassi)pipe.pipe).getModules().getSubModule(packet.slot);
            module.setDischargeMode(packet.integer == 1);
        }
    }

    private static void onRotationRequest(iq player, PacketCoordinates packet) {
        any tile = player.p.q(packet.posX, packet.posY, packet.posZ);
        if (tile instanceof IRotationProvider) {
            MainProxy.sendPacketToPlayer(new PacketPipeInteger(67, packet.posX, packet.posY, packet.posZ, ((IRotationProvider)tile).getRotation()).getPacket(), (Player)player);
        }
    }

    private static void onPriorityUp(iq player, PacketCoordinates packet) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof BaseLogicCrafting)) {
            return;
        }
        ((BaseLogicCrafting)pipe.pipe.logic).priorityUp((qx)player);
    }

    private static void onPriorityDown(iq player, PacketCoordinates packet) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof BaseLogicCrafting)) {
            return;
        }
        ((BaseLogicCrafting)pipe.pipe.logic).priorityDown((qx)player);
    }

    private static void onHUDBlockWatch(iq player, PacketCoordinates packet, boolean flag) {
        any tile = player.p.q(packet.posX, packet.posY, packet.posZ);
        if (tile instanceof IBlockWatchingHandler) {
            if (flag) {
                ((IBlockWatchingHandler)tile).playerStartWatching((qx)player);
            } else {
                ((IBlockWatchingHandler)tile).playerStopWatching((qx)player);
            }
        }
    }

    private static void onHUDSettings(iq player, PacketHUDSettings packet) {
        if (player.bJ.a(packet.slot) == null) {
            return;
        }
        HUDConfig config = new HUDConfig(player.bJ.a(packet.slot));
        switch (packet.buttonId) {
            case 0: {
                config.setHUDChassie(packet.state);
                if (config.isHUDChassie()) {
                    player.a("Enabled Chassie.");
                    break;
                }
                player.a("Disabled Chassie.");
                break;
            }
            case 1: {
                config.setHUDCrafting(packet.state);
                if (config.isHUDCrafting()) {
                    player.a("Enabled Crafting.");
                    break;
                }
                player.a("Disabled Crafting.");
                break;
            }
            case 2: {
                config.setHUDInvSysCon(packet.state);
                if (config.isHUDInvSysCon()) {
                    player.a("Enabled InvSysCon.");
                    break;
                }
                player.a("Disabled InvSysCon.");
                break;
            }
            case 3: {
                config.setHUDPowerJunction(packet.state);
                if (config.isHUDPowerJunction()) {
                    player.a("Enabled Power Junction.");
                    break;
                }
                player.a("Disabled Power Junction.");
                break;
            }
            case 4: {
                config.setHUDProvider(packet.state);
                if (config.isHUDProvider()) {
                    player.a("Enabled Provider.");
                    break;
                }
                player.a("Disabled Provider.");
                break;
            }
            case 5: {
                config.setHUDSatellite(packet.state);
                if (config.isHUDSatellite()) {
                    player.a("Enabled Satellite.");
                    break;
                }
                player.a("Disabled Satellite.");
            }
        }
        if (player.bK != null) {
            player.bK.b();
        }
    }

    private static void onBufferTransfer(PacketBufferTransfer packet, Player player) {
        SimpleServiceLocator.serverBufferHandler.handlePacket(packet, player);
    }

    private static void onNameUpdate(PacketNameUpdatePacket packetAs) {
        MainProxy.proxy.updateNames(packetAs.item, packetAs.name);
    }

    private static void onLiquidRefreshRequest(iq player, PacketPipeInteger packet) {
        int dimension = packet.integer;
        TileGenericPipe pipe = MainProxy.proxy.getPipeInDimensionAt(dimension, packet.posX, packet.posY, packet.posZ, (qx)player);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe instanceof CoreRoutedPipe)) {
            return;
        }
        RequestHandler.refreshLiquid(player, (CoreRoutedPipe)pipe.pipe);
    }

    private static void onLiquidRequestSubmit(iq player, PacketRequestSubmit packet) {
        TileGenericPipe pipe = MainProxy.proxy.getPipeInDimensionAt(packet.dimension, packet.posX, packet.posY, packet.posZ, (qx)player);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe instanceof CoreRoutedPipe)) {
            return;
        }
        if (!(pipe.pipe instanceof IRequestLiquid)) {
            return;
        }
        RequestHandler.requestLiquid(player, packet, (CoreRoutedPipe)pipe.pipe, (IRequestLiquid)pipe.pipe);
    }

    private static void onModBasedItemSinkList(iq player, PacketModuleNBT packet) {
        DummyModuleContainer dummy;
        if (packet.slot == 20 && player.bL instanceof DummyModuleContainer && (dummy = (DummyModuleContainer)player.bL).getModule() instanceof ModuleModBasedItemSink) {
            ((ModuleModBasedItemSink)dummy.getModule()).readFromNBT(packet.tag);
            return;
        }
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe instanceof PipeLogisticsChassi && ((PipeLogisticsChassi)pipe.pipe).getModules() != null && ((PipeLogisticsChassi)pipe.pipe).getModules().getSubModule(packet.slot) instanceof ModuleModBasedItemSink) {
            ((ModuleModBasedItemSink)((PipeLogisticsChassi)pipe.pipe).getModules().getSubModule(packet.slot)).readFromNBT(packet.tag);
        }
    }

    private static void onThaumicAspectSinkList(iq player, PacketModuleNBT packet) {
        if (packet.slot == 20) {
            DummyModuleContainer dummy;
            if (player.bL instanceof DummyModuleContainer && (dummy = (DummyModuleContainer)player.bL).getModule() instanceof ModuleThaumicAspectSink) {
                ModuleThaumicAspectSink module = (ModuleThaumicAspectSink)dummy.getModule();
                module.readFromNBT(packet.tag);
            }
            return;
        }
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe instanceof PipeLogisticsChassi && ((PipeLogisticsChassi)pipe.pipe).getModules() != null && ((PipeLogisticsChassi)pipe.pipe).getModules().getSubModule(packet.slot) instanceof ModuleThaumicAspectSink) {
            ((ModuleThaumicAspectSink)((PipeLogisticsChassi)pipe.pipe).getModules().getSubModule(packet.slot)).readFromNBT(packet.tag);
        }
    }

    private static void onCheatJunctionPower(iq player, PacketCoordinates packet) {
        yc world = player.p;
        if (!world.f(packet.posX, packet.posY, packet.posZ)) {
            return;
        }
        any tile = world.q(packet.posX, packet.posY, packet.posZ);
        if (tile instanceof LogisticsPowerJuntionTileEntity_BuildCraft) {
            ((LogisticsPowerJuntionTileEntity_BuildCraft)tile).addEnergy(100000.0f);
        }
    }

    private static void onFirewallFlags(iq player, PacketPipeBitSet packet) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe instanceof PipeItemsFirewall) {
            PipeItemsFirewall firewall = (PipeItemsFirewall)pipe.pipe;
            firewall.setFlags(packet.flags);
        }
    }

    private static void onSecurityCardButton(iq player, PacketPipeInteger packet) {
        any tile = player.p.q(packet.posX, packet.posY, packet.posZ);
        if (tile instanceof LogisticsSecurityTileEntity) {
            ((LogisticsSecurityTileEntity)tile).buttonFreqCard(packet.integer, (qx)player);
        }
    }

    private static void onPlayerListRequest(iq player) {
        LinkedList<String> list = new LinkedList<String>();
        File root = DimensionManager.getCurrentSaveRootDirectory();
        if (root == null) {
            return;
        }
        if (!root.exists()) {
            return;
        }
        File players = new File(root, "players");
        if (!players.exists()) {
            return;
        }
        for (String names : players.list()) {
            if (!names.endsWith(".dat") || !new File(players, names).isFile()) continue;
            list.add(names.substring(0, names.length() - 4));
        }
        MainProxy.sendPacketToPlayer(new PacketStringList(92, list).getPacket(), (Player)player);
    }

    private static void onOpenSecurityPlayer(iq player, PacketStringCoordinates packet) {
        any tile = player.p.q(packet.posX, packet.posY, packet.posZ);
        if (tile instanceof LogisticsSecurityTileEntity) {
            ((LogisticsSecurityTileEntity)tile).handleOpenSecurityPlayer(player, packet.string);
        }
    }

    private static void onSaveSecurityPlayer(iq player, PacketNBT packet) {
        any tile = player.p.q(packet.posX, packet.posY, packet.posZ);
        if (tile instanceof LogisticsSecurityTileEntity) {
            ((LogisticsSecurityTileEntity)tile).saveNewSecuritySettings(packet.tag);
        }
    }

    private static void onSetSecurityCC(iq player, PacketPipeInteger packet) {
        any tile = player.p.q(packet.posX, packet.posY, packet.posZ);
        if (tile instanceof LogisticsSecurityTileEntity) {
            ((LogisticsSecurityTileEntity)tile).changeCC();
        }
    }

    private static void onCraftingPipeNextSatelliteAdvanced(iq player, PacketPipeInteger packet) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof BaseLogicCrafting)) {
            return;
        }
        ((BaseLogicCrafting)pipe.pipe.logic).setNextSatellite((qx)player, packet.integer);
    }

    private static void onCraftingPipePrevSatelliteAdvanced(iq player, PacketPipeInteger packet) {
        TileGenericPipe pipe = ServerPacketHandler.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof BaseLogicCrafting)) {
            return;
        }
        ((BaseLogicCrafting)pipe.pipe.logic).setPrevSatellite((qx)player, packet.integer);
    }

    private static TileGenericPipe getPipe(yc world, int x, int y2, int z) {
        if (world == null) {
            return null;
        }
        if (!world.f(x, y2, z)) {
            return null;
        }
        any tile = world.q(x, y2, z);
        if (!(tile instanceof TileGenericPipe)) {
            return null;
        }
        return (TileGenericPipe)tile;
    }
}

