/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import logisticspipes.network.INBTPacketProvider;
import logisticspipes.network.SendNBTTagCompound;
import logisticspipes.network.packets.PacketCoordinates;

public class PacketModuleNBT
extends PacketCoordinates {
    public bq tag;
    public int slot;

    public PacketModuleNBT() {
    }

    public PacketModuleNBT(int id, int x, int y2, int z, int slot, bq tag) {
        super(id, x, y2, z);
        this.tag = tag;
        this.slot = slot;
    }

    public PacketModuleNBT(int id, int x, int y2, int z, int slot, INBTPacketProvider provider) {
        super(id, x, y2, z);
        this.tag = new bq();
        this.slot = slot;
        provider.writeToPacketNBT(this.tag);
    }

    public void handle(INBTPacketProvider provider) {
        if (this.tag != null) {
            provider.readFromPacketNBT(this.tag);
        }
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeInt(this.slot);
        SendNBTTagCompound.writeNBTTagCompound(this.tag, data);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        super.readData(data);
        this.slot = data.readInt();
        this.tag = SendNBTTagCompound.readNBTTagCompound(data);
    }
}

