/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import logisticspipes.network.SendNBTTagCompound;
import logisticspipes.network.packets.PacketCoordinates;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;

public class PacketPipeInvContent
extends PacketCoordinates {
    public Collection _allItems = new LinkedList();

    public PacketPipeInvContent() {
    }

    public PacketPipeInvContent(int id, int x, int y2, int z, Collection allItems) {
        super(id, x, y2, z);
        this._allItems = allItems;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        for (ItemIdentifierStack item : this._allItems) {
            data.write(1);
            if (item == null) {
                data.writeInt(0);
                continue;
            }
            data.writeInt(item.getItem().itemID);
            data.writeInt(item.getItem().itemDamage);
            data.writeInt(item.stackSize);
            SendNBTTagCompound.writeNBTTagCompound(item.getItem().tag, data);
        }
        data.write(0);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        super.readData(data);
        while (data.read() != 0) {
            int itemID = data.readInt();
            if (itemID != 0) {
                int dataValue = data.readInt();
                int amount = data.readInt();
                bq tag = SendNBTTagCompound.readNBTTagCompound(data);
                this._allItems.add(ItemIdentifier.get(itemID, dataValue, tag).makeStack(amount));
                continue;
            }
            this._allItems.add(null);
        }
    }
}

