/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import logisticspipes.network.packets.PacketCoordinates;
import logisticspipes.network.packets.PacketPayload;

public class PacketPipeUpdate
extends PacketCoordinates {
    private PacketPayload payload;

    public PacketPipeUpdate() {
    }

    public PacketPipeUpdate(int id, int x, int y2, int z, PacketPayload payload) {
        super(id, x, y2, z);
        this.payload = payload;
    }

    public PacketPayload getPayload() {
        return this.payload;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        if (this.payload == null) {
            data.writeInt(0);
            data.writeInt(0);
            data.writeInt(0);
            return;
        }
        data.writeInt(this.payload.intPayload.length);
        data.writeInt(this.payload.floatPayload.length);
        data.writeInt(this.payload.stringPayload.length);
        for (int intData : this.payload.intPayload) {
            data.writeInt(intData);
        }
        for (float floatData : this.payload.floatPayload) {
            data.writeFloat(floatData);
        }
        for (String stringData : this.payload.stringPayload) {
            data.writeUTF(stringData);
        }
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        int i;
        super.readData(data);
        this.payload = new PacketPayload();
        this.payload.intPayload = new int[data.readInt()];
        this.payload.floatPayload = new float[data.readInt()];
        this.payload.stringPayload = new String[data.readInt()];
        for (i = 0; i < this.payload.intPayload.length; ++i) {
            this.payload.intPayload[i] = data.readInt();
        }
        for (i = 0; i < this.payload.floatPayload.length; ++i) {
            this.payload.floatPayload[i] = data.readFloat();
        }
        for (i = 0; i < this.payload.stringPayload.length; ++i) {
            this.payload.stringPayload[i] = data.readUTF();
        }
    }
}

