/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import buildcraft.api.core.Position;
import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.EntityPassiveItem;
import buildcraft.core.utils.Utils;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import logisticspipes.LogisticsPipes;
import logisticspipes.blocks.LogisticsSignTileEntity;
import logisticspipes.gui.hud.HUDCrafting;
import logisticspipes.interfaces.IChangeListener;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.IOrderManagerContentReceiver;
import logisticspipes.interfaces.routing.ICraftItems;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.logic.BaseLogicCrafting;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.logisticspipes.SidedInventoryAdapter;
import logisticspipes.modules.ModuleCrafter;
import logisticspipes.network.packets.PacketCoordinates;
import logisticspipes.network.packets.PacketInventoryChange;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.network.packets.PacketPipeInvContent;
import logisticspipes.network.packets.PacketPipeUpdate;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.cc.interfaces.CCCommand;
import logisticspipes.proxy.cc.interfaces.CCQueued;
import logisticspipes.proxy.cc.interfaces.CCType;
import logisticspipes.request.CraftingTemplate;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.routing.LogisticsExtraPromise;
import logisticspipes.routing.LogisticsOrderManager;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.security.PermissionException;
import logisticspipes.textures.Textures;
import logisticspipes.transport.PipeTransportLogistics;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.IHavePriority;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.Pair3;
import logisticspipes.utils.WorldUtil;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

@CCType(name="LogisticsPipes:Crafting")
public class PipeItemsCraftingLogistics
extends CoreRoutedPipe
implements ICraftItems,
IHeadUpDisplayRendererProvider,
IChangeListener,
IOrderManagerContentReceiver,
IHavePriority {
    protected LogisticsOrderManager _orderManager = new LogisticsOrderManager(this);
    public final LinkedList oldList = new LinkedList();
    public final LinkedList displayList = new LinkedList();
    public final List localModeWatchers = new ArrayList();
    private final HUDCrafting HUD = new HUDCrafting(this);
    protected int _extras;
    private boolean init = false;
    private boolean doContentUpdate = true;
    public boolean waitingForCraft = false;
    private List _cachedCrafters = null;

    public PipeItemsCraftingLogistics(int itemID) {
        super(new BaseLogicCrafting(), itemID);
        ((BaseLogicCrafting)this.logic).setParentPipe(this);
    }

    public PipeItemsCraftingLogistics(PipeTransportLogistics transport, int itemID) {
        super(transport, new BaseLogicCrafting(), itemID);
        ((BaseLogicCrafting)this.logic).setParentPipe(this);
    }

    protected int neededEnergy() {
        return 10;
    }

    protected int itemsToExtract() {
        return 1;
    }

    protected int stacksToExtract() {
        return 1;
    }

    protected List locateCrafters() {
        if (this._cachedCrafters != null) {
            return this._cachedCrafters;
        }
        WorldUtil worldUtil = new WorldUtil(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        LinkedList<AdjacentTile> crafters = new LinkedList<AdjacentTile>();
        for (AdjacentTile tile : worldUtil.getAdjacentTileEntities(true)) {
            if (tile.tile instanceof TileGenericPipe || !(tile.tile instanceof la)) continue;
            crafters.add(tile);
        }
        this._cachedCrafters = crafters;
        return this._cachedCrafters;
    }

    public void clearCraftersCache() {
        this._cachedCrafters = null;
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        this.clearCraftersCache();
        super.onNeighborBlockChange(blockId);
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        while (this._orderManager.hasOrders()) {
            this._orderManager.sendFailed();
        }
    }

    private ur extractFromISpecialInventory(ISpecialInventory inv, ItemIdentifier wanteditem, int count) {
        ur[] stacks;
        ur retstack = null;
        while (count > 0 && (stacks = inv.extractItem(false, ForgeDirection.UNKNOWN, 1)) != null && stacks.length >= 1 && stacks[0] != null) {
            ur stack = stacks[0];
            if (stack.a == 0 || (retstack != null ? !retstack.a(stack) || !ur.a(retstack, (ur)stack) : !wanteditem.fuzzyMatch(stack))) break;
            if (!this.useEnergy(this.neededEnergy() * stack.a)) break;
            stacks = inv.extractItem(true, ForgeDirection.UNKNOWN, 1);
            if (stacks == null || stacks.length < 1 || stacks[0] == null) {
                LogisticsPipes.requestLog.info("crafting extractItem(true) got nothing from " + inv.toString());
                break;
            }
            if (!ur.b((ur)stack, (ur)stacks[0])) {
                LogisticsPipes.requestLog.info("crafting extract got a unexpected item from " + inv.toString());
            }
            if (retstack == null) {
                retstack = stack;
            } else {
                retstack.a += stack.a;
            }
            count -= stack.a;
        }
        return retstack;
    }

    private ur extractFromIInventory(la inv, ItemIdentifier wanteditem, int count) {
        IInventoryUtil invUtil = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(inv);
        int available = invUtil.itemCount(wanteditem);
        if (available == 0) {
            return null;
        }
        if (!this.useEnergy(this.neededEnergy() * Math.min(count, available))) {
            return null;
        }
        return invUtil.getMultipleItems(wanteditem, Math.min(count, available));
    }

    public void enableUpdateRequest() {
        this.init = false;
    }

    @Override
    public void ignoreDisableUpdateEntity() {
        if (!this.init) {
            if (MainProxy.isClient(this.worldObj) && FMLClientHandler.instance().getClient() != null && FMLClientHandler.instance().getClient().g != null && FMLClientHandler.instance().getClient().g.a != null) {
                MainProxy.sendPacketToServer(new PacketCoordinates(34, this.xCoord, this.yCoord, this.zCoord).getPacket());
            }
            this.init = true;
        }
    }

    @Override
    public void enabledUpdateEntity() {
        if (this.doContentUpdate) {
            this.checkContentUpdate();
        }
        if (this.worldObj.G() % 6L != 0L) {
            return;
        }
        this.waitingForCraft = false;
        if (!this._orderManager.hasOrders() && this._extras < 1) {
            return;
        }
        this.waitingForCraft = true;
        List crafters = this.locateCrafters();
        if (crafters.size() < 1) {
            if (this._orderManager.hasOrders()) {
                this._orderManager.sendFailed();
            } else {
                this._extras = 0;
            }
            return;
        }
        ItemIdentifier wanteditem = this.providedItem();
        if (wanteditem == null) {
            return;
        }
        MainProxy.sendSpawnParticlePacket(6, this.xCoord, this.yCoord, this.zCoord, this.worldObj, 2);
        int itemsleft = this.itemsToExtract();
        int stacksleft = this.stacksToExtract();
        while (itemsleft > 0 && stacksleft > 0 && (this._orderManager.hasOrders() || this._extras > 0)) {
            int maxtosend = Math.min(itemsleft, wanteditem.getMaxStackSize() * stacksleft);
            maxtosend = this._orderManager.hasOrders() ? Math.min(maxtosend, ((ItemIdentifierStack)this._orderManager.getNextRequest().getValue1()).stackSize) : Math.min(maxtosend, this._extras);
            ur extracted = null;
            AdjacentTile tile2 = null;
            for (AdjacentTile tile2 : crafters) {
                if (tile2.tile instanceof ISpecialInventory) {
                    extracted = this.extractFromISpecialInventory((ISpecialInventory)tile2.tile, wanteditem, maxtosend);
                } else if (tile2.tile instanceof ISidedInventory) {
                    SidedInventoryAdapter sidedadapter = new SidedInventoryAdapter((ISidedInventory)tile2.tile, ForgeDirection.UNKNOWN);
                    extracted = this.extractFromIInventory(sidedadapter, wanteditem, maxtosend);
                } else if (tile2.tile instanceof la) {
                    extracted = this.extractFromIInventory((la)tile2.tile, wanteditem, maxtosend);
                }
                if (extracted == null) continue;
            }
            if (extracted == null) break;
            while (extracted.a > 0) {
                int numtosend = Math.min(extracted.a, ItemIdentifier.get(extracted).getMaxStackSize());
                if (this._orderManager.hasOrders()) {
                    Pair3 order = this._orderManager.getNextRequest();
                    numtosend = Math.min(numtosend, ((ItemIdentifierStack)order.getValue1()).stackSize);
                    ur stackToSend = extracted.a(numtosend);
                    itemsleft -= numtosend;
                    --stacksleft;
                    IRoutedItem item = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(stackToSend, this.worldObj);
                    item.setDestination(((IRequestItems)order.getValue2()).getRouter().getSimpleID());
                    item.setTransportMode(IRoutedItem.TransportMode.Active);
                    item.addRelayPoints((List)order.getValue3());
                    super.queueRoutedItem(item, tile2.orientation);
                    this._orderManager.sendSuccessfull(stackToSend.a, false);
                    continue;
                }
                ur stackToSend = extracted.a(numtosend);
                this._extras = Math.max(this._extras - numtosend, 0);
                itemsleft -= numtosend;
                --stacksleft;
                Position p = new Position((double)tile2.tile.l, (double)tile2.tile.m, (double)tile2.tile.n, tile2.orientation);
                LogisticsPipes.requestLog.info(stackToSend.a + " extras dropped, " + this._extras + " remaining");
                Position entityPos = new Position(p.x + 0.5, p.y + (double)Utils.getPipeFloorOf((ur)stackToSend), p.z + 0.5, p.orientation.getOpposite());
                entityPos.moveForwards(0.5);
                EntityPassiveItem entityItem = new EntityPassiveItem(this.worldObj, entityPos.x, entityPos.y, entityPos.z, stackToSend);
                entityItem.setSpeed(Utils.pipeNormalSpeed * 10.0f);
                ((PipeTransportItems)this.transport).entityEntering((IPipedItem)entityItem, entityPos.orientation);
            }
        }
    }

    private ItemIdentifier providedItem() {
        BaseLogicCrafting craftingLogic = (BaseLogicCrafting)this.logic;
        ur stack = craftingLogic.getCraftedItem();
        if (stack == null) {
            return null;
        }
        return ItemIdentifier.get(stack);
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_CRAFTER_TEXTURE;
    }

    @Override
    public void canProvide(RequestTreeNode tree, int donePromisses, List filters) {
        if (!this.isEnabled()) {
            return;
        }
        if (this._extras < 1) {
            return;
        }
        ItemIdentifier providedItem = this.providedItem();
        if (tree.getStack().getItem() != providedItem) {
            return;
        }
        for (IFilter filter : filters) {
            if (filter.isBlocked() != filter.isFilteredItem(tree.getStack().getItem().getUndamaged()) && !filter.blockProvider()) continue;
            return;
        }
        int remaining = this._extras - donePromisses;
        if (remaining < 1) {
            return;
        }
        LogisticsExtraPromise promise = new LogisticsExtraPromise();
        promise.item = providedItem;
        promise.numberOfItems = Math.min(remaining, tree.getMissingItemCount());
        promise.sender = this;
        promise.provided = true;
        LinkedList<IFilter> relays = new LinkedList<IFilter>();
        for (IFilter filter : filters) {
            relays.add(filter);
        }
        promise.relayPoints = relays;
        tree.addPromise(promise);
    }

    @Override
    public CraftingTemplate addCrafting() {
        int i;
        if (!this.isEnabled()) {
            return null;
        }
        BaseLogicCrafting craftingLogic = (BaseLogicCrafting)this.logic;
        ur stack = craftingLogic.getCraftedItem();
        if (stack == null) {
            return null;
        }
        IRequestItems[] target = new IRequestItems[9];
        for (int i2 = 0; i2 < 9; ++i2) {
            target[i2] = this;
        }
        boolean hasSatellite = craftingLogic.isSatelliteConnected();
        if (!hasSatellite) {
            return null;
        }
        if (!this.getUpgradeManager().isAdvancedSatelliteCrafter()) {
            if (craftingLogic.satelliteId != 0) {
                CoreRoutedPipe sat = craftingLogic.getSatelliteRouter(-1, -1).getPipe();
                for (i = 6; i < 9; ++i) {
                    target[i] = sat;
                }
            }
        } else {
            for (int i3 = 0; i3 < 9; ++i3) {
                if (craftingLogic.advancedSatelliteIdArray[i3] == 0) continue;
                target[i3] = craftingLogic.getSatelliteRouter(i3, -1).getPipe();
            }
        }
        CraftingTemplate template = new CraftingTemplate(ItemIdentifierStack.GetFromStack(stack), this, craftingLogic.priority);
        for (i = 0; i < 9; ++i) {
            ur resourceStack = craftingLogic.getMaterials(i);
            if (resourceStack == null || resourceStack.a == 0) continue;
            template.addRequirement(ItemIdentifierStack.GetFromStack(resourceStack), target[i]);
        }
        return template;
    }

    @Override
    public void fullFill(LogisticsPromise promise, IRequestItems destination) {
        if (promise instanceof LogisticsExtraPromise) {
            this._extras -= promise.numberOfItems;
        }
        this._orderManager.addOrder(new ItemIdentifierStack(promise.item, promise.numberOfItems), destination, promise.relayPoints);
        MainProxy.sendSpawnParticlePacket(1, this.xCoord, this.yCoord, this.zCoord, this.worldObj, 2);
    }

    @Override
    public void registerExtras(int count) {
        this._extras += count;
        LogisticsPipes.requestLog.info(count + " extras registered");
    }

    @Override
    public void getAllItems(Map list, List filters) {
    }

    @Override
    public ItemIdentifier getCraftedItem() {
        if (!this.isEnabled()) {
            return null;
        }
        return this.providedItem();
    }

    @Override
    public ILogisticsModule getLogisticsModule() {
        return new ModuleCrafter(this);
    }

    public boolean isAttachedSign(any entity) {
        return entity.l == ((BaseLogicCrafting)this.logic).signEntityX && entity.m == ((BaseLogicCrafting)this.logic).signEntityY && entity.n == ((BaseLogicCrafting)this.logic).signEntityZ;
    }

    public void addSign(LogisticsSignTileEntity entity, qx player) {
        if (((BaseLogicCrafting)this.logic).signEntityX == 0 && ((BaseLogicCrafting)this.logic).signEntityY == 0 && ((BaseLogicCrafting)this.logic).signEntityZ == 0) {
            ((BaseLogicCrafting)this.logic).signEntityX = entity.l;
            ((BaseLogicCrafting)this.logic).signEntityY = entity.m;
            ((BaseLogicCrafting)this.logic).signEntityZ = entity.n;
            MainProxy.sendPacketToPlayer(new PacketPipeUpdate(36, this.xCoord, this.yCoord, this.zCoord, this.getLogisticsNetworkPacket()).getPacket(), (Player)player);
            PacketInventoryChange newpacket = new PacketInventoryChange(5, this.xCoord, this.yCoord, this.zCoord, ((BaseLogicCrafting)this.logic).getDummyInventory());
            MainProxy.sendPacketToPlayer(newpacket.getPacket(), (Player)player);
        }
    }

    public boolean canRegisterSign() {
        return ((BaseLogicCrafting)this.logic).signEntityX == 0 && ((BaseLogicCrafting)this.logic).signEntityY == 0 && ((BaseLogicCrafting)this.logic).signEntityZ == 0;
    }

    public void removeRegisteredSign() {
        ((BaseLogicCrafting)this.logic).signEntityX = 0;
        ((BaseLogicCrafting)this.logic).signEntityY = 0;
        ((BaseLogicCrafting)this.logic).signEntityZ = 0;
        MainProxy.sendToPlayerList(new PacketPipeUpdate(36, this.xCoord, this.yCoord, this.zCoord, this.getLogisticsNetworkPacket()).getPacket(), this.localModeWatchers);
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    public boolean hasOrder() {
        return this._orderManager.hasOrders();
    }

    @Override
    public int getTodo() {
        return this._orderManager.totalItemsCountInAllOrders();
    }

    @Override
    public int getX() {
        return this.xCoord;
    }

    @Override
    public int getY() {
        return this.yCoord;
    }

    @Override
    public int getZ() {
        return this.zCoord;
    }

    @Override
    public void startWaitching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(50, this.xCoord, this.yCoord, this.zCoord, 1).getPacket());
    }

    @Override
    public void stopWaitching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(51, this.xCoord, this.yCoord, this.zCoord, 1).getPacket());
    }

    @Override
    public void playerStartWatching(qx player, int mode) {
        if (mode == 1) {
            this.localModeWatchers.add(player);
            MainProxy.sendPacketToPlayer(new PacketPipeInvContent(53, this.xCoord, this.yCoord, this.zCoord, this.oldList).getPacket(), (Player)player);
        } else {
            super.playerStartWatching(player, mode);
        }
    }

    @Override
    public void playerStopWatching(qx player, int mode) {
        super.playerStopWatching(player, mode);
        this.localModeWatchers.remove(player);
    }

    @Override
    public void listenedChanged() {
        this.doContentUpdate = true;
    }

    private void checkContentUpdate() {
        this.doContentUpdate = false;
        LinkedList all = this._orderManager.getContentList(this.worldObj);
        if (!this.oldList.equals(all)) {
            this.oldList.clear();
            this.oldList.addAll(all);
            MainProxy.sendToPlayerList(new PacketPipeInvContent(53, this.xCoord, this.yCoord, this.zCoord, all).getPacket(), this.localModeWatchers);
        }
    }

    @Override
    public void setOrderManagerContent(Collection list) {
        this.displayList.clear();
        this.displayList.addAll(list);
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public double getLoadFactor() {
        return ((double)this._orderManager.totalItemsCountInAllOrders() + 63.0) / 64.0;
    }

    @CCCommand(description="Imports the crafting recipe from the connected machine/crafter")
    @CCQueued(prefunction="testImportAccess")
    public void reimport() throws Exception {
        this.checkCCAccess();
        ((BaseLogicCrafting)this.logic).importFromCraftingTable(null);
    }

    public void testImportAccess() throws PermissionException {
        this.checkCCAccess();
    }

    @Override
    public Set getSpecificInterests() {
        ur result = ((BaseLogicCrafting)this.logic).getCraftedItem();
        if (result == null) {
            return null;
        }
        TreeSet<ItemIdentifier> l1 = new TreeSet<ItemIdentifier>();
        l1.add(ItemIdentifier.get(result));
        return l1;
    }

    @Override
    public int getPriority() {
        return ((BaseLogicCrafting)this.logic).priority;
    }
}

