/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.api.IRequestAPI;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.logic.TemporaryLogic;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.cc.interfaces.CCCommand;
import logisticspipes.proxy.cc.interfaces.CCQueued;
import logisticspipes.proxy.cc.interfaces.CCType;
import logisticspipes.request.RequestHandler;
import logisticspipes.request.RequestLog;
import logisticspipes.request.RequestManager;
import logisticspipes.security.SecuritySettings;
import logisticspipes.textures.Textures;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemMessage;
import logisticspipes.utils.Pair;

@CCType(name="LogisticsPipes:Request")
public class PipeItemsRequestLogistics
extends CoreRoutedPipe
implements IRequestItems,
IRequestAPI {
    private final LinkedList _history = new LinkedList();

    public PipeItemsRequestLogistics(int itemID) {
        super(new TemporaryLogic(), itemID);
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_REQUESTER_TEXTURE;
    }

    @Override
    public ILogisticsModule getLogisticsModule() {
        return null;
    }

    public void openGui(qx entityplayer) {
        entityplayer.openGui((Object)LogisticsPipes.instance, 31, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public boolean wrenchClicked(yc world, int i, int j, int k, qx entityplayer, SecuritySettings settings) {
        if (MainProxy.isServer(world)) {
            if (settings == null || settings.openRequest) {
                this.openGui(entityplayer);
            } else {
                entityplayer.a("Permission denied");
            }
        }
        return true;
    }

    @Override
    public void enabledUpdateEntity() {
        if (this.worldObj.G() % 1200L == 0L) {
            this._history.addLast(SimpleServiceLocator.logisticsManager.getAvailableItems(this.getRouter().getIRoutersByCost()));
            if (this._history.size() > 20) {
                this._history.removeFirst();
            }
        }
    }

    public LinkedList getHistory() {
        return this._history;
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public List getProvidedItems() {
        Map items = SimpleServiceLocator.logisticsManager.getAvailableItems(this.getRouter().getIRoutersByCost());
        ArrayList<ur> list = new ArrayList<ur>(items.size());
        for (Map.Entry item : items.entrySet()) {
            ur is = ((ItemIdentifier)item.getKey()).unsafeMakeNormalStack((Integer)item.getValue());
            list.add(is);
        }
        return list;
    }

    @Override
    public List getCraftedItems() {
        LinkedList items = SimpleServiceLocator.logisticsManager.getCraftableItems(this.getRouter().getIRoutersByCost());
        ArrayList<ur> list = new ArrayList<ur>(items.size());
        for (ItemIdentifier item : items) {
            ur is = item.unsafeMakeNormalStack(0);
            list.add(is);
        }
        return list;
    }

    @Override
    public IRequestAPI.SimulationResult simulateRequest(ur wanted) {
        final LinkedList used = new LinkedList();
        final LinkedList missing = new LinkedList();
        RequestManager.simulate(ItemIdentifier.get(wanted.c, wanted.j(), wanted.p()).makeStack(wanted.a), this, new RequestLog(){

            @Override
            public void handleMissingItems(LinkedList list) {
                for (ItemMessage msg : list) {
                    ur is = new ur(msg.id, msg.amount, msg.data);
                    is.d(msg.tag);
                    missing.add(is);
                }
            }

            @Override
            public void handleSucessfullRequestOf(ItemMessage item) {
            }

            @Override
            public void handleSucessfullRequestOfList(LinkedList items) {
                for (ItemMessage msg : items) {
                    ur is = new ur(msg.id, msg.amount, msg.data);
                    is.d(msg.tag);
                    used.add(is);
                }
            }
        });
        IRequestAPI.SimulationResult r = new IRequestAPI.SimulationResult();
        r.used = used;
        r.missing = missing;
        return r;
    }

    @Override
    public List performRequest(ur wanted) {
        final LinkedList missing = new LinkedList();
        RequestManager.request(ItemIdentifier.get(wanted.c, wanted.j(), wanted.p()).makeStack(wanted.a), (IRequestItems)this, new RequestLog(){

            @Override
            public void handleMissingItems(LinkedList list) {
                block0: for (ItemMessage msg : list) {
                    ur is = new ur(msg.id, msg.amount, msg.data);
                    is.d(msg.tag);
                    for (ur seen : missing) {
                        if (!seen.a(is) || !ur.a((ur)seen, (ur)is)) continue;
                        seen.a += is.a;
                        continue block0;
                    }
                    missing.add(is);
                }
            }

            @Override
            public void handleSucessfullRequestOf(ItemMessage item) {
            }

            @Override
            public void handleSucessfullRequestOfList(LinkedList items) {
            }
        });
        return missing;
    }

    @CCCommand(description="Requests the given ItemIdentifier Id with the given amount")
    @CCQueued(event="request_successfull\n      ---request_failed", realQueue=false)
    public int makeRequest(Double itemId, Double amount) throws Exception {
        this.checkCCAccess();
        ItemIdentifier item = ItemIdentifier.getForId((int)Math.floor(itemId));
        if (item == null) {
            throw new Exception("Invalid ItemIdentifierID");
        }
        return RequestHandler.computerRequest(item.makeStack((int)Math.floor(amount)), this);
    }

    @CCCommand(description="Asks for all available ItemIdentifier inside the Logistics Network")
    @CCQueued(event="available_items_return")
    public List getAvailableItems() {
        Map items = SimpleServiceLocator.logisticsManager.getAvailableItems(this.getRouter().getIRoutersByCost());
        LinkedList<Pair> list = new LinkedList<Pair>();
        for (Map.Entry item : items.entrySet()) {
            int amount = (Integer)item.getValue();
            list.add(new Pair(item.getKey(), amount));
        }
        return list;
    }

    @CCCommand(description="Asks for all craftable ItemIdentifier inside the Logistics Network")
    @CCQueued(event="craftable_items_return")
    public List getCraftableItems() {
        LinkedList items = SimpleServiceLocator.logisticsManager.getCraftableItems(this.getRouter().getIRoutersByCost());
        return items;
    }
}

