/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import buildcraft.api.core.Position;
import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.gui.hud.HUDSatellite;
import logisticspipes.interfaces.IChestContentReceiver;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.logic.BaseLogicSatellite;
import logisticspipes.logisticspipes.SidedInventoryAdapter;
import logisticspipes.modules.ModuleSatelite;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.network.packets.PacketPipeInvContent;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.textures.Textures;
import logisticspipes.utils.InventoryHelper;
import logisticspipes.utils.ItemIdentifierStack;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class PipeItemsSatelliteLogistics
extends CoreRoutedPipe
implements IRequestItems,
IHeadUpDisplayRendererProvider,
IChestContentReceiver {
    public final List localModeWatchers = new ArrayList();
    public final LinkedList itemList = new LinkedList();
    public final LinkedList oldList = new LinkedList();
    private final HUDSatellite HUD = new HUDSatellite(this);

    public PipeItemsSatelliteLogistics(int itemID) {
        super(new BaseLogicSatellite(), itemID);
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_SATELLITE_TEXTURE;
    }

    @Override
    public void enabledUpdateEntity() {
        if (this.worldObj.G() % 20L == 0L && this.localModeWatchers.size() > 0) {
            this.updateInv(false);
        }
    }

    @Override
    public ILogisticsModule getLogisticsModule() {
        return new ModuleSatelite(this);
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public int getX() {
        return this.xCoord;
    }

    @Override
    public int getY() {
        return this.yCoord;
    }

    @Override
    public int getZ() {
        return this.zCoord;
    }

    @Override
    public void startWaitching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(50, this.xCoord, this.yCoord, this.zCoord, 1).getPacket());
    }

    @Override
    public void stopWaitching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(51, this.xCoord, this.yCoord, this.zCoord, 1).getPacket());
    }

    private la getRawInventory(ForgeDirection ori) {
        Position pos = new Position((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, ori);
        pos.moveForwards(1.0);
        any tile = this.worldObj.q((int)pos.x, (int)pos.y, (int)pos.z);
        if (tile instanceof TileGenericPipe) {
            return null;
        }
        if (!(tile instanceof la)) {
            return null;
        }
        return InventoryHelper.getInventory((la)tile);
    }

    private la getInventory(ForgeDirection ori) {
        la rawInventory = this.getRawInventory(ori);
        if (rawInventory instanceof ISidedInventory) {
            return new SidedInventoryAdapter((ISidedInventory)rawInventory, ori.getOpposite());
        }
        return rawInventory;
    }

    private void addToList(ItemIdentifierStack stack) {
        for (ItemIdentifierStack ident : this.itemList) {
            if (!ident.getItem().equals(stack.getItem())) continue;
            ident.stackSize += stack.stackSize;
            return;
        }
        this.itemList.addLast(stack);
    }

    private void updateInv(boolean force) {
        this.itemList.clear();
        for (ForgeDirection ori : ForgeDirection.values()) {
            la inv = this.getInventory(ori);
            if (inv == null) continue;
            for (int i = 0; i < inv.k_(); ++i) {
                if (inv.a(i) == null) continue;
                this.addToList(ItemIdentifierStack.GetFromStack(inv.a(i)));
            }
        }
        if (!this.itemList.equals(this.oldList) || force) {
            this.oldList.clear();
            this.oldList.addAll(this.itemList);
            MainProxy.sendToPlayerList(new PacketPipeInvContent(52, this.xCoord, this.yCoord, this.zCoord, this.itemList).getPacket(), this.localModeWatchers);
        }
    }

    @Override
    public void playerStartWatching(qx player, int mode) {
        if (mode == 1) {
            this.localModeWatchers.add(player);
            MainProxy.sendPacketToPlayer(new PacketPipeInteger(8, this.xCoord, this.yCoord, this.zCoord, ((BaseLogicSatellite)this.logic).satelliteId).getPacket(), (Player)player);
            this.updateInv(true);
        } else {
            super.playerStartWatching(player, mode);
        }
    }

    @Override
    public void playerStopWatching(qx player, int mode) {
        super.playerStopWatching(player, mode);
        this.localModeWatchers.remove(player);
    }

    @Override
    public void setReceivedChestContent(Collection list) {
        this.itemList.clear();
        this.itemList.addAll(list);
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }
}

