/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.upgrades;

import java.util.EnumSet;
import java.util.UUID;
import logisticspipes.LogisticsPipes;
import logisticspipes.blocks.LogisticsSecurityTileEntity;
import logisticspipes.interfaces.ISlotCheck;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.upgrades.AdvancedSatelliteUpgrade;
import logisticspipes.pipes.upgrades.ConnectionUpgrade;
import logisticspipes.pipes.upgrades.IPipeUpgrade;
import logisticspipes.pipes.upgrades.SneakyUpgrade;
import logisticspipes.pipes.upgrades.SpeedUpgrade;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.SimpleInventory;
import logisticspipes.utils.gui.DummyContainer;
import net.minecraftforge.common.ForgeDirection;

public class UpgradeManager
implements ISimpleInventoryEventHandler {
    private SimpleInventory inv = new SimpleInventory(9, "UpgradeInventory", 16);
    private IPipeUpgrade[] upgrades = new IPipeUpgrade[8];
    private CoreRoutedPipe pipe;
    private int securityDelay = 0;
    private ForgeDirection sneakyOrientation = ForgeDirection.UNKNOWN;
    private int speedUpgradeCount = 0;
    private final EnumSet disconnectedSides = EnumSet.noneOf(ForgeDirection.class);
    private boolean isAdvancedCrafter = false;

    public UpgradeManager(CoreRoutedPipe pipe) {
        this.pipe = pipe;
        this.inv.addListener(this);
    }

    public void readFromNBT(bq nbttagcompound) {
        this.inv.readFromNBT(nbttagcompound, "UpgradeInventory_");
        this.InventoryChanged(this.inv);
    }

    public void writeToNBT(bq nbttagcompound) {
        this.inv.writeToNBT(nbttagcompound, "UpgradeInventory_");
        this.InventoryChanged(this.inv);
    }

    private boolean updateModule(int slot) {
        this.upgrades[slot] = LogisticsPipes.UpgradeItem.getUpgradeForItem(this.inv.a(slot), this.upgrades[slot]);
        if (this.upgrades[slot] == null) {
            this.inv.a(slot, null);
            return false;
        }
        return this.upgrades[slot].needsUpdate();
    }

    private boolean removeUpgrade(int slot) {
        boolean needUpdate = this.upgrades[slot].needsUpdate();
        this.upgrades[slot] = null;
        return needUpdate;
    }

    @Override
    public void InventoryChanged(SimpleInventory inventory) {
        int i;
        boolean needUpdate = false;
        for (i = 0; i < this.inv.k_() - 1; ++i) {
            ur item = this.inv.a(i);
            if (item != null) {
                needUpdate |= this.updateModule(i);
                continue;
            }
            if (item != null || this.upgrades[i] == null) continue;
            needUpdate |= this.removeUpgrade(i);
        }
        this.sneakyOrientation = ForgeDirection.UNKNOWN;
        this.speedUpgradeCount = 0;
        this.isAdvancedCrafter = false;
        this.disconnectedSides.clear();
        for (i = 0; i < this.upgrades.length; ++i) {
            IPipeUpgrade upgrade = this.upgrades[i];
            if (upgrade instanceof SneakyUpgrade && this.sneakyOrientation == ForgeDirection.UNKNOWN) {
                this.sneakyOrientation = ((SneakyUpgrade)upgrade).getSneakyOrientation();
                continue;
            }
            if (upgrade instanceof SpeedUpgrade) {
                this.speedUpgradeCount += this.inv.a((int)i).a;
                continue;
            }
            if (upgrade instanceof ConnectionUpgrade) {
                this.disconnectedSides.add(((ConnectionUpgrade)upgrade).getSide());
                continue;
            }
            if (!(upgrade instanceof AdvancedSatelliteUpgrade)) continue;
            this.isAdvancedCrafter = true;
        }
        if (needUpdate) {
            this.pipe.connectionUpdate();
        }
    }

    public boolean hasSneakyUpgrade() {
        return this.sneakyOrientation != ForgeDirection.UNKNOWN;
    }

    public ForgeDirection getSneakyOrientation() {
        return this.sneakyOrientation;
    }

    public int getSpeedUpgradeCount() {
        return this.speedUpgradeCount;
    }

    public void openGui(qx entityplayer, CoreRoutedPipe pipe) {
        entityplayer.openGui((Object)LogisticsPipes.instance, 60, pipe.worldObj, pipe.xCoord, pipe.yCoord, pipe.zCoord);
    }

    public DummyContainer getDummyContainer(qx player) {
        DummyContainer dummy = new DummyContainer((la)player.bJ, this.inv);
        dummy.addNormalSlotsForPlayerInventory(8, 60);
        for (int pipeSlot = 0; pipeSlot < 8; ++pipeSlot) {
            dummy.addRestrictedSlot(pipeSlot, (la)this.inv, 8 + pipeSlot * 18, 18, new ISlotCheck(){

                @Override
                public boolean isStackAllowed(ur itemStack) {
                    if (itemStack == null) {
                        return false;
                    }
                    if (itemStack.c == LogisticsPipes.UpgradeItem.cj) {
                        return LogisticsPipes.UpgradeItem.getUpgradeForItem(itemStack, null).isAllowed(UpgradeManager.this.pipe);
                    }
                    return false;
                }
            });
        }
        dummy.addRestrictedSlot(8, (la)this.inv, 152, 18, new ISlotCheck(){

            @Override
            public boolean isStackAllowed(ur itemStack) {
                if (itemStack == null) {
                    return false;
                }
                if (itemStack.c != LogisticsPipes.LogisticsItemCard.cj) {
                    return false;
                }
                return itemStack.j() == 1;
            }
        });
        return dummy;
    }

    public void dropUpgrades(yc worldObj, int xCoord, int yCoord, int zCoord) {
        this.inv.dropContents(worldObj, xCoord, yCoord, zCoord);
    }

    public boolean isSideDisconnected(ForgeDirection side) {
        return this.disconnectedSides.contains(side);
    }

    public boolean tryIserting(yc world, qx entityplayer) {
        if (entityplayer.bS() != null && entityplayer.bS().c == LogisticsPipes.UpgradeItem.cj && LogisticsPipes.UpgradeItem.getUpgradeForItem(entityplayer.bS(), null).isAllowed(this.pipe)) {
            if (MainProxy.isClient(world)) {
                return true;
            }
            for (int i = 0; i < this.inv.k_() - 1; ++i) {
                ur item = this.inv.a(i);
                if (item == null) {
                    this.inv.a(i, entityplayer.bS().a(1));
                    this.InventoryChanged(this.inv);
                    return true;
                }
                if (item.j() != entityplayer.bS().j() || item.a >= this.inv.c()) continue;
                ++item.a;
                entityplayer.bS().a(1);
                return true;
            }
        }
        if (entityplayer.bS() != null && entityplayer.bS().c == LogisticsPipes.LogisticsItemCard.cj && entityplayer.bS().j() == 1) {
            if (MainProxy.isClient(world)) {
                return true;
            }
            if (this.inv.a(8) == null) {
                this.inv.a(8, entityplayer.bS().l());
                this.inv.a((int)8).a = 1;
                entityplayer.bS().a(1);
                return true;
            }
        }
        return false;
    }

    public UUID getSecurityID() {
        ur stack = this.inv.a(8);
        if (stack == null) {
            return null;
        }
        if (stack.c != LogisticsPipes.LogisticsItemCard.cj || stack.j() != 1) {
            return null;
        }
        if (!stack.o()) {
            return null;
        }
        if (!stack.p().b("UUID")) {
            return null;
        }
        return UUID.fromString(stack.p().i("UUID"));
    }

    public void insetSecurityID(UUID id) {
        ur stack = new ur(LogisticsPipes.LogisticsItemCard, 1, 1);
        stack.d(new bq("tag"));
        stack.p().a("UUID", id.toString());
        this.inv.a(8, stack);
    }

    public void securityTick() {
        UUID id = this.getSecurityID();
        if (id != null) {
            LogisticsSecurityTileEntity station = SimpleServiceLocator.securityStationManager.getStation(id);
            this.securityDelay = station == null ? ++this.securityDelay : 0;
            if (this.securityDelay > 20) {
                this.inv.a(8, null);
            }
        }
    }

    public boolean isAdvancedSatelliteCrafter() {
        return this.isAdvancedCrafter;
    }
}

