/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy;

import buildcraft.core.DefaultProps;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import logisticspipes.LogisticsPipes;
import logisticspipes.config.Configs;
import logisticspipes.network.packets.PacketRenderFX;
import logisticspipes.pipefxhandlers.PipeFXRenderHandler;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.interfaces.IProxy;
import logisticspipes.ticks.RoutingTableUpdateThread;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.DimensionManager;

public class MainProxy {
    @SidedProxy(clientSide="logisticspipes.proxy.side.ClientProxy", serverSide="logisticspipes.proxy.side.ServerProxy", bukkitSide="logisticspipes.proxy.side.BukkitProxy")
    public static IProxy proxy;
    private static WeakHashMap threadSideMap;

    private static Side getEffectiveSide() {
        Thread thr = Thread.currentThread();
        if (threadSideMap.containsKey(thr)) {
            return (Side)threadSideMap.get(thr);
        }
        Side side = MainProxy.getEffectiveSide(thr);
        if (threadSideMap.size() > 50) {
            threadSideMap.clear();
        }
        threadSideMap.put(thr, side);
        return side;
    }

    private static Side getEffectiveSide(Thread thr) {
        if (SimpleServiceLocator.ccProxy != null && SimpleServiceLocator.ccProxy.isLuaThread(thr)) {
            return Side.SERVER;
        }
        if (thr instanceof fy || thr instanceof hu || thr instanceof RoutingTableUpdateThread) {
            return Side.SERVER;
        }
        return Side.CLIENT;
    }

    public static boolean isClient(yc world) {
        try {
            return world.I;
        }
        catch (NullPointerException n) {
            LogisticsPipes.log.severe("isClient called with a null world - using slow thread based fallback");
            n.printStackTrace();
            return MainProxy.isClient();
        }
    }

    @Deprecated
    public static boolean isClient() {
        return MainProxy.getEffectiveSide() == Side.CLIENT;
    }

    public static boolean isServer(yc world) {
        try {
            return !world.I;
        }
        catch (NullPointerException n) {
            LogisticsPipes.log.severe("isServer called with a null world - using slow thread based fallback");
            n.printStackTrace();
            return MainProxy.isServer();
        }
    }

    @Deprecated
    public static boolean isServer() {
        return MainProxy.getEffectiveSide() == Side.SERVER;
    }

    public static yc getClientMainWorld() {
        return proxy.getWorld();
    }

    public static int getDimensionForWorld(yc world) {
        return proxy.getDimensionForWorld(world);
    }

    public static void sendPacketToServer(ef packet) {
        if (!MainProxy.isDirectSendPacket(packet)) {
            new Exception("Packet size too big").printStackTrace();
        }
        PacketDispatcher.sendPacketToServer((ef)packet);
    }

    public static void sendCompressedPacketToServer(di packet) {
        SimpleServiceLocator.clientBufferHandler.addPacketToCompressor(packet);
    }

    public static void sendPacketToPlayer(ef packet, Player player) {
        if (!MainProxy.isDirectSendPacket(packet)) {
            SimpleServiceLocator.serverBufferHandler.addPacketToCompressor((di)packet, player);
        } else {
            PacketDispatcher.sendPacketToPlayer((ef)packet, (Player)player);
        }
    }

    public static void sendCompressedPacketToPlayer(ef packet, Player player) {
        if (packet instanceof di) {
            SimpleServiceLocator.serverBufferHandler.addPacketToCompressor((di)packet, player);
        } else {
            PacketDispatcher.sendPacketToPlayer((ef)packet, (Player)player);
        }
    }

    public static void sendPacketToAllAround(double X, double Y, double Z, double range, int dimensionId, ef packet) {
        if (!MainProxy.isDirectSendPacket(packet)) {
            new Exception("Packet size too big").printStackTrace();
        }
        PacketDispatcher.sendPacketToAllAround((double)X, (double)Y, (double)Z, (double)range, (int)dimensionId, (ef)packet);
    }

    public static void sendToPlayerList(ef packet, List players) {
        if (!MainProxy.isDirectSendPacket(packet)) {
            for (qx player : players) {
                SimpleServiceLocator.serverBufferHandler.addPacketToCompressor((di)packet, (Player)player);
            }
        } else {
            for (qx player : players) {
                PacketDispatcher.sendPacketToPlayer((ef)packet, (Player)((Player)player));
            }
        }
    }

    public static void sendCompressedToPlayerList(ef packet, List players) {
        if (packet instanceof di) {
            for (qx player : players) {
                SimpleServiceLocator.serverBufferHandler.addPacketToCompressor((di)packet, (Player)player);
            }
        } else {
            for (qx player : players) {
                PacketDispatcher.sendPacketToPlayer((ef)packet, (Player)((Player)player));
            }
        }
    }

    public static void sendToAllPlayers(ef packet) {
        if (!MainProxy.isDirectSendPacket(packet)) {
            new Exception("Packet size to big").printStackTrace();
        }
        PacketDispatcher.sendPacketToAllPlayers((ef)packet);
    }

    public static void sendCompressedToAllPlayers(di packet) {
        for (in world : DimensionManager.getWorlds()) {
            for (Object playerObject : world.h) {
                Player player = (Player)playerObject;
                SimpleServiceLocator.serverBufferHandler.addPacketToCompressor(packet, player);
            }
        }
    }

    private static boolean isDirectSendPacket(ef packet) {
        if (packet instanceof di) {
            di packet250 = (di)packet;
            if (packet250.c != null && packet250.c.length > Short.MAX_VALUE && packet250.a.equals("BCLP")) {
                return false;
            }
        }
        return true;
    }

    public static List getPlayerArround(yc worldObj, int xCoord, int yCoord, int zCoord, int distance) {
        ArrayList<qx> list = new ArrayList<qx>();
        if (worldObj != null) {
            for (Object playerObject : worldObj.h) {
                qx player = (qx)playerObject;
                if (!(Math.hypot(player.t - (double)xCoord, Math.hypot(player.u - (double)yCoord, player.v - (double)zCoord)) < (double)distance)) continue;
                list.add(player);
            }
        }
        return list;
    }

    public static void sendSpawnParticlePacket(int particle, int xCoord, int yCoord, int zCoord, yc dimension, int amount) {
        if (!Configs.ENABLE_PARTICLE_FX) {
            return;
        }
        if (MainProxy.isServer(dimension)) {
            MainProxy.sendPacketToAllAround(xCoord, yCoord, zCoord, DefaultProps.NETWORK_UPDATE_RANGE, MainProxy.getDimensionForWorld(dimension), new PacketRenderFX(78, xCoord, yCoord, zCoord, particle, amount).getPacket());
        } else {
            LogisticsPipes.log.severe("Server only method on Client (Particle Spawning)");
        }
    }

    public static void spawnParticle(int particle, int xCoord, int yCoord, int zCoord, int amount) {
        if (!Configs.ENABLE_PARTICLE_FX || !Minecraft.t()) {
            return;
        }
        PipeFXRenderHandler.spawnGenericParticle(particle, xCoord, yCoord, zCoord, amount);
    }

    static {
        threadSideMap = new WeakHashMap();
    }
}

