/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.forestry;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftSilicon;
import buildcraft.BuildCraftTransport;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.core.ItemInterface;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.recipes.RecipeManagers;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import logisticspipes.LogisticsPipes;
import logisticspipes.config.Configs;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.interfaces.IForestryProxy;
import logisticspipes.utils.ItemIdentifier;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ForestryProxy
implements IForestryProxy {
    private Class tileMachine;
    private Field machine_in_TileMachine;
    private Class analyserClass;
    private Method localize;
    private up propolis;
    private up pollen;
    private LiquidStack honey;
    private final boolean has_all;

    public ForestryProxy() {
        boolean initsuccessful;
        block2: {
            initsuccessful = false;
            try {
                this.tileMachine = Class.forName("forestry.core.gadgets.TileMachine");
                this.machine_in_TileMachine = this.tileMachine.getDeclaredField("machine");
                this.machine_in_TileMachine.setAccessible(true);
                this.analyserClass = Class.forName("forestry.core.gadgets.MachineAnalyzer");
                Class<?> stringUtil = Class.forName("forestry.core.utils.StringUtil");
                this.localize = stringUtil.getDeclaredMethod("localize", String.class);
                this.localize.setAccessible(true);
                this.propolis = ItemInterface.getItem((String)"propolis").b();
                this.pollen = ItemInterface.getItem((String)"pollen").b();
                this.honey = LiquidDictionary.getLiquid((String)"honey", (int)1500);
                initsuccessful = true;
            }
            catch (Exception e) {
                if (!LogisticsPipes.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        this.has_all = initsuccessful;
    }

    @Override
    public boolean isBee(ItemIdentifier item) {
        return this.isBee(item.unsafeMakeNormalStack(1));
    }

    @Override
    public boolean isBee(ur item) {
        if (!this.has_all) {
            return false;
        }
        return BeeManager.beeInterface.isBee(item);
    }

    @Override
    public boolean isAnalysedBee(ItemIdentifier item) {
        return this.isAnalysedBee(item.unsafeMakeNormalStack(1));
    }

    @Override
    public boolean isAnalysedBee(ur item) {
        if (!this.isBee(item)) {
            return false;
        }
        return BeeManager.beeInterface.getBee(item).isAnalyzed();
    }

    @Override
    public boolean isTileAnalyser(any tile) {
        block4: {
            if (!this.has_all) {
                return false;
            }
            try {
                Object obj;
                if (this.tileMachine.isAssignableFrom(tile.getClass()) && this.analyserClass.isAssignableFrom((obj = this.machine_in_TileMachine.get(tile)).getClass())) {
                    return true;
                }
            }
            catch (Exception e) {
                if (!LogisticsPipes.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public boolean forestryEnabled() {
        return this.has_all;
    }

    @Override
    public boolean isKnownAlleleId(String allele, yc world) {
        if (!this.has_all) {
            return false;
        }
        if (!(AlleleManager.alleleRegistry.getAllele(allele) instanceof IAlleleBeeSpecies)) {
            return false;
        }
        if (!((IAlleleSpecies)AlleleManager.alleleRegistry.getAllele(allele)).isSecret()) {
            return true;
        }
        return BeeManager.breedingManager.getApiaristTracker(world, MainProxy.proxy.getClientPlayer().bR).isDiscovered((IAlleleSpecies)AlleleManager.alleleRegistry.getAllele(allele));
    }

    @Override
    public String getAlleleName(String uid) {
        if (!this.has_all) {
            return "";
        }
        if (!(AlleleManager.alleleRegistry.getAllele(uid) instanceof IAlleleSpecies)) {
            return "";
        }
        return ((IAlleleSpecies)AlleleManager.alleleRegistry.getAllele(uid)).getName();
    }

    private String getFirstValidAllele(yc world) {
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleBeeSpecies) || !this.isKnownAlleleId(allele.getUID(), world)) continue;
            return allele.getUID();
        }
        return "";
    }

    private String getLastValidAllele(yc world) {
        String uid = "";
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleBeeSpecies) || !this.isKnownAlleleId(allele.getUID(), world)) continue;
            uid = allele.getUID();
        }
        return uid;
    }

    @Override
    public String getNextAlleleId(String uid, yc world) {
        if (!this.has_all) {
            return "";
        }
        if (!(AlleleManager.alleleRegistry.getAllele(uid) instanceof IAlleleBeeSpecies)) {
            return this.getFirstValidAllele(world);
        }
        boolean next = false;
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleBeeSpecies)) continue;
            if (next && this.isKnownAlleleId(allele.getUID(), world)) {
                return allele.getUID();
            }
            if (!allele.getUID().equals(uid)) continue;
            next = true;
        }
        return "";
    }

    @Override
    public String getPrevAlleleId(String uid, yc world) {
        if (!this.has_all) {
            return "";
        }
        if (!(AlleleManager.alleleRegistry.getAllele(uid) instanceof IAlleleBeeSpecies)) {
            return this.getLastValidAllele(world);
        }
        IAllele lastAllele = null;
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleBeeSpecies)) continue;
            if (allele.getUID().equals(uid)) {
                if (lastAllele == null) {
                    return "";
                }
                return lastAllele.getUID();
            }
            if (!this.isKnownAlleleId(allele.getUID(), world)) continue;
            lastAllele = allele;
        }
        return "";
    }

    @Override
    public String getFirstAlleleId(ur bee) {
        if (!this.isBee(bee)) {
            return "";
        }
        return BeeManager.beeInterface.getBee(bee).getGenome().getPrimaryAsBee().getUID();
    }

    @Override
    public String getSecondAlleleId(ur bee) {
        if (!this.isBee(bee)) {
            return "";
        }
        return BeeManager.beeInterface.getBee(bee).getGenome().getSecondaryAsBee().getUID();
    }

    @Override
    public boolean isDrone(ur bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return BeeManager.beeInterface.isDrone(bee);
    }

    @Override
    public boolean isPrincess(ur bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        if (this.isQueen(bee)) {
            return false;
        }
        return !this.isDrone(bee);
    }

    @Override
    public boolean isQueen(ur bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return BeeManager.beeInterface.isMated(bee);
    }

    @Override
    public boolean isPurebred(ur bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return BeeManager.beeInterface.getBee(bee).isPureBred(EnumBeeChromosome.SPECIES);
    }

    @Override
    public boolean isNocturnal(ur bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return BeeManager.beeInterface.getBee(bee).getGenome().getNocturnal();
    }

    @Override
    public boolean isPureNocturnal(ur bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return BeeManager.beeInterface.getBee(bee).getGenome().getNocturnal() && BeeManager.beeInterface.getBee(bee).isPureBred(EnumBeeChromosome.NOCTURNAL);
    }

    @Override
    public boolean isFlyer(ur bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return BeeManager.beeInterface.getBee(bee).getGenome().getTolerantFlyer();
    }

    @Override
    public boolean isPureFlyer(ur bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return BeeManager.beeInterface.getBee(bee).getGenome().getTolerantFlyer() && BeeManager.beeInterface.getBee(bee).isPureBred(EnumBeeChromosome.TOLERANT_FLYER);
    }

    @Override
    public boolean isCave(ur bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return BeeManager.beeInterface.getBee(bee).getGenome().getCaveDwelling();
    }

    @Override
    public boolean isPureCave(ur bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return BeeManager.beeInterface.getBee(bee).getGenome().getCaveDwelling() && BeeManager.beeInterface.getBee(bee).isPureBred(EnumBeeChromosome.CAVE_DWELLING);
    }

    @Override
    public String getForestryTranslation(String input) {
        if (!this.has_all) {
            return input;
        }
        try {
            return (String)this.localize.invoke(null, input.toLowerCase());
        }
        catch (Exception e) {
            if (LogisticsPipes.DEBUG) {
                e.printStackTrace();
            }
            return input;
        }
    }

    @Override
    public void addCraftingRecipes() {
        if (!this.has_all) {
            return;
        }
        RecipeManagers.carpenterManager.addRecipe(25, this.honey, new ur((up)LogisticsPipes.ModuleItem, 1, 0), new ur((up)LogisticsPipes.ModuleItem, 1, 8), new Object[]{"CGC", "r r", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('G'), BuildCraftCore.ironGearItem, Character.valueOf('r'), up.aC});
        RecipeManagers.carpenterManager.addRecipe(25, this.honey, new ur((up)LogisticsPipes.ModuleItem, 1, 0), new ur((up)LogisticsPipes.ModuleItem, 1, 8), new Object[]{"CGC", "r r", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('G'), new ur(BuildCraftSilicon.redstoneChipset, 1, 1), Character.valueOf('r'), up.aC});
        RecipeManagers.carpenterManager.addRecipe(25, this.honey, new ur((up)LogisticsPipes.ModuleItem, 1, 0), new ur((up)LogisticsPipes.ModuleItem, 1, 9), new Object[]{"CrC", "r r", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('r'), up.aC});
        RecipeManagers.carpenterManager.addRecipe(25, this.honey, new ur((up)LogisticsPipes.ModuleItem, 1, 0), new ur((up)LogisticsPipes.ModuleItem, 1, 10), new Object[]{" p ", "r r", "CwC", Character.valueOf('p'), this.pollen, Character.valueOf('C'), this.propolis, Character.valueOf('w'), BuildCraftTransport.pipeItemsWood, Character.valueOf('r'), up.aC});
        RecipeManagers.carpenterManager.addRecipe(25, this.honey, new ur((up)LogisticsPipes.ModuleItem, 1, 0), new ur((up)LogisticsPipes.ModuleItem, 1, 11), new Object[]{"CGD", "r r", "DrC", Character.valueOf('C'), "dyeBlack", Character.valueOf('D'), "dyePurple", Character.valueOf('G'), this.pollen, Character.valueOf('r'), up.aC});
        RecipeManagers.carpenterManager.addRecipe(25, this.honey, new ur(LogisticsPipes.LogisticsBasicPipe, 1, 0), new ur(LogisticsPipes.LogisticsApiaristAnalyserPipe, 1, 0), new Object[]{"CGC", "r r", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('G'), BuildCraftCore.ironGearItem, Character.valueOf('r'), up.aC});
        RecipeManagers.carpenterManager.addRecipe(25, this.honey, new ur(LogisticsPipes.LogisticsBasicPipe, 1, 0), new ur(LogisticsPipes.LogisticsApiaristAnalyserPipe, 1, 0), new Object[]{"CGC", "r r", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('G'), new ur(BuildCraftSilicon.redstoneChipset, 1, 1), Character.valueOf('r'), up.aC});
        RecipeManagers.carpenterManager.addRecipe(25, this.honey, new ur(LogisticsPipes.LogisticsBasicPipe, 1, 0), new ur(LogisticsPipes.LogisticsApiaristSinkPipe, 1, 0), new Object[]{"CrC", "r r", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('r'), up.aC});
        if (Configs.MANDATORY_CARPENTER_RECIPES) {
            return;
        }
        wn.a().a(new ur((up)LogisticsPipes.ModuleItem, 1, 8), new Object[]{"CGC", "rBr", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('G'), BuildCraftCore.ironGearItem, Character.valueOf('r'), up.aC, Character.valueOf('B'), new ur((up)LogisticsPipes.ModuleItem, 1, 0)});
        wn.a().a(new ur((up)LogisticsPipes.ModuleItem, 1, 8), new Object[]{"CGC", "rBr", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('G'), new ur(BuildCraftSilicon.redstoneChipset, 1, 1), Character.valueOf('r'), up.aC, Character.valueOf('B'), new ur((up)LogisticsPipes.ModuleItem, 1, 0)});
        wn.a().a(new ur((up)LogisticsPipes.ModuleItem, 1, 9), new Object[]{"CrC", "rBr", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('r'), up.aC, Character.valueOf('B'), new ur((up)LogisticsPipes.ModuleItem, 1, 1)});
        wn.a().a(new ur((up)LogisticsPipes.ModuleItem, 1, 10), new Object[]{" p ", "rBr", "CwC", Character.valueOf('p'), this.pollen, Character.valueOf('C'), this.propolis, Character.valueOf('w'), BuildCraftTransport.pipeItemsWood, Character.valueOf('r'), up.aC, Character.valueOf('B'), new ur((up)LogisticsPipes.ModuleItem, 1, 0)});
        wn.a().b().add(new ShapedOreRecipe(new ur((up)LogisticsPipes.ModuleItem, 1, 11), new Object[]{"CGD", "rBr", "DrC", Character.valueOf('C'), "dyeBlack", Character.valueOf('D'), "dyePurple", Character.valueOf('G'), this.pollen, Character.valueOf('r'), up.aC, Character.valueOf('B'), new ur((up)LogisticsPipes.ModuleItem, 1, 0)}));
        wn.a().a(new ur(LogisticsPipes.LogisticsApiaristAnalyserPipe, 1, 0), new Object[]{"CGC", "rBr", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('G'), BuildCraftCore.ironGearItem, Character.valueOf('r'), up.aC, Character.valueOf('B'), new ur(LogisticsPipes.LogisticsBasicPipe, 1, 0)});
        wn.a().a(new ur(LogisticsPipes.LogisticsApiaristAnalyserPipe, 1, 0), new Object[]{"CGC", "rBr", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('G'), new ur(BuildCraftSilicon.redstoneChipset, 1, 1), Character.valueOf('r'), up.aC, Character.valueOf('B'), new ur(LogisticsPipes.LogisticsBasicPipe, 1, 0)});
        wn.a().a(new ur(LogisticsPipes.LogisticsApiaristSinkPipe, 1, 0), new Object[]{"CrC", "rBr", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('r'), up.aC, Character.valueOf('B'), new ur(LogisticsPipes.LogisticsBasicPipe, 1, 0)});
    }

    @Override
    public int getIconIndexForAlleleId(String uid, int phase) {
        if (!this.has_all) {
            return 0;
        }
        if (!(AlleleManager.alleleRegistry.getAllele(uid) instanceof IAlleleSpecies)) {
            return 0;
        }
        IAlleleSpecies species = (IAlleleSpecies)AlleleManager.alleleRegistry.getAllele(uid);
        int indexOffset = 0;
        if (species != null) {
            indexOffset = 16 * species.getBodyType();
        }
        if (phase == 0) {
            return indexOffset + 0 + 2;
        }
        if (phase == 1) {
            return indexOffset + 3 + 2;
        }
        return indexOffset + 6 + 2;
    }

    @Override
    public int getColorForAlleleId(String uid, int phase) {
        if (!this.has_all) {
            return 0;
        }
        if (!(AlleleManager.alleleRegistry.getAllele(uid) instanceof IAlleleSpecies)) {
            return 0;
        }
        IAlleleSpecies species = (IAlleleSpecies)AlleleManager.alleleRegistry.getAllele(uid);
        if (species != null) {
            if (phase == 0) {
                return species.getPrimaryColor();
            }
            if (phase == 1) {
                return species.getSecondaryColor();
            }
            return 0xFFFFFF;
        }
        return 0xFFFFFF;
    }

    @Override
    public int getRenderPassesForAlleleId(String uid) {
        return 3;
    }
}

