/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.side;

import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.server.FMLServerHandler;
import java.io.File;
import logisticspipes.LogisticsPipes;
import logisticspipes.blocks.LogisticsSecurityTileEntity;
import logisticspipes.blocks.LogisticsSignTileEntity;
import logisticspipes.blocks.LogisticsSolderingTileEntity;
import logisticspipes.config.Configs;
import logisticspipes.network.packets.PacketNameUpdatePacket;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.buildcraft.BuildCraftProxy;
import logisticspipes.proxy.interfaces.IProxy;
import logisticspipes.utils.ItemIdentifier;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.DimensionManager;

public class ServerProxy
implements IProxy {
    private Configuration langDatabase = new Configuration(new File("config/LogisticsPipes-LangDatabase.cfg"));
    private long saveThreadTime = 0L;

    @Override
    public String getSide() {
        return "Server";
    }

    @Override
    public yc getWorld() {
        return null;
    }

    @Override
    public void registerTileEntitis() {
        GameRegistry.registerTileEntity(LogisticsSignTileEntity.class, (String)"net.minecraft.src.buildcraft.logisticspipes.blocks.LogisticsTileEntiy");
        GameRegistry.registerTileEntity(LogisticsSignTileEntity.class, (String)"logisticspipes.blocks.LogisticsSignTileEntity");
        GameRegistry.registerTileEntity(LogisticsSolderingTileEntity.class, (String)"logisticspipes.blocks.LogisticsSolderingTileEntity");
        GameRegistry.registerTileEntity((Class)LogisticsPipes.powerTileEntity, (String)"logisticspipes.blocks.powertile.LogisticsPowerJuntionTileEntity");
        GameRegistry.registerTileEntity(LogisticsSecurityTileEntity.class, (String)"logisticspipes.blocks.LogisticsSecurityTileEntity");
        if (!Configs.LOGISTICS_TILE_GENERIC_PIPE_REPLACEMENT_DISABLED) {
            GameRegistry.registerTileEntity((Class)BuildCraftProxy.logisticsTileGenericPipe, (String)"logisticspipes.pipes.basic.LogisticsTileGenericPipe");
        }
    }

    @Override
    public qx getClientPlayer() {
        return null;
    }

    @Override
    public boolean isMainThreadRunning() {
        return FMLServerHandler.instance().getServer().m();
    }

    @Override
    public void addLogisticsPipesOverride(int index, String override1, String override2) {
    }

    @Override
    public void registerParticles() {
    }

    private String tryGetName(ItemIdentifier item) {
        String name = "???";
        try {
            name = up.e[item.itemID].l(item.unsafeMakeNormalStack(1));
            if (name == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            try {
                name = up.e[item.itemID].d(item.unsafeMakeNormalStack(1));
                if (name == null) {
                    throw new Exception();
                }
            }
            catch (Exception e1) {
                try {
                    name = up.e[item.itemID].a();
                    if (name == null) {
                        throw new Exception();
                    }
                }
                catch (Exception e2) {
                    name = "???";
                }
            }
        }
        return name;
    }

    private String getNameForCategory(String category, ItemIdentifier item) {
        String name = this.langDatabase.get((String)category, (String)"name", (String)"").value;
        if (name.equals("")) {
            this.saveLangDatabase();
            if (item.unsafeMakeNormalStack(1).f()) {
                return this.tryGetName(item);
            }
            return "LP|UNDEFINED";
        }
        return name;
    }

    private void setNameForCategory(String category, ItemIdentifier item, String newName) {
        this.langDatabase.get((String)category, (String)"name", (String)newName).value = newName;
        this.saveLangDatabase();
    }

    private void saveLangDatabase() {
        this.saveThreadTime = System.currentTimeMillis() + 30000L;
    }

    @Override
    public String getName(ItemIdentifier item) {
        String category = "";
        category = item.unsafeMakeNormalStack(1).f() ? "itemNames." + Integer.toString(item.itemID) : (item.itemDamage == 0 ? "itemNames." + Integer.toString(item.itemID) : "itemNames." + Integer.toString(item.itemID) + "." + Integer.toString(item.itemDamage));
        String name = this.getNameForCategory(category, item);
        if (name.equals("LP|UNDEFINED")) {
            if (item.itemDamage == 0) {
                return this.tryGetName(item);
            }
            category = "itemNames." + Integer.toString(item.itemID);
            name = this.getNameForCategory(category, item);
            if (name.equals("LP|UNDEFINED")) {
                return this.tryGetName(item);
            }
        }
        return name;
    }

    @Override
    public void updateNames(ItemIdentifier item, String name) {
        String category = "";
        category = item.unsafeMakeNormalStack(1).f() ? "itemNames." + Integer.toString(item.itemID) : (item.itemDamage == 0 ? "itemNames." + Integer.toString(item.itemID) : "itemNames." + Integer.toString(item.itemID) + "." + Integer.toString(item.itemDamage));
        this.setNameForCategory(category, item, name);
    }

    @Override
    public void tick() {
        if (this.saveThreadTime != 0L && this.saveThreadTime < System.currentTimeMillis()) {
            this.saveThreadTime = 0L;
            this.langDatabase.save();
            LogisticsPipes.log.info("LangDatabase saved");
        }
    }

    @Override
    public void sendNameUpdateRequest(Player player) {
        for (String category : this.langDatabase.categories.keySet()) {
            String name;
            if (!category.startsWith("itemNames.") || !(name = this.langDatabase.get((String)category, (String)"name", (String)"").value).equals("")) continue;
            String itemPart = category.substring(10);
            String metaPart = "0";
            if (itemPart.contains(".")) {
                String[] itemPartSplit = itemPart.split(".");
                itemPart = itemPartSplit[0];
                metaPart = itemPartSplit[1];
            }
            int id = Integer.valueOf(itemPart);
            int meta = Integer.valueOf(metaPart);
            SimpleServiceLocator.serverBufferHandler.addPacketToCompressor((di)new PacketNameUpdatePacket(ItemIdentifier.get(id, meta, null), "-").getPacket(), player);
        }
    }

    @Override
    public int getDimensionForWorld(yc world) {
        if (world instanceof in) {
            return ((in)world).u.h;
        }
        if (world instanceof ayp) {
            return ((ayp)world).u.h;
        }
        return world.K().j();
    }

    @Override
    public TileGenericPipe getPipeInDimensionAt(int dimension, int x, int y2, int z, qx player) {
        return ServerProxy.getPipe((yc)DimensionManager.getWorld((int)dimension), x, y2, z);
    }

    protected static TileGenericPipe getPipe(yc world, int x, int y2, int z) {
        if (world == null) {
            return null;
        }
        if (!world.f(x, y2, z)) {
            return null;
        }
        any tile = world.q(x, y2, z);
        if (!(tile instanceof TileGenericPipe)) {
            return null;
        }
        return (TileGenericPipe)tile;
    }
}

