/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialinventoryhandler;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.ItemIdentifier;
import net.minecraftforge.common.ForgeDirection;

public class BarrelInventoryHandler
extends SpecialInventoryHandler {
    private static Class barrelClass;
    private static Method getItemCount;
    private static Method setItemCount;
    private static Method getMaxSize;
    private static Field item;
    private final any _tile;
    private final boolean _hideOnePerStack;

    private BarrelInventoryHandler(any tile, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        this._tile = tile;
        this._hideOnePerStack = hideOnePerStack || hideOne;
    }

    public BarrelInventoryHandler() {
        this._tile = null;
        this._hideOnePerStack = false;
    }

    @Override
    public boolean init() {
        try {
            barrelClass = Class.forName("factorization.common.TileEntityBarrel");
            getItemCount = barrelClass.getDeclaredMethod("getItemCount", new Class[0]);
            setItemCount = barrelClass.getDeclaredMethod("setItemCount", Integer.TYPE);
            getMaxSize = barrelClass.getDeclaredMethod("getMaxSize", new Class[0]);
            item = barrelClass.getDeclaredField("item");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isType(any tile) {
        return barrelClass.isAssignableFrom(tile.getClass());
    }

    @Override
    public SpecialInventoryHandler getUtilForTile(any tile, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        return new BarrelInventoryHandler(tile, hideOnePerStack, hideOne, cropStart, cropEnd);
    }

    @Override
    public int itemCount(ItemIdentifier itemIdent) {
        try {
            ur itemStack = (ur)item.get(this._tile);
            if (itemStack != null && ItemIdentifier.get(itemStack) == itemIdent) {
                int value = (Integer)getItemCount.invoke((Object)this._tile, new Object[0]);
                return value - (this._hideOnePerStack ? 1 : 0);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    public ur getMultipleItems(ItemIdentifier itemIdent, int count) {
        try {
            ur itemStack = (ur)item.get(this._tile);
            if (itemStack != null) {
                if (ItemIdentifier.get(itemStack) != itemIdent) {
                    return null;
                }
                int value = (Integer)getItemCount.invoke((Object)this._tile, new Object[0]);
                if (value - (this._hideOnePerStack ? 1 : 0) < count) {
                    return null;
                }
                setItemCount.invoke((Object)this._tile, value - count);
                ur ret = itemStack.l();
                ret.a = count;
                return ret;
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Set getItems() {
        TreeSet<ItemIdentifier> result = new TreeSet<ItemIdentifier>();
        try {
            ur itemStack = (ur)item.get(this._tile);
            if (itemStack != null) {
                result.add(ItemIdentifier.get(itemStack));
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public HashMap getItemsAndCount() {
        HashMap<ItemIdentifier, Integer> map = new HashMap<ItemIdentifier, Integer>();
        try {
            ur itemStack = (ur)item.get(this._tile);
            if (itemStack != null) {
                int value = (Integer)getItemCount.invoke((Object)this._tile, new Object[0]);
                map.put(ItemIdentifier.get(itemStack), value - (this._hideOnePerStack ? 1 : 0));
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return map;
    }

    @Override
    public ur getSingleItem(ItemIdentifier itemIdent) {
        try {
            ur itemStack = (ur)item.get(this._tile);
            if (itemStack != null) {
                if (ItemIdentifier.get(itemStack) != itemIdent) {
                    return null;
                }
                int value = (Integer)getItemCount.invoke((Object)this._tile, new Object[0]);
                if (value > (this._hideOnePerStack ? 1 : 0)) {
                    setItemCount.invoke((Object)this._tile, value - 1);
                    ur ret = itemStack.l();
                    ret.a = 1;
                    return ret;
                }
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean containsItem(ItemIdentifier itemIdent) {
        try {
            ur itemStack = (ur)item.get(this._tile);
            if (itemStack != null) {
                return ItemIdentifier.get(itemStack) == itemIdent;
            }
            return false;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean containsUndamagedItem(ItemIdentifier itemIdent) {
        try {
            ur itemStack = (ur)item.get(this._tile);
            if (itemStack != null) {
                return ItemIdentifier.getUndamaged(itemStack) == itemIdent;
            }
            return false;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public int roomForItem(ItemIdentifier item) {
        return this.roomForItem(item, 0);
    }

    @Override
    public int roomForItem(ItemIdentifier itemIdent, int count) {
        try {
            ur itemStack = (ur)item.get(this._tile);
            int max = (Integer)getMaxSize.invoke((Object)this._tile, new Object[0]);
            if (itemStack != null) {
                if (ItemIdentifier.get(itemStack) != itemIdent) {
                    return 0;
                }
                int value = (Integer)getItemCount.invoke((Object)this._tile, new Object[0]);
                return max - value;
            }
            return max;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public ur add(ur stack, ForgeDirection from, boolean doAdd) {
        ur st = stack.l();
        st.a = 0;
        if (from != ForgeDirection.UP) {
            return st;
        }
        try {
            ur itemStack = (ur)item.get(this._tile);
            if (itemStack == null) {
                st.a = stack.a;
                if (doAdd) {
                    ur tst = stack.l();
                    if (tst.d != null && tst.d.e().equals("")) {
                        tst.d.p("tag");
                    }
                    ((la)this._tile).a(0, tst);
                }
            } else {
                if (ItemIdentifier.get(itemStack) != ItemIdentifier.get(stack)) {
                    return st;
                }
                int max = (Integer)getMaxSize.invoke((Object)this._tile, new Object[0]);
                int value = (Integer)getItemCount.invoke((Object)this._tile, new Object[0]);
                int room = max - value;
                st.a = Math.max(Math.min(room, stack.a), 0);
                if (doAdd && st.a > 0) {
                    setItemCount.invoke((Object)this._tile, value + st.a);
                }
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return st;
    }
}

