/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialinventoryhandler;

import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.ItemIdentifier;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class DSUInventoryHandler
extends SpecialInventoryHandler {
    private final IDeepStorageUnit _tile;
    private final boolean _hideOnePerStack;

    private DSUInventoryHandler(any tile, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        this._tile = (IDeepStorageUnit)tile;
        this._hideOnePerStack = hideOnePerStack || hideOne;
    }

    public DSUInventoryHandler() {
        this._tile = null;
        this._hideOnePerStack = false;
    }

    @Override
    public boolean init() {
        return true;
    }

    @Override
    public boolean isType(any tile) {
        return tile instanceof IDeepStorageUnit;
    }

    @Override
    public SpecialInventoryHandler getUtilForTile(any tile, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        return new DSUInventoryHandler(tile, hideOnePerStack, hideOne, cropStart, cropEnd);
    }

    @Override
    public int itemCount(ItemIdentifier itemIdent) {
        ur items = this._tile.getStoredItemType();
        if (items != null && ItemIdentifier.get(items) == itemIdent) {
            return items.a - (this._hideOnePerStack ? 1 : 0);
        }
        return 0;
    }

    @Override
    public ur getMultipleItems(ItemIdentifier itemIdent, int count) {
        ur items = this._tile.getStoredItemType();
        if (items == null || ItemIdentifier.get(items) != itemIdent) {
            return null;
        }
        if (this._hideOnePerStack) {
            --items.a;
        }
        if (count >= items.a) {
            this._tile.setStoredItemCount(this._hideOnePerStack ? 1 : 0);
            return items;
        }
        ur newItems = items.a(count);
        this._tile.setStoredItemCount(items.a + (this._hideOnePerStack ? 1 : 0));
        return newItems;
    }

    @Override
    public Set getItems() {
        TreeSet<ItemIdentifier> result = new TreeSet<ItemIdentifier>();
        ur items = this._tile.getStoredItemType();
        if (items != null && items.a > 0) {
            result.add(ItemIdentifier.get(items));
        }
        return result;
    }

    @Override
    public HashMap getItemsAndCount() {
        HashMap<ItemIdentifier, Integer> result = new HashMap<ItemIdentifier, Integer>();
        ur items = this._tile.getStoredItemType();
        if (items != null && items.a > 0) {
            result.put(ItemIdentifier.get(items), items.a - (this._hideOnePerStack ? 1 : 0));
        }
        return result;
    }

    @Override
    public ur getSingleItem(ItemIdentifier itemIdent) {
        return this.getMultipleItems(itemIdent, 1);
    }

    @Override
    public boolean containsItem(ItemIdentifier itemIdent) {
        ur items = this._tile.getStoredItemType();
        return items != null && ItemIdentifier.get(items) == itemIdent;
    }

    @Override
    public boolean containsUndamagedItem(ItemIdentifier itemIdent) {
        ur items = this._tile.getStoredItemType();
        return items != null && ItemIdentifier.getUndamaged(items) == itemIdent;
    }

    @Override
    public int roomForItem(ItemIdentifier item) {
        return this.roomForItem(item, 0);
    }

    @Override
    public int roomForItem(ItemIdentifier itemIdent, int count) {
        if (itemIdent.tag != null) {
            return 0;
        }
        ur items = this._tile.getStoredItemType();
        if (items == null) {
            return this._tile.getMaxStoredCount();
        }
        if (ItemIdentifier.get(items) == itemIdent) {
            return this._tile.getMaxStoredCount() - items.a;
        }
        return 0;
    }

    public ur add(ur stack, ForgeDirection from, boolean doAdd) {
        ur st = stack.l();
        st.a = 0;
        if (stack.p() != null) {
            return st;
        }
        ur items = this._tile.getStoredItemType();
        if (items == null || items.a == 0) {
            if (stack.a <= this._tile.getMaxStoredCount()) {
                this._tile.setStoredItemType(stack.c, stack.j(), stack.a);
                st.a = stack.a;
                return st;
            }
            this._tile.setStoredItemType(stack.c, stack.j(), this._tile.getMaxStoredCount());
            st.a = this._tile.getMaxStoredCount();
            return st;
        }
        if (!items.a(stack)) {
            return st;
        }
        if (stack.a <= this._tile.getMaxStoredCount() - items.a) {
            this._tile.setStoredItemCount(items.a + stack.a);
            st.a = stack.a;
            return st;
        }
        this._tile.setStoredItemCount(this._tile.getMaxStoredCount());
        st.a = this._tile.getMaxStoredCount() - items.a;
        return st;
    }
}

