/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request;

import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import logisticspipes.interfaces.routing.ILiquidProvider;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.interfaces.routing.IRequestLiquid;
import logisticspipes.logisticspipes.MessageManager;
import logisticspipes.network.packets.PacketItems;
import logisticspipes.network.packets.PacketRequestGuiContent;
import logisticspipes.network.packets.PacketRequestSubmit;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.cc.CCHelper;
import logisticspipes.request.RequestLog;
import logisticspipes.request.RequestManager;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.ServerRouter;
import logisticspipes.ticks.QueuedTasks;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.ItemMessage;
import logisticspipes.utils.LiquidIdentifier;

public class RequestHandler {
    private static int request_id = 0;

    public static void request(final iq player, final PacketRequestSubmit packet, CoreRoutedPipe pipe) {
        if (!pipe.useEnergy(5)) {
            player.a("No Energy");
            return;
        }
        RequestManager.request(ItemIdentifier.get(packet.itemID, packet.dataValue, packet.tag).makeStack(packet.amount), (IRequestItems)pipe, new RequestLog(){

            @Override
            public void handleSucessfullRequestOf(ItemMessage item) {
                LinkedList<ItemMessage> list = new LinkedList<ItemMessage>();
                list.add(new ItemMessage(packet.itemID, packet.dataValue, packet.amount, packet.tag));
                MessageManager.requested((qx)player, list);
            }

            @Override
            public void handleMissingItems(LinkedList list) {
                MessageManager.errors((qx)player, list);
            }

            @Override
            public void handleSucessfullRequestOfList(LinkedList items) {
            }
        });
    }

    public static void simulate(iq player, PacketRequestSubmit packet, CoreRoutedPipe pipe) {
        final LinkedList used = new LinkedList();
        final LinkedList missing = new LinkedList();
        RequestManager.simulate(ItemIdentifier.get(packet.itemID, packet.dataValue, packet.tag).makeStack(packet.amount), pipe, new RequestLog(){

            @Override
            public void handleSucessfullRequestOf(ItemMessage item) {
            }

            @Override
            public void handleMissingItems(LinkedList list) {
                missing.addAll(list);
            }

            @Override
            public void handleSucessfullRequestOfList(LinkedList items) {
                used.addAll(items);
            }
        });
        MessageManager.simulated(player, used, missing);
    }

    public static void refresh(iq player, CoreRoutedPipe pipe, DisplayOptions option) {
        HashMap _availableItems = option == DisplayOptions.SupplyOnly || option == DisplayOptions.Both ? SimpleServiceLocator.logisticsManager.getAvailableItems(pipe.getRouter().getIRoutersByCost()) : new HashMap();
        LinkedList _craftableItems = option == DisplayOptions.CraftOnly || option == DisplayOptions.Both ? SimpleServiceLocator.logisticsManager.getCraftableItems(pipe.getRouter().getIRoutersByCost()) : new LinkedList();
        TreeSet<ItemIdentifierStack> _allItems = new TreeSet<ItemIdentifierStack>();
        for (Map.Entry entry : _availableItems.entrySet()) {
            ItemIdentifierStack newStack = ((ItemIdentifier)entry.getKey()).makeStack((Integer)entry.getValue());
            _allItems.add(newStack);
        }
        for (ItemIdentifier itemIdentifier : _craftableItems) {
            if (_availableItems.containsKey(itemIdentifier)) continue;
            _allItems.add(itemIdentifier.makeStack(0));
        }
        MainProxy.sendPacketToPlayer(new PacketRequestGuiContent(_allItems).getPacket(), (Player)player);
    }

    public static void requestMacrolist(bq itemlist, CoreRoutedPipe requester, final qx player) {
        if (!requester.useEnergy(5)) {
            player.a("No Energy");
            return;
        }
        by list = itemlist.m("inventar");
        LinkedList<ItemIdentifierStack> transaction = new LinkedList<ItemIdentifierStack>();
        ArrayList<ItemMessage> items = new ArrayList<ItemMessage>();
        for (int i = 0; i < list.c(); ++i) {
            bq itemnbt = (bq)list.b(i);
            bq itemNBTContent = itemnbt.l("nbt");
            if (!itemnbt.b("nbt")) {
                itemNBTContent = null;
            }
            ItemIdentifierStack stack = ItemIdentifier.get(itemnbt.e("id"), itemnbt.e("data"), itemNBTContent).makeStack(itemnbt.e("amount"));
            transaction.add(stack);
            items.add(new ItemMessage(stack));
        }
        RequestManager.request(transaction, (IRequestItems)requester, new RequestLog(){

            @Override
            public void handleSucessfullRequestOfList(LinkedList items) {
                MainProxy.sendPacketToPlayer(new PacketItems((List)items, false).getPacket(), (Player)player);
            }

            @Override
            public void handleSucessfullRequestOf(ItemMessage item) {
            }

            @Override
            public void handleMissingItems(LinkedList list) {
                MainProxy.sendPacketToPlayer(new PacketItems((List)list, true).getPacket(), (Player)player);
            }
        });
    }

    public static int computerRequest(final ItemIdentifierStack makeStack, final CoreRoutedPipe pipe) {
        if (!pipe.useEnergy(15)) {
            return -1;
        }
        QueuedTasks.queueTask(new Callable(){

            public Object call() throws Exception {
                RequestManager.request(makeStack, (IRequestItems)pipe, new RequestLog(){

                    @Override
                    public void handleSucessfullRequestOf(ItemMessage item) {
                        pipe.queueEvent("request_successfull", new Object[]{request_id});
                    }

                    @Override
                    public void handleMissingItems(LinkedList list) {
                        pipe.queueEvent("request_failed", new Object[]{request_id, CCHelper.getAnswer(list)});
                    }

                    @Override
                    public void handleSucessfullRequestOfList(LinkedList items) {
                    }
                });
                return null;
            }
        });
        return ++request_id;
    }

    public static void refreshLiquid(iq player, CoreRoutedPipe pipe) {
        TreeSet _allItems = SimpleServiceLocator.logisticsLiquidManager.getAvailableLiquid(pipe.getRouter().getIRoutersByCost());
        MainProxy.sendPacketToPlayer(new PacketRequestGuiContent(_allItems).getPacket(), (Player)player);
    }

    public static void requestLiquid(final iq player, final PacketRequestSubmit packet, CoreRoutedPipe pipe, IRequestLiquid requester) {
        if (!pipe.useEnergy(10)) {
            player.a("No Energy");
            return;
        }
        BitSet routersIndex = ServerRouter.getRoutersInterestedIn(LiquidIdentifier.get(packet.itemID, packet.dataValue).getItemIdentifier());
        ArrayList<ExitRoute> validDestinations = new ArrayList<ExitRoute>();
        int i = routersIndex.nextSetBit(0);
        while (i >= 0) {
            ExitRoute e;
            IRouter r = SimpleServiceLocator.routerManager.getRouterUnsafe(i, false);
            if (r.getPipe() instanceof ILiquidProvider && (e = requester.getRouter().getDistanceTo(r)) != null) {
                validDestinations.add(e);
            }
            i = routersIndex.nextSetBit(i + 1);
        }
        RequestManager.requestLiquid(LiquidIdentifier.get(packet.itemID, packet.dataValue), packet.amount, requester, validDestinations, new RequestLog(){

            @Override
            public void handleSucessfullRequestOf(ItemMessage item) {
                LinkedList<ItemMessage> list = new LinkedList<ItemMessage>();
                list.add(new ItemMessage(packet.itemID, packet.dataValue, packet.amount, packet.tag));
                MessageManager.requested((qx)player, list);
            }

            @Override
            public void handleMissingItems(LinkedList list) {
                MessageManager.errors((qx)player, list);
            }

            @Override
            public void handleSucessfullRequestOfList(LinkedList items) {
            }
        });
    }

    public static enum DisplayOptions {
        Both,
        SupplyOnly,
        CraftOnly;

    }
}

