/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.request.RequestLog;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.utils.FinalPair;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.ItemMessage;

public class RequestTree
extends RequestTreeNode {
    private final HashMap _promisetotals = new HashMap();

    public RequestTree(ItemIdentifierStack item, IRequestItems requester, RequestTree parent) {
        super(item, requester, parent);
    }

    public int getAllPromissesFor(IProvideItems provider, ItemIdentifier item) {
        FinalPair key = new FinalPair(provider, item);
        Integer n = (Integer)this._promisetotals.get(key);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public LinkedList getExtrasFor(ItemIdentifier item) {
        HashMap extraMap = new HashMap();
        this.checkForExtras(item, extraMap);
        this.removeUsedExtras(item, extraMap);
        LinkedList extras = new LinkedList();
        for (List sublist : extraMap.values()) {
            extras.addAll(sublist);
        }
        return extras;
    }

    public void fullFillAll() {
        this.fullFill();
    }

    public void sendMissingMessage(RequestLog log) {
        LinkedList missing = new LinkedList();
        this.sendMissingMessage(missing);
        ItemMessage.compress(missing);
        log.handleMissingItems(missing);
    }

    public void sendUsedMessage(RequestLog log) {
        LinkedList used = new LinkedList();
        LinkedList missing = new LinkedList();
        this.sendUsedMessage(used, missing);
        ItemMessage.compress(used);
        ItemMessage.compress(missing);
        log.handleSucessfullRequestOfList(used);
        log.handleMissingItems(missing);
    }

    public void promiseAdded(LogisticsPromise promise) {
        FinalPair key = new FinalPair(promise.sender, promise.item);
        Integer n = (Integer)this._promisetotals.get(key);
        if (n == null) {
            this._promisetotals.put(key, promise.numberOfItems);
        } else {
            this._promisetotals.put(key, n + promise.numberOfItems);
        }
    }

    public void promiseRemoved(LogisticsPromise promise) {
        FinalPair key = new FinalPair(promise.sender, promise.item);
        int r = (Integer)this._promisetotals.get(key) - promise.numberOfItems;
        if (r == 0) {
            this._promisetotals.remove(key);
        } else {
            this._promisetotals.put(key, r);
        }
    }
}

