/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import logisticspipes.interfaces.routing.ICraftItems;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.request.CraftingTemplate;
import logisticspipes.request.RequestTree;
import logisticspipes.routing.LogisticsExtraPromise;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.ItemMessage;

public class RequestTreeNode {
    protected final IRequestItems target;
    protected final ItemIdentifierStack request;
    protected final RequestTreeNode parentNode;
    protected final RequestTree root;
    protected List subRequests = new ArrayList();
    protected List promises = new ArrayList();
    protected List extrapromises = new ArrayList();
    protected SortedSet usedCrafters = new TreeSet();
    protected CraftingTemplate lastCrafterTried = null;
    private int promiseItemCount = 0;

    public RequestTreeNode(ItemIdentifierStack item, IRequestItems requester, RequestTreeNode parentNode) {
        this.request = item;
        this.target = requester;
        this.parentNode = parentNode;
        if (parentNode != null) {
            parentNode.subRequests.add(this);
            this.root = parentNode.root;
        } else {
            this.root = (RequestTree)this;
        }
    }

    public boolean isCrafterUsed(CraftingTemplate test) {
        if (!this.usedCrafters.isEmpty() && this.usedCrafters.contains(test)) {
            return true;
        }
        if (this.parentNode == null) {
            return false;
        }
        return this.parentNode.isCrafterUsed(test);
    }

    public boolean declareCrafterUsed(CraftingTemplate test) {
        if (this.isCrafterUsed(test)) {
            return false;
        }
        this.usedCrafters.add(test);
        return true;
    }

    public int getPromiseItemCount() {
        return this.promiseItemCount;
    }

    public int getMissingItemCount() {
        return this.request.stackSize - this.promiseItemCount;
    }

    public void addPromise(LogisticsPromise promise) {
        if (promise.item != this.request.getItem()) {
            throw new IllegalArgumentException("wrong item");
        }
        if (this.getMissingItemCount() == 0) {
            throw new IllegalArgumentException("zero count needed, promises not needed.");
        }
        if (promise.numberOfItems > this.getMissingItemCount()) {
            int more = promise.numberOfItems - this.getMissingItemCount();
            promise.numberOfItems = this.getMissingItemCount();
            LogisticsExtraPromise extra = new LogisticsExtraPromise();
            extra.item = promise.item;
            extra.numberOfItems = more;
            extra.sender = promise.sender;
            extra.relayPoints = new LinkedList();
            extra.relayPoints.addAll(promise.relayPoints);
            this.extrapromises.add(extra);
        }
        if (promise.numberOfItems <= 0) {
            throw new IllegalArgumentException("zero count ... again");
        }
        this.promises.add(promise);
        this.promiseItemCount += promise.numberOfItems;
        this.root.promiseAdded(promise);
    }

    public boolean isDone() {
        return this.getMissingItemCount() <= 0;
    }

    public boolean isAllDone() {
        boolean result = this.getMissingItemCount() <= 0;
        for (RequestTreeNode node : this.subRequests) {
            result &= node.isAllDone();
        }
        return result;
    }

    public ItemIdentifierStack getStack() {
        return this.request;
    }

    public void remove(List subNodes) {
        this.subRequests.removeAll(subNodes);
        for (RequestTreeNode subnode : subNodes) {
            subnode.removeSubPromisses();
        }
    }

    protected void removeSubPromisses() {
        for (LogisticsPromise promise : this.promises) {
            this.root.promiseRemoved(promise);
        }
        for (RequestTreeNode subNode : this.subRequests) {
            subNode.removeSubPromisses();
        }
    }

    protected void checkForExtras(ItemIdentifier item, HashMap extraMap) {
        for (LogisticsExtraPromise extra : this.extrapromises) {
            if (extra.item != item) continue;
            LinkedList<LogisticsExtraPromise> extras = (LinkedList<LogisticsExtraPromise>)extraMap.get(extra.sender);
            if (extras == null) {
                extras = new LinkedList<LogisticsExtraPromise>();
                extraMap.put(extra.sender, extras);
            }
            extras.add(extra.copy());
        }
        for (RequestTreeNode subNode : this.subRequests) {
            subNode.checkForExtras(item, extraMap);
        }
    }

    protected void removeUsedExtras(ItemIdentifier item, HashMap extraMap) {
        block0: for (LogisticsPromise promise : this.promises) {
            if (promise.item != item || !(promise instanceof LogisticsExtraPromise)) continue;
            LogisticsExtraPromise epromise = (LogisticsExtraPromise)promise;
            if (epromise.provided) continue;
            int usedcount = epromise.numberOfItems;
            List extras = (List)extraMap.get(epromise.sender);
            if (extras == null) continue;
            Iterator it = extras.iterator();
            while (it.hasNext()) {
                LogisticsExtraPromise extra = (LogisticsExtraPromise)it.next();
                if (extra.numberOfItems >= usedcount) {
                    extra.numberOfItems -= usedcount;
                    usedcount = 0;
                    continue block0;
                }
                usedcount -= extra.numberOfItems;
                it.remove();
            }
        }
        for (RequestTreeNode subNode : this.subRequests) {
            subNode.removeUsedExtras(item, extraMap);
        }
    }

    protected void fullFill() {
        for (RequestTreeNode subNode : this.subRequests) {
            subNode.fullFill();
        }
        for (LogisticsPromise promise : this.promises) {
            promise.sender.fullFill(promise, this.target);
        }
        for (LogisticsPromise promise : this.extrapromises) {
            if (!(promise.sender instanceof ICraftItems)) continue;
            ((ICraftItems)promise.sender).registerExtras(promise.numberOfItems);
        }
    }

    protected void sendMissingMessage(LinkedList missing) {
        if (this.getMissingItemCount() != 0) {
            ItemIdentifierStack stack = this.getStack().clone();
            stack.stackSize = this.getMissingItemCount();
            missing.add(new ItemMessage(stack));
        }
        for (RequestTreeNode subNode : this.subRequests) {
            subNode.sendMissingMessage(missing);
        }
    }

    protected void sendUsedMessage(LinkedList used, LinkedList missing) {
        ItemIdentifierStack stack;
        int usedcount = 0;
        for (LogisticsPromise promise : this.promises) {
            if (!(promise.sender instanceof IProvideItems) || promise.sender instanceof ICraftItems) continue;
            usedcount += promise.numberOfItems;
        }
        if (usedcount != 0) {
            stack = this.getStack().clone();
            stack.stackSize = usedcount;
            used.add(new ItemMessage(stack));
        }
        if (this.getMissingItemCount() != 0) {
            stack = this.getStack().clone();
            stack.stackSize = this.getMissingItemCount();
            missing.add(new ItemMessage(stack));
        }
        for (RequestTreeNode subNode : this.subRequests) {
            subNode.sendUsedMessage(used, missing);
        }
    }
}

