/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.interfaces.routing.IRequestLiquid;
import logisticspipes.routing.LiquidLogisticsPromise;
import logisticspipes.utils.LiquidIdentifier;
import logisticspipes.utils.Pair3;

public class LogisticsLiquidOrderManager {
    private LinkedList queue = new LinkedList();

    public void add(LiquidLogisticsPromise promise, IRequestLiquid destination) {
        this.queue.addLast(new Pair3(promise.item, promise.amount, destination));
    }

    public boolean hasOrders() {
        return !this.queue.isEmpty();
    }

    public Pair3 getFirst() {
        return (Pair3)this.queue.getFirst();
    }

    public void sendAmount(int amount) {
        if (!this.hasOrders()) {
            return;
        }
        int result = (Integer)((Pair3)this.queue.getFirst()).getValue2() - amount;
        if (result <= 0) {
            this.queue.removeFirst();
        } else {
            ((Pair3)this.queue.getFirst()).setValue2((Integer)((Pair3)this.queue.getFirst()).getValue2() - amount);
        }
    }

    public void sendFailed() {
        if (!this.hasOrders()) {
            return;
        }
        ((IRequestLiquid)((Pair3)this.queue.getFirst()).getValue3()).sendFailed((LiquidIdentifier)((Pair3)this.queue.getFirst()).getValue1(), (Integer)((Pair3)this.queue.getFirst()).getValue2());
        this.queue.removeFirst();
    }

    public List getAll() {
        return Collections.unmodifiableList(this.queue);
    }
}

