/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import buildcraft.api.core.LaserKind;
import buildcraft.api.core.Position;
import buildcraft.core.EntityBlock;
import buildcraft.core.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import logisticspipes.LogisticsPipes;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IPaintPath;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.PathFinder;
import logisticspipes.routing.PipeRoutingConnectionType;
import net.minecraftforge.common.ForgeDirection;

class RouteLaser
implements IPaintPath {
    private LinkedList _lasers = new LinkedList();
    private IRouter _lastRouter;
    private LaserKind _pewpewLazors = LaserKind.Stripes;

    RouteLaser() {
    }

    public void clear() {
        for (EntityBlock b : this._lasers) {
            b.x();
            if (!MainProxy.isClient()) continue;
            ((ayp)b.p).b(b.k);
        }
        this._lasers = new LinkedList();
    }

    private void addLeg(yc worldObj, Position start, ForgeDirection o) {
        Position end = new Position(start.x, start.y, start.z, o);
        end.moveForwards(1.0);
        switch (o) {
            case WEST: 
            case DOWN: 
            case NORTH: {
                this._lasers.add(Utils.createLaser((yc)worldObj, (Position)end, (Position)start, (LaserKind)this._pewpewLazors));
                break;
            }
            default: {
                this._lasers.add(Utils.createLaser((yc)worldObj, (Position)start, (Position)end, (LaserKind)this._pewpewLazors));
            }
        }
    }

    public void displayRoute(IRouter source, Integer destination) {
        this._pewpewLazors = LaserKind.Red;
        LinkedList<Integer> routerList = new LinkedList<Integer>();
        routerList.add(destination);
        this.displayRoute(source, routerList);
        this._pewpewLazors = LaserKind.Stripes;
    }

    public void displayRoute(IRouter r) {
        LinkedList<Integer> knownRouters = new LinkedList<Integer>();
        ArrayList table = r.getRouteTable();
        for (int i = 0; i < table.size(); ++i) {
            if (table.get(i) == null || i == r.getSimpleID()) continue;
            knownRouters.add(i);
        }
        this.displayRoute(r, knownRouters);
    }

    public void displayRoute(IRouter r, LinkedList knownRouters) {
        this.clear();
        if (r == this._lastRouter) {
            this._lastRouter = null;
            return;
        }
        this._lastRouter = r;
        block0: while (!knownRouters.isEmpty()) {
            int targetRouter = (Integer)knownRouters.pop();
            ForgeDirection next = ((ExitRoute)r.getRouteTable().get((int)targetRouter)).exitOrientation;
            if (next == ForgeDirection.UNKNOWN) {
                LogisticsPipes.log.warning("BAAAD MOJO");
            }
            IRouter nextRouter = r;
            LinkedList<Integer> visited = new LinkedList<Integer>();
            while (nextRouter.getSimpleID() != targetRouter) {
                if (visited.contains(nextRouter)) {
                    LogisticsPipes.log.info("ROUTE LOOP");
                    continue block0;
                }
                visited.add(nextRouter.getSimpleID());
                LinkedList<IRouter> discovered = new LinkedList<IRouter>();
                Position firstPos = new Position((double)nextRouter.getPipe().container.l, (double)nextRouter.getPipe().container.m, (double)nextRouter.getPipe().zCoord, next);
                this.addLeg(r.getPipe().worldObj, firstPos, next);
                HashMap result = PathFinder.paintAndgetConnectedRoutingPipes(nextRouter.getPipe().container, next, 50, 100, this);
                for (CoreRoutedPipe pipe : result.keySet()) {
                    discovered.add(pipe.getRouter());
                }
                if (discovered.isEmpty()) {
                    LogisticsPipes.log.info("BAD ROUTE");
                }
                boolean ok = false;
                for (IRouter dicoveredRouter : discovered) {
                    ExitRoute source;
                    if (knownRouters.contains(dicoveredRouter)) {
                        knownRouters.remove(dicoveredRouter);
                    }
                    if ((source = (ExitRoute)dicoveredRouter.getRouteTable().get(targetRouter)) == null || !source.containsFlag(PipeRoutingConnectionType.canRouteTo)) continue;
                    ok = true;
                    nextRouter = dicoveredRouter;
                    next = ((ExitRoute)dicoveredRouter.getRouteTable().get((int)targetRouter)).exitOrientation;
                }
                if (ok) continue;
                LogisticsPipes.log.info("DEAD ROUTE");
                continue block0;
            }
        }
    }

    @Override
    public void addLaser(yc worldObj, Position start, ForgeDirection o) {
        this.addLeg(worldObj, start, o);
    }
}

