/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.logisticspipes.SidedInventoryAdapter;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.FuzzyInventoryUtil;
import logisticspipes.utils.InventoryHelper;
import logisticspipes.utils.InventoryUtil;

public class InventoryUtilFactory {
    private final List handler = new ArrayList();

    public void registerHandler(SpecialInventoryHandler invHandler) {
        if (invHandler.init()) {
            this.handler.add(invHandler);
        }
    }

    private any getTileEntityFromInventory(la inv) {
        if (inv instanceof any) {
            return (any)inv;
        }
        if (inv instanceof SidedInventoryAdapter && ((SidedInventoryAdapter)inv)._sidedInventory instanceof any) {
            return (any)((SidedInventoryAdapter)inv)._sidedInventory;
        }
        return null;
    }

    public SpecialInventoryHandler getUtilForInv(la inv, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        any tile = this.getTileEntityFromInventory(inv);
        if (tile == null) {
            return null;
        }
        for (SpecialInventoryHandler invHandler : this.handler) {
            if (!invHandler.isType(tile)) continue;
            return invHandler.getUtilForTile(tile, hideOnePerStack, hideOne, cropStart, cropEnd);
        }
        return null;
    }

    public IInventoryUtil getInventoryUtil(la inv) {
        return this.getHidingInventoryUtil(inv, false, false, 0, 0);
    }

    public IInventoryUtil getHidingInventoryUtil(la inv, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        IInventoryUtil util = this.getUtilForInv(inv, hideOnePerStack, hideOne, cropStart, cropEnd);
        if (util == null) {
            util = new InventoryUtil(InventoryHelper.getInventory(inv), hideOnePerStack, hideOne, cropStart, cropEnd);
        }
        return util;
    }

    public IInventoryUtil getFuzzyInventoryUtil(la inv) {
        return new FuzzyInventoryUtil(inv);
    }
}

