/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.ItemData;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import logisticspipes.LogisticsPipes;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.FinalNBTTagCompound;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.LiquidIdentifier;

public final class ItemIdentifier
implements Comparable {
    private static final ConcurrentHashMap _itemIdentifierIdCache = new ConcurrentHashMap(4096, 0.5f, 1);
    private static final ConcurrentHashMap _itemIdentifierTagCache = new ConcurrentHashMap(1024, 0.5f, 1);
    private static final ConcurrentHashMap _itemIdentifierCache = new ConcurrentHashMap(4096, 0.5f, 1);
    private static final ArrayList _modNameList = new ArrayList();
    private static final Map _modNameToModIdMap = new HashMap();
    private static final int[] _modItemIdMap = new int[32768];
    private static boolean init = false;
    public final int itemID;
    public final int itemDamage;
    public final FinalNBTTagCompound tag;
    public final int uniqueID;
    private ItemIdentifier _IDIgnoringNBT = null;
    private ItemIdentifier _IDIgnoringDamage = null;
    public static boolean allowNullsForTesting;

    private ItemIdentifier(int itemID, int itemDamage, FinalNBTTagCompound tag, int uniqueID) {
        this.itemID = itemID;
        this.itemDamage = itemDamage;
        this.tag = tag;
        this.uniqueID = uniqueID;
    }

    public static ItemIdentifier get(int itemID, int itemUndamagableDamage, bq tag) {
        ItemKey itemKey = new ItemKey(itemID, itemUndamagableDamage);
        if (tag == null) {
            ItemIdentifier unknownItem = (ItemIdentifier)_itemIdentifierCache.get(itemKey);
            if (unknownItem != null) {
                return unknownItem;
            }
            int id = ItemIdentifier.getUnusedId();
            unknownItem = new ItemIdentifier(itemID, itemUndamagableDamage, null, id);
            _itemIdentifierCache.put(itemKey, unknownItem);
            _itemIdentifierIdCache.put(id, unknownItem);
            return unknownItem;
        }
        ConcurrentHashMap<FinalNBTTagCompound, ItemIdentifier> itemNBTList = (ConcurrentHashMap<FinalNBTTagCompound, ItemIdentifier>)_itemIdentifierTagCache.get(itemKey);
        FinalNBTTagCompound tagwithfixedname = new FinalNBTTagCompound(tag);
        if (itemNBTList != null) {
            ItemIdentifier unknownItem = (ItemIdentifier)itemNBTList.get((Object)tagwithfixedname);
            if (unknownItem != null) {
                return unknownItem;
            }
        } else {
            itemNBTList = new ConcurrentHashMap<FinalNBTTagCompound, ItemIdentifier>(16, 0.5f, 1);
            _itemIdentifierTagCache.put(itemKey, itemNBTList);
        }
        FinalNBTTagCompound finaltag = new FinalNBTTagCompound((bq)tag.b());
        ItemIdentifier unknownItem = new ItemIdentifier(itemID, itemUndamagableDamage, finaltag, ItemIdentifier.getUnusedId());
        ItemIdentifier.checkNBTbadness(unknownItem, (cd)tag);
        itemNBTList.put(finaltag, unknownItem);
        _itemIdentifierIdCache.put(unknownItem.uniqueID, unknownItem);
        return unknownItem;
    }

    public static ItemIdentifier get(ur itemStack) {
        if (itemStack == null && allowNullsForTesting) {
            return null;
        }
        return ItemIdentifier.get(itemStack.c, itemStack.j(), itemStack.d);
    }

    public static ItemIdentifier getUndamaged(ur itemStack) {
        if (itemStack == null && allowNullsForTesting) {
            return null;
        }
        int itemDamage = 0;
        if (!up.e[itemStack.c].n()) {
            itemDamage = itemStack.j();
        }
        return ItemIdentifier.get(itemStack.c, itemDamage, itemStack.d);
    }

    public ItemIdentifier getUndamaged() {
        if (this._IDIgnoringDamage == null) {
            this._IDIgnoringDamage = !up.e[this.itemID].n() ? this : ItemIdentifier.get(this.itemID, 0, this.tag);
        }
        return this._IDIgnoringDamage;
    }

    public static ItemIdentifier getIgnoringNBT(ur itemStack) {
        return ItemIdentifier.get(itemStack.c, itemStack.j(), null);
    }

    public ItemIdentifier getIgnoringNBT() {
        if (this._IDIgnoringNBT == null) {
            this._IDIgnoringNBT = ItemIdentifier.get(this.itemID, this.itemDamage, null);
        }
        return this._IDIgnoringNBT;
    }

    public static ItemIdentifier getForId(int id) {
        return (ItemIdentifier)_itemIdentifierIdCache.get(id);
    }

    private static int getUnusedId() {
        int id = new Random().nextInt();
        while (ItemIdentifier.isIdUsed(id)) {
            id = new Random().nextInt();
        }
        return id;
    }

    private static boolean isIdUsed(int id) {
        return _itemIdentifierIdCache.containsKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick() {
        if (init) {
            return;
        }
        int[] nArray = _modItemIdMap;
        synchronized (_modItemIdMap) {
            if (init) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            init = true;
            _modNameToModIdMap.put("UNKNOWN", 0);
            _modNameList.add("UNKNOWN");
            by list = new by();
            GameData.writeItemData((by)list);
            Set set = GameData.buildWorldItemData((by)list);
            for (ItemData data : set) {
                String modname = data.getModId();
                if (modname == null) continue;
                Integer modid = (Integer)_modNameToModIdMap.get(modname);
                if (modid == null) {
                    modid = _modNameList.size();
                    _modNameList.add(modname);
                    _modNameToModIdMap.put(modname, modid);
                }
                ItemIdentifier._modItemIdMap[data.getItemId()] = modid;
            }
            _modNameList.ensureCapacity(_modNameToModIdMap.size());
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public String getDebugName() {
        if (up.e[this.itemID] != null) {
            return up.e[this.itemID].a() + "(ID: " + this.itemID + ", Damage: " + this.itemDamage + ")";
        }
        return "<item not found>";
    }

    public boolean isValid() {
        return up.e[this.itemID] != null;
    }

    private String getName(int id, ur stack) {
        String name = "???";
        try {
            name = up.e[id].l(stack);
            if (name == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            try {
                name = up.e[id].d(stack);
                if (name == null) {
                    throw new Exception();
                }
            }
            catch (Exception e1) {
                try {
                    name = up.e[id].a();
                    if (name == null) {
                        throw new Exception();
                    }
                }
                catch (Exception e2) {
                    name = "???";
                }
            }
        }
        return name;
    }

    public String getFriendlyName() {
        if (up.e[this.itemID] != null) {
            return this.getName(this.itemID, this.unsafeMakeNormalStack(1));
        }
        return "<Item name not found>";
    }

    public String getFriendlyNameCC() {
        if (up.e[this.itemID] != null) {
            return MainProxy.proxy.getName(this);
        }
        return "<Item name not found>";
    }

    public int getModId() {
        return _modItemIdMap[this.itemID];
    }

    public String getModName() {
        return (String)_modNameList.get(_modItemIdMap[this.itemID]);
    }

    public static int getModIdForName(String modname) {
        Integer m = (Integer)_modNameToModIdMap.get(modname);
        if (m == null) {
            return 0;
        }
        return m;
    }

    public ItemIdentifierStack makeStack(int stackSize) {
        return new ItemIdentifierStack(this, stackSize);
    }

    public ur unsafeMakeNormalStack(int stackSize) {
        ur stack = new ur(this.itemID, stackSize, this.itemDamage);
        stack.d((bq)this.tag);
        return stack;
    }

    public ur makeNormalStack(int stackSize) {
        ur stack = new ur(this.itemID, stackSize, this.itemDamage);
        if (this.tag != null) {
            stack.d((bq)this.tag.b());
        }
        return stack;
    }

    public int getMaxStackSize() {
        if (up.e[this.itemID].n() && this.itemDamage > 0) {
            return 1;
        }
        int limit = up.e[this.itemID].k();
        return limit < 64 ? limit : 64;
    }

    public boolean fuzzyMatch(ur stack) {
        if (stack.c != this.itemID) {
            return false;
        }
        return stack.j() == this.itemDamage;
    }

    public int getId() {
        return this.uniqueID;
    }

    public String getNBTTagCompoundName() {
        if (this.tag != null) {
            return this.tag.e();
        }
        return null;
    }

    public Map getNBTTagCompoundAsMap() {
        if (this.tag != null) {
            try {
                return this.getNBTBaseAsMap((cd)this.tag);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private Map getArrayAsMap(int[] array) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        int i = 0;
        for (int object : array) {
            map.put(i, object);
            ++i;
        }
        return map;
    }

    private Map getArrayAsMap(byte[] array) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        int i = 1;
        for (byte object : array) {
            map.put(i, object);
            ++i;
        }
        return map;
    }

    private Map getNBTBaseAsMap(cd nbt) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        if (nbt == null) {
            return null;
        }
        if (nbt instanceof bp) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", nbt.e());
            map.put("type", "NBTTagByte");
            map.put("value", ((bp)nbt).a);
            return map;
        }
        if (nbt instanceof bo) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", nbt.e());
            map.put("type", "NBTTagByteArray");
            map.put("value", this.getArrayAsMap(((bo)nbt).a));
            return map;
        }
        if (nbt instanceof bt) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", nbt.e());
            map.put("type", "NBTTagDouble");
            map.put("value", ((bt)nbt).a);
            return map;
        }
        if (nbt instanceof bv) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", nbt.e());
            map.put("type", "NBTTagFloat");
            map.put("value", Float.valueOf(((bv)nbt).a));
            return map;
        }
        if (nbt instanceof bx) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", nbt.e());
            map.put("type", "NBTTagInt");
            map.put("value", ((bx)nbt).a);
            return map;
        }
        if (nbt instanceof bw) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", nbt.e());
            map.put("type", "NBTTagIntArray");
            map.put("value", this.getArrayAsMap(((bw)nbt).a));
            return map;
        }
        if (nbt instanceof by) {
            Field fList;
            try {
                fList = by.class.getDeclaredField("tagList");
            }
            catch (Exception e) {
                fList = by.class.getDeclaredField("a");
            }
            fList.setAccessible(true);
            List internal = (List)fList.get(nbt);
            HashMap<Integer, Map> content = new HashMap<Integer, Map>();
            int i = 1;
            for (Object object : internal) {
                if (object instanceof cd) {
                    content.put(i, this.getNBTBaseAsMap((cd)object));
                }
                ++i;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", nbt.e());
            map.put("type", "NBTTagList");
            map.put("value", content);
            return map;
        }
        if (nbt instanceof bq) {
            Field fMap;
            HashMap internal = new HashMap();
            try {
                fMap = bq.class.getDeclaredField("tagMap");
            }
            catch (Exception e) {
                fMap = bq.class.getDeclaredField("a");
            }
            fMap.setAccessible(true);
            internal = (HashMap)fMap.get(nbt);
            HashMap content = new HashMap();
            HashMap keys = new HashMap();
            int i = 1;
            for (Map.Entry object : internal.entrySet()) {
                Map.Entry e = object;
                if (e.getValue() instanceof cd) {
                    content.put(e.getKey(), this.getNBTBaseAsMap((cd)e.getValue()));
                    keys.put(i, e.getKey());
                }
                ++i;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", nbt.e());
            map.put("type", "NBTTagCompound");
            map.put("value", content);
            map.put("keys", keys);
            return map;
        }
        if (nbt instanceof bz) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", nbt.e());
            map.put("type", "NBTTagLong");
            map.put("value", ((bz)nbt).a);
            return map;
        }
        if (nbt instanceof cb) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", nbt.e());
            map.put("type", "NBTTagShort");
            map.put("value", ((cb)nbt).a);
            return map;
        }
        if (nbt instanceof cc) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", nbt.e());
            map.put("type", "NBTTagString");
            map.put("value", ((cc)nbt).a);
            return map;
        }
        throw new UnsupportedOperationException("Unsupported NBTBase of type:" + nbt.getClass().getName());
    }

    public String toString() {
        return this.getModName() + "(" + this.getModId() + "):" + this.getFriendlyName();
    }

    public int compareTo(ItemIdentifier o) {
        if (this.uniqueID < o.uniqueID) {
            return -1;
        }
        if (this.uniqueID > o.uniqueID) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object that) {
        if (!(that instanceof ItemIdentifier)) {
            return false;
        }
        ItemIdentifier i = (ItemIdentifier)that;
        return this.uniqueID == i.uniqueID;
    }

    public int hashCode() {
        return this.uniqueID;
    }

    public LiquidIdentifier getLiquidIdentifier() {
        return LiquidIdentifier.get(this.itemID, this.itemDamage);
    }

    private static void checkNBTbadness(ItemIdentifier item, cd nbt) {
        if ((item.getMaxStackSize() > 1 || LogisticsPipes.DEBUG) && nbt.e() == "") {
            LogisticsPipes.log.warning("Bad item " + item.getDebugName() + " : Root NBTTag has no name");
        }
        try {
            String s = ItemIdentifier.checkNBTbadness_recurse(nbt);
            if (s != null) {
                LogisticsPipes.log.warning("Bad item " + item.getDebugName() + " : " + s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String checkNBTbadness_recurse(cd nbt) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        block8: {
            Field fMap;
            block7: {
                if (!(nbt instanceof by)) break block7;
                by l = (by)nbt;
                for (int i = 0; i < l.c(); ++i) {
                    cd b = l.b(i);
                    if (!b.e().equals("")) {
                        return "NBTTagList containing named tag " + b.e();
                    }
                    String ret = ItemIdentifier.checkNBTbadness_recurse(b);
                    if (ret == null) continue;
                    return ret;
                }
                break block8;
            }
            if (!(nbt instanceof bq)) break block8;
            try {
                fMap = bq.class.getDeclaredField("a");
            }
            catch (Exception e) {
                fMap = bq.class.getDeclaredField("tagMap");
            }
            fMap.setAccessible(true);
            Map internal = (Map)fMap.get(nbt);
            for (Map.Entry e : internal.entrySet()) {
                String k = (String)e.getKey();
                cd v = (cd)e.getValue();
                if (k == null || k.equals("")) {
                    return "NBTTagCompound containing empty key";
                }
                if (!k.equals(v.e())) {
                    return "NBTTagCompound key " + k + " doesn't match value name " + v;
                }
                String ret = ItemIdentifier.checkNBTbadness_recurse(v);
                if (ret == null) continue;
                return ret;
            }
        }
        return null;
    }

    private static class ItemKey
    implements Comparable {
        public final int itemID;
        public final int itemDamage;

        public ItemKey(int id, int d) {
            this.itemID = id;
            this.itemDamage = d;
        }

        public boolean equals(Object that) {
            if (!(that instanceof ItemKey)) {
                return false;
            }
            ItemKey i = (ItemKey)that;
            return this.itemID == i.itemID && this.itemDamage == i.itemDamage;
        }

        public int hashCode() {
            return this.itemID * 1000001 + this.itemDamage;
        }

        public int compareTo(ItemKey o) {
            if (this.itemID == o.itemID) {
                return this.itemDamage - o.itemDamage;
            }
            return this.itemID - o.itemID;
        }
    }
}

