/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.routing.ISaveState;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;

public class SimpleInventory
implements la,
ISaveState {
    private ur[] _contents;
    private final String _name;
    private final int _stackLimit;
    private final HashMap _contentsMap;
    private final HashSet _contentsUndamagedSet;
    private final LinkedList _listener = new LinkedList();

    public SimpleInventory(int size, String name, int stackLimit) {
        this._contents = new ur[size];
        this._name = name;
        this._stackLimit = stackLimit;
        this._contentsMap = new HashMap((int)((double)size * 1.5));
        this._contentsUndamagedSet = new HashSet((int)((double)size * 1.5));
    }

    public int k_() {
        return this._contents.length;
    }

    public ur a(int i) {
        return this._contents[i];
    }

    public ur a(int i, int j) {
        if (this._contents[i] == null) {
            return null;
        }
        if (this._contents[i].a > j) {
            ur ret = this._contents[i].a(j);
            this.updateContents();
            return ret;
        }
        ur ret = this._contents[i];
        this._contents[i] = null;
        this.updateContents();
        return ret;
    }

    public void a(int i, ur itemstack) {
        this._contents[i] = itemstack;
        this.updateContents();
    }

    public String b() {
        return this._name;
    }

    public int c() {
        return this._stackLimit;
    }

    public void d() {
        this.updateContents();
        for (ISimpleInventoryEventHandler handler : this._listener) {
            handler.InventoryChanged(this);
        }
    }

    public boolean a_(qx entityplayer) {
        return false;
    }

    public void l_() {
    }

    public void f() {
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        this.readFromNBT(nbttagcompound, "");
    }

    public void readFromNBT(bq nbttagcompound, String prefix) {
        by nbttaglist = nbttagcompound.m(prefix + "items");
        for (int j = 0; j < nbttaglist.c(); ++j) {
            bq nbttagcompound2 = (bq)nbttaglist.b(j);
            int index = nbttagcompound2.e("index");
            if (index < this._contents.length) {
                this._contents[index] = ur.a((bq)nbttagcompound2);
                continue;
            }
            LogisticsPipes.log.severe("SimpleInventory: java.lang.ArrayIndexOutOfBoundsException: " + index + " of " + this._contents.length);
        }
        this.updateContents();
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        this.writeToNBT(nbttagcompound, "");
    }

    public void writeToNBT(bq nbttagcompound, String prefix) {
        by nbttaglist = new by();
        for (int j = 0; j < this._contents.length; ++j) {
            if (this._contents[j] == null || this._contents[j].a <= 0) continue;
            bq nbttagcompound2 = new bq();
            nbttaglist.a((cd)nbttagcompound2);
            nbttagcompound2.a("index", j);
            this._contents[j].b(nbttagcompound2);
        }
        nbttagcompound.a(prefix + "items", (cd)nbttaglist);
        nbttagcompound.a(prefix + "itemsCount", this._contents.length);
    }

    public void dropContents(yc worldObj, int xCoord, int yCoord, int zCoord) {
        if (MainProxy.isServer(worldObj)) {
            for (int i = 0; i < this._contents.length; ++i) {
                while (this._contents[i] != null) {
                    ur todrop = this.a(i, this._contents[i].d());
                    SimpleInventory.dropItems(worldObj, todrop, xCoord, yCoord, zCoord);
                }
            }
            this.updateContents();
        }
    }

    private static void dropItems(yc world, ur stack, int i, int j, int k) {
        if (stack.a <= 0) {
            return;
        }
        float f1 = 0.7f;
        double d = (double)(world.t.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d1 = (double)(world.t.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d2 = (double)(world.t.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        px entityitem = new px(world, (double)i + d, (double)j + d1, (double)k + d2, stack);
        entityitem.b = 10;
        world.d((lq)entityitem);
    }

    public void addListener(ISimpleInventoryEventHandler listner) {
        if (!this._listener.contains(listner)) {
            this._listener.add(listner);
        }
    }

    public void removeListener(ISimpleInventoryEventHandler listner) {
        if (this._listener.contains(listner)) {
            this._listener.remove(listner);
        }
    }

    public ur a_(int i) {
        if (this._contents[i] == null) {
            return null;
        }
        ur stackToTake = this._contents[i];
        this._contents[i] = null;
        this.updateContents();
        return stackToTake;
    }

    public void handleItemIdentifierList(Collection _allItems) {
        int i = 0;
        for (ItemIdentifierStack stack : _allItems) {
            if (this._contents.length <= i) break;
            this._contents[i] = stack == null ? null : stack.unsafeMakeNormalStack();
            ++i;
        }
        this.d();
    }

    private int tryAddToSlot(int i, ur stack) {
        ItemIdentifier stackIdent;
        ur slot = this._contents[i];
        if (slot == null) {
            this._contents[i] = stack.l();
            return stack.a;
        }
        ItemIdentifier slotIdent = ItemIdentifier.get(slot);
        if (slotIdent.equals(stackIdent = ItemIdentifier.get(stack))) {
            slot.a += stack.a;
            if (slot.a > 127) {
                int ans = stack.a - (slot.a - 127);
                slot.a = 127;
                return ans;
            }
            return stack.a;
        }
        return 0;
    }

    public int addCompressed(ur stack) {
        stack = stack.l();
        for (int i = 0; i < this._contents.length && stack.a > 0; ++i) {
            int added = this.tryAddToSlot(i, stack);
            stack.a -= added;
        }
        this.d();
        return stack.a;
    }

    private void updateContents() {
        this._contentsMap.clear();
        this._contentsUndamagedSet.clear();
        for (int i = 0; i < this._contents.length; ++i) {
            ur stack = this._contents[i];
            if (stack == null) continue;
            ItemIdentifier itemId = ItemIdentifier.get(stack);
            Integer count = (Integer)this._contentsMap.get(itemId);
            if (count == null) {
                this._contentsMap.put(itemId, stack.a);
            } else {
                this._contentsMap.put(itemId, (Integer)this._contentsMap.get(itemId) + stack.a);
            }
            ItemIdentifier itemUndamagedId = ItemIdentifier.getUndamaged(stack);
            this._contentsUndamagedSet.add(itemUndamagedId);
        }
    }

    public int itemCount(ItemIdentifier item) {
        Integer i = (Integer)this._contentsMap.get(item);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public Map getItemsAndCount() {
        return this._contentsMap;
    }

    public boolean containsItem(ItemIdentifier item) {
        return this._contentsMap.containsKey(item);
    }

    public boolean containsUndamagedItem(ItemIdentifier item) {
        return this._contentsUndamagedSet.contains(item);
    }

    public boolean isEmpty() {
        return this._contentsMap.isEmpty();
    }
}

