/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.plugins.redpower;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public class ComboGenerator {
    public static ArrayList generate(int sum) {
        if (sum < 2) {
            return null;
        }
        ArrayList<LinkedList<Integer>> combos = new ArrayList<LinkedList<Integer>>();
        if (sum == 2) {
            combos.add(new LinkedList<Integer>(Arrays.asList(1, 1)));
            return combos;
        }
        int base = 1;
        while (base <= sum / 2) {
            ArrayList subcombos = ComboGenerator.generate(sum - base);
            block1: for (LinkedList combo : subcombos) {
                for (Integer i : combo) {
                    if (i < base) continue block1;
                }
                combo.addFirst(base);
                combos.add(combo);
            }
            combos.add(new LinkedList<Integer>(Arrays.asList(base, sum - base)));
            ++base;
        }
        return combos;
    }

    public static void print(ArrayList combos) {
        System.out.println("Combinations summing to: " + ComboGenerator.sum((LinkedList)combos.get(0)));
        for (LinkedList combo : combos) {
            StringBuilder line = new StringBuilder();
            boolean comma = false;
            for (Integer i : combo) {
                if (!comma) {
                    comma = true;
                } else {
                    line.append(',');
                }
                line.append(i);
            }
            System.out.println(line);
        }
    }

    public static ArrayList removeNotContaining(ArrayList combos, int required) {
        Iterator iterator = combos.iterator();
        block0: while (iterator.hasNext()) {
            LinkedList combo = (LinkedList)iterator.next();
            for (Integer i : combo) {
                if (i == required) continue block0;
            }
            iterator.remove();
        }
        return combos;
    }

    private static int sum(LinkedList combo) {
        int sum = 0;
        for (Integer i : combo) {
            sum += i.intValue();
        }
        return sum;
    }
}

