/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.plugins.redpower;

import codechicken.nei.PositionedStack;
import codechicken.nei.plugins.redpower.ComboGenerator;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.eloraam.redpower.RedPowerBase;
import com.eloraam.redpower.base.ItemHandsaw;
import com.eloraam.redpower.core.CoverLib;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;

public class MicroRecipeHandler
extends ShapedRecipeHandler {
    public static int[] covers;
    public static int[] strips;
    public static int[] corners;
    public static int[] posts;
    public static int[] hollow;
    public static ItemHandsaw[] saws;
    public static int[] materials;
    public static Random rand;

    static {
        rand = new Random();
    }

    public MicroRecipeHandler() {
        MicroRecipeHandler.load();
    }

    public static void load() {
        if (covers != null) {
            return;
        }
        int[] nArray = new int[7];
        nArray[1] = 16;
        nArray[2] = 27;
        nArray[3] = 17;
        nArray[4] = 28;
        nArray[5] = 29;
        nArray[6] = 30;
        covers = nArray;
        strips = new int[]{21, 22, 39, 23, 40, 41, 42};
        corners = new int[]{18, 19, 35, 20, 36, 37, 38};
        posts = new int[]{-1, 43, -1, 44, -1, 45, -1};
        hollow = new int[]{24, 25, 31, 26, 32, 33, 34};
        ArrayList<Integer> amaterial = new ArrayList<Integer>();
        int i = 0;
        while (i < 256) {
            if (CoverLib.getItemStack((int)i) != null) {
                amaterial.add(i);
            }
            ++i;
        }
        materials = new int[amaterial.size()];
        i = 0;
        while (i < amaterial.size()) {
            MicroRecipeHandler.materials[i] = (Integer)amaterial.get(i);
            ++i;
        }
    }

    public static PositionedStack position(ur item, int row, int col) {
        return new PositionedStack((Object)item, 25 + col * 18, 6 + row * 18);
    }

    public String getRecipeName() {
        return "Microblocks";
    }

    public void loadCraftingRecipes(ur ingred) {
        ingred = ingred.l();
        ingred.a = 1;
        if (CoverLib.getMaterial((ur)ingred) != null) {
            this.arecipes.add(new GluingRecipe(covers, ingred, -1));
            this.arecipes.add(new GluingRecipe(hollow, ingred, -1));
        } else if (ingred.c == RedPowerBase.blockMicro.cm && MicroRecipeHandler.isValidMicroType(ingred.j() >> 8)) {
            int type = ingred.j() >> 8;
            int material = ingred.j() & 0xFF;
            this.addCuttingRecipe(type, material);
            this.addGluingRecipe(type, material);
            this.addPostRecipe(type, material);
        }
    }

    private void addPostRecipe(int type, int material) {
        int thickness = MicroRecipeHandler.getThickness(type);
        int[] microclass = MicroRecipeHandler.getMicroClass(type);
        if (thickness % 2 == 0 && (microclass == posts || microclass == strips)) {
            this.arecipes.add(new PostRecipe(MicroRecipeHandler.getMicro(type, material, 1)));
        }
    }

    private void addGluingRecipe(int type, int material) {
        int thickness = MicroRecipeHandler.getThickness(type);
        int[] microclass = MicroRecipeHandler.getMicroClass(type);
        if ((microclass == covers || microclass == hollow) && thickness > 1) {
            this.arecipes.add(new GluingRecipe(MicroRecipeHandler.getMicroClass(type), MicroRecipeHandler.getMicro(type, material, 1), -1));
        }
        if (MicroRecipeHandler.thicknessPow2(thickness) && (microclass == covers || microclass == strips)) {
            int[] subclass = MicroRecipeHandler.getNextMicroClass(MicroRecipeHandler.getMicroClass(type), false);
            if (microclass == covers) {
                this.arecipes.add(new GluingRecipe(MicroRecipeHandler.getMicro(MicroRecipeHandler.getNextMicroClass(subclass, false)[thickness - 1], material, 4), MicroRecipeHandler.getMicro(type, material, 1)));
            }
            this.arecipes.add(new GluingRecipe(MicroRecipeHandler.getMicro(subclass[thickness - 1], material, 2), MicroRecipeHandler.getMicro(type, material, 1)));
        }
    }

    private void addCuttingRecipe(int type, int material) {
        int thickness = MicroRecipeHandler.getThickness(type);
        int[] microclass = MicroRecipeHandler.getMicroClass(type);
        if (microclass == covers || microclass == hollow) {
            if (thickness <= 3 || microclass == covers && thickness == 4) {
                this.arecipes.add(new CuttingRecipe(MicroRecipeHandler.getMicro(type, material, 2), MicroRecipeHandler.getMicro(MicroRecipeHandler.setThickness(type, thickness * 2), material, 1), null));
            }
        } else if (microclass == strips || microclass == corners) {
            this.arecipes.add(new CuttingRecipe(MicroRecipeHandler.getMicro(type, material, 2), MicroRecipeHandler.getMicro(MicroRecipeHandler.getNextMicroClass(microclass, true)[thickness - 1], material, 1), null));
        }
    }

    public void loadUsageRecipes(ur result) {
        result = result.l();
        result.a = 1;
        if (CoverLib.getMaterial((ur)result) != null) {
            this.arecipes.add(new CuttingRecipe(MicroRecipeHandler.getMicro(covers[3], MicroRecipeHandler.getMaterial(result), 2), result, null));
        } else if (result.b() instanceof ItemHandsaw) {
            this.addSawUsage(result);
        } else if (result.c == RedPowerBase.blockMicro.cm && MicroRecipeHandler.isValidMicroType(result.j() >> 8)) {
            int type = result.j() >> 8;
            int material = result.j() & 0xFF;
            this.addCuttingUsage(type, material);
            this.addGluingUsage(type, material);
            this.addPostUsage(type, material);
        }
    }

    private void addSawSplitting(int[] microclass, int thicknesses, ur handsaw) {
        int i = thicknesses;
        while (i >= 0) {
            this.arecipes.add(new CuttingRecipe(MicroRecipeHandler.setThickness(microclass[i], (i + 1) * 2), microclass[i], handsaw));
            --i;
        }
    }

    private void addSawCutting(int[] microclass, ur handsaw) {
        int[] superclass = MicroRecipeHandler.getNextMicroClass(microclass, true);
        int i = 6;
        while (i >= 0) {
            this.arecipes.add(new CuttingRecipe(superclass[i], microclass[i], handsaw));
            --i;
        }
    }

    private void addPostUsage(int type, int material) {
        int thickness = MicroRecipeHandler.getThickness(type);
        int[] microclass = MicroRecipeHandler.getMicroClass(type);
        if (thickness % 2 == 0 && (microclass == posts || microclass == strips)) {
            this.arecipes.add(new PostRecipe(MicroRecipeHandler.getMicro(MicroRecipeHandler.swapPostType(type), material, 1)));
        }
    }

    private void addGluingUsage(int type, int material) {
        int thickness = MicroRecipeHandler.getThickness(type);
        int[] microclass = MicroRecipeHandler.getMicroClass(type);
        if (MicroRecipeHandler.thicknessPow2(thickness) && (microclass == corners || microclass == strips)) {
            int[] superclass = MicroRecipeHandler.getNextMicroClass(microclass, true);
            if (microclass == corners) {
                this.arecipes.add(new GluingRecipe(MicroRecipeHandler.getMicro(type, material, 4), MicroRecipeHandler.getMicro(MicroRecipeHandler.getNextMicroClass(superclass, true)[thickness - 1], material, 1)));
            }
            this.arecipes.add(new GluingRecipe(MicroRecipeHandler.getMicro(type, material, 2), MicroRecipeHandler.getMicro(superclass[thickness - 1], material, 1)));
        }
        if (microclass == covers || microclass == hollow) {
            int i = thickness + 1;
            while (i <= 8) {
                this.arecipes.add(new GluingRecipe(microclass, MicroRecipeHandler.getMicro(MicroRecipeHandler.setThickness(type, i), material, 1), thickness));
                ++i;
            }
        }
    }

    private void addCuttingUsage(int type, int material) {
        int thickness = MicroRecipeHandler.getThickness(type);
        int[] microclass = MicroRecipeHandler.getMicroClass(type);
        if (thickness % 2 == 0 && (microclass == covers || microclass == hollow)) {
            this.arecipes.add(new CuttingRecipe(MicroRecipeHandler.getMicro(MicroRecipeHandler.setThickness(type, MicroRecipeHandler.getThickness(type) / 2), material, 2), MicroRecipeHandler.getMicro(type, material, 1), null));
        }
        if (microclass == covers || microclass == strips) {
            this.arecipes.add(new CuttingRecipe(MicroRecipeHandler.getMicro(MicroRecipeHandler.getNextMicroClass(microclass, false)[MicroRecipeHandler.getThickness(type) - 1], material, 2), MicroRecipeHandler.getMicro(type, material, 1), null));
        }
    }

    private void addSawUsage(ur ingredient) {
        this.addSawSplitting(covers, 3, ingredient);
        this.addSawSplitting(hollow, 2, ingredient);
        this.addSawCutting(strips, ingredient);
        this.addSawCutting(corners, ingredient);
    }

    public static int swapPostType(int type) {
        if (MicroRecipeHandler.containsInt(posts, type)) {
            return strips[MicroRecipeHandler.getThickness(type) - 1];
        }
        return posts[MicroRecipeHandler.getThickness(type) - 1];
    }

    public static boolean isValidMicroType(int type) {
        return type == 0 || type >= 16 && type <= 45;
    }

    public static int[] getNextMicroClass(int[] microclass, boolean higher) {
        if (higher) {
            if (microclass == corners) {
                return strips;
            }
            if (microclass == strips) {
                return covers;
            }
        } else {
            if (microclass == strips) {
                return corners;
            }
            if (microclass == covers) {
                return strips;
            }
        }
        return null;
    }

    public static int getMaterial(ur itemstack) {
        if (itemstack.c == CoverLib.blockCoverPlate.cm) {
            return itemstack.j() & 0xFF;
        }
        return CoverLib.getMaterial((ur)itemstack);
    }

    public static int getThickness(int type) {
        if (type == -1) {
            return 8;
        }
        return MicroRecipeHandler.getIndex(MicroRecipeHandler.getMicroClass(type), type) + 1;
    }

    public static int[] getMicroClass(int type) {
        if (MicroRecipeHandler.containsInt(covers, type)) {
            return covers;
        }
        if (MicroRecipeHandler.containsInt(strips, type)) {
            return strips;
        }
        if (MicroRecipeHandler.containsInt(corners, type)) {
            return corners;
        }
        if (MicroRecipeHandler.containsInt(hollow, type)) {
            return hollow;
        }
        return posts;
    }

    public static int setThickness(int type, int thickness) {
        if (thickness == 8) {
            return -1;
        }
        return MicroRecipeHandler.getMicroClass(type)[thickness - 1];
    }

    public static ur getMicro(int type, int material, int quantity) {
        if (type == -1) {
            ur stack = CoverLib.getItemStack((int)material);
            stack.a = quantity;
            return stack;
        }
        return new ur(CoverLib.blockCoverPlate, quantity, type << 8 | material);
    }

    public static int getType(ur itemstack) {
        if (itemstack.c == CoverLib.blockCoverPlate.cm) {
            return itemstack.j() >> 8;
        }
        return -1;
    }

    public static boolean thicknessPow2(int thickness) {
        return thickness == 1 || thickness == 2 || thickness == 4;
    }

    public static boolean containsInt(int[] array, int i) {
        return MicroRecipeHandler.getIndex(array, i) != -1;
    }

    public static int getIndex(int[] array, int i) {
        int j = 0;
        while (j < array.length) {
            if (array[j] == i) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    public class CuttingRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        ur saw;
        ur ingred;
        ur result;
        int cycletype;
        ArrayList cyclemap;

        public CuttingRecipe(ur result, ur ingred, ur saw) {
            super((TemplateRecipeHandler)MicroRecipeHandler.this);
            this.cyclemap = new ArrayList();
            this.result = result;
            this.ingred = ingred;
            this.saw = saw;
            this.cycletype = 0;
            this.mapSharpSaws();
        }

        public CuttingRecipe(int typeingred, int typeresult, ur saw) {
            super((TemplateRecipeHandler)MicroRecipeHandler.this);
            this.cyclemap = new ArrayList();
            this.result = MicroRecipeHandler.getMicro(typeingred, 0, 1);
            this.ingred = MicroRecipeHandler.getMicro(typeresult, 0, 2);
            this.saw = saw;
            this.cycletype = 1;
            this.mapSoftMaterials();
        }

        public void mapSharpSaws() {
            int i = 0;
            while (i < saws.length) {
                if (saws[i].getSharpness() >= CoverLib.getHardness((int)MicroRecipeHandler.getMaterial(this.ingred))) {
                    this.cyclemap.add(i);
                }
                ++i;
            }
        }

        public void mapSoftMaterials() {
            int i = 0;
            while (i < materials.length) {
                if (((ItemHandsaw)this.saw.b()).getSharpness() >= CoverLib.getHardness((int)materials[i])) {
                    this.cyclemap.add(i);
                }
                ++i;
            }
        }

        public ArrayList getIngredients() {
            int index = (Integer)this.cyclemap.get(MicroRecipeHandler.this.cycleticks / 20 % this.cyclemap.size());
            if (this.cycletype == 0) {
                this.saw = new ur((up)saws[index]);
            } else {
                this.ingred = MicroRecipeHandler.getMicro(MicroRecipeHandler.getType(this.ingred), materials[index], 1);
            }
            ArrayList<PositionedStack> ingreds = new ArrayList<PositionedStack>();
            int type = this.result.j() >> 8;
            if (MicroRecipeHandler.containsInt(covers, type) || MicroRecipeHandler.containsInt(hollow, type)) {
                ingreds.add(MicroRecipeHandler.position(this.saw, 0, 1));
            } else {
                ingreds.add(MicroRecipeHandler.position(this.saw, 1, 0));
            }
            ingreds.add(MicroRecipeHandler.position(this.ingred, 1, 1));
            return ingreds;
        }

        public PositionedStack getResult() {
            int index = (Integer)this.cyclemap.get(MicroRecipeHandler.this.cycleticks / 20 % this.cyclemap.size());
            if (this.cycletype == 1) {
                this.result = MicroRecipeHandler.getMicro(MicroRecipeHandler.getType(this.result), materials[index], 2);
            }
            return new PositionedStack((Object)this.result, 119, 24);
        }
    }

    public class GluingRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        ur result;
        int[] microclass;
        ArrayList gluingcombos;
        ArrayList ingreds;
        int cycletype;

        public GluingRecipe(int[] microclass, ur result, int usedthickness) {
            super((TemplateRecipeHandler)MicroRecipeHandler.this);
            this.ingreds = new ArrayList();
            this.result = result;
            this.microclass = microclass;
            this.gluingcombos = ComboGenerator.generate(MicroRecipeHandler.getThickness(MicroRecipeHandler.getType(result)));
            if (usedthickness != -1) {
                ComboGenerator.removeNotContaining(this.gluingcombos, usedthickness);
            }
            this.cycletype = 0;
        }

        public GluingRecipe(ur micro, ur result) {
            super((TemplateRecipeHandler)MicroRecipeHandler.this);
            this.ingreds = new ArrayList();
            this.result = result;
            ur microcopy = micro.l();
            microcopy.a = 1;
            int i = 0;
            while (i < micro.a) {
                int pos = i >= 2 ? i + 1 : i;
                this.ingreds.add(MicroRecipeHandler.position(microcopy, pos / 3, pos % 3));
                ++i;
            }
            this.cycletype = -1;
        }

        public ArrayList getIngredients() {
            if (this.cycletype == 0) {
                this.ingreds.clear();
                int cycle = MicroRecipeHandler.this.cycleticks / 20 % this.gluingcombos.size();
                int material = MicroRecipeHandler.getMaterial(this.result);
                LinkedList combo = (LinkedList)this.gluingcombos.get(cycle);
                this.ingreds = new ArrayList(combo.size());
                int i = 0;
                while (i < combo.size()) {
                    this.ingreds.add(MicroRecipeHandler.position(MicroRecipeHandler.getMicro(this.microclass[(Integer)combo.get(i) - 1], material, 1), i / 3, i % 3));
                    ++i;
                }
            }
            return this.ingreds;
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.result, 119, 24);
        }
    }

    public class PostRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        int type;
        int material;

        public PostRecipe(ur result) {
            super((TemplateRecipeHandler)MicroRecipeHandler.this);
            this.type = MicroRecipeHandler.getType(result);
            this.material = MicroRecipeHandler.getMaterial(result);
        }

        public ArrayList getIngredients() {
            return new ArrayList<PositionedStack>(Arrays.asList(MicroRecipeHandler.position(MicroRecipeHandler.getMicro(MicroRecipeHandler.swapPostType(this.type), this.material, 1), 1, 1)));
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)MicroRecipeHandler.getMicro(this.type, this.material, 1), 119, 24);
        }
    }
}

