/*
 * Decompiled with CFR 0.152.
 */
package net.thecondemned.LumySkinPatch;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import net.thecondemned.LumySkinPatch.FixImageUrlResult;
import net.thecondemned.LumySkinPatch.Logger;
import net.thecondemned.LumySkinPatch.MojangAPI;
import net.thecondemned.LumySkinPatch.Profile;
import net.thecondemned.LumySkinPatch.UUID;

public class Manager {
    public static FixImageUrlResult fixImageUrl(String imageUrl) {
        FixImageUrlResult ret = new FixImageUrlResult(imageUrl);
        if (imageUrl.startsWith("http://skins.minecraft.net/MinecraftSkins/") || imageUrl.startsWith("http://s3.amazonaws.com/MinecraftSkins/")) {
            try {
                String[] coll = imageUrl.split("/");
                String[] coll2 = coll[coll.length - 1].split("\\.");
                String playername = coll2[0];
                UUID u = MojangAPI.getPlayerUUID(playername);
                if (u == null) {
                    return ret;
                }
                ret.set_id(u.id);
                ret.set_name(u.name);
                Profile p = MojangAPI.getProfile(u.id);
                if (p == null) {
                    return ret;
                }
                ret.set_modelSlim(p.properties[0].valueBase64.textures.SKIN.metadata.model.equals("slim"));
                ret.set_url(p.properties[0].valueBase64.textures.SKIN.url);
                if (ret.get_url().isEmpty()) {
                    ret.set_url(imageUrl);
                }
            }
            catch (Exception ex) {
                Logger.Log("Error on getImageUrl " + imageUrl + " | " + ex.getMessage());
                ret.set_url(imageUrl);
            }
        } else if (imageUrl.startsWith("http://skins.minecraft.net/MinecraftCloaks/") || imageUrl.startsWith("http://s3.amazonaws.com/MinecraftCloaks/")) {
            try {
                String[] coll = imageUrl.split("/");
                String[] coll2 = coll[coll.length - 1].split("\\.");
                String playername = coll2[0];
                UUID u = MojangAPI.getPlayerUUID(playername);
                if (u == null) {
                    return ret;
                }
                Profile p = MojangAPI.getProfile(u.id);
                if (p == null) {
                    return ret;
                }
                ret.set_modelSlim(false);
                ret.set_url(p.properties[0].valueBase64.textures.CAPE.url);
                if (ret.get_url().isEmpty()) {
                    ret.set_url(imageUrl);
                }
            }
            catch (Exception ex) {
                Logger.Log("Error on getImageUrl " + imageUrl + " | " + ex.getMessage());
                ret.set_url(imageUrl);
            }
        }
        return ret;
    }

    public static BufferedImage fixSkin(BufferedImage image, boolean modelSlim) {
        BufferedImage ret = image;
        if (image != null && modelSlim && image.getWidth() == 64 && (image.getHeight() == 64 || image.getHeight() == 32)) {
            BufferedImage srcImg = image;
            int srcWidth = srcImg.getWidth();
            int srcHeight = srcImg.getHeight();
            BufferedImage retImage = new BufferedImage(srcWidth, srcHeight, 2);
            Graphics graphics = retImage.getGraphics();
            graphics.drawImage(srcImg, 0, 0, null);
            graphics.drawImage(srcImg, 46, 16, 51, 20, 45, 16, 51, 20, null);
            graphics.drawImage(srcImg, 50, 16, 52, 20, 48, 16, 50, 20, null);
            graphics.drawImage(srcImg, 46, 20, 55, 32, 45, 20, 54, 32, null);
            graphics.drawImage(srcImg, 54, 20, 56, 32, 52, 20, 54, 32, null);
            if (srcHeight == 64) {
                graphics.drawImage(srcImg, 46, 32, 51, 36, 45, 32, 50, 36, null);
                graphics.drawImage(srcImg, 50, 32, 52, 36, 48, 32, 50, 36, null);
                graphics.drawImage(srcImg, 46, 36, 55, 48, 45, 36, 54, 48, null);
                graphics.drawImage(srcImg, 54, 36, 56, 48, 52, 36, 54, 48, null);
                graphics.drawImage(srcImg, 38, 48, 43, 52, 37, 48, 42, 52, null);
                graphics.drawImage(srcImg, 42, 48, 44, 52, 40, 48, 42, 52, null);
                graphics.drawImage(srcImg, 38, 52, 47, 64, 37, 52, 46, 64, null);
                graphics.drawImage(srcImg, 46, 52, 48, 64, 44, 52, 46, 64, null);
                graphics.drawImage(srcImg, 54, 48, 59, 52, 53, 48, 58, 52, null);
                graphics.drawImage(srcImg, 58, 48, 60, 52, 56, 48, 58, 52, null);
                graphics.drawImage(srcImg, 54, 52, 63, 64, 53, 52, 62, 64, null);
                graphics.drawImage(srcImg, 62, 52, 64, 64, 60, 52, 62, 64, null);
            }
            graphics.dispose();
            ret = retImage;
        }
        return ret;
    }

    public static Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> getTextures(String id, String name) {
        HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture> ret = new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        try {
            UUID u;
            Profile p = null;
            if (id != null && id.trim().length() > 0) {
                p = MojangAPI.getProfile(id.trim().replace("-", ""));
            }
            if (p == null && name != null && name.trim().length() > 0 && (u = MojangAPI.getPlayerUUID(name)) != null) {
                p = MojangAPI.getProfile(u.id);
            }
            if (p == null) {
                return ret;
            }
            ret.put(MinecraftProfileTexture.Type.SKIN, new MinecraftProfileTexture(p.properties[0].valueBase64.textures.SKIN.url, p.properties[0].valueBase64.textures.SKIN.getMetadata()));
            ret.put(MinecraftProfileTexture.Type.CAPE, new MinecraftProfileTexture(p.properties[0].valueBase64.textures.CAPE.url, new HashMap<String, String>()));
        }
        catch (Exception ex) {
            Logger.Log("Error on getTextures " + id + " - " + name + " | " + ex.getMessage());
        }
        return ret;
    }
}

