/*
 * Decompiled with CFR 0.152.
 */
package denoflionsx.denLib.Config;

import denoflionsx.denLib.denLib;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Properties;

public class Config_JavaProperties {
    public static String ConfigDir;
    protected String ConfigFile = "";
    public static boolean verbose;
    public static final boolean debug = false;
    public static MODE mode;
    public Properties Options;
    public Properties Defaults;

    public Config_JavaProperties(String c) {
        if (mode.equals((Object)MODE.XML)) {
            String[] split;
            for (String s : split = c.split(".")) {
                denLib.print(s);
            }
        }
        this.ConfigFile = ConfigDir + c;
        this.Options = new Properties();
        this.Defaults = new Properties();
    }

    public String getConfigFile() {
        return this.ConfigFile;
    }

    public void setConfigDir(String dir) {
        ConfigDir = dir;
    }

    public void readFile() {
        try {
            if (mode.equals((Object)MODE.INI)) {
                this.Options.load(new FileInputStream(this.ConfigFile));
            } else if (mode.equals((Object)MODE.XML)) {
                this.Options.loadFromXML(new FileInputStream(this.ConfigFile));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getOptionInt(String key) {
        String op = this.getOption(key);
        if (op.equals("")) {
            op = "0";
        }
        return Integer.valueOf(op);
    }

    public float getOptionFloat(String key) {
        String op = this.getOption(key);
        if (op.equals("")) {
            op = "0";
        }
        return Float.valueOf(op).floatValue();
    }

    public boolean getOptionBool(String key) {
        String value = this.getOption(key);
        return denLib.toLowerCaseNoSpaces(value).equals("true");
    }

    public void setOption(String key, String param) {
        this.Options.put(key, param);
    }

    public String getOption(String key) {
        String op = "";
        if (this.Options.get(key) == null) {
            for (String s : denLib.dumpPropertiesKeys(this.Defaults)) {
                if (!s.equals(key)) continue;
                this.Options.setProperty(key, this.Defaults.getProperty(key));
            }
        }
        if (this.Options.get(key) != null) {
            op = this.Options.get(key).toString();
        }
        return op;
    }

    public String getOptionNoUpdate(String key) {
        if (this.Options.get(key) == null) {
            return null;
        }
        return this.Options.get(key).toString();
    }

    public void addDefault(String d) {
        if (d.contains("#") || d.contains("[") && d.contains("]")) {
            return;
        }
        String[] split = d.split("=");
        String key = split[0];
        String value = split[1];
        this.Defaults.setProperty(key, value);
    }

    public boolean doesConfigExist() {
        return new File(this.ConfigFile).exists();
    }

    public void writeConfig() {
        try {
            if (!this.doesConfigExist()) {
                if (mode.equals((Object)MODE.INI)) {
                    this.Defaults.store(new FileOutputStream(this.ConfigFile), null);
                } else if (mode.equals((Object)MODE.XML)) {
                    this.Defaults.storeToXML(new FileOutputStream(this.ConfigFile), null);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteConfig() {
        if (new File(this.ConfigFile).exists()) {
            new File(this.ConfigFile).delete();
        }
    }

    public ArrayList dumpValues() {
        ArrayList<String> values = new ArrayList<String>();
        for (Object o : this.Options.values()) {
            String v = o.toString();
            values.add(v);
        }
        return values;
    }

    public ArrayList dumpKeys() {
        return denLib.dumpPropertiesKeys(this.Options);
    }

    static {
        verbose = false;
        mode = MODE.INI;
    }

    public static enum MODE {
        INI,
        XML;

    }
}

