/*
 * Decompiled with CFR 0.152.
 */
package thaumicbees.bees;

import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IAlleleFlowers;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import thaumicbees.bees.AlleleEffectAuraNodeAttract;
import thaumicbees.bees.AlleleEffectAuraNodeCharge;
import thaumicbees.bees.AlleleEffectAuraNodeFlux;
import thaumicbees.bees.AlleleEffectAuraNodePurify;
import thaumicbees.bees.AlleleEffectCure;
import thaumicbees.bees.AlleleEffectPotion;
import thaumicbees.bees.AlleleEffectSpawnMob;
import thaumicbees.bees.AlleleEffectSpawnWisp;
import thaumicbees.bees.AlleleFlower;
import thaumicbees.bees.AlleleInteger;
import thaumicbees.bees.FlowerProviderAuraNode;
import thaumicbees.bees.FlowerProviderBookshelf;
import thaumicbees.bees.FlowerProviderThaumcraftFlower;
import thaumicbees.main.utils.compat.ThaumcraftHelper;

public class Allele
implements IAllele {
    public static AlleleInteger fertilityHighDominant;
    public static IAlleleFlowers flowerBookshelf;
    public static IAlleleFlowers flowerThaumcraft;
    public static IAlleleFlowers flowerAuraNode;
    @Deprecated
    public static IAlleleFlowers flowerNodePurify;
    @Deprecated
    public static IAlleleFlowers flowerNodeFluxify;
    public static AlleleEffectCure cleansingEffect;
    public static AlleleEffectPotion digSpeed;
    public static AlleleEffectPotion moveSpeed;
    public static AlleleEffectPotion slowSpeed;
    public static AlleleEffectSpawnMob spawnBrainyZombie;
    public static AlleleEffectSpawnMob spawnWisp;
    public static AlleleEffectSpawnMob spawnBats;
    public static AlleleEffectSpawnMob spawnGhast;
    public static AlleleEffectAuraNodeAttract effectNodeAttract;
    public static AlleleEffectAuraNodePurify effectNodePurify;
    public static AlleleEffectAuraNodeFlux effectNodeFlux;
    public static AlleleEffectAuraNodeCharge effectNodeCharge;
    private String uid;
    private boolean dominant;

    public static void setupAdditionalAlleles() {
        fertilityHighDominant = new AlleleInteger("fertilityHighDominant", 3, true);
        flowerBookshelf = new AlleleFlower("flowerBookshelf", new FlowerProviderBookshelf(), true);
        if (ThaumcraftHelper.isActive()) {
            flowerThaumcraft = new AlleleFlower("flowerThaumcraftPlant", new FlowerProviderThaumcraftFlower(), false);
            flowerAuraNode = new AlleleFlower("flowerAuraNode", new FlowerProviderAuraNode(), true);
            flowerNodePurify = new AlleleFlower("flowerAuraNodePurify", new FlowerProviderAuraNode(), false);
            flowerNodeFluxify = new AlleleFlower("flowerAuraNodeFlux", new FlowerProviderAuraNode(), false);
        } else {
            flowerThaumcraft = (IAlleleFlowers)Allele.getBaseAllele("flowersVanilla");
            flowerAuraNode = (IAlleleFlowers)Allele.getBaseAllele("flowersVanilla");
            flowerNodePurify = (IAlleleFlowers)Allele.getBaseAllele("flowersVanilla");
            flowerNodeFluxify = (IAlleleFlowers)Allele.getBaseAllele("flowersVanilla");
        }
        effectNodeAttract = new AlleleEffectAuraNodeAttract("effectNodeGeneration", false, 400);
        effectNodePurify = new AlleleEffectAuraNodePurify("effectNodePurify", false, 600, 150);
        effectNodeFlux = new AlleleEffectAuraNodeFlux("effectNodeFlux", true, 300, 300);
        effectNodeCharge = new AlleleEffectAuraNodeCharge("effectNodeCharge", true, 1200);
        cleansingEffect = new AlleleEffectCure("effectCurative", false);
        digSpeed = new AlleleEffectPotion("effectDigSpeed", ll.e, 15, false);
        moveSpeed = new AlleleEffectPotion("effectMoveSpeed", ll.c, 10, false);
        slowSpeed = new AlleleEffectPotion("effectSlowSpeed", ll.d, 3, false);
        spawnBrainyZombie = new AlleleEffectSpawnMob("effectBrainy", false, ThaumcraftHelper.Entity.BRAINY_ZOMBIE.entityID);
        spawnBrainyZombie.setAggrosPlayerOnSpawn().setThrottle(800).setSpawnsOnPlayerNear(null).setMaxMobsInSpawnZone(2);
        spawnBats = new AlleleEffectSpawnMob("effectBatty", false, ThaumcraftHelper.Entity.FIREBAT.entityID);
        spawnBats.setThrottle(300).setSpawnsOnPlayerNear("Bat");
        spawnWisp = new AlleleEffectSpawnWisp("effectWispy", false, ThaumcraftHelper.Entity.WISP.entityID, "thaumcraft.wisplive");
        spawnWisp.setThrottle(1800).setChanceToSpawn(79);
        spawnGhast = new AlleleEffectSpawnMob("Ghast", false, "Ghast", "mob.ghast.moan");
        spawnGhast.setThrottle(2060).setChanceToSpawn(10).setMaxMobsInSpawnZone(1);
    }

    public static IAlleleBeeSpecies getBaseSpecies(String name) {
        return (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.species" + name);
    }

    public static IAlleleBeeSpecies getExtraSpecies(String name) {
        return (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("extrabees.species." + name);
    }

    public static IAllele getBaseAllele(String name) {
        return AlleleManager.alleleRegistry.getAllele("forestry." + name);
    }

    public Allele(String id, boolean isDominant) {
        this.uid = "thaumicbees." + id;
        this.dominant = isDominant;
        AlleleManager.alleleRegistry.registerAllele((IAllele)this);
    }

    public String getUID() {
        return this.uid;
    }

    public boolean isDominant() {
        return this.dominant;
    }
}

