/*
 * Decompiled with CFR 0.152.
 */
package thaumicbees.bees;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import thaumcraft.api.AuraNode;
import thaumcraft.api.ThaumcraftApi;
import thaumicbees.bees.AlleleEffect;
import thaumicbees.bees.EffectData;

public class AlleleEffectAuraNodeAttract
extends AlleleEffect {
    private int throttle;

    public AlleleEffectAuraNodeAttract(String id, boolean isDominant, int timeout) {
        super(id, isDominant);
        this.throttle = timeout;
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData == null) {
            storedData = new EffectData(1, 0, 0);
        }
        return storedData;
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        int value = storedData.getInteger(0);
        if (value >= this.throttle) {
            float z;
            float y;
            float x;
            int nodeId;
            yc w = housing.getWorld();
            if (w.t.nextInt(10) < 1 && (nodeId = ThaumcraftApi.getClosestAuraWithinRange((yc)w, (double)(x = (float)housing.getXCoord()), (double)(y = (float)housing.getYCoord()), (double)(z = (float)housing.getZCoord()), (double)1800.0)) != -1) {
                AuraNode node = ThaumcraftApi.getNodeCopy((int)nodeId);
                if (node.level >= node.baseLevel * 4 / 5) {
                    x = (float)((double)x - node.xPos);
                    y = (float)((double)y - node.yPos);
                    z = (float)((double)z - node.zPos);
                    float distance = (float)Math.sqrt(x * x + y * y + z * z);
                    x /= distance;
                    y /= distance;
                    z /= distance;
                    ThaumcraftApi.queueNodeChanges((int)nodeId, (int)(node.baseLevel * -1 / 13), (int)w.t.nextInt(2), (boolean)false, null, (float)(x *= 0.05f), (float)(y *= 0.05f), (float)(z *= 0.05f));
                }
            }
            storedData.setInteger(0, 0);
        } else {
            storedData.setInteger(0, value + 1);
        }
        return storedData;
    }
}

