/*
 * Decompiled with CFR 0.152.
 */
package thaumicbees.bees;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import thaumcraft.api.EnumTag;
import thaumcraft.api.ThaumcraftApi;
import thaumicbees.bees.AlleleEffect;
import thaumicbees.bees.EffectData;

public class AlleleEffectAuraNodeCharge
extends AlleleEffect {
    private int effectTimeout;

    AlleleEffectAuraNodeCharge(String id, boolean dominant, int timeout) {
        super(id, dominant);
        this.effectTimeout = timeout;
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData == null) {
            storedData = new EffectData(1, 0, 0);
        }
        return storedData;
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        int timeout = storedData.getInteger(0);
        if (timeout >= this.effectTimeout) {
            EnumTag tag;
            yc world = housing.getWorld();
            int x = housing.getXCoord();
            int y = housing.getYCoord();
            int z = housing.getZCoord();
            while ((tag = EnumTag.values()[world.t.nextInt(EnumTag.values().length)]) == EnumTag.UNKNOWN || tag == EnumTag.WEATHER) {
            }
            ThaumcraftApi.increaseLowestAura((yc)world, (double)x, (double)y, (double)z, (int)1);
        } else {
            storedData.setInteger(0, timeout + 1);
        }
        return storedData;
    }
}

