/*
 * Decompiled with CFR 0.152.
 */
package thaumicbees.bees;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import thaumcraft.api.AuraNode;
import thaumcraft.api.EnumTag;
import thaumcraft.api.ObjectTags;
import thaumcraft.api.ThaumcraftApi;
import thaumicbees.bees.AlleleEffect;
import thaumicbees.bees.EffectData;
import thaumicbees.main.Config;

public class AlleleEffectAuraNodePurify
extends AlleleEffect {
    private int effectTimeout;
    private int nodeRange;

    public AlleleEffectAuraNodePurify(String id, boolean dominant, int timeout, int range) {
        super(id, dominant);
        this.effectTimeout = timeout;
        this.nodeRange = range;
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData == null) {
            storedData = new EffectData(1, 0, 0);
        }
        return storedData;
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        int timeout = storedData.getInteger(0);
        if (timeout >= this.effectTimeout) {
            EnumTag selectedTag;
            int aspectCount;
            AuraNode node;
            int z;
            int y;
            int x;
            yc world = housing.getWorld();
            int nodeId = ThaumcraftApi.getClosestAuraWithinRange((yc)world, (double)(x = housing.getXCoord()), (double)(y = housing.getYCoord()), (double)(z = housing.getZCoord()), (double)this.nodeRange);
            if (nodeId >= 0 && (node = ThaumcraftApi.getNodeCopy((int)nodeId)) != null && (aspectCount = node.flux.tags.size()) > 0 && (selectedTag = node.flux.getAspectsSorted()[world.t.nextInt(node.flux.tags.size())]) != null && housing.addProduct(new ur((up)Config.solidFlux, 1, selectedTag.id), true)) {
                node.flux.remove(selectedTag, 1);
                ThaumcraftApi.queueNodeChanges((int)node.key, (int)0, (int)0, (boolean)false, (ObjectTags)new ObjectTags().remove(selectedTag, 1), (float)0.0f, (float)0.0f, (float)0.0f);
            }
            storedData.setInteger(0, 0);
        } else {
            storedData.setInteger(0, timeout + 1);
        }
        return storedData;
    }
}

