/*
 * Decompiled with CFR 0.152.
 */
package thaumicbees.bees;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeMutation;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import thaumcraft.api.AuraNode;
import thaumcraft.api.EnumNodeType;
import thaumcraft.api.ThaumcraftApi;
import thaumicbees.bees.Allele;
import thaumicbees.bees.BeeSpecies;
import thaumicbees.main.utils.MoonPhase;
import thaumicbees.main.utils.compat.EquivalentExchangeHelper;
import thaumicbees.main.utils.compat.ExtraBeesHelper;
import thaumicbees.main.utils.compat.ThaumcraftHelper;

public class BeeMutation
implements IBeeMutation {
    private static BeeMutation Esoteric;
    private static BeeMutation Esoteric1;
    private static BeeMutation Mysterious;
    private static BeeMutation Mysterious1;
    private static BeeMutation Arcane;
    private static BeeMutation Charmed;
    private static BeeMutation Enchanted;
    private static BeeMutation Supernatural;
    private static BeeMutation Stark;
    private static BeeMutation Fire;
    private static BeeMutation Water;
    private static BeeMutation Pupil;
    private static BeeMutation Scholarly;
    private static BeeMutation Savant;
    private static BeeMutation Aware;
    private static BeeMutation Vis;
    private static BeeMutation Vis1;
    private static BeeMutation Pure;
    private static BeeMutation Flux;
    private static BeeMutation Node;
    private static BeeMutation Node1;
    private static BeeMutation Skulking;
    private static BeeMutation Brainy;
    private static BeeMutation Gossamer;
    private static BeeMutation Wispy;
    private static BeeMutation Batty;
    private static BeeMutation Ghastly;
    private static BeeMutation Timely;
    private static BeeMutation Lordly;
    private static BeeMutation Doctoral;
    private static BeeMutation Spirit;
    private static BeeMutation Spirit1;
    private static BeeMutation Soul;
    private static BeeMutation Minium;
    private static BeeMutation Iron;
    private static BeeMutation Gold;
    private static BeeMutation Copper;
    private static BeeMutation Tin;
    private static BeeMutation Silver;
    private static BeeMutation Lead;
    private static BeeMutation Diamond;
    private static BeeMutation Emerald;
    private static BeeMutation Lead1;
    private static BeeMutation Lead2;
    private static BeeMutation Beef;
    private static BeeMutation Chicken;
    private static BeeMutation Pork;
    private static BeeMutation Aura;
    private static BeeMutation Aura1;
    private IAllele parent1;
    private IAllele parent2;
    private IAllele[] mutationTemplate;
    private int baseChance;
    private boolean isSecret;
    private boolean isMoonRestricted;
    private MoonPhase moonPhaseStart;
    private MoonPhase moonPhaseEnd;
    private float moonPhaseMutationBonus;
    private boolean nodeRequired;
    private EnumNodeType nodeType;
    private double nodeRange;

    public static void setupMutations() {
        Esoteric = new BeeMutation(Allele.getBaseSpecies("Imperial"), Allele.getBaseSpecies("Demonic"), BeeSpecies.ESOTERIC, 10);
        Esoteric1 = new BeeMutation(Allele.getBaseSpecies("Heroic"), Allele.getBaseSpecies("Demonic"), BeeSpecies.ESOTERIC, 25);
        Mysterious = new BeeMutation(Allele.getBaseSpecies("Ended"), BeeSpecies.ESOTERIC, BeeSpecies.MYSTERIOUS, 15);
        Mysterious1 = new BeeMutation(Allele.getBaseSpecies("Demonic"), BeeSpecies.ESOTERIC, BeeSpecies.MYSTERIOUS, 4);
        Arcane = new BeeMutation(BeeSpecies.ESOTERIC, BeeSpecies.MYSTERIOUS, BeeSpecies.ARCANE, 8).setMoonPhaseBonus(MoonPhase.WANING_CRESCENT, MoonPhase.WAXING_CRESCENT, 1.5f);
        Charmed = new BeeMutation(Allele.getBaseSpecies("Diligent"), Allele.getBaseSpecies("Valiant"), BeeSpecies.CHARMED, 20);
        Enchanted = new BeeMutation(BeeSpecies.CHARMED, Allele.getBaseSpecies("Valiant"), BeeSpecies.ENCHANTED, 8);
        Supernatural = new BeeMutation(BeeSpecies.CHARMED, BeeSpecies.ENCHANTED, BeeSpecies.SUPERNATURAL, 10).setMoonPhaseBonus(MoonPhase.WAXING_GIBBOUS, MoonPhase.WANING_GIBBOUS, 1.5f);
        Pupil = new BeeMutation(BeeSpecies.ARCANE, BeeSpecies.ENCHANTED, BeeSpecies.PUPIL, 10);
        Stark = new BeeMutation(BeeSpecies.ARCANE, BeeSpecies.SUPERNATURAL, BeeSpecies.STARK, 8);
        Timely = new BeeMutation(Allele.getBaseSpecies("Industrious"), BeeSpecies.ENCHANTED, BeeSpecies.TIMELY, 10);
        Lordly = new BeeMutation(BeeSpecies.TIMELY, Allele.getBaseSpecies("Imperial"), BeeSpecies.LORDLY, 9);
        Doctoral = new BeeMutation(BeeSpecies.TIMELY, BeeSpecies.LORDLY, BeeSpecies.DOCTORAL, 7);
        Minium = new BeeMutation(Allele.getBaseSpecies("Sinister"), BeeSpecies.MYSTERIOUS, BeeSpecies.MINIUM, 11);
        Spirit = new BeeMutation(Allele.getBaseSpecies("Fiendish"), BeeSpecies.ENCHANTED, BeeSpecies.SPIRIT, 12);
        Spirit1 = new BeeMutation(Allele.getBaseSpecies("Fiendish"), Allele.getBaseSpecies("Ended"), BeeSpecies.SPIRIT, 20);
        Soul = new BeeMutation(Allele.getBaseSpecies("Fiendish"), BeeSpecies.SPIRIT, BeeSpecies.SOUL, 11);
        Iron = new BeeMutation(Allele.getBaseSpecies("Industrious"), Allele.getBaseSpecies("Diligent"), BeeSpecies.IRON, 10);
        BeeSpecies baseA = BeeSpecies.MINIUM.isActive() ? BeeSpecies.MINIUM : Allele.getBaseSpecies("Imperial");
        BeeSpecies baseB = BeeSpecies.LEAD.isActive() ? BeeSpecies.LEAD : BeeSpecies.IRON;
        Gold = new BeeMutation(baseA, baseB, BeeSpecies.GOLD, 8);
        if (BeeSpecies.COPPER.isActive()) {
            Copper = new BeeMutation(Allele.getBaseSpecies("Industrious"), Allele.getBaseSpecies("Meadows"), BeeSpecies.COPPER, 12);
        }
        if (BeeSpecies.TIN.isActive()) {
            Tin = new BeeMutation(Allele.getBaseSpecies("Industrious"), Allele.getBaseSpecies("Forest"), BeeSpecies.TIN, 12);
        }
        if (BeeSpecies.SILVER.isActive()) {
            Silver = new BeeMutation(Allele.getBaseSpecies("Imperial"), Allele.getBaseSpecies("Modest"), BeeSpecies.SILVER, 10);
        }
        if (BeeSpecies.LEAD.isActive()) {
            if (BeeSpecies.COPPER.isActive()) {
                Lead = new BeeMutation(Allele.getBaseSpecies("Industrious"), BeeSpecies.COPPER, BeeSpecies.LEAD, 13);
            }
            if (BeeSpecies.TIN.isActive()) {
                Lead1 = new BeeMutation(Allele.getBaseSpecies("Industrious"), BeeSpecies.TIN, BeeSpecies.LEAD, 13);
            }
            Lead2 = new BeeMutation(Allele.getBaseSpecies("Industrious"), Allele.getBaseSpecies("Common"), BeeSpecies.LEAD, 9);
        }
        Diamond = new BeeMutation(Allele.getBaseSpecies("Austere"), BeeSpecies.GOLD, BeeSpecies.DIAMOND, 6);
        baseA = BeeSpecies.SILVER.isActive() ? BeeSpecies.SILVER : Allele.getBaseSpecies("Imperial");
        Emerald = new BeeMutation(Allele.getBaseSpecies("Austere"), baseA, BeeSpecies.EMERALD, 6);
        if (BeeSpecies.BEEF.isActive()) {
            Beef = new BeeMutation(Allele.getBaseSpecies("Common"), BeeSpecies.SKULKING, BeeSpecies.BEEF, 10);
        }
        if (BeeSpecies.CHICKEN.isActive()) {
            Chicken = new BeeMutation(Allele.getBaseSpecies("Common"), BeeSpecies.SKULKING, BeeSpecies.CHICKEN, 10);
        }
        if (BeeSpecies.PORK.isActive()) {
            Pork = new BeeMutation(Allele.getBaseSpecies("Common"), BeeSpecies.SKULKING, BeeSpecies.PORK, 10);
        }
        if (ExtraBeesHelper.isActive()) {
            Skulking = new BeeMutation(BeeSpecies.MYSTERIOUS, Allele.getExtraSpecies("desolate"), BeeSpecies.SKULKING, 10);
            Ghastly = new BeeMutation(BeeSpecies.SKULKING, Allele.getExtraSpecies("creeper"), BeeSpecies.GHASTLY, 13);
        } else {
            Skulking = new BeeMutation(BeeSpecies.MYSTERIOUS, Allele.getBaseSpecies("Modest"), BeeSpecies.SKULKING, 10);
            Ghastly = new BeeMutation(BeeSpecies.SKULKING, Allele.getBaseSpecies("Austere"), BeeSpecies.GHASTLY, 13);
        }
        if (ThaumcraftHelper.isActive()) {
            Scholarly = new BeeMutation(BeeSpecies.PUPIL, BeeSpecies.ARCANE, BeeSpecies.SCHOLARLY, 8);
            Savant = new BeeMutation(BeeSpecies.PUPIL, BeeSpecies.SCHOLARLY, BeeSpecies.SAVANT, 6);
            Aware = new BeeMutation(Allele.getBaseSpecies("Demonic"), Allele.getBaseSpecies("Edenic"), BeeSpecies.AWARE, 12);
            Vis = new BeeMutation(BeeSpecies.AWARE, BeeSpecies.ARCANE, BeeSpecies.VIS, 9).setAuraNodeRequired(40.0);
            Vis1 = new BeeMutation(BeeSpecies.AWARE, BeeSpecies.STARK, BeeSpecies.VIS, 12).setAuraNodeRequired(80.0);
            Pure = new BeeMutation(BeeSpecies.VIS, Allele.getBaseSpecies("Edenic"), BeeSpecies.PURE, 7).setAuraNodeTypeRequired(5.0, EnumNodeType.PURE).setMoonPhaseBonus(MoonPhase.NEW, MoonPhase.NEW, 1.6f);
            Flux = new BeeMutation(BeeSpecies.VIS, Allele.getBaseSpecies("Edenic"), BeeSpecies.FLUX, 7).setAuraNodeTypeRequired(30.0, EnumNodeType.UNSTABLE).setMoonPhaseBonus(MoonPhase.FULL, MoonPhase.FULL, 1.6f);
            Node = new BeeMutation(BeeSpecies.PURE, BeeSpecies.FLUX, BeeSpecies.NODE, 2).setAuraNodeRequired(4.0).setMoonPhaseRestricted(MoonPhase.WANING_HALF, MoonPhase.WANING_HALF);
            Node1 = new BeeMutation(BeeSpecies.PURE, BeeSpecies.FLUX, BeeSpecies.NODE, 2).setAuraNodeRequired(4.0).setMoonPhaseRestricted(MoonPhase.WAXING_HALF, MoonPhase.WAXING_HALF);
            if (ExtraBeesHelper.isActive()) {
                Brainy = new BeeMutation(BeeSpecies.SKULKING, Allele.getExtraSpecies("rotten"), BeeSpecies.BRAINY, 12);
                Gossamer = new BeeMutation(BeeSpecies.SKULKING, Allele.getExtraSpecies("ancient"), BeeSpecies.GOSSAMER, 10);
                Batty = new BeeMutation(BeeSpecies.SKULKING, Allele.getExtraSpecies("rock"), BeeSpecies.BATTY, 14);
                Aura = new BeeMutation(BeeSpecies.VIS, Allele.getExtraSpecies("energetic"), BeeSpecies.REJUVENATING, 3);
                Aura1 = new BeeMutation(BeeSpecies.VIS, Allele.getExtraSpecies("energetic"), BeeSpecies.REJUVENATING, 3);
            } else {
                Brainy = new BeeMutation(BeeSpecies.SKULKING, Allele.getBaseSpecies("Sinister"), BeeSpecies.BRAINY, 10);
                Gossamer = new BeeMutation(BeeSpecies.SKULKING, BeeSpecies.SUPERNATURAL, BeeSpecies.GOSSAMER, 10);
                Batty = new BeeMutation(BeeSpecies.SKULKING, Allele.getBaseSpecies("Frugal"), BeeSpecies.BATTY, 11);
                Aura = new BeeMutation(BeeSpecies.VIS, Allele.getBaseSpecies("Industrious"), BeeSpecies.REJUVENATING, 3);
                Aura1 = new BeeMutation(BeeSpecies.VIS, Allele.getBaseSpecies("Industrious"), BeeSpecies.REJUVENATING, 3);
            }
            Gossamer.setMoonPhaseRestricted(MoonPhase.FULL, MoonPhase.WANING_CRESCENT);
            Wispy = new BeeMutation(BeeSpecies.GOSSAMER, Allele.getBaseSpecies("Cultivated"), BeeSpecies.WISPY, 8);
            Aura.setMoonPhaseRestricted(MoonPhase.WANING_CRESCENT, MoonPhase.WANING_CRESCENT);
            Aura1.setMoonPhaseRestricted(MoonPhase.WAXING_CRESCENT, MoonPhase.WAXING_CRESCENT);
        } else {
            Fire = new BeeMutation(BeeSpecies.STARK, Allele.getBaseSpecies("Fiendish"), BeeSpecies.FIRE, 10);
            if (ExtraBeesHelper.isActive()) {
                Water = new BeeMutation(BeeSpecies.STARK, Allele.getExtraSpecies("ocean"), BeeSpecies.WATER, 12);
                Water = new BeeMutation(BeeSpecies.STARK, Allele.getExtraSpecies("river"), BeeSpecies.WATER, 8);
            } else {
                Water = new BeeMutation(BeeSpecies.STARK, Allele.getBaseSpecies("Marshy"), BeeSpecies.WATER, 10);
            }
        }
        if (EquivalentExchangeHelper.isActive()) {
            Minium = new BeeMutation(Allele.getBaseSpecies("Frugal"), BeeSpecies.PUPIL, BeeSpecies.MINIUM, 10);
        }
    }

    public BeeMutation(IAlleleBeeSpecies species0, IAlleleBeeSpecies species1, BeeSpecies resultSpecies, int percentChance) {
        this.parent1 = species0;
        this.parent2 = species1;
        this.mutationTemplate = resultSpecies.getGenome();
        this.baseChance = percentChance;
        this.isSecret = false;
        this.isMoonRestricted = false;
        this.moonPhaseMutationBonus = -1.0f;
        this.nodeType = null;
        BeeManager.breedingManager.registerBeeMutation((IBeeMutation)this);
    }

    public int getChance(IBeeHousing housing, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        int finalChance = 0;
        float chance = (float)this.baseChance * 1.0f;
        if (this.arePartners(allele0, allele1)) {
            if (this.moonPhaseStart != null && this.moonPhaseEnd != null) {
                if (this.isMoonRestricted && !MoonPhase.getMoonPhase(housing.getWorld()).isBetween(this.moonPhaseStart, this.moonPhaseEnd)) {
                    chance = 0.0f;
                } else if (this.moonPhaseMutationBonus != -1.0f && MoonPhase.getMoonPhase(housing.getWorld()).isBetween(this.moonPhaseStart, this.moonPhaseEnd)) {
                    chance = (int)(chance * this.moonPhaseMutationBonus);
                }
            }
            if (this.nodeRequired) {
                int nodeId = ThaumcraftApi.getClosestAuraWithinRange((yc)housing.getWorld(), (double)housing.getXCoord(), (double)housing.getYCoord(), (double)housing.getZCoord(), (double)this.nodeRange);
                if (nodeId >= 0) {
                    if (this.nodeType != null) {
                        AuraNode node = ThaumcraftApi.getNodeCopy((int)nodeId);
                        if (node.type != this.nodeType) {
                            chance = 0.0f;
                        }
                    }
                } else {
                    chance = 0.0f;
                }
            }
            finalChance = Math.round(chance * housing.getMutationModifier((IBeeGenome)genome0, (IBeeGenome)genome1) * BeeManager.breedingManager.getBeekeepingMode(housing.getWorld()).getMutationModifier((IBeeGenome)genome0, (IBeeGenome)genome1));
        }
        return finalChance;
    }

    public IAllele getAllele0() {
        return this.parent1;
    }

    public IAllele getAllele1() {
        return this.parent2;
    }

    public IAllele[] getTemplate() {
        return this.mutationTemplate;
    }

    public int getBaseChance() {
        return this.baseChance;
    }

    public boolean isPartner(IAllele allele) {
        return this.parent1.getUID().equals(allele.getUID()) || this.parent2.getUID().equals(allele.getUID());
    }

    public IAllele getPartner(IAllele allele) {
        IAllele val = this.parent1;
        if (val.getUID().equals(allele.getUID())) {
            val = this.parent2;
        }
        return val;
    }

    public boolean arePartners(IAllele alleleA, IAllele alleleB) {
        return this.parent1.getUID().equals(alleleA.getUID()) && this.parent2.getUID().equals(alleleB.getUID()) || this.parent1.getUID().equals(alleleB.getUID()) && this.parent2.getUID().equals(alleleA.getUID());
    }

    public BeeMutation setSecret() {
        this.isSecret = true;
        return this;
    }

    public boolean isSecret() {
        return this.isSecret;
    }

    public BeeMutation setMoonPhaseRestricted(MoonPhase begin, MoonPhase end) {
        this.isMoonRestricted = true;
        this.moonPhaseStart = begin;
        this.moonPhaseEnd = end;
        return this;
    }

    public BeeMutation setMoonPhaseBonus(MoonPhase begin, MoonPhase end, float mutationBonus) {
        this.moonPhaseMutationBonus = mutationBonus;
        this.moonPhaseStart = begin;
        this.moonPhaseEnd = end;
        return this;
    }

    public BeeMutation setAuraNodeRequired(double range) {
        this.nodeRequired = true;
        this.nodeRange = range;
        return this;
    }

    public BeeMutation setAuraNodeTypeRequired(double range, EnumNodeType type) {
        this.nodeType = type;
        return this.setAuraNodeRequired(range);
    }
}

