/*
 * Decompiled with CFR 0.152.
 */
package thaumicbees.main;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import forestry.api.core.ItemInterface;
import thaumicbees.bees.Allele;
import thaumicbees.bees.BeeMutation;
import thaumicbees.bees.BeeSpecies;
import thaumicbees.main.CommonProxy;
import thaumicbees.main.Config;
import thaumicbees.main.utils.CompatabilityManager;
import thaumicbees.main.utils.CraftingManager;
import thaumicbees.main.utils.LocalizationManager;
import thaumicbees.main.utils.VersionInfo;
import thaumicbees.main.utils.compat.EquivalentExchangeHelper;
import thaumicbees.main.utils.compat.ExtraBeesHelper;
import thaumicbees.main.utils.compat.ThaumcraftHelper;

@Mod(modid="ThaumicBees", name="Thaumic Bees", useMetadata=true, acceptedMinecraftVersions="1.4.7", version="1.4.4 - 152", dependencies="required-after:Forestry;after:Thaumcraft@[3.0.3,);after:ExtraBees")
public class ThaumicBees {
    @Mod.Instance(value="ThaumicBees")
    public static ThaumicBees object;
    @SidedProxy(serverSide="thaumicbees.main.CommonProxy", clientSide="thaumicbees.main.ClientProxy")
    public static CommonProxy proxy;
    private String configsPath;
    private Config modConfig;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        LocalizationManager.setupLocalizationInfo();
        this.configsPath = event.getModConfigurationDirectory().getAbsolutePath();
        this.modConfig = new Config(event.getSuggestedConfigurationFile());
        ThaumcraftHelper.init();
        ExtraBeesHelper.init();
        EquivalentExchangeHelper.init();
    }

    @Mod.Init
    public void init(FMLInitializationEvent event) {
        proxy.preloadTextures();
        try {
            FMLLog.info((String)"[ThaumicBees] Attempting to get Forestry's item graphics file...", (Object[])new Object[0]);
            CommonProxy.FORESTRY_GFX_ITEMS = ItemInterface.getItem((String)"beeComb").b().getTextureFile();
        }
        catch (Exception e) {
            FMLLog.severe((String)"ThaumicBees encountered a problem while loading!", (Object[])new Object[0]);
            throw new RuntimeException("Could not get the Forestry item texture file! Did Forestry load correctly?", e);
        }
        this.modConfig.setupBlocks();
        this.modConfig.registerTileEntities();
        this.modConfig.setupItems();
        CompatabilityManager.setupBackpacks();
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent event) {
        Allele.setupAdditionalAlleles();
        BeeSpecies.setupBeeSpecies();
        BeeMutation.setupMutations();
        this.modConfig.saveConfigs();
        ThaumcraftHelper.setupItemAspects();
        CraftingManager.setupCrafting();
        ThaumcraftHelper.setupResearch();
        VersionInfo.doVersionCheck();
    }

    public static Config getConfig() {
        return ThaumicBees.object.modConfig;
    }
}

