/*
 * Decompiled with CFR 0.152.
 */
package thaumicbees.main.utils.compat;

import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.genetics.IAllele;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import thaumcraft.api.ObjectTags;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.crafting.ShapelessInfusionCraftingRecipes;
import thaumcraft.api.research.ResearchList;

public class ShapelessBeeInfusionCraftingRecipe
extends ShapelessInfusionCraftingRecipes {
    private String alleleId;
    private byte alleleSlot;

    public static void createNewRecipe(String key, String researchKey, ur output, Object[] input, int auraCost, ObjectTags tags, IAllele allele, EnumBeeChromosome slot) {
        ArrayList<ur> inputList = new ArrayList<ur>(input.length);
        for (Object item : input) {
            if (item instanceof ur) {
                inputList.add(((ur)item).l());
                continue;
            }
            if (item instanceof up) {
                inputList.add(new ur((up)item));
                continue;
            }
            if (item instanceof amq) {
                inputList.add(new ur((amq)item));
                continue;
            }
            throw new RuntimeException("Invalid shapeless crafting recipe!");
        }
        ThaumcraftApi.getCraftingRecipes().add(new ShapelessBeeInfusionCraftingRecipe(key, output, inputList, auraCost, tags, allele, slot));
        ResearchList.craftingRecipesForResearch.put(researchKey, Arrays.asList(ThaumcraftApi.getCraftingRecipes().size() - 1));
    }

    private ShapelessBeeInfusionCraftingRecipe(String key, ur output, List itemList, int cost, ObjectTags tags, IAllele allele, EnumBeeChromosome slot) {
        super(key, output, itemList, cost, tags);
        this.alleleId = allele.getUID();
        this.alleleSlot = (byte)slot.ordinal();
    }

    public boolean matches(la craftingInventory, qx player) {
        ArrayList recipeItemsList = new ArrayList(this.recipeItems);
        boolean invalidItemFound = false;
        if (this.key.length() == 0 || this.key.length() > 0 && ThaumcraftApiHelper.isResearchComplete((String)player.bR, (String)this.key)) {
            for (int i = 0; i < 3 && !invalidItemFound; ++i) {
                for (int j = 0; j < 3 && !invalidItemFound; ++j) {
                    ur itemStack = ThaumcraftApiHelper.getStackInRowAndColumn((Object)craftingInventory, (int)j, (int)i);
                    if (itemStack == null) continue;
                    Iterator itr = recipeItemsList.iterator();
                    boolean currentItemInRecipe = false;
                    while (itr.hasNext()) {
                        ur recipeItem = (ur)itr.next();
                        if (itemStack.c == recipeItem.c && (recipeItem.j() == -1 || itemStack.j() == recipeItem.j())) {
                            currentItemInRecipe = recipeItem.o() ? this.hasMatchingChromosome(itemStack) : true;
                        }
                        if (!currentItemInRecipe) continue;
                        itr.remove();
                        break;
                    }
                    if (currentItemInRecipe) continue;
                    invalidItemFound = true;
                }
            }
        }
        return recipeItemsList.isEmpty() && !invalidItemFound;
    }

    private boolean hasMatchingChromosome(ur itemStack) {
        bq genome;
        boolean genesMatch = false;
        bq compoundRoot = itemStack.p();
        if (compoundRoot.b("Genome") && (genome = compoundRoot.l("Genome")).b("Chromosomes")) {
            by chromosomes = genome.m("Chromosomes");
            for (int i = 0; i < chromosomes.c() && !genesMatch; ++i) {
                bq genes = (bq)chromosomes.b(i);
                if (!genes.b("Slot") || genes.c("Slot") != this.alleleSlot || !genes.i("UID0").equals(this.alleleId) || !genes.i("UID1").equals(this.alleleId)) continue;
                genesMatch = true;
            }
        }
        return genesMatch;
    }
}

