/*
 * Decompiled with CFR 0.152.
 */
package thaumicbees.main.utils.compat;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.core.BlockInterface;
import forestry.api.core.ItemInterface;
import forestry.api.genetics.IAllele;
import thaumcraft.api.EnumTag;
import thaumcraft.api.ItemApi;
import thaumcraft.api.ObjectTags;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchList;
import thaumicbees.bees.BeeGenomeManager;
import thaumicbees.bees.BeeSpecies;
import thaumicbees.item.types.CombType;
import thaumicbees.item.types.DropType;
import thaumicbees.item.types.LiquidType;
import thaumicbees.item.types.PollenType;
import thaumicbees.item.types.PropolisType;
import thaumicbees.item.types.ResourceType;
import thaumicbees.item.types.WaxType;
import thaumicbees.main.Config;
import thaumicbees.main.ThaumicBees;
import thaumicbees.main.utils.compat.ExtraBeesHelper;
import thaumicbees.main.utils.compat.ForestryHelper;
import thaumicbees.main.utils.compat.ShapelessBeeInfusionCraftingRecipe;

public class ThaumcraftHelper {
    private static boolean isThaumcraftPresent = false;

    public static boolean isActive() {
        return isThaumcraftPresent;
    }

    public static void init() {
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            isThaumcraftPresent = true;
            ThaumcraftHelper.registerResearchXML();
        }
    }

    public static void getBlocks() {
        if (ThaumcraftHelper.isActive()) {
            Config.tcPlant = amq.p[ItemApi.getItem((String)"blockCustomPlant", (int)0).c];
            Config.tcCandle = amq.p[ItemApi.getItem((String)"blockCandle", (int)0).c];
            Config.tcCrystal = amq.p[ItemApi.getItem((String)"blockCrystal", (int)0).c];
            Config.tcMarker = amq.p[ItemApi.getItem((String)"blockMarker", (int)0).c];
            Config.tcJar = amq.p[ItemApi.getItem((String)"blockJar", (int)0).c];
            Config.tcLog = amq.p[ItemApi.getItem((String)"blockMagicalLog", (int)0).c];
            Config.tcLeaf = amq.p[ItemApi.getItem((String)"blockMagicalLeaves", (int)0).c];
            Config.tcWarded = amq.p[ItemApi.getItem((String)"blockWarded", (int)0).c];
        }
    }

    public static void getItems() {
        if (ThaumcraftHelper.isActive()) {
            Config.tcFilledJar = ItemApi.getItem((String)"itemJarFilled", (int)0).b();
            Config.tcMiscResource = ItemApi.getItem((String)"itemResource", (int)0).b();
            Config.tcEssentiaBottle = ItemApi.getItem((String)"itemEssence", (int)0).b();
            Config.tcShard = ItemApi.getItem((String)"itemShard", (int)0).b();
            Config.tcGolem = ItemApi.getItem((String)"itemGolemPlacer", (int)0).b();
            Config.tcWispEssence = ItemApi.getItem((String)"itemWispEssence", (int)0).b();
            Config.tcNuggets = ItemApi.getItem((String)"itemNugget", (int)0).b();
            Config.tcNuggetChicken = ItemApi.getItem((String)"itemNuggetChicken", (int)0).b();
            Config.tcNuggetBeef = ItemApi.getItem((String)"itemNuggetBeef", (int)0).b();
            Config.tcNuggetPork = ItemApi.getItem((String)"itemNuggetPork", (int)0).b();
        }
    }

    public static void addItemsToBackpack() {
        if (ThaumicBees.getConfig().AddThaumcraftItemsToBackpacks) {
            String ids = Config.tcShard.cj + ":" + -1 + ";" + Config.tcMiscResource.cj + ":" + MiscResource.THAUMIUM.ordinal();
            FMLInterModComms.sendMessage((String)"Forestry", (String)"add-backpack-items", (String)("miner@" + ids));
            ids = Config.tcMiscResource.cj + ":" + -1 + ";" + Config.tcShard.cj + ":" + -1 + ";" + Config.tcFilledJar.cj + ":" + -1 + ";" + Config.tcCrystal.cm + ":" + -1 + ";" + Config.tcJar.cm + ":" + -1 + ";" + Config.tcGolem.cj + ":" + -1 + ";";
            FMLInterModComms.sendMessage((String)"Forestry", (String)"add-backpack-items", (String)("thaumaturge@" + ids));
            ids = Config.tcPlant.cm + ":" + "-1" + ";" + Config.tcLeaf.cm + ":" + -1 + ";" + Config.tcLog.cm + ":" + "-1";
            FMLInterModComms.sendMessage((String)"Forestry", (String)"add-backpack-items", (String)("forester@" + ids));
            ids = Config.tcWispEssence.cj + ":" + -1 + ";" + Config.tcMiscResource.cj + ":" + MiscResource.ZOMBIE_BRAIN.ordinal();
            FMLInterModComms.sendMessage((String)"Forestry", (String)"add-backpack-items", (String)("hunter@" + ids));
            ids = Config.tcCandle.cm + ":" + -1 + ";" + Config.tcMarker.cm + ":" + -1 + ";" + Config.tcWarded.cm + ":" + -1;
            FMLInterModComms.sendMessage((String)"Forestry", (String)"add-backpack-items", (String)("builder@" + ids));
        }
    }

    public static void setupItemAspects() {
        if (ThaumcraftHelper.isActive()) {
            ThaumcraftHelper.setupItemAspectsThaumicBees();
            ThaumcraftHelper.setupItemAspectsForestry();
            if (ExtraBeesHelper.isActive()) {
                ThaumcraftHelper.setupItemAspectsExtraBees();
            }
        }
    }

    private static void setupItemAspectsThaumicBees() {
        ObjectTags tags = new ObjectTags().add(EnumTag.WOOD, 2);
        ThaumcraftApi.registerObjectTag((int)Config.planksWood.cm, (int)-1, (ObjectTags)tags);
        tags = new ObjectTags().add(EnumTag.MAGIC, 2);
        ThaumcraftApi.registerObjectTag((int)Config.wax.cj, (int)WaxType.MAGIC.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags().add(EnumTag.MAGIC, 1);
        ThaumcraftApi.registerObjectTag((int)Config.drops.cj, (int)DropType.ENCHANTED.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags().add(EnumTag.KNOWLEDGE, 1);
        ThaumcraftApi.registerObjectTag((int)Config.drops.cj, (int)DropType.INTELLECT.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags().add(EnumTag.ELDRITCH, 2);
        ThaumcraftApi.registerObjectTag((int)Config.pollen.cj, (int)PollenType.UNUSUAL.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags().add(EnumTag.TIME, 2);
        ThaumcraftApi.registerObjectTag((int)Config.pollen.cj, (int)PollenType.PHASED.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags().add(EnumTag.CONTROL, 1);
        ThaumcraftApi.registerObjectTag((int)Config.propolis.cj, (int)-1, (ObjectTags)tags);
        tags = new ObjectTags(Config.propolis.cj, -1).add(EnumTag.MAGIC, 1);
        ThaumcraftApi.registerObjectTag((int)Config.propolis.cj, (int)PropolisType.STARK.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags(Config.propolis.cj, -1).add(EnumTag.MAGIC, 1).add(EnumTag.WIND, 3);
        ThaumcraftApi.registerObjectTag((int)Config.propolis.cj, (int)PropolisType.AIR.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags(Config.propolis.cj, -1).add(EnumTag.MAGIC, 1).add(EnumTag.FIRE, 3);
        ThaumcraftApi.registerObjectTag((int)Config.propolis.cj, (int)PropolisType.FIRE.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags(Config.propolis.cj, -1).add(EnumTag.MAGIC, 1).add(EnumTag.WATER, 3);
        ThaumcraftApi.registerObjectTag((int)Config.propolis.cj, (int)PropolisType.WATER.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags(Config.propolis.cj, -1).add(EnumTag.MAGIC, 1).add(EnumTag.EARTH, 3);
        ThaumcraftApi.registerObjectTag((int)Config.propolis.cj, (int)PropolisType.EARTH.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags(Config.propolis.cj, -1).add(EnumTag.MAGIC, 4);
        ThaumcraftApi.registerObjectTag((int)Config.propolis.cj, (int)PropolisType.INFUSED.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags().add(EnumTag.KNOWLEDGE, 3);
        ThaumcraftApi.registerObjectTag((int)Config.miscResources.cj, (int)ResourceType.LORE_FRAGMENT.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags().add(EnumTag.INSECT, 2).add(EnumTag.TRAP, 2);
        ThaumcraftApi.registerObjectTag((int)Config.combs.cj, (int)-1, (ObjectTags)tags);
        tags = new ObjectTags(Config.combs.cj, -1).add(EnumTag.MAGIC, 2);
        ThaumcraftApi.registerObjectTag((int)Config.combs.cj, (int)CombType.OCCULT.ordinal(), (ObjectTags)tags);
        ThaumcraftApi.registerObjectTag((int)Config.combs.cj, (int)CombType.OTHERWORLDLY.ordinal(), (ObjectTags)tags);
        ThaumcraftApi.registerObjectTag((int)Config.combs.cj, (int)CombType.STARK.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags(Config.combs.cj, -1).add(EnumTag.MAGIC, 4);
        ThaumcraftApi.registerObjectTag((int)Config.combs.cj, (int)CombType.INFUSED.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags(Config.combs.cj, -1).add(EnumTag.MAGIC, 2).add(EnumTag.MOTION, 2);
        ThaumcraftApi.registerObjectTag((int)Config.combs.cj, (int)CombType.AIRY.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags(Config.combs.cj, -1).add(EnumTag.MAGIC, 2).add(EnumTag.POWER, 2);
        ThaumcraftApi.registerObjectTag((int)Config.combs.cj, (int)CombType.FIREY.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags(Config.combs.cj, -1).add(EnumTag.MAGIC, 2).add(EnumTag.COLD, 2);
        ThaumcraftApi.registerObjectTag((int)Config.combs.cj, (int)CombType.WATERY.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags(Config.combs.cj, -1).add(EnumTag.MAGIC, 2).add(EnumTag.ROCK, 2);
        ThaumcraftApi.registerObjectTag((int)Config.combs.cj, (int)CombType.EARTHY.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags().add(EnumTag.VOID, 2).add(EnumTag.MAGIC, 2);
        ThaumcraftApi.registerComplexObjectTag((int)Config.magicCapsule.cj, (int)LiquidType.EMPTY.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags(Config.magicCapsule.cj, LiquidType.EMPTY.ordinal()).add(EnumTag.WATER, 8);
        ThaumcraftApi.registerObjectTag((int)Config.magicCapsule.cj, (int)LiquidType.WATER.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags(Config.magicCapsule.cj, LiquidType.EMPTY.ordinal()).add(EnumTag.FIRE, 12).add(EnumTag.ROCK, 4);
        ThaumcraftApi.registerObjectTag((int)Config.magicCapsule.cj, (int)LiquidType.LAVA.ordinal(), (ObjectTags)tags);
        for (EnumTag tag : EnumTag.values()) {
            if (tag == EnumTag.UNKNOWN) continue;
            tags = new ObjectTags().add(tag, 1);
            ThaumcraftApi.registerObjectTag((int)Config.solidFlux.cj, (int)tag.id, (ObjectTags)tags);
        }
    }

    private static void setupItemAspectsForestry() {
        ur itemStack = BlockInterface.getBlock((String)"candle");
        ObjectTags tags = new ObjectTags().add(EnumTag.LIGHT, 1).add(EnumTag.CONTROL, 1);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)itemStack.j(), (ObjectTags)tags);
        itemStack = BlockInterface.getBlock((String)"glass");
        tags = new ObjectTags(amq.P.cm, 0);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)-1, (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"propolis");
        tags = new ObjectTags().add(EnumTag.CONTROL, 1);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)-1, (ObjectTags)tags);
        tags = new ObjectTags(itemStack.c, -1).add(EnumTag.ELDRITCH, 1);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ForestryHelper.Propolis.PULSATING.ordinal(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"pollen");
        tags = new ObjectTags().add(EnumTag.FLOWER, 1).add(EnumTag.PLANT, 1);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ForestryHelper.Pollen.NORMAL.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags(itemStack.c, ForestryHelper.Pollen.NORMAL.ordinal()).add(EnumTag.COLD, 1);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ForestryHelper.Pollen.CRYSTALLINE.ordinal(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"craftingMaterial");
        tags = new ObjectTags().add(EnumTag.ELDRITCH, 2);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ForestryHelper.CraftingMaterial.PULSATING_MESH.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags().add(EnumTag.INSECT, 1);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ForestryHelper.CraftingMaterial.SILK_WISP.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags().add(EnumTag.INSECT, 4).add(EnumTag.CLOTH, 5);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ForestryHelper.CraftingMaterial.WOVEN_SILK.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags().add(EnumTag.COLD, 1);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ForestryHelper.CraftingMaterial.ICE_SHARD.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags().add(EnumTag.VALUABLE, 1).add(EnumTag.PLANT, 1).add(EnumTag.INSECT, 2).add(EnumTag.CONTROL, 2).add(EnumTag.WOOD, 5);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ForestryHelper.CraftingMaterial.SCENTED_PANELING.ordinal(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"beealyzer");
        tags = new ObjectTags().add(EnumTag.VALUABLE, 3).add(EnumTag.MECHANISM, 3).add(EnumTag.METAL, 19).add(EnumTag.POWER, 8).add(EnumTag.TOOL, 18);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)itemStack.j(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"treealyzer");
        tags = new ObjectTags().add(EnumTag.POWER, 3).add(EnumTag.PURE, 3).add(EnumTag.LIFE, 6).add(EnumTag.TOOL, 12).add(EnumTag.METAL, 19);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)itemStack.j(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"apatite");
        tags = new ObjectTags().add(EnumTag.CRYSTAL, 2).add(EnumTag.POWER, 2);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)itemStack.j(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"impregnatedCasing");
        tags = new ObjectTags().add(EnumTag.WOOD, 56).add(EnumTag.EXCHANGE, 8);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)itemStack.j(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"stickImpregnated");
        tags = new ObjectTags().add(EnumTag.WOOD, 6).add(EnumTag.EXCHANGE, 2);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)itemStack.j(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"peat");
        tags = new ObjectTags().add(EnumTag.POWER, 2).add(EnumTag.PLANT, 2);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)itemStack.j(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"ash");
        tags = new ObjectTags().add(EnumTag.DESTRUCTION, 1).add(EnumTag.EXCHANGE, 1);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)itemStack.j(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"honeyDrop");
        tags = new ObjectTags().add(EnumTag.EXCHANGE, 2).add(EnumTag.LIFE, 1);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)itemStack.j(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"honeydew");
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)itemStack.j(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"royalJelly");
        tags = new ObjectTags().add(EnumTag.INSECT, 2).add(EnumTag.POWER, 1).add(EnumTag.VALUABLE, 1);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)itemStack.j(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"honeyPot");
        tags = new ObjectTags().add(EnumTag.LIFE, 2);
        ThaumcraftApi.registerComplexObjectTag((int)itemStack.c, (int)itemStack.j(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"ambrosia");
        tags = new ObjectTags().add(EnumTag.HEAL, 4);
        ThaumcraftApi.registerComplexObjectTag((int)itemStack.c, (int)itemStack.j(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"beeswax");
        tags = new ObjectTags().add(EnumTag.CONTROL, 1);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)itemStack.j(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"refractoryWax");
        tags = new ObjectTags().add(EnumTag.FIRE, 3);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)itemStack.j(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"phosphor");
        tags = new ObjectTags().add(EnumTag.FIRE, 2).add(EnumTag.DESTRUCTION, 1);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)itemStack.j(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"waxCapsule");
        tags = new ObjectTags().add(EnumTag.CONTROL, 1).add(EnumTag.VOID, 1);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)itemStack.j(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"waxCapsuleWater");
        tags = new ObjectTags().add(EnumTag.CONTROL, 1).add(EnumTag.VOID, 1).add(EnumTag.WATER, 4);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)itemStack.j(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"refractoryEmpty");
        tags = new ObjectTags().add(EnumTag.FIRE, 1).add(EnumTag.CONTROL, 1).add(EnumTag.VOID, 1);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)itemStack.j(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"refractoryWater");
        tags = new ObjectTags().add(EnumTag.FIRE, 1).add(EnumTag.VOID, 1).add(EnumTag.WATER, 4);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)itemStack.j(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"refractoryLava");
        tags = new ObjectTags().add(EnumTag.VOID, 1).add(EnumTag.FIRE, 7).add(EnumTag.WATER, 1).add(EnumTag.ROCK, 2);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)itemStack.j(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"canEmpty");
        tags = new ObjectTags().add(EnumTag.METAL, 1).add(EnumTag.VOID, 1);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)itemStack.j(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"canWater");
        tags = new ObjectTags().add(EnumTag.METAL, 1).add(EnumTag.VOID, 1).add(EnumTag.WATER, 4);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)itemStack.j(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"canLava");
        tags = new ObjectTags().add(EnumTag.METAL, 1).add(EnumTag.VOID, 1).add(EnumTag.FIRE, 6).add(EnumTag.WATER, 1).add(EnumTag.ROCK, 2);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)itemStack.j(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"beeComb");
        tags = new ObjectTags().add(EnumTag.INSECT, 2).add(EnumTag.TRAP, 2);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)-1, (ObjectTags)tags);
        tags = new ObjectTags(itemStack.c, -1).add(EnumTag.FIRE, 2);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ForestryHelper.Comb.SIMMERING.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags(itemStack.c, -1).add(EnumTag.COLD, 2);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ForestryHelper.Comb.FROZEN.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags(itemStack.c, -1).add(EnumTag.CROP, 2);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ForestryHelper.Comb.WHEATEN.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags(itemStack.c, -1).add(EnumTag.FUNGUS, 2);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ForestryHelper.Comb.MOSSY.ordinal(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"ambrosia");
        tags = new ObjectTags().add(EnumTag.LIFE, 2).add(EnumTag.HEAL, 4);
        itemStack = BlockInterface.getBlock((String)"log1");
        tags = new ObjectTags().add(EnumTag.WOOD, 8);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)-1, (ObjectTags)tags);
        itemStack = BlockInterface.getBlock((String)"log2");
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)-1, (ObjectTags)tags);
        itemStack = BlockInterface.getBlock((String)"log3");
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)-1, (ObjectTags)tags);
        itemStack = BlockInterface.getBlock((String)"log4");
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)-1, (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"sapling");
        tags = new ObjectTags().add(EnumTag.PLANT, 4).add(EnumTag.WOOD, 2);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)-1, (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"beeDroneGE");
        tags = new ObjectTags().add(EnumTag.INSECT, 1).add(EnumTag.FLIGHT, 2);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)-1, (ObjectTags)tags);
        tags = new ObjectTags(itemStack.c, -1).add(EnumTag.VALUABLE, 4);
        itemStack = ItemInterface.getItem((String)"beePrincessGE");
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)-1, (ObjectTags)tags);
        tags = new ObjectTags().add(EnumTag.VALUABLE, 8).add(EnumTag.INSECT, 2).add(EnumTag.FLIGHT, 4);
        itemStack = ItemInterface.getItem((String)"beeQueenGE");
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)-1, (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"circuitboards");
        tags = new ObjectTags().add(EnumTag.CRYSTAL, 2).add(EnumTag.METAL, 5).add(EnumTag.MECHANISM, 10).add(EnumTag.POWER, 10);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ForestryHelper.CircuitBoard.BASIC.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags().add(EnumTag.MECHANISM, 10).add(EnumTag.POWER, 10).add(EnumTag.METAL, 14).add(EnumTag.CONTROL, 2).add(EnumTag.EXCHANGE, 2);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ForestryHelper.CircuitBoard.ENHANCED.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags().add(EnumTag.MECHANISM, 10).add(EnumTag.POWER, 10).add(EnumTag.METAL, 14);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ForestryHelper.CircuitBoard.REFINED.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags().add(EnumTag.MECHANISM, 10).add(EnumTag.POWER, 10).add(EnumTag.METAL, 19).add(EnumTag.VALUABLE, 10);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ForestryHelper.CircuitBoard.INTRICATE.ordinal(), (ObjectTags)tags);
        itemStack = ItemInterface.getItem((String)"tubes");
        tags = new ObjectTags(ItemInterface.getItem((String)"ingotCopper").c, 0).add(EnumTag.MECHANISM, 1).add(EnumTag.POWER, 1);
        tags = new ObjectTags(ItemInterface.getItem((String)"ingotTin").c, 0).add(EnumTag.MECHANISM, 1).add(EnumTag.POWER, 1);
        tags = new ObjectTags(ItemInterface.getItem((String)"ingotBronze").c, 0).add(EnumTag.MECHANISM, 1).add(EnumTag.POWER, 1);
        tags = new ObjectTags(up.o.cj, 0).add(EnumTag.MECHANISM, 1).add(EnumTag.POWER, 1);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ForestryHelper.Tube.IRON.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags(up.p.cj, 0).add(EnumTag.MECHANISM, 1).add(EnumTag.POWER, 1);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ForestryHelper.Tube.GOLD.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags(up.n.cj, 0).add(EnumTag.MECHANISM, 1).add(EnumTag.POWER, 1);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ForestryHelper.Tube.DIAMOND.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags(amq.as.cm, 0).add(EnumTag.MECHANISM, 1).add(EnumTag.POWER, 1);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ForestryHelper.Tube.OBSIDIAN.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags(up.bw.cj, 0).add(EnumTag.MECHANISM, 1).add(EnumTag.POWER, 1);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ForestryHelper.Tube.BLAZE.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags().add(EnumTag.MOTION, 2).add(EnumTag.CONTROL, 2).add(EnumTag.MECHANISM, 1).add(EnumTag.POWER, 1);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ForestryHelper.Tube.RUBBER.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags(up.bH.cj, 0).add(EnumTag.MECHANISM, 1).add(EnumTag.POWER, 1);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ForestryHelper.Tube.EMERALD.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags(ItemInterface.getItem((String)"apatite").c, 0).add(EnumTag.MECHANISM, 1).add(EnumTag.POWER, 1);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ForestryHelper.Tube.APATITE.ordinal(), (ObjectTags)tags);
        tags = new ObjectTags(up.aW.cj, 4).add(EnumTag.MECHANISM, 1).add(EnumTag.POWER, 1);
        ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ForestryHelper.Tube.LAPIS.ordinal(), (ObjectTags)tags);
    }

    private static void setupItemAspectsExtraBees() {
        try {
            ur itemStack = ExtraBeesHelper.getExtraBeeItem("comb");
            ObjectTags tags = new ObjectTags().add(EnumTag.INSECT, 2).add(EnumTag.TRAP, 2);
            ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)-1, (ObjectTags)tags);
            tags = new ObjectTags(itemStack.c, -1).add(EnumTag.POWER, 2);
            ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ExtraBeesHelper.CombType.OIL.ordinal(), (ObjectTags)tags);
            ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ExtraBeesHelper.CombType.COAL.ordinal(), (ObjectTags)tags);
            ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ExtraBeesHelper.CombType.FUEL.ordinal(), (ObjectTags)tags);
            ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ExtraBeesHelper.CombType.ALCOHOL.ordinal(), (ObjectTags)tags);
            ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ExtraBeesHelper.CombType.REDSTONE.ordinal(), (ObjectTags)tags);
            ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ExtraBeesHelper.CombType.URANIUM.ordinal(), (ObjectTags)tags);
            tags = new ObjectTags(itemStack.c, -1).add(EnumTag.POISON, 2);
            ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)ExtraBeesHelper.CombType.VENOMOUS.ordinal(), (ObjectTags)tags);
            itemStack = ExtraBeesHelper.getExtraBeeItem("propolis");
            tags = new ObjectTags().add(EnumTag.CONTROL, 1);
            ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)-1, (ObjectTags)tags);
            itemStack = ExtraBeesHelper.getExtraBeeItem("honeyDrop");
            tags = new ObjectTags().add(EnumTag.EXCHANGE, 2).add(EnumTag.LIFE, 1);
            ThaumcraftApi.registerObjectTag((int)itemStack.c, (int)-1, (ObjectTags)tags);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void setupResearch() {
        if (ThaumcraftHelper.isActive()) {
            ObjectTags tags = new ObjectTags().add(EnumTag.WOOD, 10).add(EnumTag.PLANT, 10).add(EnumTag.INSECT, 10);
            ResearchItem startNode = new ResearchItem("TBSTARTNODE", tags, 10, 1, Config.miscResources.getStackForType(ResourceType.RESEARCH_StartNode)).setParents(new ResearchItem[]{ResearchList.getResearch((String)"UTFT")}).registerResearchItem();
            tags = new ObjectTags().add(EnumTag.INSECT, 9).add(EnumTag.MAGIC, 4).add(EnumTag.FLUX, 4);
            ResearchItem starkHint = new ResearchItem("STARKHINT", tags, 5, 2, ItemInterface.getItem((String)"beeQueenGE")).setParents(new ResearchItem[]{startNode}).registerResearchItem();
            tags = new ObjectTags().add(EnumTag.INSECT, 15).add(EnumTag.MAGIC, 5).add(EnumTag.WATER, 5).add(EnumTag.EARTH, 5).add(EnumTag.WIND, 5).add(EnumTag.FIRE, 5);
            ResearchItem beeInfusion = new ResearchItem("BEEINFUSION", tags, 5, 3, Config.miscResources.getStackForType(ResourceType.RESEARCH_BeeInfusion)).setParents(new ResearchItem[]{starkHint}).setHidden().registerResearchItem();
            tags = new ObjectTags().add(EnumTag.CROP, 20).add(EnumTag.EARTH, 20).add(EnumTag.WATER, 5);
            ResearchItem fertilizer = new ResearchItem("FERTILIZER", tags, 16, 0, ItemInterface.getItem((String)"apatite")).setParents(new ResearchItem[]{startNode}).registerResearchItem();
            tags = new ObjectTags().add(EnumTag.TOOL, 6).add(EnumTag.INSECT, 15).add(EnumTag.BEAST, 2).add(EnumTag.MAGIC, 5);
            ResearchItem magicFrame = new ResearchItem("HIVEFRAME", tags, 10, -2, (up)Config.hiveFrameMagic).setParents(new ResearchItem[]{startNode}).registerResearchItem();
            tags = new ObjectTags().add(EnumTag.TOOL, 5).add(EnumTag.INSECT, 10).add(EnumTag.ARMOR, 5).add(EnumTag.EXCHANGE, 6).add(EnumTag.MAGIC, 8);
            ResearchItem magicFrame2 = new ResearchItem("HIVEFRAME2", tags, 8, -2, (up)Config.hiveFrameResilient).setParents(new ResearchItem[]{magicFrame}).setHidden().registerResearchItem();
            tags = new ObjectTags().add(EnumTag.TOOL, 4).add(EnumTag.INSECT, 10).add(EnumTag.LIFE, 5).add(EnumTag.EXCHANGE, 6).add(EnumTag.HEAL, 2).add(EnumTag.FLOWER, 6);
            ResearchItem gentleFrame = new ResearchItem("HIVEFRAMEGENTLE", tags, 12, -2, (up)Config.hiveFrameGentle).setParents(new ResearchItem[]{magicFrame}).setHidden().registerResearchItem();
            tags = new ObjectTags().add(EnumTag.TOOL, 4).add(EnumTag.INSECT, 10).add(EnumTag.LIFE, 6).add(EnumTag.EXCHANGE, 8).add(EnumTag.MAGIC, 8).add(EnumTag.MOTION, 4).add(EnumTag.FLESH, 4);
            ResearchItem metabolicFrame = new ResearchItem("HIVEFRAMEMETA", tags, 9, -3, (up)Config.hiveFrameMetabolic).setParents(new ResearchItem[]{magicFrame}).setHidden().registerResearchItem();
            tags = new ObjectTags().add(EnumTag.TOOL, 5).add(EnumTag.INSECT, 10).add(EnumTag.DEATH, 15).add(EnumTag.EXCHANGE, 6).add(EnumTag.MAGIC, 8).add(EnumTag.POISON, 6);
            ResearchItem necroticFrame = new ResearchItem("HIVEFRAMENECRO", tags, 11, -3, (up)Config.hiveFrameNecrotic).setParents(new ResearchItem[]{magicFrame}).setHidden().registerResearchItem();
            tags = new ObjectTags().add(EnumTag.TOOL, 5).add(EnumTag.INSECT, 10).add(EnumTag.TIME, 4);
            ResearchItem temporalFrame = new ResearchItem("HIVEFRAMETIME", tags, 9, -5, (up)Config.hiveFrameTemporal).setParents(new ResearchItem[]{magicFrame}).setHidden().registerResearchItem();
            tags = new ObjectTags().add(EnumTag.VOID, 15).add(EnumTag.CRYSTAL, 8).add(EnumTag.ELDRITCH, 8).add(EnumTag.EXCHANGE, 15);
            ResearchItem voidCapsule = new ResearchItem("VOIDCAPSULE", tags, 10, 9, (up)Config.voidCapsule).setParents(new ResearchItem[]{startNode, ResearchList.getResearch((String)"PORTABLEHOLE")}).setHidden().registerResearchItem();
            tags = new ObjectTags().add(EnumTag.WOOD, 8).add(EnumTag.INSECT, 10).add(EnumTag.TOOL, 6).add(EnumTag.MAGIC, 6);
            ResearchItem scoop = new ResearchItem("THAUMIUMSCOOP", tags, 0, -3, (up)Config.thaumiumScoop).setParents(new ResearchItem[]{ResearchList.getResearch((String)"THAUMIUM")}).registerResearchItem();
            tags = new ObjectTags().add(EnumTag.WOOD, 16).add(EnumTag.PLANT, 20).add(EnumTag.TOOL, 6).add(EnumTag.MAGIC, 6);
            ResearchItem grafter = new ResearchItem("THAUMIUMGRAFTER", tags, 0, -4, (up)Config.thaumiumGrafter).setParents(new ResearchItem[]{scoop}).registerResearchItem();
        }
    }

    private static void registerResearchXML() {
        if (ThaumcraftHelper.isActive()) {
            ThaumcraftApi.registerResearchXML((String)"/research/thaumicbees/research.xml");
        }
    }

    public static void setupThaumcraftCrafting() {
        ur input = ThaumicBees.getConfig().UseImpregnatedStickInTools ? ItemInterface.getItem((String)"stickImpregnated") : new ur(up.D);
        ThaumcraftApi.addArcaneCraftingRecipe((String)"THAUMIUMSCOOP", (String)"THAUMIUMSCOOP", (int)45, (ur)new ur((up)Config.thaumiumScoop), (Object[])new Object[]{"sWs", "sTs", " T ", Character.valueOf('s'), input, Character.valueOf('W'), amq.ae, Character.valueOf('T'), new ur(Config.tcMiscResource, 1, MiscResource.THAUMIUM.ordinal())});
        ThaumcraftApi.addArcaneCraftingRecipe((String)"THAUMIUMGRAFTER", (String)"THAUMIUMGRAFTER", (int)160, (ur)new ur((up)Config.thaumiumGrafter), (Object[])new Object[]{"  T", " T ", "s  ", Character.valueOf('s'), input, Character.valueOf('T'), new ur(Config.tcMiscResource, 1, MiscResource.THAUMIUM.ordinal())});
        ur output = Config.miscResources.getStackForType(ResourceType.EXTENDED_FERTILIZER);
        input = ItemInterface.getItem((String)"apatite");
        ObjectTags tags = new ObjectTags().add(EnumTag.CROP, 12);
        output.a = 2;
        ThaumcraftApi.addShapelessInfusionCraftingRecipe((String)"FERTILIZER", (String)"FERTILIZER", (int)5, (ObjectTags)tags, (ur)output, (Object[])new Object[]{input});
        output = new ur((up)Config.hiveFrameMagic);
        input = ItemInterface.getItem((String)"frameUntreated");
        tags = new ObjectTags().add(EnumTag.WOOD, 4).add(EnumTag.INSECT, 8);
        ThaumcraftApi.addShapelessInfusionCraftingRecipe((String)"HIVEFRAME", (String)"FRAMEMAGIC", (int)50, (ObjectTags)tags, (ur)output, (Object[])new Object[]{input});
        output = new ur((up)Config.hiveFrameResilient);
        tags = new ObjectTags().add(EnumTag.WOOD, 12).add(EnumTag.INSECT, 8).add(EnumTag.EXCHANGE, 12);
        ThaumcraftApi.addInfusionCraftingRecipe((String)"HIVEFRAME2", (String)"FRAMERESILIENT", (int)50, (ObjectTags)tags, (ur)output, (Object[])new Object[]{" i ", "ifi", " i ", Character.valueOf('f'), Config.hiveFrameMagic, Character.valueOf('i'), up.o});
        output = new ur((up)Config.hiveFrameGentle);
        tags = new ObjectTags().add(EnumTag.WOOD, 4).add(EnumTag.INSECT, 8).add(EnumTag.HEAL, 12);
        ThaumcraftApi.addInfusionCraftingRecipe((String)"HIVEFRAMEGENTLE", (String)"FRAMEGENTLE", (int)50, (ObjectTags)tags, (ur)output, (Object[])new Object[]{"www", "wFw", "www", Character.valueOf('F'), input, Character.valueOf('w'), ItemInterface.getItem((String)"beeswax")});
        output = new ur((up)Config.hiveFrameMetabolic);
        tags = new ObjectTags().add(EnumTag.WOOD, 4).add(EnumTag.INSECT, 8).add(EnumTag.LIFE, 8).add(EnumTag.MOTION, 8).add(EnumTag.EXCHANGE, 8);
        ThaumcraftApi.addShapelessInfusionCraftingRecipe((String)"HIVEFRAMEMETA", (String)"FRAMEMETABOLIC", (int)50, (ObjectTags)tags, (ur)output, (Object[])new Object[]{up.bx, input});
        output = new ur((up)Config.hiveFrameNecrotic);
        tags = new ObjectTags().add(EnumTag.WOOD, 4).add(EnumTag.INSECT, 8).add(EnumTag.EXCHANGE, 12).add(EnumTag.DEATH, 16).add(EnumTag.POISON, 1);
        ThaumcraftApi.addInfusionCraftingRecipe((String)"HIVEFRAMENECRO", (String)"FRAMENECROTIC", (int)50, (ObjectTags)tags, (ur)output, (Object[])new Object[]{" S ", "SxS", " S ", Character.valueOf('S'), up.bm, Character.valueOf('x'), input});
        output = new ur((up)Config.hiveFrameTemporal);
        tags = new ObjectTags().add(EnumTag.WOOD, 4).add(EnumTag.INSECT, 8).add(EnumTag.TIME, 2);
        ThaumcraftApi.addInfusionCraftingRecipe((String)"HIVEFRAMETIME", (String)"FRAMETIME", (int)50, (ObjectTags)tags, (ur)output, (Object[])new Object[]{"tSt", "SFS", "tSt", Character.valueOf('t'), up.D, Character.valueOf('S'), amq.H, Character.valueOf('F'), input});
        output = Config.voidCapsule.getCapsuleForLiquid(LiquidType.EMPTY);
        output.a = 4;
        tags = new ObjectTags().add(EnumTag.VOID, 16).add(EnumTag.ELDRITCH, 4).add(EnumTag.EXCHANGE, 8);
        ThaumcraftApi.addInfusionCraftingRecipe((String)"VOIDCAPSULE", (String)"VOIDCAPSULE", (int)10, (ObjectTags)tags, (ur)output, (Object[])new Object[]{" G ", "GPG", "TGT", Character.valueOf('G'), amq.bt, Character.valueOf('P'), up.bn, Character.valueOf('T'), up.o});
        ur drone = BeeGenomeManager.getBeeNBTForSpecies(BeeSpecies.STARK, EnumBeeType.DRONE);
        ur princess = BeeGenomeManager.getBeeNBTForSpecies(BeeSpecies.STARK, EnumBeeType.PRINCESS);
        String researchKey = "BEEINFUSION";
        tags = new ObjectTags().add(EnumTag.WIND, 40).add(EnumTag.MOTION, 24);
        ShapelessBeeInfusionCraftingRecipe.createNewRecipe(researchKey, "BEEINFUSION1", BeeSpecies.AIR.getBeeItem(EnumBeeType.DRONE), new ur[]{drone, new ur(Config.tcShard, 1, ShardType.AIR.ordinal())}, 100, tags, (IAllele)BeeSpecies.STARK, EnumBeeChromosome.SPECIES);
        ShapelessBeeInfusionCraftingRecipe.createNewRecipe(researchKey, "BEEINFUSION2", BeeSpecies.AIR.getBeeItem(EnumBeeType.PRINCESS), new ur[]{princess, new ur(Config.tcShard, 1, ShardType.AIR.ordinal())}, 100, tags, (IAllele)BeeSpecies.STARK, EnumBeeChromosome.SPECIES);
        tags = new ObjectTags().add(EnumTag.FIRE, 40).add(EnumTag.POWER, 24);
        ShapelessBeeInfusionCraftingRecipe.createNewRecipe(researchKey, "BEEINFUSION3", BeeSpecies.FIRE.getBeeItem(EnumBeeType.DRONE), new Object[]{drone, new ur(Config.tcShard, 1, ShardType.FIRE.ordinal())}, 100, tags, (IAllele)BeeSpecies.STARK, EnumBeeChromosome.SPECIES);
        ShapelessBeeInfusionCraftingRecipe.createNewRecipe(researchKey, "BEEINFUSION4", BeeSpecies.FIRE.getBeeItem(EnumBeeType.PRINCESS), new Object[]{princess, new ur(Config.tcShard, 1, ShardType.FIRE.ordinal())}, 100, tags, (IAllele)BeeSpecies.STARK, EnumBeeChromosome.SPECIES);
        tags = new ObjectTags().add(EnumTag.WATER, 40).add(EnumTag.COLD, 24);
        ShapelessBeeInfusionCraftingRecipe.createNewRecipe(researchKey, "BEEINFUSION5", BeeSpecies.WATER.getBeeItem(EnumBeeType.DRONE), new Object[]{drone, new ur(Config.tcShard, 1, ShardType.WATER.ordinal())}, 100, tags, (IAllele)BeeSpecies.STARK, EnumBeeChromosome.SPECIES);
        ShapelessBeeInfusionCraftingRecipe.createNewRecipe(researchKey, "BEEINFUSION6", BeeSpecies.WATER.getBeeItem(EnumBeeType.PRINCESS), new Object[]{princess, new ur(Config.tcShard, 1, ShardType.WATER.ordinal())}, 100, tags, (IAllele)BeeSpecies.STARK, EnumBeeChromosome.SPECIES);
        tags = new ObjectTags().add(EnumTag.EARTH, 40).add(EnumTag.ROCK, 24);
        ShapelessBeeInfusionCraftingRecipe.createNewRecipe(researchKey, "BEEINFUSION7", BeeSpecies.EARTH.getBeeItem(EnumBeeType.DRONE), new Object[]{drone, new ur(Config.tcShard, 1, ShardType.EARTH.ordinal())}, 100, tags, (IAllele)BeeSpecies.STARK, EnumBeeChromosome.SPECIES);
        ShapelessBeeInfusionCraftingRecipe.createNewRecipe(researchKey, "BEEINFUSION8", BeeSpecies.EARTH.getBeeItem(EnumBeeType.PRINCESS), new Object[]{princess, new ur(Config.tcShard, 1, ShardType.EARTH.ordinal())}, 100, tags, (IAllele)BeeSpecies.STARK, EnumBeeChromosome.SPECIES);
        tags = new ObjectTags().add(EnumTag.MAGIC, 40).add(EnumTag.FLUX, 24);
        ShapelessBeeInfusionCraftingRecipe.createNewRecipe(researchKey, "BEEINFUSION9", BeeSpecies.INFUSED.getBeeItem(EnumBeeType.DRONE), new Object[]{drone, new ur(Config.tcShard, 1, ShardType.MAGIC.ordinal())}, 100, tags, (IAllele)BeeSpecies.STARK, EnumBeeChromosome.SPECIES);
        ShapelessBeeInfusionCraftingRecipe.createNewRecipe(researchKey, "BEEINFUSION0", BeeSpecies.INFUSED.getBeeItem(EnumBeeType.PRINCESS), new Object[]{princess, new ur(Config.tcShard, 1, ShardType.MAGIC.ordinal())}, 100, tags, (IAllele)BeeSpecies.STARK, EnumBeeChromosome.SPECIES);
    }

    public static enum TreeType {
        GREATWOOD,
        SILVERWOOD;

    }

    public static enum BlockPlant {
        GREATWOOD_SAPLING,
        SILVERWOOD_SAPLING,
        SHIMMERLEAF,
        CINDERPEARL;

    }

    public static enum Entity {
        BRAINY_ZOMBIE("entBrainyZombie", "EntityBrainyZombie"),
        GIANT_BRAINY_ZOMBIE("entGiantBrainyZombie", "EntityGiantBrainyZombie"),
        WISP("entWisp", "EntityWisp"),
        FIREBAT("entFirebat", "EntityFireBat");

        private static String packageName;
        public String entityID;
        private String className;

        /*
         * WARNING - void declaration
         */
        private Entity() {
            void clazz;
            void id;
            this.entityID = id;
            this.className = clazz;
        }

        public String getClassName() {
            return packageName + this.className;
        }

        static {
            packageName = "thaumcraft.common.entities.monster.";
        }
    }

    public static enum ShardType {
        AIR,
        FIRE,
        WATER,
        EARTH,
        MAGIC,
        DULL;

    }

    public static enum NuggetType {
        IRON,
        COPPER,
        TIN,
        SILVER,
        LEAD,
        QUICKSILVER,
        _6,
        _7,
        _8,
        _9,
        _10,
        _11,
        _12,
        _13,
        _14,
        _15,
        NATIVE_IRON,
        NATIVE_COPPER,
        NATIVE_TIN,
        NATIVE_SILVER,
        NATIVE_LEAD,
        _21,
        _22,
        _23,
        _24,
        _25,
        _26,
        _27,
        _28,
        _29,
        _30,
        NATIVE_GOLD;

    }

    public static enum MiscResource {
        ALUMENTUM,
        NITOR,
        THAUMIUM,
        QUICKSILVER,
        MAGIC_TALLOW,
        ZOMBIE_BRAIN,
        AMBER,
        ENCHANTED_FABRIC,
        FLUX_FILTER,
        KNOWLEDGE_FRAGMENT,
        MIRRORED_GLASS;

    }
}

